/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import teddy.Link;
import teddy.ListEnumeration;

public class LinkedList
implements Serializable {
    private Link head;
    private Link tail;
    private Link pre;
    private int len;

    public Object remove() {
        Link cur = this.cursor();
        if (cur == null) {
            throw new NoSuchElementException();
        }
        if (this.tail == cur) {
            this.tail = this.pre;
        }
        if (this.pre != null) {
            this.pre.next = cur.next;
        } else {
            this.head = cur.next;
        }
        this.len += -1;
        return cur.data;
    }

    public void merge(LinkedList l) {
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (this.member(element)) continue;
            this.append(element);
        }
    }

    public LinkedList cdr() {
        LinkedList clone = new LinkedList();
        Enumeration e = this.elements();
        e.nextElement();
        while (e.hasMoreElements()) {
            clone.append(e.nextElement());
        }
        return clone;
    }

    public void reset() {
        this.pre = null;
    }

    public Object head() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.data;
    }

    public Object nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
        if (this.pre == null) {
            throw new NoSuchElementException();
        }
        return this.pre.data;
    }

    public LinkedList() {
    }

    public LinkedList(Vector vector) {
        int i = 0;
        while (i < vector.size()) {
            this.append(vector.elementAt(i));
            ++i;
        }
    }

    public void substitute(LinkedList l) {
        this.head = l.head;
        this.tail = l.tail;
        this.pre = null;
        this.len = l.len;
    }

    public void replace_head(Object object) {
        this.head.data = object;
    }

    public void insert(Object n) {
        Link p = new Link(n, this.cursor());
        if (this.pre != null) {
            this.pre.next = p;
            if (this.pre == this.tail) {
                this.tail = p;
            }
        } else {
            if (this.head == null) {
                this.tail = p;
            }
            this.head = p;
        }
        this.pre = p;
        ++this.len;
    }

    public boolean contains(Object element) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (element != e.nextElement()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMoreElements() {
        return this.cursor() != null;
    }

    public int size() {
        return this.len;
    }

    public Enumeration elements() {
        return new ListEnumeration(this.head);
    }

    public LinkedList reverse() {
        Enumeration e = this.elements();
        return this.reverse_sub(e);
    }

    public Object elementAt(int n) {
        Enumeration e = this.elements();
        int i = 0;
        while (i < n) {
            e.nextElement();
            ++i;
        }
        return e.nextElement();
    }

    public Vector vector() {
        Vector vector = new Vector();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            vector.addElement(e.nextElement());
        }
        return vector;
    }

    public Object tail() {
        if (this.tail == null) {
            throw new NoSuchElementException();
        }
        return this.tail.data;
    }

    public LinkedList copy() {
        LinkedList clone = new LinkedList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            clone.append(e.nextElement());
        }
        return clone;
    }

    public boolean member(Object element) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (element != e.nextElement()) continue;
            return true;
        }
        return false;
    }

    public void print() {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            System.out.print(", " + e.nextElement());
        }
        System.out.println();
    }

    public Object currentElement() {
        Link cur = this.cursor();
        if (cur == null) {
            throw new NoSuchElementException();
        }
        return cur.data;
    }

    public void replace_tail(Object object) {
        this.tail.data = object;
    }

    public LinkedList reverse_sub(Enumeration e) {
        if (e.hasMoreElements()) {
            Object element = e.nextElement();
            LinkedList l = this.reverse_sub(e);
            l.append(element);
            return l;
        }
        return new LinkedList();
    }

    public void append(Object n) {
        Link p = new Link(n, null);
        if (this.head == null) {
            this.head = this.tail = p;
        } else {
            this.tail.next = p;
            this.tail = p;
        }
        ++this.len;
    }

    private Link cursor() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    public void remove(Object object) {
        this.reset();
        while (this.hasMoreElements()) {
            if (object == this.currentElement()) {
                this.remove();
                return;
            }
            this.nextElement();
        }
    }

    public void connect(LinkedList l) {
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            this.append(e.nextElement());
        }
    }
}

