/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import teddy.Vector2;
import teddy.Vertex2D;

class Line2D {
    Vertex2D base;
    Vector2 direction;

    public static Vertex2D cross_point(Line2D v, Line2D u) {
        Vertex2D v0 = v.base;
        Vector2 v1 = v.direction;
        Vertex2D u0 = u.base;
        Vector2 u1 = u.direction;
        double a = v1.x;
        double b = -u1.x;
        double c = v1.y;
        double d = -u1.y;
        double e = u0.x - v0.x;
        double f = u0.y - v0.y;
        double det = a * d - b * c;
        if (det == 0.0) {
            return null;
        }
        double _a = d / det;
        double _b = -b / det;
        double _c = -c / det;
        double _d = a / det;
        double t = _a * e + _b * f;
        double s = _c * e + _d * f;
        double x = v0.x + v1.x * t;
        double y = v0.y + v1.y * t;
        return new Vertex2D(x, y);
    }

    Line2D(Vertex2D _base, Vector2 _direction) {
        this.base = _base;
        this.direction = _direction.get_normalized();
    }

    public double distance(Vertex2D node) {
        double a = this.direction.x;
        double b = this.direction.y;
        double bunbo = Math.sqrt(a * a + b * b);
        double bunshi = a * (node.y - this.base.y) - b * (node.x - this.base.x);
        if (bunbo == 0.0) {
            System.out.println("Error in Line2D.distance");
            return 0.0;
        }
        return Math.abs(bunshi / bunbo);
    }
}

