/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleMatrix;
import VisualNumerics.math.DoubleSVD;
import VisualNumerics.math.DoubleVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Edge;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Queue;
import teddy.Skin;
import teddy.Vector3;
import teddy.Vertex;

public class LeastSquareFit {
    public static final int N_NEIGHBOR = 13;
    public static final double RADIUS_TO_EDGE_LENGTH = 0.8;
    public static final boolean IN_OUT_CONSTRAINTS_FOR_ALL = true;

    public static Vertex move_to_isosurface(Vertex v, double[] F) {
        int i = 0;
        while (i < 3) {
            v = LeastSquareFit.move_to_isosurface_sub(v, F);
            ++i;
        }
        return v;
    }

    public static Vertex move_to_isosurface_on_sharp(Vertex v) {
        Vertex u = new Vertex(v);
        int i = 0;
        while (i < v.quadratic_functions.size()) {
            double[] F = (double[])v.quadratic_functions.elementAt(i);
            u = LeastSquareFit.move_to_isosurface(u, F);
            ++i;
        }
        return u;
    }

    public static Vertex move_to_isosurface(Vertex v, Vertex base, Polygon2 polygon) {
        if (base.quadratic_function != null) {
            return LeastSquareFit.move_to_isosurface(v, base.quadratic_function);
        }
        return LeastSquareFit.move_to_isosurface(v, (double[])base.quadratic_function_hashtable.get(polygon));
    }

    public static Vertex move_to_isosurface(Vertex v, Vertex base, Edge edge) {
        if (base.quadratic_function != null) {
            return LeastSquareFit.move_to_isosurface(v, base.quadratic_function);
        }
        if (!edge.sharp) {
            return LeastSquareFit.move_to_isosurface(v, (double[])base.quadratic_function_hashtable.get(edge.left_polygon));
        }
        v = LeastSquareFit.move_to_isosurface(v, (double[])base.quadratic_function_hashtable.get(edge.left_polygon));
        v = LeastSquareFit.move_to_isosurface(v, (double[])base.quadratic_function_hashtable.get(edge.right_polygon));
        return v;
    }

    public static Vertex move_to_isosurface_sub(Vertex v, double[] F) {
        double dx = 2.0 * F[0] * v.x + F[3] * v.y + F[5] * v.z + F[6];
        double dy = 2.0 * F[1] * v.y + F[3] * v.x + F[4] * v.z + F[7];
        double dz = 2.0 * F[2] * v.z + F[4] * v.y + F[5] * v.x + F[8];
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double height = F[0] * v.x * v.x + F[1] * v.y * v.y + F[2] * v.z * v.z + F[3] * v.x * v.y + F[4] * v.y * v.z + F[5] * v.z * v.x + F[6] * v.x + F[7] * v.y + F[8] * v.z + F[9];
        double t = height / (d * d);
        if (d == 0.0) {
            System.out.println("d=0 in LeastSquareFit.move_to_isosurface " + F[0] + "," + F[1] + "," + F[2]);
        }
        return new Vertex(v.x - dx * t, v.y - dy * t, v.z - dz * t);
    }

    public static Vector3 calculate_normal(Vertex v, double[] F) {
        double dx = 2.0 * F[0] * v.x + F[3] * v.y + F[5] * v.z + F[6];
        double dy = 2.0 * F[1] * v.y + F[3] * v.x + F[4] * v.z + F[7];
        double dz = 2.0 * F[2] * v.z + F[4] * v.y + F[5] * v.x + F[8];
        Vector3 normal = new Vector3(dx, dy, dz);
        normal.normalize_self();
        return normal;
    }

    public static double calc_error(double[] v, double[][] Lt) {
        double[] Lv = DoubleMatrix.multiply((double[][])Lt, (double[])v);
        return DoubleVector.innerProduct((double[])Lv, (double[])Lv);
    }

    public static Vertex calculate_position(Vertex vertex, Vertex body_vertex, Object body_element) {
        if (body_element instanceof Vertex) {
            return LeastSquareFit.move_to_isosurface(body_vertex);
        }
        if (body_element instanceof Polygon2) {
            Polygon2 polygon = (Polygon2)body_element;
            Vertex p1 = polygon.get_vertex(0);
            Vertex p2 = polygon.get_vertex(1);
            Vertex p3 = polygon.get_vertex(2);
            Vector3 v12 = new Vector3(p1, p2);
            Vector3 v13 = new Vector3(p1, p3);
            Vector3 v10 = new Vector3(p1, body_vertex);
            double[] b = new double[]{v10.x, v10.y, v10.z};
            double[][] A = new double[][]{{v12.x, v13.x}, {v12.y, v13.y}, {v12.z, v13.z}};
            double[] x = null;
            try {
                DoubleSVD doubleSVD;
                DoubleSVD svd = doubleSVD = new DoubleSVD((double[][])A);
                x = DoubleMatrix.multiply((double[][])svd.inverse(), (double[])b);
            }
            catch (Exception e) {
                System.out.println("" + e);
            }
            double w2 = x[0];
            double w3 = x[1];
            double w1 = 1.0 - w2 - w3;
            Vertex v1 = LeastSquareFit.move_to_isosurface(body_vertex, p1, polygon);
            Vertex v2 = LeastSquareFit.move_to_isosurface(body_vertex, p2, polygon);
            Vertex v3 = LeastSquareFit.move_to_isosurface(body_vertex, p3, polygon);
            Vertex m = Vector3.interporate(v1, v2, w2 / (w1 + w2));
            return Vector3.interporate(m, v3, w3);
        }
        Edge edge = (Edge)body_element;
        Vertex v0 = LeastSquareFit.move_to_isosurface(body_vertex, edge.start, edge);
        Vertex v1 = LeastSquareFit.move_to_isosurface(body_vertex, edge.end, edge);
        return Vector3.interporate(v0, v1, Vector3.distance(edge.start, body_vertex) / edge.length());
    }

    public static void smooth(Polyhedron h) {
        Vertex v;
        int i = 0;
        while (i < h.n_vertices) {
            v = h.vertices[i];
            LeastSquareFit.calculate_quadratic_patch(v, true);
            ++i;
        }
        i = 0;
        while (i < h.n_vertices) {
            v = h.vertices[i];
            if (!v.on_sharp()) {
                v.warp(LeastSquareFit.move_to_isosurface(v));
            }
            ++i;
        }
        h.set_normals();
    }

    public static void set_target_edge_length(Polyhedron h) {
        Polygon2 p0 = (Polygon2)h.vertices[0].polygons().head();
        double max_edge_length = p0.patch.unit_length * 3.0;
        double min_edge_length = p0.patch.unit_length / 3.0;
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            double r = 0.0;
            if (v.quadratic_function != null) {
                r = LeastSquareFit.calculate_curvature(v, v.quadratic_function);
            } else {
                double total = 0.0;
                Enumeration e = v.quadratic_functions.elements();
                while (e.hasMoreElements()) {
                    double[] F = (double[])e.nextElement();
                    total += LeastSquareFit.calculate_curvature(v, F);
                }
                r = total / (double)v.quadratic_functions.size();
            }
            if (v.on_seam()) {
                r = Math.min(r, LeastSquareFit.calculate_seam_curvature(v) * 2.0);
            }
            v.target_edge_length = r * 0.8;
            v.target_edge_length = Math.max(min_edge_length, Math.min(v.target_edge_length, max_edge_length));
            ++i;
        }
        double[] target_length = new double[h.n_vertices];
        int i2 = 0;
        while (i2 < h.n_vertices) {
            Vertex v = h.vertices[i2];
            target_length[i2] = Skin.prevail(v, v.target_edge_length);
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_vertices) {
            Vertex v = h.vertices[i2];
            v.target_edge_length = Math.max(min_edge_length, Math.min(target_length[i2], max_edge_length));
            ++i2;
        }
    }

    public static void calculate_quadratic_patch_sharp(Vertex v) {
        Vector groups = v.get_polygon_groups_divided_by_sharp_edges();
        v.quadratic_functions = new Vector();
        v.quadratic_function_hashtable = new Hashtable();
        int i = 0;
        while (i < groups.size()) {
            Vector polygons = (Vector)groups.elementAt(i);
            Vector3 hint = LeastSquareFit.get_average_normal(polygons);
            Vector vs = LeastSquareFit.get_nearby_vertices(v, polygons);
            if (hint.length() == 0.0) {
                System.out.println("hint=0 in LeastSquareFit.calculate_quadratic_patch_sharp(v)");
                hint = v.get_non0_normal();
            }
            double[] F = LeastSquareFit.calculate_quadratic_patch_sub(v, hint, vs, false);
            v.quadratic_functions.addElement(F);
            int j = 0;
            while (j < polygons.size()) {
                Polygon2 polygon = (Polygon2)polygons.elementAt(j);
                v.quadratic_function_hashtable.put(polygon, F);
                ++j;
            }
            ++i;
        }
    }

    public static double calculate_seam_curvature(Vertex v) {
        Edge[] seam_edges = v.get_seam_edges();
        Vector3 vec0 = new Vector3(v, seam_edges[0].get_the_other_vertex(v));
        Vector3 vec1 = new Vector3(v, seam_edges[1].get_the_other_vertex(v));
        double l0 = vec0.length();
        double l1 = vec1.length();
        double cos = Vector3.dot_product(vec0, vec1);
        double l = Math.sqrt((l0 * l0 + l1 * l1 - 2.0 * l0 * l1 * cos) / 4.0 / (1.0 - cos * cos)) * 2.0;
        return l;
    }

    public static void drift(Polyhedron h) {
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            v.warp(LeastSquareFit.calculate_position(v, v.body_vertex, v.body_element));
            ++i;
        }
        h.set_normals();
    }

    public static void calculate_quadratic_patch(Polyhedron h, boolean slow_and_robust) {
        int i = 0;
        while (i < h.n_polygons) {
            h.polygons[i].set_area();
            ++i;
        }
        i = 0;
        while (i < h.n_vertices) {
            h.vertices[i].set_area();
            ++i;
        }
        i = 0;
        while (i < h.n_vertices) {
            LeastSquareFit.calculate_quadratic_patch(h.vertices[i], slow_and_robust);
            ++i;
        }
    }

    public static void calculate_quadratic_patch(Vertex v, boolean slow_and_robust) {
        if (v.on_sharp()) {
            LeastSquareFit.calculate_quadratic_patch_sharp(v);
            return;
        }
        Vector3 hint = v.normal;
        Vector vs = LeastSquareFit.get_nearby_vertices_wide(v);
        if (hint.length() == 0.0) {
            System.out.println("hint=0 in LeastSquareFit.calculate_quadratic_patch(v)");
            hint = v.get_non0_normal();
        }
        v.quadratic_function = LeastSquareFit.calculate_quadratic_patch_sub(v, hint, vs, slow_and_robust);
    }

    public static Vector get_nearby_vertices(Vertex v, Vector polygons) {
        Queue queue = new Queue();
        queue.enqueue(v, 0.0);
        int i = 0;
        while (i < polygons.size()) {
            Polygon2 polygon = (Polygon2)polygons.elementAt(i);
            int j = 0;
            while (j < 3) {
                Vertex u = polygon.get_vertex(j);
                if (!queue.contains(u)) {
                    queue.enqueue(u, Vector3.distance(v, u));
                }
                ++j;
            }
            ++i;
        }
        Vector<Vertex> result = new Vector<Vertex>();
        while (result.size() < 13) {
            Vertex u = (Vertex)queue.dequeue();
            result.addElement(u);
            Enumeration e = u.polygons().elements();
            while (e.hasMoreElements()) {
                Vertex w;
                Polygon2 polygon = (Polygon2)e.nextElement();
                if (!polygons.contains(polygon)) continue;
                Edge edge = polygon.get_opposite_edge(u);
                if (edge.sharp) continue;
                Polygon2 next_polygon = edge.get_another_polygon(polygon);
                if (!polygons.contains(next_polygon)) {
                    polygons.addElement(next_polygon);
                }
                if (queue.contains(w = next_polygon.get_opposite_vertex(edge)) || result.contains(w)) continue;
                queue.enqueue(w, Vector3.distance(v, w));
            }
            if (queue.size() == 0) break;
        }
        return result;
    }

    public static void calculate_quadratic_patch(Polygon2 polygon) {
        Vector vs = LeastSquareFit.get_nearby_vertices_wide(polygon);
        Vertex center = polygon.get_center();
        vs.addElement(center.translate(polygon.normal.multiple(0.1)));
        vs.addElement(center.translate(polygon.normal.multiple(-0.1)));
        double[][] L = new double[10][vs.size()];
        double[][] W = new double[vs.size()][vs.size()];
        double[] b = new double[vs.size()];
        int i = 0;
        while (i < vs.size()) {
            Vertex p = (Vertex)vs.elementAt(i);
            double x = p.x;
            double y = p.y;
            double z = p.z;
            L[0][i] = x * x;
            L[1][i] = y * y;
            L[2][i] = z * z;
            L[3][i] = x * y;
            L[4][i] = y * z;
            L[5][i] = z * x;
            L[6][i] = x;
            L[7][i] = y;
            L[8][i] = z;
            L[9][i] = 1.0;
            W[i][i] = 1.0;
            b[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < 3) {
            W[i][i] = 2.0;
            ++i;
        }
        b[vs.size() - 2] = 1.0;
        b[vs.size() - 1] = -1.0;
        W[vs.size() - 2][vs.size() - 2] = 0.01;
        W[vs.size() - 1][vs.size() - 1] = 0.01;
        double[][] Lt = DoubleMatrix.transpose((double[][])L);
        double[][] M = DoubleMatrix.multiply((double[][])L, (double[][])W);
        M = DoubleMatrix.multiply((double[][])M, (double[][])Lt);
        double[] B = DoubleMatrix.multiply((double[][])DoubleMatrix.multiply((double[][])L, (double[][])W), (double[])b);
        double[] F = null;
        try {
            F = DoubleMatrix.solve((double[][])M, (double[])B);
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        polygon.quadratic_function = F;
    }

    public static double[] calculate_quadratic_patch_sub(Vertex v, Vector3 hint, Vector vs, boolean slow_and_robust) {
        int n = vs.size();
        int m = 1;
        slow_and_robust = true;
        if (slow_and_robust) {
            m = vs.size();
            int i = 0;
            while (i < m) {
                Vertex u = (Vertex)vs.elementAt(i);
                vs.addElement(u.translate(u.normal.multiple(0.05)));
                vs.addElement(u.translate(u.normal.multiple(-0.05)));
                ++i;
            }
        } else {
            vs.addElement(v.translate(hint.multiple(0.1)));
            vs.addElement(v.translate(hint.multiple(-0.1)));
        }
        double area = 0.0;
        double[][] L = new double[10][vs.size()];
        double[][] W = new double[vs.size()][vs.size()];
        double[] b = new double[vs.size()];
        int i = 0;
        while (i < vs.size()) {
            Vertex p = (Vertex)vs.elementAt(i);
            double x = p.x;
            double y = p.y;
            double z = p.z;
            L[0][i] = x * x;
            L[1][i] = y * y;
            L[2][i] = z * z;
            L[3][i] = x * y;
            L[4][i] = y * z;
            L[5][i] = z * x;
            L[6][i] = x;
            L[7][i] = y;
            L[8][i] = z;
            L[9][i] = 1.0;
            W[i][i] = 1.0;
            b[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < m) {
            b[n + i * 2] = 1.0;
            b[n + i * 2 + 1] = -1.0;
            W[n + i * 2][n + i * 2] = 0.01;
            W[n + i * 2 + 1][n + i * 2 + 1] = 0.01;
            ++i;
        }
        double[][] Lt = DoubleMatrix.transpose((double[][])L);
        double[][] M = DoubleMatrix.multiply((double[][])L, (double[][])W);
        M = DoubleMatrix.multiply((double[][])M, (double[][])Lt);
        double[] B = DoubleMatrix.multiply((double[][])DoubleMatrix.multiply((double[][])L, (double[][])W), (double[])b);
        double[] F = null;
        try {
            F = DoubleMatrix.solve((double[][])M, (double[])B);
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        if (F[0] == 0.0 && F[1] == 0.0 && F[2] == 0.0) {
            System.out.println("error in LeastSquareFit.calculate_quadratic_patch_sub() " + vs.size() + " " + n + " " + m + "(" + v.x + "," + v.y + "," + v.z + ")");
            System.out.println("" + hint.x + " " + hint.y + " " + hint.z);
        }
        return F;
    }

    public static Vector get_nearby_vertices(Vertex v) {
        Vector<Vertex> vs = new Vector<Vertex>();
        vs.addElement(v);
        Enumeration e = v.get_surrounding_vertices().elements();
        while (e.hasMoreElements()) {
            Vertex u = (Vertex)e.nextElement();
            vs.addElement(u);
        }
        e = v.polygons().elements();
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            Edge edge = polygon.get_opposite_edge(v);
            Vertex u = edge.get_another_polygon(polygon).get_opposite_vertex(edge);
            vs.addElement(u);
        }
        return vs;
    }

    public static Vector get_nearby_vertices(Polygon2 polygon) {
        Vector<Vertex> vs = new Vector<Vertex>();
        int i = 0;
        while (i < 3) {
            Vertex v = polygon.get_vertex(i);
            Enumeration e = v.get_surrounding_vertices().elements();
            while (e.hasMoreElements()) {
                Vertex u = (Vertex)e.nextElement();
                if (vs.contains(u)) continue;
                vs.addElement(u);
            }
            ++i;
        }
        return vs;
    }

    public static Vector get_nearby_vertices_wide(Vertex v) {
        Vector<Vertex> result = new Vector<Vertex>();
        result.addElement(v);
        Queue queue = new Queue();
        queue.enqueue(v, 0.0);
        Enumeration e = v.get_surrounding_vertices().elements();
        while (e.hasMoreElements()) {
            Vertex u = (Vertex)e.nextElement();
            queue.enqueue(u, Vector3.distance(v, u));
            result.addElement(u);
        }
        while (result.size() < 13) {
            Vertex u = (Vertex)queue.dequeue();
            if (!result.contains(u)) {
                result.addElement(u);
            }
            Enumeration e2 = u.edges.elements();
            while (e2.hasMoreElements()) {
                Vertex v1;
                Vertex v0;
                Vertex w;
                Edge edge = (Edge)e2.nextElement();
                if (edge.sharp || !result.contains(w = edge.get_the_other_vertex(u))) continue;
                if (edge.left_polygon != null && !result.contains(v0 = edge.left_polygon().get_opposite_vertex(edge)) && !queue.contains(v0)) {
                    queue.enqueue(v0, Vector3.distance(v, v0));
                }
                if (edge.right_polygon == null || result.contains(v1 = edge.right_polygon().get_opposite_vertex(edge)) || queue.contains(v1)) continue;
                queue.enqueue(v1, Vector3.distance(v, v1));
            }
            if (queue.size() == 0) break;
        }
        return result;
    }

    public static Vector get_nearby_vertices_wide(Polygon2 polygon) {
        Vertex v;
        Vertex center = polygon.get_circum_center();
        Queue queue = new Queue();
        int i = 0;
        while (i < 3) {
            v = polygon.get_vertex(i);
            queue.enqueue(v, Vector3.distance(v, center));
            ++i;
        }
        Edge base_edge = polygon.get_opposite_edge(polygon.get_vertex(2));
        if (!base_edge.sharp) {
            v = base_edge.get_another_polygon(polygon).get_opposite_vertex(base_edge);
            queue.enqueue(v, Vector3.distance(v, center));
        }
        Vector<Vertex> result = new Vector<Vertex>();
        while (result.size() < 13) {
            Vertex u = (Vertex)queue.dequeue();
            result.addElement(u);
            Enumeration e = u.edges.elements();
            while (e.hasMoreElements()) {
                Vertex v1;
                Vertex w;
                Edge edge = (Edge)e.nextElement();
                if (edge.sharp || !result.contains(w = edge.get_the_other_vertex(u))) continue;
                Vertex v0 = edge.left_polygon().get_opposite_vertex(edge);
                if (!result.contains(v0) && !queue.contains(v0)) {
                    queue.enqueue(v0, Vector3.distance(center, v0));
                }
                if (result.contains(v1 = edge.right_polygon().get_opposite_vertex(edge)) || queue.contains(v1)) continue;
                queue.enqueue(v1, Vector3.distance(center, v1));
            }
            if (queue.size() == 0) break;
        }
        return result;
    }

    public static Vector3 get_average_normal(Vector polygons) {
        Vector3 total = new Vector3();
        int i = 0;
        while (i < polygons.size()) {
            Polygon2 polygon = (Polygon2)polygons.elementAt(i);
            total.add_self(polygon.normal);
            ++i;
        }
        total.normalize_self();
        return total;
    }

    public static Vector get_nearby_vertices_wide(Edge base_edge) {
        Vertex center = base_edge.get_mid_vertex();
        Queue queue = new Queue();
        queue.enqueue(base_edge.start, Vector3.distance(base_edge.start, center));
        queue.enqueue(base_edge.end, Vector3.distance(base_edge.end, center));
        Vertex u0 = base_edge.left_polygon().get_opposite_vertex(base_edge);
        queue.enqueue(u0, Vector3.distance(u0, center));
        Vertex u1 = base_edge.right_polygon().get_opposite_vertex(base_edge);
        queue.enqueue(u1, Vector3.distance(u1, center));
        Vector<Vertex> result = new Vector<Vertex>();
        while (result.size() < 13) {
            Vertex u = (Vertex)queue.dequeue();
            result.addElement(u);
            Enumeration e = u.edges.elements();
            while (e.hasMoreElements()) {
                Vertex v1;
                Vertex w;
                Edge edge = (Edge)e.nextElement();
                if (edge.sharp || !result.contains(w = edge.get_the_other_vertex(u))) continue;
                Vertex v0 = edge.left_polygon().get_opposite_vertex(edge);
                if (!result.contains(v0) && !queue.contains(v0)) {
                    queue.enqueue(v0, Vector3.distance(center, v0));
                }
                if (result.contains(v1 = edge.right_polygon().get_opposite_vertex(edge)) || queue.contains(v1)) continue;
                queue.enqueue(v1, Vector3.distance(center, v1));
            }
            if (queue.size() == 0) break;
        }
        return result;
    }

    public static Vector3 get_normal(Vertex v, double[] F) {
        double dx = 2.0 * F[0] * v.x + F[3] * v.y + F[5] * v.z + F[6];
        double dy = 2.0 * F[1] * v.y + F[3] * v.x + F[4] * v.z + F[7];
        double dz = 2.0 * F[2] * v.z + F[4] * v.y + F[5] * v.x + F[8];
        Vector3 normal = new Vector3(dx, dy, dz);
        normal.normalize_self();
        return normal;
    }

    public static double calculate_curvature(Vertex v, double[] F) {
        double dx = 2.0 * F[0] * v.x + F[3] * v.y + F[5] * v.z + F[6];
        double dy = 2.0 * F[1] * v.y + F[3] * v.x + F[4] * v.z + F[7];
        double dz = 2.0 * F[2] * v.z + F[4] * v.y + F[5] * v.x + F[8];
        Vector3 normal = new Vector3(dx, dy, dz);
        normal.normalize_self();
        Vector3 b0 = new Vector3(normal.y - normal.z, normal.z - normal.x, normal.x - normal.y);
        b0.normalize_self();
        Vector3 b1 = Vector3.cross_product(normal, b0);
        b1.normalize_self();
        double[][] A = new double[2][2];
        A[0][0] = 2.0 * (F[0] * b0.x * b0.x + F[1] * b0.y * b0.y + F[2] * b0.z * b0.z + F[3] * b0.x * b0.y + F[4] * b0.y * b0.z + F[5] * b0.z * b0.x);
        double d = 2.0 * (F[0] * b0.x * b1.x + F[1] * b0.y * b1.y + F[2] * b0.z * b1.z) + F[3] * b0.x * b1.y + F[4] * b0.y * b1.z + F[5] * b0.z * b1.x + F[3] * b1.x * b0.y + F[4] * b1.y * b0.z + F[5] * b1.z * b0.x;
        A[0][1] = d;
        A[1][0] = d;
        A[1][1] = 2.0 * (F[0] * b1.x * b1.x + F[1] * b1.y * b1.y + F[2] * b1.z * b1.z + F[3] * b1.x * b1.y + F[4] * b1.y * b1.z + F[5] * b1.z * b1.x);
        DoubleSVD svd = new DoubleSVD(A);
        double[] S = svd.S();
        double k0 = S[0];
        double k1 = S[1];
        double k = k0;
        double r = 1.0 / (k /= Math.sqrt(dx * dx + dy * dy + dz * dz));
        return r;
    }

    public static Vertex move_to_isosurface(Vertex v) {
        if (v.quadratic_function != null) {
            return LeastSquareFit.move_to_isosurface(v, v.quadratic_function);
        }
        return LeastSquareFit.move_to_isosurface_on_sharp(v);
    }
}

