/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.Edge;
import teddy.ImplicitFunction;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;

public class ImplicitPatch {
    public static void set(Polyhedron h) {
        int i = 0;
        while (i < h.n_polygons) {
            Polygon2 polygon = h.polygons[i];
            ImplicitPatch.set(polygon);
            ++i;
        }
    }

    public static void set(Polygon2 polygon) {
        Vertex v;
        Vector<Vertex> zeroKnots = new Vector<Vertex>();
        Vector<Vertex> plusKnots = new Vector<Vertex>();
        int i = 0;
        while (i < 3) {
            v = polygon.get_vertex(i);
            Enumeration e = v.get_surrounding_vertices().elements();
            while (e.hasMoreElements()) {
                Vertex u = (Vertex)e.nextElement();
                if (zeroKnots.contains(u)) continue;
                zeroKnots.addElement(u);
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Edge edge = polygon.edges[i];
            Vertex v2 = edge.get_another_polygon(polygon).get_opposite_vertex(edge);
            Enumeration e = v2.get_surrounding_vertices().elements();
            while (e.hasMoreElements()) {
                Vertex u = (Vertex)e.nextElement();
                if (zeroKnots.contains(u)) continue;
                zeroKnots.addElement(u);
            }
            ++i;
        }
        i = 0;
        while (i < zeroKnots.size()) {
            v = (Vertex)zeroKnots.elementAt(i);
            Vertex pv = v.translate(v.normal.multiple(0.001));
            plusKnots.addElement(pv);
            ++i;
        }
        polygon.iFunction = new ImplicitFunction(zeroKnots, plusKnots);
    }

    public static Vertex calculate_position(Vertex v, Vertex body_vertex, Object body_element) {
        if (body_element instanceof Vertex) {
            return body_vertex;
        }
        if (body_element instanceof Polygon2) {
            Polygon2 polygon = (Polygon2)body_element;
            return ImplicitPatch.calculate_position(v, polygon);
        }
        Edge edge = (Edge)body_element;
        Vertex v0 = ImplicitPatch.calculate_position(v, edge.right_polygon);
        Vertex v1 = ImplicitPatch.calculate_position(v, edge.right_polygon);
        return Vertex.mid_point(v0, v1);
    }

    public static Vertex calculate_position(Vertex v, Polygon2 polygon) {
        double height = polygon.iFunction.get_value(v);
        if (Double.isNaN(height)) {
            System.out.println("height Nan");
        }
        Vector3 dv = polygon.normal.multiple(-height / 1000.0);
        return v.translate(dv);
    }
}

