/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleMatrix;
import java.util.Vector;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class ImplicitFunction {
    public Vector zeroKnots;
    public Vector plusKnots;
    public double[] d;
    public double[] p;
    public Vertex[] c;
    public int size;

    public double phai_dz(Vertex v0, Vertex v1) {
        double d = Vector3.distance(v0, v1);
        double dz = v1.z - v0.z;
        return 2.0 * dz * 3.0 * d * d;
    }

    public void set(Vector zeroKnots, Vector plusKnots) {
        Vertex v;
        this.zeroKnots = new Vector();
        int i = 0;
        while (i < zeroKnots.size()) {
            v = (Vertex)zeroKnots.elementAt(i);
            this.zeroKnots.addElement(new Vertex(v));
            ++i;
        }
        this.plusKnots = new Vector();
        i = 0;
        while (i < plusKnots.size()) {
            v = (Vertex)plusKnots.elementAt(i);
            this.plusKnots.addElement(new Vertex(v));
            ++i;
        }
        this.calculate(zeroKnots, plusKnots);
    }

    ImplicitFunction() {
        this.size = 0;
    }

    ImplicitFunction(Vector zeroKnots, Vector plusKnots) {
        this.set(zeroKnots, plusKnots);
    }

    public void calculate(Vector zeroKnots, Vector plusKnots) {
        int i;
        this.size = zeroKnots.size() + plusKnots.size();
        this.c = new Vertex[this.size];
        double[] values = new double[this.size];
        int i2 = 0;
        while (i2 < this.size) {
            boolean value;
            Vertex p;
            if (i2 < zeroKnots.size()) {
                p = (Vertex)zeroKnots.elementAt(i2);
                value = false;
            } else {
                p = (Vertex)plusKnots.elementAt(i2 - zeroKnots.size());
                value = true;
            }
            this.c[i2] = new Vertex(p);
            values[i2] = (double)value;
            ++i2;
        }
        double[][] matrix = new double[this.size + 4][this.size + 4];
        int j = 0;
        while (j < this.size) {
            i = j;
            while (i < this.size) {
                double dammy = matrix[i][j];
                dammy = this.phai(this.c[i], this.c[j]);
                matrix[i][j] = this.phai(this.c[i], this.c[j]);
                ++i;
            }
            matrix[this.size][j] = 1.0;
            matrix[this.size + 1][j] = this.c[j].x;
            matrix[this.size + 2][j] = this.c[j].y;
            matrix[this.size + 3][j] = this.c[j].z;
            ++j;
        }
        j = 0;
        while (j < this.size + 4) {
            i = j + 1;
            while (i < this.size + 4) {
                matrix[j][i] = matrix[i][j];
                ++i;
            }
            ++j;
        }
        double[] array = new double[this.size + 4];
        i = 0;
        while (i < this.size) {
            array[i] = values[i];
            ++i;
        }
        double[] array2 = new double[this.size + 4];
        try {
            array2 = DoubleMatrix.solve((double[][])matrix, (double[])array);
        }
        catch (Exception e) {
            System.out.println("Solve failed! " + e);
        }
        this.d = new double[this.size];
        int i3 = 0;
        while (i3 < this.size) {
            this.d[i3] = array2[i3];
            ++i3;
        }
        this.p = new double[4];
        this.p[0] = array2[this.size];
        this.p[1] = array2[this.size + 1];
        this.p[2] = array2[this.size + 2];
        this.p[3] = array2[this.size + 3];
    }

    public double get_value(Vertex v) {
        if (this.size == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.size) {
            sum += this.d[i] * this.phai(v, this.c[i]);
            ++i;
        }
        sum += this.p[0];
        sum += this.p[1] * v.x;
        sum += this.p[2] * v.y;
        return sum += this.p[3] * v.z;
    }

    public ImplicitFunction copy() {
        ImplicitFunction child = new ImplicitFunction();
        child.zeroKnots = Util.duplicateVector(this.zeroKnots);
        child.plusKnots = Util.duplicateVector(this.plusKnots);
        child.size = this.size;
        child.d = (double[])this.d.clone();
        child.p = (double[])this.p.clone();
        child.c = (Vertex[])this.c.clone();
        return child;
    }

    public double phai_dx(Vertex v0, Vertex v1) {
        double d = Vector3.distance(v0, v1);
        double dx = v1.x - v0.x;
        return 2.0 * dx * 3.0 * d * d;
    }

    public double get_slope(Vertex position, Vector3 direction) {
        if (this.size == 0) {
            return 0.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.size) {
            sum += this.d[i] * this.phai_dx(position, this.c[i]) * direction.x;
            sum += this.d[i] * this.phai_dy(position, this.c[i]) * direction.y;
            sum += this.d[i] * this.phai_dz(position, this.c[i]) * direction.z;
            ++i;
        }
        sum += this.p[1] * direction.x;
        sum += this.p[2] * direction.y;
        return sum += this.p[3] * direction.z;
    }

    public double phai(Vertex v0, Vertex v1) {
        double d = Vector3.distance(v0, v1);
        return d * d * d;
    }

    public double phai_dy(Vertex v0, Vertex v1) {
        double d = Vector3.distance(v0, v1);
        double dy = v1.y - v0.y;
        return 2.0 * dy * 3.0 * d * d;
    }
}

