/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import VisualNumerics.math.DoubleMatrix;
import java.util.Enumeration;
import teddy.ConjugateGradient;
import teddy.Edge;
import teddy.LoopSubdivision;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Skin;
import teddy.Vector3;
import teddy.Vertex;

public class HoppeOptimization {
    public static void propagate(Vertex v, Vertex parent, boolean[] visited) {
        visited[v.index] = true;
        if (parent != null) {
            Object[] result = Skin.move_along_body_surface(null, parent.body_element, v);
            v.body_element = result[0];
            v.body_vertex = (Vertex)result[1];
        }
        Enumeration e = v.get_surrounding_vertices().elements();
        while (e.hasMoreElements()) {
            Vertex u = (Vertex)e.nextElement();
            if (visited[u.index]) continue;
            HoppeOptimization.propagate(u, v, visited);
        }
    }

    public static double[] blend_weight_vector(double[] v0, double[] v1, double[] v2, double w0, double w1, double w2) {
        double[] v = new double[v0.length];
        int i = 0;
        while (i < v.length) {
            v[i] = v0[i] * w0 + v1[i] * w1 + v2[i] * w2;
            ++i;
        }
        return v;
    }

    public static void init_weight_vector(Polyhedron control_mesh) {
        int i = 0;
        while (i < control_mesh.n_vertices) {
            Vertex v = control_mesh.vertices[i];
            v.weight_vector = new double[control_mesh.n_vertices];
            v.weight_vector[i] = 1.0;
            ++i;
        }
    }

    public static void set_closest_polygons(Polyhedron original_mesh, Polyhedron refined_mesh) {
        Vertex root = original_mesh.vertices[0];
        root.body_element = HoppeOptimization.find_closest_polygon(root, refined_mesh);
        boolean[] visited = new boolean[original_mesh.n_vertices];
        HoppeOptimization.propagate(root, null, visited);
        int i = 0;
        while (i < original_mesh.n_vertices) {
            Vertex v = original_mesh.vertices[i];
            if (v.body_element instanceof Edge) {
                v.body_element = ((Edge)v.body_element).left_polygon;
            } else if (v.body_element instanceof Vertex) {
                v.body_element = (Polygon2)((Vertex)v.body_element).polygons().head();
            }
            ++i;
        }
    }

    public static Polygon2 find_closest_polygon(Vertex v, Polyhedron refined_mesh) {
        double min = -1.0;
        Polygon2 closest_polygon = null;
        int i = 0;
        while (i < refined_mesh.n_polygons) {
            Polygon2 polygon = refined_mesh.polygons[i];
            double d = polygon.distance_as_a_segment(v);
            d *= d;
            if (min == -1.0 || d < min) {
                closest_polygon = polygon;
                min = d;
            }
            ++i;
        }
        return closest_polygon;
    }

    public static Polygon2 find_closest_polygon(Vertex v, Vertex parent, Polygon2 polygon) {
        Polygon2 p0 = polygon.edges[0].get_another_polygon(polygon);
        Polygon2 p1 = polygon.edges[1].get_another_polygon(polygon);
        Polygon2 p2 = polygon.edges[2].get_another_polygon(polygon);
        double d = polygon.distance_as_a_segment(v);
        double d0 = p0.distance_as_a_segment(v);
        double d1 = p1.distance_as_a_segment(v);
        double d2 = p2.distance_as_a_segment(v);
        if (d <= d0 && d <= d1 && d <= d2) {
            return polygon;
        }
        if (d0 <= d && d0 <= d1 && d0 <= d2) {
            return p0;
        }
        if (d1 <= d && d1 <= d0 && d1 <= d2) {
            return p1;
        }
        return p2;
    }

    public static Object[] calculate_weights(Vertex v, Polygon2 closest_polygon) {
        Vertex w = closest_polygon.project_as_a_segment(v);
        Vertex v0 = closest_polygon.get_vertex(0);
        Vertex v1 = closest_polygon.get_vertex(1);
        Vertex v2 = closest_polygon.get_vertex(2);
        Vector3 e0 = new Vector3(v0, v1);
        Vector3 e1 = new Vector3(v0, v2);
        Vector3 vec = new Vector3(v0, w);
        double[][] A = new double[][]{{e0.x, e1.x}, {e0.y, e1.y}};
        double[] b = new double[]{vec.x, vec.y};
        double[] x = null;
        try {
            x = DoubleMatrix.solve((double[][])A, (double[])b);
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
        double s = x[0];
        double t = x[1];
        if (s < 0.0) {
            s = 0.0;
        }
        if (t < 0.0) {
            t = 0.0;
        }
        if (s > 1.0) {
            s = 1.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        if (s + t > 1.0) {
            double k = s + t;
            s /= k;
            t /= k;
        }
        double u = 1.0 - s - t;
        Object[] result = new Object[]{v0, v1, v2, new Double(u), new Double(s), new Double(t)};
        return result;
    }

    public static void optimize_control_mesh(Polyhedron control_mesh, Polyhedron original_mesh) {
        double[] b = new double[original_mesh.n_vertices];
        double[] x = new double[control_mesh.n_vertices];
        double[][] A = new double[original_mesh.n_vertices][control_mesh.n_vertices];
        Polyhedron refined_mesh = control_mesh.copy();
        HoppeOptimization.init_weight_vector(refined_mesh);
        LoopSubdivision.subdivide(refined_mesh);
        HoppeOptimization.set_closest_polygons(original_mesh, refined_mesh);
        int i = 0;
        while (i < original_mesh.n_vertices) {
            Vertex v = original_mesh.vertices[i];
            Polygon2 closest_polygon = (Polygon2)v.body_element;
            A[i] = HoppeOptimization.get_weight_vector(v, closest_polygon);
            ++i;
        }
        int c = 0;
        while (c < 3) {
            int i2 = 0;
            while (i2 < original_mesh.n_vertices) {
                b[i2] = original_mesh.vertices[i2].get_coord(c);
                ++i2;
            }
            i2 = 0;
            while (i2 < control_mesh.n_vertices) {
                x[i2] = control_mesh.vertices[i2].get_coord(c);
                ++i2;
            }
            x = ConjugateGradient.solve_least_square(A, b, x);
            i2 = 0;
            while (i2 < control_mesh.n_vertices) {
                control_mesh.vertices[i2].set_coord(c, x[i2]);
                ++i2;
            }
            ++c;
        }
        control_mesh.set_parameters();
    }

    public static double[] get_weight_vector(Vertex v, Polygon2 polygon) {
        Object[] t = HoppeOptimization.calculate_weights(v, polygon);
        Vertex v0 = (Vertex)t[0];
        Vertex v1 = (Vertex)t[1];
        Vertex v2 = (Vertex)t[2];
        double w0 = (Double)t[3];
        double w1 = (Double)t[4];
        double w2 = (Double)t[5];
        double[] weight_vector = HoppeOptimization.blend_weight_vector(v0.weight_vector, v1.weight_vector, v2.weight_vector, w0, w1, w2);
        return weight_vector;
    }
}

