/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import teddy.Vector2;

public class Graphics2 {
    static void addPoint(Polygon s, Point p, Vector2 v) {
        s.addPoint((int)((double)p.x + v.x), (int)((double)p.y + v.y));
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        Graphics2.drawWideLine(g, x1, y1, x2, y2, 4.0);
    }

    public static void drawRandomLine(Graphics g, int x1, int y1, int x2, int y2) {
        Vector2 v = new Vector2(x2 - x1, y2 - y1);
        Vector2 r0 = v.rotate(Math.random() * 60.0 - 30.0).scale(Math.random() * 0.2);
        Vector2 r1 = r0.rotate(180.0);
        int xx0 = x1 + (int)r1.x;
        int yy0 = y1 + (int)r1.y;
        int xx1 = x2 + (int)r0.x;
        int yy1 = y2 + (int)r0.y;
        g.drawLine(xx0, yy0, xx1, yy1);
    }

    public static void drawWideCircle(Graphics g, int x, int y, int radius, int w) {
        int i = radius - w / 2;
        while (i < radius + w / 2) {
            g.drawOval(x - i, y - i, i * 2 - 1, i * 2 - 1);
            ++i;
        }
    }

    public static void floodFill(Image image, Point p, Color color) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (Exception e) {
            return;
        }
        if ((grabber.status() & 0x80) != 0) {
            return;
        }
        Graphics2.floodFill(p.x, p.y, color.getRGB(), pixels, width, height);
        Image displayImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        Graphics g = image.getGraphics();
        g.drawImage(displayImage, 0, 0, null);
        g.dispose();
    }

    private static void floodFill(int x, int y, int color, int[] pixels, int width, int height) {
        int baseRGB = Graphics2.getPixel(x, y, pixels, width);
        int[] pixelQueue = new int[pixels.length];
        int pixelQueueSize = 0;
        pixelQueue[0] = (y << 16) + x;
        pixelQueueSize = 1;
        pixels[y * width + x] = color;
        while (pixelQueueSize > 0) {
            x = pixelQueue[0] & 0xFFFF;
            y = pixelQueue[0] >> 16 & 0xFFFF;
            pixelQueue[0] = pixelQueue[--pixelQueueSize];
            if (x > 0 && Graphics2.getPixel(x - 1, y, pixels, width) == baseRGB) {
                Graphics2.setPixel(x - 1, y, color, pixels, width);
                pixelQueue[pixelQueueSize] = (y << 16) + x - 1;
                ++pixelQueueSize;
            }
            if (y > 0 && Graphics2.getPixel(x, y - 1, pixels, width) == baseRGB) {
                Graphics2.setPixel(x, y - 1, color, pixels, width);
                pixelQueue[pixelQueueSize] = (y - 1 << 16) + x;
                ++pixelQueueSize;
            }
            if (x < width - 1 && Graphics2.getPixel(x + 1, y, pixels, width) == baseRGB) {
                Graphics2.setPixel(x + 1, y, color, pixels, width);
                pixelQueue[pixelQueueSize] = (y << 16) + x + 1;
                ++pixelQueueSize;
            }
            if (y >= height - 1 || Graphics2.getPixel(x, y + 1, pixels, width) != baseRGB) continue;
            Graphics2.setPixel(x, y + 1, color, pixels, width);
            pixelQueue[pixelQueueSize] = (y + 1 << 16) + x;
            ++pixelQueueSize;
        }
    }

    public static void drawWideLine(Graphics g, double x1, double y1, double x2, double y2, double w) {
        Graphics2.drawWideLine(g, (int)x1, (int)y1, (int)x2, (int)y2, w);
    }

    public static void drawWideLine(Graphics g, int x1, int y1, int x2, int y2, double w) {
        int x = x2 - x1;
        int y = y2 - y1;
        double length = Math.sqrt(x * x + y * y);
        double nx = (double)x / length * w / 2.0;
        double ny = (double)y / length * w / 2.0;
        if (length == 0.0) {
            nx = w / 2.0;
            ny = 0.0;
        }
        Point start = new Point(x1, y1);
        Point end = new Point(x2, y2);
        Vector2 vector = new Vector2(nx, ny);
        Polygon s = new Polygon();
        int steps = 16;
        int i = 0;
        while (i <= steps) {
            Graphics2.addPoint(s, start, vector.rotate(90 + 180 * i / steps));
            ++i;
        }
        i = 0;
        while (i <= steps) {
            Graphics2.addPoint(s, end, vector.rotate(270 + 180 * i / steps));
            ++i;
        }
        Graphics2.addPoint(s, start, vector.rotate(90.0));
        g.fillPolygon(s);
    }

    public static int getPixel(int x, int y, int[] pixels, int width) {
        return pixels[y * width + x];
    }

    public static void setPixel(int x, int y, int color, int[] pixels, int width) {
        pixels[y * width + x] = color;
    }

    public static void drawRect(Graphics g, Rectangle box) {
        g.draw3DRect(box.x, box.y, box.width, box.height, true);
    }
}

