/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import teddy.Line2D;
import teddy.Vector2;
import teddy.Vertex2D;

public class Geometry2D {
    public static double get_radius(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        Vertex2D center = Geometry2D.get_circumcenter(v0, v1, v2);
        if (center == null) {
            return Double.MAX_VALUE;
        }
        return Vertex2D.distance(center, v0);
    }

    private static Line2D get_dividing_line(Vertex2D v0, Vertex2D v1) {
        Vertex2D mid_point = Vertex2D.mid_point(v0, v1);
        double dx = v1.x - v0.x;
        double dy = v1.y - v0.y;
        Vector2 direction = new Vector2(dy, -dx);
        return new Line2D(mid_point, direction);
    }

    public static boolean left_side(Vertex2D v0, Vertex2D v1, Point p) {
        return Geometry2D.left_side(v0, v1, new Vertex2D(p));
    }

    public static boolean left_side(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        if (v0 == v2 || v1 == v2) {
            return true;
        }
        Vector2 vec0 = new Vector2(v0, (Vector2)v1);
        Vector2 vec1 = new Vector2(v0, (Vector2)v2);
        return vec0.cross_product(vec1) <= 0.0;
    }

    public static boolean left_side(Vertex2D v0, Vertex2D v1, Vertex2D v2, Vertex2D v3) {
        Vector2 in_vec = new Vector2(v1, (Vector2)v0);
        Vector2 out_vec = new Vector2(v1, (Vector2)v2);
        Vector2 target_vec = new Vector2(v1, (Vector2)v3);
        double angle0 = 360.0 - out_vec.get_angle(target_vec);
        double angle1 = 360.0 - out_vec.get_angle(in_vec);
        if (angle0 == 360.0) {
            angle0 = 0.0;
        }
        return angle0 <= angle1;
    }

    public static boolean left_side(Point a, Point b, Point p) {
        return Geometry2D.left_side(new Vertex2D(a), new Vertex2D(b), new Vertex2D(p));
    }

    public static double distance_to_segment(Vertex2D start, Vertex2D end, Point node) {
        return Geometry2D.distance_to_segment(start, end, new Vertex2D(node));
    }

    public static double distance_to_segment(Point start, Point end, Vertex2D node) {
        return Geometry2D.distance_to_segment(new Vertex2D(start), new Vertex2D(end), node);
    }

    public static double distance_to_segment(Vertex2D start, Vertex2D end, Vertex2D node) {
        Vector2 vec0 = new Vector2(start, (Vector2)end);
        Vector2 vec1 = new Vector2(start, (Vector2)node);
        if (vec0.length() == 0.0) {
            return vec1.length();
        }
        if (Vector2.dot_product(vec0, vec1) < 0.0) {
            return Vertex2D.distance(node, start);
        }
        vec1 = new Vector2(end, (Vector2)node);
        if (Vector2.dot_product(vec0, vec1) > 0.0) {
            return Vertex2D.distance(node, end);
        }
        return Geometry2D.distance_line(start, end, node);
    }

    public static Vertex2D get_circumcenter(Vertex2D v0, Vertex2D v1, Vertex2D v2) {
        Line2D line0 = Geometry2D.get_dividing_line(v0, v1);
        Line2D line1 = Geometry2D.get_dividing_line(v0, v2);
        return Line2D.cross_point(line0, line1);
    }

    public static boolean intersects(Vertex2D a, Vertex2D b, Vertex2D p, Vertex2D q) {
        return Geometry2D.cross(a.x, a.y, b.x, b.y, p.x, p.y, q.x, q.y);
    }

    public static boolean intersects(Point a, Point b, Vertex2D p, Vertex2D q) {
        return Geometry2D.cross(a.x, a.y, b.x, b.y, p.x, p.y, q.x, q.y);
    }

    public static double distance_line(Vertex2D start, Vertex2D end, Vertex2D node) {
        double a = end.x - start.x;
        double b = end.y - start.y;
        double bunbo = Math.sqrt(a * a + b * b);
        double bunshi = a * (node.y - start.y) - b * (node.x - start.x);
        if (bunbo == 0.0) {
            System.out.println("Error in Segment.distance_line");
            return 0.0;
        }
        return Math.abs(bunshi / bunbo);
    }

    public static boolean cross(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        return (a0 * xx1 + b0 * yy1 + c0) * (a0 * xx2 + b0 * yy2 + c0) <= 0.0 && (a1 * x1 + b1 * y1 + c1) * (a1 * x2 + b1 * y2 + c1) <= 0.0;
    }
}

