/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Objects;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.ProjectedEdge;
import teddy.Surface;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

class Geometry {
    public static Polyhedron h;
    public static Vertex camera;
    public static Polygon2[] sorted_polygons;

    private static Vertex cross_point(Polygon2 polygon, Vertex2D v) {
        Vertex vertex = null;
        Edge edge = new Edge(camera, vertex);
        return polygon.cross_point(edge);
    }

    Geometry() {
    }

    public static Objects find_vertex_on_surface(Vertex2D v, boolean front_facing) {
        Vertex closest_vertex = null;
        Polygon2 closest_polygon = null;
        double closest_distance = -1.0;
        Vertex vertex = null;
        Polygon2 polygon = null;
        int i = 0;
        while (i < Geometry.h.n_polygons) {
            polygon = sorted_polygons[i];
            if (polygon.front_facing == front_facing && Geometry.on_surface(polygon, v)) {
                double distance;
                vertex = Geometry.cross_point(polygon, v);
                closest_distance = distance = Vector3.distance(camera, vertex);
                closest_vertex = vertex;
                closest_polygon = polygon;
                break;
            }
            ++i;
        }
        if (closest_distance != -1.0) {
            return new Objects(closest_polygon, closest_vertex);
        }
        return null;
    }

    public static LinkedList surface_path(Vertex2D start2D, Vertex2D end2D, Vertex start3D, Vertex end3D, Polygon2 start_polygon, Polygon2 end_polygon) {
        LinkedList edge_vertex_list = new LinkedList();
        if (start_polygon == end_polygon) {
            return edge_vertex_list;
        }
        ProjectedEdge stroke = new ProjectedEdge(start2D, end2D);
        Polygon2 current_polygon = start_polygon;
        Vertex previous_vertex3D = start3D;
        ProjectedEdge previous_edge = stroke;
        Surface cut_surface = null;
        while (current_polygon != end_polygon) {
            Objects objects = Geometry.find_cross_edge(current_polygon, stroke, previous_edge.original);
            ProjectedEdge next_edge = (ProjectedEdge)objects.get(0);
            Vertex2D next_vertex2D = (Vertex2D)objects.get(1);
            Vertex next_vertex3D = cut_surface.cross_point(next_edge.original);
            edge_vertex_list.append(new Objects(next_edge.original, next_vertex3D));
            current_polygon = next_edge.original.get_another_polygon(current_polygon);
            previous_vertex3D = next_vertex3D.copy();
            previous_edge = next_edge;
        }
        return edge_vertex_list;
    }

    public static boolean on_surface(Polygon2 polygon, Vertex2D v) {
        int i = 0;
        while (i < polygon.n_edges) {
            if (!new ProjectedEdge(polygon.edges(i)).in(polygon, v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Objects find_cross_edge(Polygon2 polygon, ProjectedEdge stroke, Edge previous) {
        int i = 0;
        while (i < polygon.n_edges) {
            ProjectedEdge edge;
            if (polygon.edges(i) != previous && (edge = new ProjectedEdge(polygon.edges(i))).cross(stroke)) {
                Vertex2D vertex = edge.cross_point(stroke);
                return new Objects(edge, vertex);
            }
            ++i;
        }
        System.out.println("error in path finding (Geometry.find_cross_edge())");
        return null;
    }

    public static void sort_polygons() {
        LinkedList l = new LinkedList();
        int i = 0;
        while (i < Geometry.h.n_polygons) {
            Geometry.h.polygons[i].set_distance(camera);
            l.append(Geometry.h.polygons[i]);
            ++i;
        }
        l = Geometry.sort_polygons(l);
        sorted_polygons = new Polygon2[Geometry.h.n_polygons];
        Enumeration e = l.elements();
        int i2 = 0;
        while (i2 < Geometry.h.n_polygons) {
            Geometry.sorted_polygons[i2] = (Polygon2)e.nextElement();
            ++i2;
        }
    }

    private static LinkedList sort_polygons(LinkedList l) {
        LinkedList left = new LinkedList();
        LinkedList right = new LinkedList();
        Enumeration e = l.elements();
        if (!e.hasMoreElements()) {
            return new LinkedList();
        }
        Polygon2 pivot = (Polygon2)e.nextElement();
        double mean = pivot.distance;
        while (e.hasMoreElements()) {
            Polygon2 polygon = (Polygon2)e.nextElement();
            if (polygon.distance < mean) {
                left.append(polygon);
                continue;
            }
            right.append(polygon);
        }
        left = Geometry.sort_polygons(left);
        right = Geometry.sort_polygons(right);
        l = left;
        l.append(pivot);
        l.connect(right);
        return l;
    }

    public static void init(Polyhedron _h, Vertex _c) {
        h = _h;
        camera = _c;
        Geometry.sort_polygons();
    }
}

