/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.ImplicitFunction;
import teddy.LinkedList;
import teddy.Polyhedron;
import teddy.Skeleton;
import teddy.StrokeAnalyzer;
import teddy.Vertex;
import teddy.Vertex2D;

public class Generate {
    private static Polyhedron h;
    public static final double UNIT_LENGTH = 0.1;

    public static Polyhedron symmetric_generate(Vector stroke, double inflation_ratio, double max_height) {
        Vertex2D v;
        int i = 0;
        while (i < stroke.size()) {
            ((Vertex2D)stroke.elementAt((int)i)).index = i;
            ++i;
        }
        double unit_length = 0.1;
        StrokeAnalyzer.setParameters(unit_length);
        stroke = StrokeAnalyzer.resample(stroke);
        Vector<Vertex2D> new_stroke = new Vector<Vertex2D>();
        int n = stroke.size() / 2;
        Vertex2D base = new Vertex2D((Vertex2D)stroke.elementAt(0));
        Vertex2D top = new Vertex2D((Vertex2D)stroke.elementAt(n));
        int i2 = 0;
        while (i2 <= n) {
            v = (Vertex2D)stroke.elementAt(i2);
            new_stroke.addElement(new Vertex2D(v.x - base.x - (double)i2 * (top.x - base.x) / (double)n, v.y));
            ++i2;
        }
        i2 = n - 1;
        while (i2 > 0) {
            v = (Vertex2D)stroke.elementAt(i2);
            new_stroke.addElement(new Vertex2D(-(v.x - base.x - (double)i2 * (top.x - base.x) / (double)n), v.y));
            --i2;
        }
        LinkedList point_list = new LinkedList(new_stroke);
        point_list = Generate.counter_clockwise(point_list);
        return Skeleton.generate_polyhedron(point_list, inflation_ratio, max_height, unit_length);
    }

    public static Polyhedron generate(Vector stroke) {
        return Generate.generate(stroke, 0.85);
    }

    public static Polyhedron generate(Vector stroke, double inflation_ratio) {
        return Generate.generate(stroke, inflation_ratio, 10.0);
    }

    public static Polyhedron generate(Vector stroke, double inflation_ratio, double max_height) {
        double unit_length = 0.1;
        LinkedList point_list = new LinkedList(stroke);
        point_list = Generate.counter_clockwise(point_list);
        return Skeleton.generate_polyhedron(point_list, inflation_ratio, max_height, unit_length);
    }

    public static LinkedList counter_clockwise(LinkedList stroke) {
        double total_area = 0.0;
        Enumeration e = stroke.elements();
        Vertex2D prev = (Vertex2D)e.nextElement();
        while (e.hasMoreElements()) {
            Vertex2D next = (Vertex2D)e.nextElement();
            total_area += (prev.y + next.y) * (next.x - prev.x);
            prev = next;
        }
        if (total_area < 0.0) {
            return stroke.reverse();
        }
        return stroke;
    }

    public static void adjust(Polyhedron h, double scale) {
        ImplicitFunction iFunction;
        Vector<ImplicitFunction> iFunctions = new Vector<ImplicitFunction>();
        int i = 0;
        while (i < h.n_polygons) {
            iFunction = h.polygons[i].patch.iFunction;
            if (!iFunctions.contains(iFunction)) {
                iFunctions.addElement(iFunction);
            }
            ++i;
        }
        int j = 0;
        while (j < iFunctions.size()) {
            Vertex v;
            iFunction = (ImplicitFunction)iFunctions.elementAt(j);
            Vector<Vertex> zeroKnots = new Vector<Vertex>();
            Vector<Vertex> plusKnots = new Vector<Vertex>();
            int i2 = 0;
            while (i2 < iFunction.zeroKnots.size()) {
                v = (Vertex)iFunction.zeroKnots.elementAt(i2);
                v.z *= scale;
                zeroKnots.addElement(v);
                ++i2;
            }
            i2 = 0;
            while (i2 < iFunction.plusKnots.size()) {
                v = (Vertex)iFunction.plusKnots.elementAt(i2);
                v.z *= scale;
                plusKnots.addElement(v);
                ++i2;
            }
            iFunction.set(zeroKnots, plusKnots);
            ++j;
        }
    }
}

