/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.BoundarySmooth;
import teddy.Edge;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Pop;
import teddy.Seam;
import teddy.Skin;
import teddy.Smooth;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class Fillet
extends Pop {
    public static void propagate(Vertex v, Vector visited, Vector boundary, Vector boundary_edges, Hashtable distances, Vector base_edges, double radius) {
        if (visited.contains(v)) {
            return;
        }
        visited.addElement(v);
        double d = Fillet.distance(base_edges, v);
        distances.put(v, new Double(d));
        if (d > radius) {
            boundary.addElement(v);
            return;
        }
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex u = edge.get_the_other_vertex(v);
            Fillet.propagate(u, visited, boundary, boundary_edges, distances, base_edges, radius);
            if (!boundary.contains(u)) continue;
            boundary_edges.addElement(edge);
        }
    }

    public static SurfacePath get_offset_path(Vector base_edges, double radius) {
        return (SurfacePath)Fillet.get_offset_paths(base_edges, radius).elementAt(0);
    }

    public static Vector find_patch_polygons(Polyhedron h, Patch patch) {
        Vector<Polygon2> patch_polygons = new Vector<Polygon2>();
        int i = 0;
        while (i < h.n_polygons) {
            Polygon2 polygon = h.polygons[i];
            if (polygon.patch == patch) {
                patch_polygons.addElement(polygon);
            }
            ++i;
        }
        return patch_polygons;
    }

    public static Edge find_next_boundary_edge(Polygon2 polygon, Edge base_edge, Vector boundary_edges) {
        int i = 0;
        while (i < 3) {
            Edge edge = polygon.edges[i];
            if (edge != base_edge && boundary_edges.contains(edge)) {
                return edge;
            }
            ++i;
        }
        return null;
    }

    public static Vector get_offset_paths(Vector base_edges, double radius) {
        Vector visited = new Vector();
        Vector boundary = new Vector();
        Vector boundary_edges = new Vector();
        Hashtable distances = new Hashtable();
        Fillet.propagate(((Edge)base_edges.elementAt((int)0)).start, visited, boundary, boundary_edges, distances, base_edges, radius);
        int i = 0;
        while (i < base_edges.size()) {
            Edge edge = (Edge)base_edges.elementAt(i);
            Fillet.propagate(edge.end, visited, boundary, boundary_edges, distances, base_edges, radius);
            ++i;
        }
        Vector<SurfacePath> surfacePaths = new Vector<SurfacePath>();
        while (boundary_edges.size() > 0) {
            Edge edge;
            SurfacePath surfacePath = new SurfacePath();
            Edge start_edge = edge = (Edge)boundary_edges.elementAt(0);
            Polygon2 polygon = edge.left_polygon;
            if (boundary.contains(edge.end)) {
                polygon = edge.right_polygon;
            }
            while (true) {
                Vertex v = Fillet.get_edge_vertex(edge, distances, radius);
                surfacePath.addPathElement(edge, v);
                boundary_edges.removeElement(edge);
                Edge next_edge = Fillet.find_next_boundary_edge(polygon, edge, boundary_edges);
                if (next_edge == null || next_edge == start_edge) break;
                polygon = next_edge.get_another_polygon(polygon);
                edge = next_edge;
            }
            surfacePath.adjust_to_PNsurface();
            surfacePaths.addElement(surfacePath);
        }
        return surfacePaths;
    }

    public static Vector find_dirty_edges(Patch patch, Seam seam0, Seam seam1) {
        Vector<Edge> results = new Vector<Edge>();
        int i = 0;
        while (i < Pop.h.n_edges) {
            Edge edge = Pop.h.edges[i];
            if (edge.left_polygon.patch == patch || edge.right_polygon.patch == patch) {
                results.addElement(edge);
            }
            ++i;
        }
        Vector boundary_edges = Util.connectVector(Pop.find_boundary_edges(seam0), Pop.find_boundary_edges(seam1));
        int i2 = 0;
        while (i2 < boundary_edges.size()) {
            Edge boundary_edge = (Edge)boundary_edges.elementAt(i2);
            Enumeration e = boundary_edge.start.edges.elements();
            while (e.hasMoreElements()) {
                Edge edge = (Edge)e.nextElement();
                if (edge.left_polygon.patch == patch || edge.right_polygon.patch == patch) continue;
                Vertex v = edge.get_the_other_vertex(boundary_edge.start);
                if (!results.contains(edge)) {
                    results.addElement(edge);
                }
                Enumeration ee = v.edges.elements();
                while (ee.hasMoreElements()) {
                    Edge u = (Edge)ee.nextElement();
                    if (results.contains(u)) continue;
                    results.addElement(u);
                }
            }
            ++i2;
        }
        return results;
    }

    public static Vector find_patch_edges(Polyhedron h, Seam seam0, Seam seam1) {
        Vector<Edge> boundary_patch_edges = new Vector<Edge>();
        int i = 0;
        while (i < h.n_edges) {
            Edge edge = h.edges[i];
            if (edge.seam == seam0 || edge.seam == seam1) {
                boundary_patch_edges.addElement(edge);
            }
            ++i;
        }
        return boundary_patch_edges;
    }

    public static Vector find_dirty_vertices(Patch patch, Seam seam0, Seam seam1) {
        Vector edges = Fillet.find_dirty_edges(patch, seam0, seam1);
        Vector<Vertex> results = new Vector<Vertex>();
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.elementAt(i);
            if (!results.contains(edge.start)) {
                results.addElement(edge.start);
            }
            if (!results.contains(edge.end)) {
                results.addElement(edge.end);
            }
            ++i;
        }
        return results;
    }

    public static void fillet(Polyhedron _h, SurfacePath path) {
        Vector boundary_edges = new Vector();
        int i = 0;
        while (i < path.size()) {
            Vertex v0 = path.getParentVertex(i);
            Vertex v1 = path.getParentVertex(Util.mod(i + 1, path.size()));
            Edge edge = v0.get_common_edge(v1);
            boundary_edges.addElement(edge);
            if (edge == null) {
                Pop.h = _h;
                boundary_edges = Pop.find_boundary_edges(path.seam);
                break;
            }
            ++i;
        }
        Fillet.fillet(_h, boundary_edges, 0.07);
    }

    public static Object[] fillet(Polyhedron _h, Vector boundary_edges, double MERGE_OFFSET) {
        Pop.h = _h;
        Vector surfacePaths = Fillet.get_offset_paths(boundary_edges, MERGE_OFFSET);
        Vector[] boundary_edges_side = new Vector[2];
        Vector[] patch_polygons_side = new Vector[2];
        Seam[] seams = new Seam[2];
        Patch boundary_patch = new Patch();
        Edge boundary_edge = (Edge)boundary_edges.elementAt(0);
        boundary_patch.unit_length = (boundary_edge.right_polygon().patch.unit_length + boundary_edge.left_polygon().patch.unit_length) / 2.0;
        int i = 0;
        while (i < 2) {
            SurfacePath surfacePath = (SurfacePath)surfacePaths.elementAt(i);
            surfacePath.insertOnPolygon();
            Object[] result = Pop.remesh(surfacePath, false, true);
            boundary_edges_side[i] = (Vector)result[0];
            patch_polygons_side[i] = (Vector)result[1];
            seams[i] = new Seam();
            double total = 0.0;
            int j = 0;
            while (j < boundary_edges_side[i].size()) {
                Edge edge = (Edge)boundary_edges_side[i].elementAt(j);
                edge.seam = seams[i];
                edge.sharp = true;
                ++j;
            }
            j = 0;
            while (j < patch_polygons_side[i].size()) {
                Polygon2 polygon = (Polygon2)patch_polygons_side[i].elementAt(j);
                polygon.patch = boundary_patch;
                ++j;
            }
            ++i;
        }
        Seam seam = ((Edge)boundary_edges.elementAt((int)0)).seam;
        int i2 = 0;
        while (i2 < Pop.h.n_edges) {
            Edge edge = Pop.h.edges[i2];
            if (edge.seam == seam) {
                edge.seam = null;
                edge.sharp = false;
            }
            ++i2;
        }
        Vector boundary_patch_polygons = Fillet.find_patch_polygons(Pop.h, boundary_patch);
        Vector boundary_patch_edges = Fillet.find_patch_edges(Pop.h, seams[0], seams[1]);
        Pop.soap(boundary_patch_edges, boundary_patch_polygons);
        Vector dirty_vertices = Fillet.find_dirty_vertices(boundary_patch, seams[0], seams[1]);
        Vector dirty_edges = Fillet.find_dirty_edges(boundary_patch, seams[0], seams[1]);
        Pop.set_original_mesh(Pop.h, true);
        Skin.drift(dirty_vertices, 5);
        Pop.set_original_mesh(Pop.h, false);
        Skin.refine_mesh_connectivity(Pop.h, dirty_edges);
        dirty_vertices = Fillet.find_dirty_vertices(boundary_patch, seams[0], seams[1]);
        dirty_edges = Fillet.find_dirty_edges(boundary_patch, seams[0], seams[1]);
        Skin.drift(dirty_vertices, 5);
        Vector boundary_edges0 = Pop.find_boundary_edges(seams[0]);
        Vector boundary_edges1 = Pop.find_boundary_edges(seams[1]);
        Vector boundary_vertices = Util.connectVector(Pop.find_boundary_vertices(boundary_edges0), Pop.find_boundary_vertices(boundary_edges1));
        Vector internal_vertices = Smooth.find_internal_vertices_for_smooth(boundary_edges0, boundary_vertices);
        int i3 = 0;
        while (i3 < 5) {
            BoundarySmooth.smooth(Pop.h, internal_vertices, boundary_vertices);
            ++i3;
        }
        Pop.set_original_mesh(Pop.h, false);
        Skin.drift(dirty_vertices, 3);
        Skin.refine_mesh_connectivity(Pop.h, dirty_edges);
        dirty_vertices = Fillet.find_dirty_vertices(boundary_patch, seams[0], seams[1]);
        Skin.drift(dirty_vertices, 3);
        Pop.h.set_normals();
        Pop.remove_sharp(seams[0]);
        Pop.remove_sharp(seams[1]);
        Object[] info = new Object[]{boundary_patch, seams[0], seams[1]};
        return info;
    }

    public static Vertex get_edge_vertex(Edge edge, Hashtable distances, double radius) {
        double d0 = Math.abs((Double)distances.get(edge.start) - radius);
        double d1 = Math.abs((Double)distances.get(edge.end) - radius);
        return Vector3.interporate(edge.start, edge.end, d0 / (d0 + d1));
    }

    public static double distance(Vector base_edges, Vertex v) {
        double min = -1.0;
        int i = 0;
        while (i < base_edges.size()) {
            Edge edge = (Edge)base_edges.elementAt(i);
            double d = edge.distance_as_a_segment(v);
            if (min == -1.0 || d < min) {
                min = d;
            }
            ++i;
        }
        return min;
    }
}

