/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.CameraInterface;
import teddy.Edge;
import teddy.Line;
import teddy.LinkedList;
import teddy.Patch;
import teddy.Plane;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Pop;
import teddy.Ring;
import teddy.Seam;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Extrusion
extends Pop {
    private static int old_part_index;
    private static int new_part_index;

    private static void construct(LinkedList rings, SurfacePath path) {
        Enumeration e = rings.elements();
        Ring prev_ring = (Ring)e.nextElement();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Vertex) {
                Extrusion.construct_top(prev_ring, (Vertex)object);
                break;
            }
            Ring ring = (Ring)object;
            Extrusion.construct_sub(prev_ring, ring);
            prev_ring = ring;
        }
    }

    public static SurfacePath extrude(Polyhedron _h, SurfacePath path, Vector stroke, CameraInterface camera) {
        Vertex base_end;
        Vertex base_start;
        Edge edge;
        Edge edge1;
        Edge edge0;
        Pop.h = _h;
        Vector3 normal = new Vector3(0.0, 0.0, 0.0);
        int i = 0;
        while (i < path.size()) {
            if (path.onPolygon(i)) {
                normal.add_self(path.getPolygon((int)i).normal);
            }
            ++i;
        }
        normal.normalize();
        Vertex center = new Vertex(0.0, 0.0, 0.0);
        int i2 = 0;
        while (i2 < path.size()) {
            center.add_self(path.getVertex(i2));
            ++i2;
        }
        center.multiple_self(1.0 / (double)path.size());
        Vector3 camera_to_center = new Vector3(camera.get_camera_position(), center);
        Vector3 normal2 = normal.cross_product(camera_to_center);
        Vertex vertex = path.getVertex(0);
        Vector3 center_to_vertex = new Vector3(center, vertex);
        double dot_product = normal2.dot_product(center_to_vertex);
        Vertex most_left_vertex = vertex;
        Vertex most_right_vertex = vertex;
        double max = dot_product;
        double min = dot_product;
        int i3 = 0;
        while (i3 < path.size()) {
            vertex = path.getVertex(i3);
            center_to_vertex = new Vector3(center, vertex);
            dot_product = normal2.dot_product(center_to_vertex);
            if (dot_product > max) {
                max = dot_product;
                most_left_vertex = vertex;
            }
            if (dot_product < min) {
                min = dot_product;
                most_right_vertex = vertex;
            }
            ++i3;
        }
        Plane pop_surface = new Plane(center, normal.cross_product(normal.cross_product(camera_to_center)));
        LinkedList cross_section = new LinkedList();
        int i4 = 0;
        while (i4 < stroke.size()) {
            Vertex2D p = (Vertex2D)stroke.elementAt(i4);
            Vertex v = camera.screen_coords_to_local_coords(p);
            cross_section.append(pop_surface.cross_point(new Line(v, camera.get_camera_lay(p))));
            ++i4;
        }
        System.out.println(cross_section.size());
        i4 = 0;
        while (i4 < path.size() - 1) {
            if (path.getVertex(i4).same_position(path.getVertex(Util.mod(i4 + 1, path.size())))) {
                System.out.println("ouch in path " + i4 + " " + path.size());
            }
            ++i4;
        }
        Object[] result = Pop.remesh(path, true, false);
        Vector boundary_edges = (Vector)result[0];
        Vector patch_polygons = (Vector)result[1];
        int i5 = 0;
        while (i5 < patch_polygons.size()) {
            Pop.h.remove((Polygon2)patch_polygons.elementAt(i5));
            ++i5;
        }
        System.out.println("before " + boundary_edges.size());
        i5 = 0;
        while (i5 < boundary_edges.size()) {
            edge0 = (Edge)boundary_edges.elementAt(i5);
            edge1 = (Edge)boundary_edges.elementAt(Util.mod(i5 + 1, boundary_edges.size()));
            if (edge0.end != edge1.start) {
                System.out.println("ouch 0");
            } else if (edge0.start == edge0.end) {
                System.out.println("ouch 1");
            } else if (edge0.start.same_position(edge0.end)) {
                System.out.println("ouch 2");
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < Pop.h.n_edges) {
            edge = Pop.h.edges[i5];
            if (!(edge.left_polygon != null && edge.right_polygon != null || boundary_edges.contains(edge))) {
                System.out.println("super ouch");
            }
            if (!edge.start.edges.contains(edge) || !edge.end.edges.contains(edge)) {
                System.out.println("broken edge " + edge + " " + edge.start + " " + edge.end + " " + edge.left_polygon + " " + edge.right_polygon);
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < boundary_edges.size()) {
            edge = (Edge)boundary_edges.elementAt(i5);
            if (!Pop.h.contains(edge)) {
                System.out.println("missing edge " + edge);
            }
            if (!edge.start.edges.contains(edge) || !edge.end.edges.contains(edge)) {
                System.out.println("broken edge_ " + edge + " " + edge.start + " " + edge.end + " " + edge.left_polygon + " " + edge.right_polygon);
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < boundary_edges.size()) {
            edge0 = (Edge)boundary_edges.elementAt(i5);
            if (edge0.end.edges.size() == 3) {
                edge1 = (Edge)boundary_edges.elementAt(Util.mod(i5 + 1, boundary_edges.size()));
                Polygon2 polygon0 = edge0.left_polygon;
                Polygon2 polygon1 = edge1.left_polygon;
                Edge center_edge = polygon0.get_common_edge(polygon1);
                if (center_edge == null) {
                    System.out.println("" + edge0 + ", " + edge1 + " " + edge0.end);
                    System.out.println("" + edge0.end.edges.elementAt(0) + " " + edge0.end.edges.elementAt(1) + " " + edge0.end.edges.elementAt(2));
                    System.out.println("k " + polygon0.edges[0] + " : " + polygon0.edges[0].start + " " + polygon0.edges[0].end);
                    System.out.println("k " + polygon0.edges[1] + " : " + polygon0.edges[1].start + " " + polygon0.edges[1].end);
                    System.out.println("k " + polygon0.edges[2] + " : " + polygon0.edges[2].start + " " + polygon0.edges[2].end);
                    System.out.println("k " + polygon1.edges[0] + " : " + polygon1.edges[0].start + " " + polygon1.edges[0].end);
                    System.out.println("k " + polygon1.edges[1] + " : " + polygon1.edges[1].start + " " + polygon1.edges[1].end);
                    System.out.println("k " + polygon1.edges[2] + " : " + polygon1.edges[2].start + " " + polygon1.edges[2].end);
                    System.out.println("" + Pop.h.contains(polygon0) + " " + Pop.h.contains(polygon1));
                    System.out.println("" + Pop.h.contains(polygon0.edges[0]) + " " + Pop.h.contains(polygon0.edges[1]) + " " + Pop.h.contains(polygon0.edges[2]));
                    System.out.println("" + Pop.h.contains(polygon1.edges[0]) + " " + Pop.h.contains(polygon1.edges[1]) + " " + Pop.h.contains(polygon1.edges[2]));
                }
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < boundary_edges.size()) {
            edge0 = (Edge)boundary_edges.elementAt(i5);
            if (edge0.end.edges.size() == 3) {
                edge1 = (Edge)boundary_edges.elementAt(Util.mod(i5 + 1, boundary_edges.size()));
                Line line = new Line(edge0.start, new Vector3(edge0.start, edge1.end));
                if (line.distance(edge0.end) < Vector3.distance(edge0.start, edge1.end) * 0.1) {
                    Polygon2 polygon0 = edge0.left_polygon;
                    Polygon2 polygon1 = edge1.left_polygon;
                    Edge center_edge = polygon0.get_common_edge(polygon1);
                    if (center_edge == null) {
                        System.out.println("" + polygon0.edges[0] + " " + polygon0.edges[1] + " " + polygon0.edges[2]);
                        System.out.println("" + polygon1.edges[0] + " " + polygon1.edges[1] + " " + polygon1.edges[2]);
                        System.out.println("" + edge0.end.edges.elementAt(0) + " " + edge0.end.edges.elementAt(1) + " " + edge0.end.edges.elementAt(2));
                    }
                    if (center_edge.seam == null) {
                        Vertex v0 = edge0.start;
                        Vertex v1 = edge0.end;
                        Vertex v2 = edge1.end;
                        Vertex v3 = center_edge.get_the_other_vertex(v1);
                        Edge merged_edge = new Edge(edge0.start, edge1.end);
                        Polygon2 new_polygon = new Polygon2(merged_edge, v2.get_common_edge(v3), v3.get_common_edge(v0));
                        new_polygon.patch = polygon0.patch;
                        Pop.h.append(merged_edge);
                        Pop.h.append(new_polygon);
                        Pop.h.remove(polygon0);
                        Pop.h.remove(polygon1);
                        boundary_edges.insertElementAt(merged_edge, i5);
                        boundary_edges.removeElement(edge0);
                        boundary_edges.removeElement(edge1);
                        i5 = 0;
                    }
                }
            }
            ++i5;
        }
        System.out.println("after " + boundary_edges.size());
        Seam seam = new Seam();
        int i6 = 0;
        while (i6 < boundary_edges.size()) {
            Edge edge2 = (Edge)boundary_edges.elementAt(i6);
            edge2.sharp = true;
            edge2.seam = seam;
            ++i6;
        }
        Ring base_ring = new Ring(boundary_edges);
        double right_to_start = Vector3.distance(most_right_vertex, (Vertex)cross_section.head());
        double right_to_end = Vector3.distance(most_right_vertex, (Vertex)cross_section.tail());
        double left_to_start = Vector3.distance(most_left_vertex, (Vertex)cross_section.head());
        double left_to_end = Vector3.distance(most_left_vertex, (Vertex)cross_section.tail());
        if (right_to_start + left_to_end < right_to_end + left_to_start) {
            base_start = most_right_vertex;
            base_end = most_left_vertex;
        } else {
            base_start = most_left_vertex;
            base_end = most_right_vertex;
        }
        Line line = new Line(center, normal.cross_product(camera_to_center));
        base_start = line.get_foot(base_start);
        base_end = line.get_foot(base_end);
        int original_edge_size = Pop.h.n_edges;
        Enumeration e = base_ring.elements();
        Vertex prev_v = (Vertex)e.nextElement();
        while (e.hasMoreElements()) {
            Vertex v = (Vertex)e.nextElement();
            if (prev_v == v) {
                System.out.println("error in base_ring");
            } else if (prev_v.same_position(v)) {
                System.out.println("error in base_ring pos");
            }
            prev_v = v;
        }
        LinkedList rings = Extrusion.generate_rings(base_ring, base_start, base_end, cross_section, normal);
        Extrusion.construct(rings, path);
        Pop.h.set_parameters();
        int i7 = 0;
        while (i7 < Pop.h.n_edges) {
            Edge edge3 = Pop.h.edges[i7];
            if (edge3.left_polygon == null || edge3.right_polygon == null) {
                System.out.println("!");
                if (base_ring.contains(edge3.start) && base_ring.contains(edge3.end)) {
                    System.out.println("base_ring both " + boundary_edges.contains(edge3) + " " + edge3 + " " + edge3.start + " " + edge3.end);
                    int j = 0;
                    while (j < boundary_edges.size()) {
                        System.out.print(" " + boundary_edges.elementAt(j));
                        ++j;
                    }
                    System.out.println("");
                    Enumeration ee = base_ring.elements();
                    while (ee.hasMoreElements()) {
                        System.out.print(" " + ee.nextElement());
                    }
                    System.out.println("");
                } else if (base_ring.contains(edge3.start) || base_ring.contains(edge3.end)) {
                    System.out.println("base_ring one");
                }
            }
            ++i7;
        }
        Patch patch = new Patch();
        Edge edge02 = (Edge)boundary_edges.elementAt(0);
        patch.unit_length = edge02.left_polygon.patch.unit_length;
        patch_polygons = new Vector();
        Pop.propagate_patch(edge02.right_polygon, edge02, boundary_edges, patch_polygons, true, false);
        System.out.println("" + patch_polygons.size());
        int i8 = 0;
        while (i8 < patch_polygons.size()) {
            Polygon2 polygon = (Polygon2)patch_polygons.elementAt(i8);
            polygon.patch = patch;
            ++i8;
        }
        boundary_edges = Pop.find_boundary_edges(seam);
        SurfacePath final_path = new SurfacePath(boundary_edges);
        final_path.seam = seam;
        return final_path;
    }

    private static void construct_top(Ring ring, Vertex vertex) {
        Pop.h.append(vertex);
        Enumeration e = ring.elements();
        Vertex lower_prev = (Vertex)e.nextElement();
        while (e.hasMoreElements()) {
            Vertex lower_next = (Vertex)e.nextElement();
            Pop.h.append_a_new_polygon(lower_prev, vertex, lower_next);
            lower_prev = lower_next;
        }
    }

    private static LinkedList generate_rings(Ring base_ring, Vertex base_start, Vertex base_end, LinkedList cross_section, Vector3 normal) {
        LinkedList rings = new LinkedList();
        rings.append(base_ring);
        LinkedList reversed_cross_section = cross_section.reverse();
        Enumeration p = cross_section.elements();
        Enumeration q = reversed_cross_section.elements();
        Vertex p0 = (Vertex)p.nextElement();
        Vertex p1 = (Vertex)p.nextElement();
        Vertex p2 = (Vertex)p.nextElement();
        Vertex q0 = (Vertex)q.nextElement();
        Vertex q1 = (Vertex)q.nextElement();
        Vertex q2 = (Vertex)q.nextElement();
        while (true) {
            Ring ring = Ring.sweep(base_ring, base_start, base_end, p0, q0, normal);
            rings.append(ring);
            if (p1 == q1) {
                rings.append(p1);
                break;
            }
            if (p1 == q0) {
                rings.append(Vertex.mid_point(p0, q0));
                break;
            }
            Vector3 p_vector0 = new Vector3(p0, p1).get_normalized();
            Vector3 p_vector1 = new Vector3(p1, p2).get_normalized();
            Vector3 q_vector0 = new Vector3(q0, q1).get_normalized();
            Vector3 q_vector1 = new Vector3(q1, q2).get_normalized();
            Vector3 edge_direction01 = p_vector0.add(q_vector1);
            Vector3 edge_direction10 = p_vector1.add(q_vector0);
            Vector3 edge_direction11 = p_vector1.add(q_vector1);
            Vector3 base_direction01 = new Vector3(p0, q1);
            Vector3 base_direction10 = new Vector3(p1, q0);
            Vector3 base_direction11 = new Vector3(p1, q1);
            double cos01 = Math.max(Math.abs(base_direction01.cos(p_vector0)), Math.abs(base_direction01.cos(q_vector1)));
            double cos10 = Math.max(Math.abs(base_direction10.cos(p_vector1)), Math.abs(base_direction10.cos(q_vector0)));
            double cos11 = Math.max(Math.abs(base_direction11.cos(p_vector1)), Math.abs(base_direction11.cos(q_vector1)));
            if (cos01 <= cos10 && cos01 <= cos11) {
                q0 = q1;
                q1 = q2;
                q2 = (Vertex)q.nextElement();
                p0 = Vertex.mid_point(p0, p1);
                continue;
            }
            if (cos10 <= cos01 && cos10 <= cos11) {
                p0 = p1;
                p1 = p2;
                p2 = (Vertex)p.nextElement();
                q0 = Vertex.mid_point(q0, q1);
                continue;
            }
            p0 = p1;
            p1 = p2;
            p2 = (Vertex)p.nextElement();
            q0 = q1;
            q1 = q2;
            q2 = (Vertex)q.nextElement();
        }
        Enumeration e = rings.elements();
        Ring prev_ring = (Ring)e.nextElement();
        while (e.hasMoreElements()) {
            Object object = e.nextElement();
            if (object instanceof Vertex) break;
            Ring next_ring = (Ring)object;
            if (((Vertex)prev_ring.head()).same_position((Vertex)next_ring.head())) {
                next_ring.replace_head(prev_ring.head());
                next_ring.replace_tail(prev_ring.head());
            }
            prev_ring = next_ring;
        }
        return rings;
    }

    /*
     * Unable to fully structure code
     */
    private static void construct_sub(Ring lower_ring, Ring upper_ring) {
        block6: {
            e = upper_ring.elements();
            e.nextElement();
            while (e.hasMoreElements()) {
                Pop.h.append((Vertex)e.nextElement());
            }
            le = lower_ring.elements();
            ue = upper_ring.elements();
            lower_prev = (Vertex)le.nextElement();
            upper_prev = (Vertex)ue.nextElement();
            if (lower_ring.size() == upper_ring.size()) ** GOTO lbl43
            lower_next = (Vertex)le.nextElement();
            upper_next = (Vertex)ue.nextElement();
            while (le.hasMoreElements() || ue.hasMoreElements()) {
                upper_vec = new Vector3(upper_prev, upper_next);
                lower_vec = new Vector3(lower_prev, lower_next);
                upper_advance = new Vector3(lower_prev, upper_next);
                lower_advance = new Vector3(upper_prev, lower_next);
                upper_advance_worse = Math.min(Math.abs(upper_advance.sin(upper_vec)), Math.abs(upper_advance.sin(lower_vec)));
                lower_advance_worse = Math.min(Math.abs(lower_advance.sin(upper_vec)), Math.abs(lower_advance.sin(lower_vec)));
                if (lower_advance_worse > upper_advance_worse || !ue.hasMoreElements()) {
                    Pop.h.append_a_new_polygon(lower_prev, upper_prev, lower_next);
                    lower_prev = lower_next;
                    lower_next = (Vertex)le.nextElement();
                    continue;
                }
                Pop.h.append_a_new_polygon(upper_next, lower_prev, upper_prev);
                upper_prev = upper_next;
                upper_next = (Vertex)ue.nextElement();
            }
            Pop.h.append_a_new_polygon(lower_prev, upper_prev, lower_next);
            Pop.h.append_a_new_polygon(upper_next, lower_next, upper_prev);
            break block6;
lbl-1000:
            // 1 sources

            {
                lower_next = (Vertex)le.nextElement();
                upper_next = (Vertex)ue.nextElement();
                if (lower_next.distance(upper_prev) < lower_prev.distance(upper_next)) {
                    Pop.h.append_a_new_polygon(lower_prev, upper_prev, lower_next);
                    Pop.h.append_a_new_polygon(upper_next, lower_next, upper_prev);
                } else {
                    Pop.h.append_a_new_polygon(lower_prev, upper_next, lower_next);
                    Pop.h.append_a_new_polygon(upper_next, lower_prev, upper_prev);
                }
                lower_prev = lower_next;
                upper_prev = upper_next;
lbl43:
                // 2 sources

                ** while (le.hasMoreElements())
            }
        }
    }
}

