/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import teddy.Vector2;
import teddy.Vertex2D;

class Edge2D {
    Vertex2D start;
    Vertex2D end;

    public Vector2 vector2() {
        return new Vector2(this.start, (Vector2)this.end);
    }

    public boolean right_side_of_edge(double x1, double y1, double x2, double y2, double x, double y) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        return a0 * x + b0 * y + c0 < 0.0;
    }

    public static Vertex2D cross_point(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        if (Math.abs(a0 * b1 - a1 * b0) < 1.0E-5) {
            return null;
        }
        double x = (b0 * c1 - b1 * c0) / (a0 * b1 - a1 * b0);
        double y = (a0 * c1 - a1 * c0) / (a1 * b0 - a0 * b1);
        return new Vertex2D(x, y);
    }

    public Vertex2D mid_point() {
        return new Vertex2D((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
    }

    Edge2D() {
    }

    Edge2D(Vertex2D _start, Vertex2D _end) {
        this.start = _start;
        this.end = _end;
    }

    Edge2D(Point _start, Point _end) {
        this.start = new Vertex2D(_start);
        this.end = new Vertex2D(_end);
    }

    public Vertex2D get_the_other_vertex(Vertex2D v) {
        if (v == this.start) {
            return this.end;
        }
        return this.start;
    }

    public Vertex2D get_common_vertex(Edge2D edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        return this.end;
    }

    public boolean contains(Vertex2D v) {
        return v == this.start || v == this.end;
    }

    public Vertex2D get_nearest_point_on_edge(Vertex2D v) {
        Vector2 vec0 = new Vector2(this.start, (Vector2)this.end);
        Vector2 vec1 = new Vector2(this.start, (Vector2)v);
        if (vec0.dot_product(vec1) < 0.0) {
            return this.start;
        }
        vec1 = new Vector2(this.end, (Vector2)v);
        if (vec0.dot_product(vec1) > 0.0) {
            return this.end;
        }
        Vector2 vec = new Vector2(this.start, (Vector2)v);
        Vector2 n_vec = new Vector2(this.start, (Vector2)this.end);
        n_vec.normalize_self();
        return Vertex2D.translate(this.start, Vector2.multiply(n_vec, Vector2.dot_product(n_vec, vec)));
    }

    public boolean equals(Vertex2D v0, Vertex2D v1) {
        return v0 == this.start && v1 == this.end || v1 == this.start && v0 == this.end;
    }

    public double distance_as_a_segment(Vertex2D node) {
        Vector2 vec0 = new Vector2(this.start, (Vector2)this.end);
        Vector2 vec1 = new Vector2(this.start, (Vector2)node);
        if (vec0.dot_product(vec1) < 0.0) {
            return Vector2.distance(node, this.start);
        }
        vec1 = new Vector2(this.end, (Vector2)node);
        if (vec0.dot_product(vec1) > 0.0) {
            return Vector2.distance(node, this.end);
        }
        return this.distance(node);
    }

    public double length() {
        return Vertex2D.distance(this.start, this.end);
    }

    public boolean cross(Edge2D e) {
        return Edge2D.cross(this.start.x, this.start.y, this.end.x, this.end.y, e.start.x, e.start.y, e.end.x, e.end.y);
    }

    public static boolean cross(double x1, double y1, double x2, double y2, double xx1, double yy1, double xx2, double yy2) {
        double a0 = y1 - y2;
        double b0 = x2 - x1;
        double c0 = y2 * x1 - x2 * y1;
        double a1 = yy1 - yy2;
        double b1 = xx2 - xx1;
        double c1 = yy2 * xx1 - xx2 * yy1;
        return (a0 * xx1 + b0 * yy1 + c0) * (a0 * xx2 + b0 * yy2 + c0) <= 0.0 && (a1 * x1 + b1 * y1 + c1) * (a1 * x2 + b1 * y2 + c1) <= 0.0;
    }

    public double distance(Vertex2D v) {
        double a = this.end.x - this.start.x;
        double b = this.end.y - this.start.y;
        double bunbo = Math.sqrt(a * a + b * b);
        double bunshi = a * (v.y - this.start.y) - b * (v.x - this.start.x);
        if (bunbo == 0.0) {
            System.out.println("Error in Edge2D.distance");
            return 0.0;
        }
        return Math.abs(bunshi / bunbo);
    }
}

