/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import teddy.Polygon2;
import teddy.Seam;
import teddy.Vector3;
import teddy.Vertex;

public class Edge
implements Serializable {
    public Vertex start;
    public Vertex end;
    public int index;
    boolean disposed = false;
    boolean delaunay_edge = false;
    Seam seam = null;
    public double target_edge_length;
    public double[] quadratic_function;
    public Polygon2 left_polygon;
    public Polygon2 right_polygon;
    public boolean sharp = false;
    public boolean concave;
    public int type;
    public boolean checked = false;
    public transient Edge child;
    static final int NONE = 0;
    static final int BACK_SILHOUETTE = 1;
    static final int FRONT_SILHOUETTE = 2;
    static final int SHARP_FRONT = 3;
    Vertex mid_vertex;
    boolean error_mark;

    public Polygon2 left_polygon() {
        return this.left_polygon;
    }

    public boolean contain(Vertex v) {
        return this.start == v || this.end == v;
    }

    public Vertex end() {
        return this.end;
    }

    public boolean connected(Polygon2 p) {
        return p == this.left_polygon() || p == this.right_polygon();
    }

    public boolean connected(Edge edge) {
        return this.start == edge.start || this.start == edge.end || this.end == edge.start || this.end == edge.end;
    }

    public void set_parameters() {
        if (this.left_polygon() == null && this.right_polygon() == null) {
            System.out.println("Edge has no polygon (Edge:set_parameters()) " + this);
            return;
        }
        if (this.left_polygon() == null || this.right_polygon() == null) {
            System.out.println("Edge doesn't have 2 polygons (Edge:set_parameters())" + this);
            this.error_mark = true;
            return;
        }
        Polygon2 p1 = this.left_polygon();
        Polygon2 p2 = this.right_polygon();
        Vector3 s1 = new Vector3(this.start, this.end);
        Vector3 n1 = p1.normal;
        Vector3 n2 = p2.normal;
        Vector3 s2 = n1.cross_product(n2);
        this.concave = s1.cos(s2) < 0.0;
    }

    public void set_sharp_if_sharp() {
        Vector3 n1 = this.left_polygon().normal;
        Vector3 n2 = this.right_polygon().normal;
        this.sharp = this.concave ? n1.cos(n2) < 0.7 : n1.cos(n2) < 0.3;
    }

    public int visibility_type() {
        Polygon2 p1 = this.left_polygon();
        Polygon2 p2 = this.right_polygon();
        if (p1.front_facing && p2.front_facing && this.sharp) {
            this.type = 3;
            return 3;
        }
        if (p1.front_facing == p2.front_facing) {
            this.type = 0;
            return 0;
        }
        if (this.concave) {
            this.type = 1;
            return 1;
        }
        this.type = 2;
        return 2;
    }

    public boolean on_edge(Vertex v) {
        if (v == this.start || v == this.end) {
            return true;
        }
        Vector3 vec0 = new Vector3(v, this.start);
        Vector3 vec1 = new Vector3(v, this.end);
        return vec0.cos(vec1) < -0.9;
    }

    public boolean silhouette() {
        this.visibility_type();
        return this.type == 1 || this.type == 2;
    }

    public void set_sharp() {
        this.sharp = true;
    }

    public void set_sharp(boolean _sharp) {
        this.sharp = _sharp;
    }

    public double get_target_edge_length() {
        double l0 = this.start.get_target_edge_length();
        double l1 = this.end.get_target_edge_length();
        return Math.min(l0, l1);
    }

    public Vertex start() {
        return this.start;
    }

    public Vertex mid_vertex() {
        return new Vertex((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0, (this.start.z + this.end.z) / 2.0);
    }

    public void renew_network() {
        this.start = this.start.child;
        this.end = this.end.child;
        if (this.left_polygon != null) {
            this.left_polygon = this.left_polygon.child;
        }
        if (this.right_polygon != null) {
            this.right_polygon = this.right_polygon.child;
        }
    }

    public Polygon2 get_another_polygon(Polygon2 polygon) {
        return this.get_the_other_polygon(polygon);
    }

    public Polygon2 get_the_other_polygon(Polygon2 polygon) {
        if (this.left_polygon() != polygon) {
            return this.left_polygon();
        }
        return this.right_polygon();
    }

    public void set_right_polygon(Polygon2 p) {
        this.right_polygon = p;
    }

    public Polygon2 get_common_polygon(Edge edge) {
        if (this.left_polygon != null && (this.left_polygon == edge.left_polygon || this.left_polygon == edge.right_polygon)) {
            return this.left_polygon;
        }
        if (this.right_polygon != null && (this.right_polygon == edge.left_polygon || this.right_polygon == edge.right_polygon)) {
            return this.right_polygon;
        }
        return null;
    }

    public Vector3 vertical_from(Vertex p) {
        Vertex v0 = this.start();
        Vertex v1 = this.end();
        Vector3 v0_to_v1 = new Vector3(v0, v1);
        Vector3 v0_to_p = new Vector3(v0, p);
        double product = v0_to_v1.dot_product(v0_to_p);
        double l = v0_to_v1.length();
        Vector3 v0_to_f = v0_to_v1.multiple(product / l / l);
        Vertex f = v0.shift(v0_to_f);
        return new Vector3(p, f);
    }

    public boolean polygon_is_empty() {
        return this.left_polygon == null && this.right_polygon == null;
    }

    public double length() {
        return this.vector3().length();
    }

    public boolean same_edge(Vertex v0, Vertex v1) {
        return v0 == this.start && v1 == this.end || v1 == this.start && v0 == this.end;
    }

    Edge() {
        this.start = new Vertex();
        this.end = new Vertex();
        this.left_polygon = null;
        this.right_polygon = null;
    }

    Edge(Vertex _start, Vertex _end, boolean sharp) {
        this(_start, _end);
        this.sharp = sharp;
    }

    Edge(Vertex _start, Vertex _end) {
        this.start = _start;
        this.end = _end;
        if (this.start == this.end) {
            System.out.println("Edge with same Vertex (Edge.java)");
        }
        this.start.edges.append(this);
        this.end.edges.append(this);
        this.left_polygon = null;
        this.right_polygon = null;
    }

    public Vertex get_the_other_vertex(Vertex v) {
        if (v == this.start) {
            return this.end;
        }
        if (v == this.end) {
            return this.start;
        }
        System.out.println("error in Edge.get_the_other_vertex(v)");
        return null;
    }

    public Vertex get_common_vertex(Edge edge) {
        if (this.start == edge.start || this.start == edge.end) {
            return this.start;
        }
        if (this.end == edge.start || this.end == edge.end) {
            return this.end;
        }
        return null;
    }

    public Vertex project_as_a_segment(Vertex v) {
        Vector3 vec = new Vector3(this.start, v);
        Vector3 normal = new Vector3(this.start, this.end);
        normal.normalize_self();
        double t = Vector3.dot_product(vec, normal);
        t /= this.length();
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        vec = new Vector3(this.start, this.end);
        vec.multiply(t);
        Vertex u = Vertex.translate(this.start, vec);
        return u;
    }

    public boolean possible() {
        this.visibility_type();
        return this.type == 3 || this.type == 2;
    }

    public Polygon2 right_polygon() {
        return this.right_polygon;
    }

    public void set_left_polygon(Polygon2 p) {
        this.left_polygon = p;
    }

    public void remove_polygon(Polygon2 p) {
        if (this.left_polygon == p) {
            this.left_polygon = null;
        } else if (this.right_polygon == p) {
            this.right_polygon = null;
        }
    }

    public Vector3 vector3() {
        return new Vector3(this.start, this.end);
    }

    public Edge copy() {
        Edge clone = new Edge();
        clone.start = this.start;
        clone.end = this.end;
        clone.left_polygon = this.left_polygon;
        clone.right_polygon = this.right_polygon;
        clone.seam = this.seam;
        clone.sharp = this.sharp;
        clone.target_edge_length = this.target_edge_length;
        clone.concave = this.concave;
        clone.index = this.index;
        this.child = clone;
        return clone;
    }

    public void print() {
        System.out.println("" + this + ":" + this.start + "," + this.end + "; " + this.left_polygon + "," + this.right_polygon);
    }

    public double distance_as_a_segment(Vertex v) {
        Vector3 vec = new Vector3(this.start, v);
        Vector3 normal = new Vector3(this.start, this.end);
        normal.normalize_self();
        double t = Vector3.dot_product(vec, normal);
        t /= this.length();
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        vec = new Vector3(this.start, this.end);
        vec.multiply(t);
        Vertex u = Vertex.translate(this.start, vec);
        return Vector3.distance(u, v);
    }

    public boolean on_seam() {
        return this.seam != null;
    }

    public Vector3 get_normal() {
        Vector3 normal = new Vector3();
        if (this.left_polygon != null) {
            normal.add_self(this.left_polygon.normal);
        } else if (this.right_polygon != null) {
            normal.add_self(this.right_polygon.normal);
        }
        normal.normalize_self();
        return normal;
    }

    public Vertex get_mid_vertex() {
        this.mid_vertex = this.mid_vertex();
        return this.mid_vertex;
    }
}

