/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Vector;
import teddy.Vector2;

public class Delaunay {
    Vector triangles;
    Vector edges;
    public Vertex baseVertex;
    public Vertex prevVertex;
    public Edge prevEdge;
    Vertex latest_vertex;

    public void recursiveFlip(Edge edge, Edge fixed) {
        Vertex v1;
        if (edge.constrained) {
            return;
        }
        Triangle triangle0 = edge.left;
        Triangle triangle1 = edge.right;
        if (triangle0 == null || triangle1 == null) {
            return;
        }
        Vertex v0 = triangle0.get_the_other_vertex(edge);
        if (this.should_flip(edge, v0, v1 = triangle1.get_the_other_vertex(edge))) {
            Edge edge0s = triangle0.get_the_other_edge(edge.end);
            Edge edge0e = triangle0.get_the_other_edge(edge.start);
            Edge edge1s = triangle1.get_the_other_edge(edge.end);
            Edge edge1e = triangle1.get_the_other_edge(edge.start);
            this.delete(triangle0);
            this.delete(triangle1);
            this.delete(edge);
            Edge flippeEdge = this.add(new Edge(v0, v1, false));
            flippeEdge.flipped = true;
            triangle0 = this.add(new Triangle(flippeEdge, edge1e, edge0e));
            triangle1 = this.add(new Triangle(flippeEdge, edge0s, edge1s));
            if (edge0s != fixed) {
                this.recursiveFlip(edge0s, edge);
            }
            if (edge0e != fixed) {
                this.recursiveFlip(edge0e, edge);
            }
            if (edge1s != fixed) {
                this.recursiveFlip(edge1s, edge);
            }
            if (edge1e != fixed) {
                this.recursiveFlip(edge1e, edge);
            }
        }
    }

    public static Vector[] triangulate(Vector loop) {
        return new Delaunay().triangulate_main(loop);
    }

    public boolean double_flipped(Edge edge) {
        if (edge.flipped) {
            return false;
        }
        if (edge.constrained) {
            return false;
        }
        Triangle triangle0 = edge.left;
        Triangle triangle1 = edge.right;
        if (triangle0 == null || triangle1 == null) {
            return false;
        }
        Vertex v0 = triangle0.get_the_other_vertex(edge);
        Vertex v1 = triangle1.get_the_other_vertex(edge);
        return this.same_side(edge.start, edge.end, v0, v1);
    }

    public Triangle add(Triangle triangle) {
        this.triangles.addElement(triangle);
        return triangle;
    }

    public Edge add(Edge edge) {
        this.edges.addElement(edge);
        return edge;
    }

    public void add_vertex(Vertex v) {
        Edge edge0 = this.add(new Edge(v, this.baseVertex, false));
        Edge edge1 = this.add(new Edge(this.prevVertex, v, true));
        Triangle triangle = this.add(new Triangle(this.prevEdge, edge1, edge0));
        this.latest_vertex = v;
        this.clearFlipped();
        this.recursiveFlip(this.prevEdge, null);
        this.clearFlipped();
        int i = 0;
        while (i < this.edges.size()) {
            Edge edge = (Edge)this.edges.elementAt(i);
            this.recursiveFlip(edge, null);
            this.clearFlipped();
            ++i;
        }
        this.prevVertex = v;
        this.prevEdge = edge0;
    }

    public boolean should_flip(Edge edge, Vertex v0, Vertex v1) {
        if (edge.flipped) {
            return false;
        }
        if (v0.x == v1.x && v0.y == v1.y) {
            return false;
        }
        if (this.same_side(edge.start, edge.end, v0, v1)) {
            return true;
        }
        if (this.same_side(v0, v1, edge.start, edge.end)) {
            return false;
        }
        double originalMinimumAngle = this.min(this.get_angle(edge.start, edge.end, v0), this.get_angle(edge.end, edge.start, v0), this.get_angle(edge.start, edge.end, v1), this.get_angle(edge.end, edge.start, v1));
        double flippedMinimumAngle = this.min(this.get_angle(edge.start, v0, v1), this.get_angle(edge.start, v1, v0), this.get_angle(edge.end, v0, v1), this.get_angle(edge.end, v1, v0));
        return flippedMinimumAngle > originalMinimumAngle;
    }

    public boolean same_side(Vertex start, Vertex end, Vertex v0, Vertex v1) {
        Vector2 axis = new Vector2(start, (Vector2)end);
        Vector2 vec0 = new Vector2(start, (Vector2)v0);
        Vector2 vec1 = new Vector2(start, (Vector2)v1);
        return axis.cross_product(vec0) * axis.cross_product(vec1) > 0.0;
    }

    public double get_angle(Vertex v0, Vertex v1, Vertex v2) {
        Vector2 vec0 = new Vector2(v1, (Vector2)v0);
        Vector2 vec1 = new Vector2(v1, (Vector2)v2);
        return vec0.get_relative_angle(vec1);
    }

    public Vector[] triangulate_main(Vector loop) {
        this.triangles = new Vector();
        this.edges = new Vector();
        Vertex v0 = new Vertex((Vector2)loop.elementAt(0), 0);
        Vertex v1 = new Vertex((Vector2)loop.elementAt(1), 1);
        Vertex v2 = new Vertex((Vector2)loop.elementAt(2), 2);
        Edge e0 = this.add(new Edge(v0, v1, true));
        Edge e1 = this.add(new Edge(v1, v2, true));
        Edge e2 = this.add(new Edge(v2, v0, false));
        Triangle t0 = this.add(new Triangle(e0, e1, e2));
        this.baseVertex = v0;
        this.prevVertex = v2;
        this.prevEdge = e2;
        int i = 3;
        while (i < loop.size()) {
            Vertex v = new Vertex((Vector2)loop.elementAt(i), i);
            this.add_vertex(v);
            ++i;
        }
        Vector<int[]> delaunay_edges = new Vector<int[]>();
        int i2 = 0;
        while (i2 < this.edges.size()) {
            Edge edge = (Edge)this.edges.elementAt(i2);
            edge.index = i2++;
            int[] delaunay_edge = new int[]{edge.start.index, edge.end.index};
            delaunay_edges.addElement(delaunay_edge);
        }
        Vector<int[]> delaunay_triangles = new Vector<int[]>();
        int i3 = 0;
        while (i3 < this.triangles.size()) {
            Triangle triangle = (Triangle)this.triangles.elementAt(i3);
            int[] delaunay_triangle = new int[]{triangle.edges[0].index, triangle.edges[1].index, triangle.edges[2].index};
            delaunay_triangles.addElement(delaunay_triangle);
            ++i3;
        }
        Vector[] result = new Vector[]{delaunay_edges, delaunay_triangles};
        return result;
    }

    public void clearFlipped() {
        int i = 0;
        while (i < this.edges.size()) {
            ((Edge)this.edges.elementAt((int)i)).flipped = false;
            ++i;
        }
    }

    public double min(double a, double b, double c, double d) {
        return Math.min(Math.min(a, b), Math.min(c, d));
    }

    public void delete(Triangle triangle) {
        this.triangles.removeElement(triangle);
        triangle.delete();
    }

    public void delete(Edge edge) {
        this.edges.removeElement(edge);
        edge.delete();
    }

    class Edge {
        Triangle left;
        Triangle right;
        Vertex start;
        Vertex end;
        boolean constrained;
        boolean flipped;
        int index;

        Edge(Vertex v0, Vertex v1, boolean c) {
            Delaunay.this.getClass();
            this.start = v0;
            this.end = v1;
            this.constrained = c;
            this.start.edges.addElement(this);
            this.end.edges.addElement(this);
        }

        public Vertex get_common_vertex(Edge edge) {
            if (edge.contains(this.start)) {
                return this.start;
            }
            if (edge.contains(this.end)) {
                return this.end;
            }
            return null;
        }

        public boolean contains(Vertex v) {
            return v == this.start || v == this.end;
        }

        public void set_left(Triangle triangle) {
            if (this.left != null) {
                System.out.println("Error in Edge.set_left");
            }
            this.left = triangle;
        }

        public void set_right(Triangle triangle) {
            if (this.right != null) {
                System.out.println("Error in Edge.set_right");
            }
            this.right = triangle;
        }

        public void delete() {
            this.start.remove(this);
            this.end.remove(this);
        }

        public void remove(Triangle triangle) {
            if (this.left == triangle) {
                this.left = null;
            }
            if (this.right == triangle) {
                this.right = null;
            }
        }
    }

    class Triangle {
        Edge[] edges;

        public Edge get_the_other_edge(Vertex v) {
            if (!this.edges[0].contains(v)) {
                return this.edges[0];
            }
            if (!this.edges[1].contains(v)) {
                return this.edges[1];
            }
            if (!this.edges[2].contains(v)) {
                return this.edges[2];
            }
            return null;
        }

        Triangle(Edge e0, Edge e1, Edge e2) {
            Delaunay.this.getClass();
            this.edges = new Edge[3];
            this.edges[0] = e0;
            this.edges[1] = e1;
            this.edges[2] = e2;
            if (e1.contains(e0.end)) {
                e0.set_left(this);
            } else {
                e0.set_right(this);
            }
            if (e2.contains(e1.end)) {
                e1.set_left(this);
            } else {
                e1.set_right(this);
            }
            if (e0.contains(e2.end)) {
                e2.set_left(this);
            } else {
                e2.set_right(this);
            }
        }

        public Vertex get_the_other_vertex(Edge edge) {
            if (edge == this.edges[0]) {
                return this.edges[1].get_common_vertex(this.edges[2]);
            }
            if (edge == this.edges[1]) {
                return this.edges[2].get_common_vertex(this.edges[0]);
            }
            if (edge == this.edges[2]) {
                return this.edges[0].get_common_vertex(this.edges[1]);
            }
            return null;
        }

        public Vertex get_vertex(int i) {
            if (i == 0) {
                return this.edges[1].get_common_vertex(this.edges[2]);
            }
            if (i == 1) {
                return this.edges[2].get_common_vertex(this.edges[0]);
            }
            if (i == 2) {
                return this.edges[0].get_common_vertex(this.edges[1]);
            }
            return null;
        }

        public void delete() {
            this.edges[0].remove(this);
            this.edges[1].remove(this);
            this.edges[2].remove(this);
        }
    }

    class Vertex
    extends Vector2 {
        Vector edges;
        int index;

        public Vector2 vector2() {
            return new Vector2(this.x, this.y);
        }

        Vertex(Vector2 v, int index) {
            Delaunay.this.getClass();
            this.edges = new Vector();
            this.x = v.x;
            this.y = v.y;
            this.index = index;
        }

        public void remove(Edge edge) {
            this.edges.removeElement(edge);
        }
    }
}

