/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Delaunay;
import teddy.Edge;
import teddy.Fillet;
import teddy.ImplicitFunction;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Pop;
import teddy.Seam;
import teddy.Skin;
import teddy.Sort;
import teddy.SurfacePath;
import teddy.TaubinFairing;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;
import teddy.Vertex2D;

public class Cut
extends Pop {
    private static ImplicitFunction cut_iFunction(Vector boundary_edges, Patch patch, Vector section_edges, double unit_length) {
        Vector<Vertex> zeroKnots = new Vector<Vertex>();
        Vector<Vertex> plusKnots = new Vector<Vertex>();
        int i = 0;
        while (i < section_edges.size()) {
            Edge edge = (Edge)section_edges.elementAt(i);
            double l = edge.length();
            int n = 1 + (int)(l / unit_length);
            double dl = l / (double)n;
            int j = 1;
            while (j < n) {
                Vector3 vec = edge.vector3().multiple((double)j * dl / l);
                plusKnots.addElement(edge.start.translate(vec));
                ++j;
            }
            zeroKnots.addElement(edge.start);
            zeroKnots.addElement(edge.end);
            Vector3 vec = edge.start.get_patch_noraml(patch);
            vec.normalize_self();
            vec.multiple_self(1.0E-4);
            plusKnots.addElement(edge.start.translate(vec));
            plusKnots.addElement(edge.end.translate(vec));
            ++i;
        }
        return new ImplicitFunction(zeroKnots, plusKnots);
    }

    private static Vector remesh_section(SurfacePath surfacePath, Patch patch, Vector boundary_edges, Vector patch_polygons) {
        int i = 0;
        while (i < patch_polygons.size()) {
            Polygon2 polygon = (Polygon2)patch_polygons.elementAt(i);
            Pop.h.remove(polygon);
            ++i;
        }
        Hashtable<Vertex, Edge> section_edges = new Hashtable<Vertex, Edge>();
        Hashtable<Edge, Vector3> cameraLays = new Hashtable<Edge, Vector3>();
        Vector<Edge> section_edge_list = new Vector<Edge>();
        Enumeration e = surfacePath.crosssection.elements();
        while (e.hasMoreElements()) {
            Vector vs = (Vector)e.nextElement();
            Vector3 cameraLay = (Vector3)vs.elementAt(0);
            Vector<Vertex> objects = new Vector<Vertex>();
            Vector<Double> values = new Vector<Double>();
            int i2 = 1;
            while (i2 < vs.size()) {
                Vertex v = (Vertex)vs.elementAt(i2);
                objects.addElement(v);
                values.addElement(new Double(cameraLay.dot_product(v)));
                ++i2;
            }
            vs = Sort.sort(objects, values);
            i2 = 0;
            while (i2 < vs.size()) {
                Vertex v0 = (Vertex)vs.elementAt(i2);
                Vertex v1 = (Vertex)vs.elementAt(i2 + 1);
                Edge edge = new Edge(v0, v1);
                Pop.h.append(edge);
                if (v0.fixed && v1.fixed) {
                    edge.seam = new Seam();
                    edge.sharp = true;
                }
                section_edges.put(v0, edge);
                section_edges.put(v1, edge);
                cameraLays.put(edge, cameraLay);
                section_edge_list.addElement(edge);
                i2 += 2;
            }
        }
        Vector<Edge> visited = new Vector<Edge>();
        int i3 = 0;
        while (i3 < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i3);
            if (!visited.contains(edge)) {
                Vector loop = new Vector();
                Vector3 cameraLay = null;
                int index = i3;
                Edge start_edge = edge;
                block5: do {
                    visited.addElement(edge);
                    loop.addElement(edge);
                    Vertex next_vertex = edge.end;
                    Edge section_edge = (Edge)section_edges.get(next_vertex);
                    if (section_edge != null) {
                        loop.addElement(section_edge);
                        cameraLay = (Vector3)cameraLays.get(section_edge);
                        next_vertex = section_edge.get_the_other_vertex(next_vertex);
                        int j = 0;
                        while (j < boundary_edges.size()) {
                            edge = (Edge)boundary_edges.elementAt(j);
                            if (edge.start == next_vertex) {
                                index = j;
                                continue block5;
                            }
                            ++j;
                        }
                    } else {
                        if (++index == boundary_edges.size()) {
                            index = 0;
                        }
                        edge = (Edge)boundary_edges.elementAt(index);
                    }
                } while (edge != start_edge);
                Vector3 x_vec = cameraLay.get_normalized();
                Vector3 y_vec0 = ((Edge)loop.elementAt(0)).vector3();
                Vector3 normal = y_vec0.cross_product(x_vec);
                Vector3 y_vec = normal.cross_product(x_vec).get_normalized();
                loop = Util.reverseVector(loop);
                Vector<Vertex> loop_vertices = new Vector<Vertex>();
                Vertex v = ((Edge)loop.elementAt(0)).get_common_vertex((Edge)loop.elementAt(loop.size() - 1));
                int j = 0;
                while (j < loop.size()) {
                    loop_vertices.addElement(v);
                    Edge _edge = (Edge)loop.elementAt(j);
                    v = _edge.get_the_other_vertex(v);
                    ++j;
                }
                Vector<Vertex2D> loop_vertices2D = new Vector<Vertex2D>();
                int j2 = 0;
                while (j2 < loop_vertices.size()) {
                    Vertex v0 = (Vertex)loop_vertices.elementAt(j2);
                    double x = x_vec.dot_product(v0);
                    double y = y_vec.dot_product(v0);
                    Vertex2D u = new Vertex2D(x, y);
                    loop_vertices2D.addElement(u);
                    ++j2;
                }
                Vector[] result = Delaunay.triangulate(loop_vertices2D);
                Vector delaunay_edges = result[0];
                Vector delaunay_triangles = result[1];
                Vector<Edge> edges = new Vector<Edge>();
                int j3 = 0;
                while (j3 < delaunay_edges.size()) {
                    Vertex end;
                    int[] delaunay_edge = (int[])delaunay_edges.elementAt(j3);
                    Vertex start = (Vertex)loop_vertices.elementAt(delaunay_edge[0]);
                    Edge _edge = start.get_shared_edge(end = (Vertex)loop_vertices.elementAt(delaunay_edge[1]));
                    if (_edge == null) {
                        _edge = new Edge(start, end);
                        Pop.h.append(_edge);
                    }
                    edges.addElement(_edge);
                    ++j3;
                }
                j3 = 0;
                while (j3 < delaunay_triangles.size()) {
                    int[] delaunay_triangle = (int[])delaunay_triangles.elementAt(j3);
                    Edge edge0 = (Edge)edges.elementAt(delaunay_triangle[0]);
                    Edge edge1 = (Edge)edges.elementAt(delaunay_triangle[1]);
                    Edge edge2 = (Edge)edges.elementAt(delaunay_triangle[2]);
                    Pop.h.append(new Polygon2(edge0, edge1, edge2, patch));
                    ++j3;
                }
            }
            ++i3;
        }
        Pop.h.set_parameters();
        return section_edge_list;
    }

    public static void smooth_cut(Polyhedron _h, SurfacePath surfacePath) {
        Pop.h = _h;
        Object[] result = Pop.remesh(surfacePath, true, false);
        Patch patch = new Patch();
        Vector boundary_edges = (Vector)result[0];
        Vector patch_polygons = (Vector)result[1];
        Cut.remesh_section(surfacePath, patch, boundary_edges, patch_polygons);
        patch.unit_length = Cut.get_unit_length(surfacePath);
        patch.iFunction = Cut.smooth_cut_iFunction(boundary_edges);
    }

    private static double get_unit_length(SurfacePath surfacePath) {
        Vector<Vertex> vertices = new Vector<Vertex>();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onPolygon(i)) {
                vertices.addElement(surfacePath.getVertex(i));
            }
            ++i;
        }
        double total_length = 0.0;
        Vertex prev = (Vertex)vertices.elementAt(vertices.size() - 1);
        int i2 = 0;
        while (i2 < vertices.size()) {
            Vertex next = (Vertex)vertices.elementAt(i2);
            total_length += Vector3.distance(prev, next);
            prev = next;
            ++i2;
        }
        if (vertices.size() > 16) {
            return total_length / (double)vertices.size();
        }
        return total_length / 16.0;
    }

    private static ImplicitFunction smooth_cut_iFunction(Vector boundary_edges) {
        Seam seam = new Seam();
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i);
            edge.seam = seam;
            ++i;
        }
        Vector<Vertex> zeroKnots = new Vector<Vertex>();
        Vector<Vertex> plusKnots = new Vector<Vertex>();
        Vertex center = new Vertex();
        double total_length = 0.0;
        int i2 = 0;
        while (i2 < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i2);
            Vertex v = edge.mid_vertex();
            double l = edge.length();
            center.add_self(v.multiple(l));
            total_length += l;
            ++i2;
        }
        center.multiple_self(1.0 / total_length);
        Vector3 normal = new Vector3();
        int i3 = 0;
        while (i3 < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i3);
            Vector3 vec0 = new Vector3(center, edge.start);
            Vector3 vec1 = new Vector3(center, edge.end);
            normal.add_self(vec1.cross_product(vec0));
            ++i3;
        }
        normal.normalize_self();
        double radius = 0.0;
        int i4 = 0;
        while (i4 < boundary_edges.size()) {
            Vertex v = ((Edge)boundary_edges.elementAt((int)i4)).start;
            radius += Vector3.distance(v, center);
            ++i4;
        }
        radius /= (double)boundary_edges.size();
        Vertex vm = center.translate(normal.multiple(radius *= 0.2));
        zeroKnots.addElement(vm);
        vm = vm.translate(normal.multiple(1.0E-4));
        plusKnots.addElement(vm);
        vm = center.translate(normal.multiple(-radius));
        zeroKnots.addElement(vm);
        vm = vm.translate(normal.multiple(-1.0E-4));
        plusKnots.addElement(vm);
        Vertex prev_v = ((Edge)boundary_edges.elementAt((int)(boundary_edges.size() - 1))).start;
        int i5 = 0;
        while (i5 < boundary_edges.size()) {
            Vertex v = ((Edge)boundary_edges.elementAt((int)i5)).start;
            zeroKnots.addElement(v);
            Vector3 vec = new Vector3(v.normal);
            vec.normalize_self();
            vec.multiple_self(1.0E-4);
            Vertex pv = v.translate(vec);
            plusKnots.addElement(pv);
            prev_v = v;
            ++i5;
        }
        return new ImplicitFunction(zeroKnots, plusKnots);
    }

    public static SurfacePath cut(Polyhedron _h, SurfacePath surfacePath, boolean smooth) {
        Pop.h = _h;
        Object[] result = Pop.remesh(surfacePath, true, false);
        Patch patch = new Patch();
        Vector boundary_edges = (Vector)result[0];
        Vector patch_polygons = (Vector)result[1];
        Vector section_edges = Cut.remesh_section(surfacePath, patch, boundary_edges, patch_polygons);
        Seam seam = new Seam();
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i);
            edge.seam = seam;
            edge.sharp = !smooth;
            ++i;
        }
        patch.unit_length = Cut.get_unit_length(surfacePath) * 2.0;
        i = 0;
        while (i < Pop.h.n_polygons) {
            if (Pop.h.polygons[i].target_edge_length == 0.0) {
                Pop.h.polygons[i].target_edge_length = patch.unit_length;
            }
            ++i;
        }
        System.out.println("cut " + seam);
        Vector dirty_edges = Pop.find_dirty_edges(patch, seam);
        Skin.refine_mesh_connectivity_split_only(Pop.h, dirty_edges);
        Pop.h.set_normals();
        if (smooth) {
            boundary_edges = Pop.find_boundary_edges(seam);
            Object[] info = Fillet.fillet(Pop.h, boundary_edges, 0.1);
            Patch boundary_patch = (Patch)info[0];
            Seam seam0 = (Seam)info[1];
            Seam seam1 = (Seam)info[2];
            Vector internal_vertices = Pop.find_internal_vertices(patch);
            Util.appendVector(internal_vertices, Pop.find_internal_vertices(boundary_patch));
            Util.appendVector(internal_vertices, Pop.find_boundary_vertices(seam1));
            Vector boundary_vertices = Pop.find_boundary_vertices(seam0);
            TaubinFairing.constrained_smooth(internal_vertices, boundary_vertices, 5);
            Pop.set_original_mesh(Pop.h, true);
            Skin.drift(internal_vertices, 5);
            TaubinFairing.constrained_smooth(internal_vertices, boundary_vertices, 5);
            Pop.set_original_mesh(Pop.h, false);
            Skin.drift(internal_vertices, 5);
            Skin.refine_mesh_connectivity(Pop.h);
            Skin.drift(Pop.h, 5);
            Pop.h.set_parameters();
            return null;
        }
        boundary_edges = Pop.find_boundary_edges(seam);
        SurfacePath path = new SurfacePath(boundary_edges);
        path.seam = seam;
        return path;
    }
}

