/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import teddy.Edge;
import teddy.Fillet;
import teddy.Patch;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Pop;
import teddy.Seam;
import teddy.Skin;
import teddy.SurfacePath;
import teddy.Util;
import teddy.Vector3;
import teddy.Vertex;

public class Crease
extends Pop {
    public static final double CREASE_RADIUS = 0.1;
    public static final double CREASE_DEPTH = 0.08;
    public static SurfacePath surfacePath;

    public static Vector propagate_polygons(Polygon2 polygon, Vector surrounding) {
        Vector result = new Vector();
        Crease.propagate_polygons(polygon, null, surrounding, result);
        return result;
    }

    public static void propagate_polygons(Polygon2 polygon, Edge base_edge, Vector surrounding, Vector result) {
        if (result.contains(polygon)) {
            return;
        }
        result.addElement(polygon);
        int i = 0;
        while (i < 3) {
            Edge edge = polygon.edges[i];
            if (edge != base_edge && !surrounding.contains(edge)) {
                Polygon2 next_polygon = edge.get_another_polygon(polygon);
                Crease.propagate_polygons(next_polygon, edge, surrounding, result);
            }
            ++i;
        }
    }

    public static void sink_spine(Vector spine, Vector surrounding, Vector spokes) {
        double d;
        Vector3 normal = new Vector3();
        int i = 0;
        while (i < spine.size()) {
            Edge edge = (Edge)spine.elementAt(i);
            normal.add_self(edge.start.normal);
            normal.add_self(edge.end.normal);
            ++i;
        }
        normal.normalize_self();
        double depth = 0.08;
        double[] spine_length = new double[spine.size() + 1];
        Vertex[] spine_vertex = new Vertex[spine.size() + 1];
        double total_length = 0.0;
        spine_length[0] = 0.0;
        spine_vertex[0] = ((Edge)spine.elementAt((int)0)).start;
        int i2 = 0;
        while (i2 < spine.size()) {
            Edge edge = (Edge)spine.elementAt(i2);
            spine_length[i2 + 1] = total_length += edge.length();
            spine_vertex[i2 + 1] = edge.end;
            ++i2;
        }
        Hashtable<Vertex, Double> spine_depth = new Hashtable<Vertex, Double>();
        int i3 = 0;
        while (i3 < spine.size() + 1) {
            double d2 = Math.min(spine_length[i3], total_length - spine_length[i3]);
            double ratio = 1.0;
            if (d2 < 0.1) {
                double t = d2 / 0.1;
                ratio = 0.2 + 0.8 * t;
            }
            spine_depth.put(spine_vertex[i3], new Double(depth * ratio));
            ++i3;
        }
        int steps = 4;
        Vertex[][] spoke_vertex = new Vertex[spokes.size()][steps];
        int i4 = 0;
        while (i4 < spokes.size()) {
            Edge spoke = (Edge)spokes.elementAt(i4);
            spoke_vertex[i4][0] = spoke.start;
            spoke_vertex[i4][steps - 1] = spoke.end;
            if ((Double)spine_depth.get(spoke.start) == null) {
                System.out.println("" + spoke.start.index);
            }
            d = (Double)spine_depth.get(spoke.start);
            normal = spoke.start.normal;
            int j = 1;
            while (j < steps - 1) {
                Vertex v = Vector3.interporate(spoke.start, spoke.end, 1.0 * (double)j / (double)(steps - 1));
                double t = 1.0 * (double)j / (double)(steps - 1);
                double r = 1.0 - Math.sin(1.5707963267948966 * t);
                v.translate_self(Vector3.multiply(normal, -d * r));
                spoke_vertex[i4][j] = v;
                Pop.h.append(v);
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < spine.size() + 1) {
            Vertex v = spine_vertex[i4];
            d = (Double)spine_depth.get(v);
            normal = v.normal;
            v.translate_self(Vector3.multiply(normal, -d));
            ++i4;
        }
        Vertex[] spoke0 = spoke_vertex[spokes.size() - 1];
        int i5 = 0;
        while (i5 < spokes.size()) {
            int j;
            Vertex[] spoke1 = spoke_vertex[i5];
            if (spoke0[0] == spoke1[0]) {
                Crease.add_polygon(spoke1[1], spoke0[1], spoke0[0]);
                j = 1;
                while (j < steps - 1) {
                    Crease.add_polygon(spoke1[j], spoke0[j + 1], spoke0[j]);
                    Crease.add_polygon(spoke1[j + 1], spoke0[j + 1], spoke1[j]);
                    ++j;
                }
            } else {
                j = 0;
                while (j < steps - 2) {
                    Crease.add_polygon(spoke1[j], spoke0[j + 1], spoke0[j]);
                    Crease.add_polygon(spoke1[j + 1], spoke0[j + 1], spoke1[j]);
                    ++j;
                }
                Crease.add_polygon(spoke0[steps - 2], spoke1[steps - 2], spoke0[steps - 1]);
            }
            spoke0 = spoke1;
            ++i5;
        }
        Edge spoke_0 = (Edge)spokes.elementAt(spokes.size() - 1);
        int i6 = 0;
        while (i6 < spokes.size()) {
            Edge spoke_1 = (Edge)spokes.elementAt(i6);
            Polygon2 polygon = spoke_0.get_common_polygon(spoke_1);
            Pop.h.remove(polygon);
            spoke_0 = spoke_1;
            ++i6;
        }
        Pop.h.set_parameters();
    }

    public static Edge find_closest_vertex(Vertex v, Vector edges) {
        double min = -1.0;
        Edge closest = null;
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.elementAt(i);
            double d = Vector3.distance(edge.start, v);
            if (min == -1.0 || d < min) {
                min = d;
                closest = edge;
            }
            ++i;
        }
        return closest;
    }

    public static Vector surrounding(Vector base_edges, Seam surrounding_seam, Seam base_seam) {
        Edge edge;
        surfacePath = Fillet.get_offset_path(base_edges, 0.1);
        surfacePath.insertOnPolygon();
        Object[] result = Pop.remesh(surfacePath, true, false);
        Vector boundary_edges = (Vector)result[0];
        Vector patch_polygons = (Vector)result[1];
        double total = 0.0;
        int i = 0;
        while (i < boundary_edges.size()) {
            edge = (Edge)boundary_edges.elementAt(i);
            edge.seam = surrounding_seam;
            edge.sharp = true;
            ++i;
        }
        i = 0;
        while (i < base_edges.size()) {
            edge = (Edge)base_edges.elementAt(i);
            edge.seam = base_seam;
            edge.sharp = true;
            ++i;
        }
        ((Edge)base_edges.elementAt((int)0)).start.fixed = true;
        ((Edge)base_edges.elementAt((int)(base_edges.size() - 1))).end.fixed = true;
        return boundary_edges;
    }

    public static Vector fill(Vector spine, Vector surrounding) {
        Vertex surrounding_v0;
        Vector dead_polygons = Crease.propagate_polygons(((Edge)spine.elementAt((int)0)).left_polygon, surrounding);
        int i = 0;
        while (i < dead_polygons.size()) {
            Polygon2 polygon = (Polygon2)dead_polygons.elementAt(i);
            Pop.h.remove(polygon);
            ++i;
        }
        Pop.h.append(((Edge)spine.elementAt((int)0)).start);
        i = 0;
        while (i < spine.size()) {
            Edge edge = (Edge)spine.elementAt(i);
            Pop.h.append(edge.end);
            edge.start.edges.append(edge);
            edge.end.edges.append(edge);
            Pop.h.append(edge);
            ++i;
        }
        Edge spine_edge0 = (Edge)spine.elementAt(0);
        Vertex spine_v0 = spine_edge0.start;
        Edge surrounding_edge0 = Crease.find_closest_vertex(spine_v0, surrounding);
        Vertex surrounding_start_v = surrounding_v0 = surrounding_edge0.start;
        Vertex spine_start_v = spine_v0;
        Edge spine_start_edge = spine_edge0;
        boolean surrounding_looped = false;
        boolean spine_looped = false;
        Vector<Edge> spokes = new Vector<Edge>();
        Edge spoke_edge = new Edge(spine_v0, surrounding_v0);
        Pop.h.append(spoke_edge);
        spokes.addElement(spoke_edge);
        do {
            Vertex surrounding_v1 = surrounding_edge0.get_the_other_vertex(surrounding_v0);
            Vertex spine_v1 = spine_edge0.get_the_other_vertex(spine_v0);
            if (spine_looped || Vector3.distance(spine_v0, surrounding_v1) < Vector3.distance(spine_v1, surrounding_v0) && !surrounding_looped) {
                if (spine_v0.get_common_edge(surrounding_v1) == null) {
                    spoke_edge = new Edge(spine_v0, surrounding_v1);
                    Pop.h.append(spoke_edge);
                    spokes.addElement(spoke_edge);
                }
                Crease.add_polygon(spine_v0, surrounding_v1, surrounding_v0);
                surrounding_edge0 = Crease.fill_find_next_edge(surrounding_v1, surrounding_edge0, surrounding);
                surrounding_v0 = surrounding_v1;
                if (surrounding_v0 != surrounding_start_v) continue;
                surrounding_looped = true;
                continue;
            }
            if (spine_v1.get_common_edge(surrounding_v0) == null) {
                spoke_edge = new Edge(spine_v1, surrounding_v0);
                Pop.h.append(spoke_edge);
                spokes.addElement(spoke_edge);
            }
            Crease.add_polygon(surrounding_v0, spine_v0, spine_v1);
            spine_edge0 = Crease.fill_find_next_edge(spine_v1, spine_edge0, spine);
            spine_v0 = spine_v1;
            if (spine_edge0 != spine_start_edge || spine_v0 != spine_start_v) continue;
            spine_looped = true;
        } while (!surrounding_looped || !spine_looped);
        Pop.h.set_parameters();
        return spokes;
    }

    public static Edge fill_find_next_edge(Vertex v, Edge prev_edge, Vector edges) {
        int i = 0;
        while (i < edges.size()) {
            Edge edge = (Edge)edges.elementAt(i);
            if (edge.contain(v) && edge != prev_edge) {
                return edge;
            }
            ++i;
        }
        return prev_edge;
    }

    public static void crease(Polyhedron _h, SurfacePath surfacePath) {
        Pop.h = _h;
        Patch patch = new Patch();
        patch.unit_length = surfacePath.getPolygon((int)0).patch.unit_length;
        Object[] result = Crease.remesh_no_loop(surfacePath);
        Vector boundary_edges = (Vector)result[0];
        Vector patch_polygons = (Vector)result[1];
        Seam seam = new Seam();
        seam.maximum_edge_length = patch.unit_length / 4.0;
        double total = 0.0;
        int i = 0;
        while (i < boundary_edges.size()) {
            Edge edge = (Edge)boundary_edges.elementAt(i);
            edge.seam = seam;
            edge.sharp = true;
            ++i;
        }
        ((Edge)boundary_edges.elementAt((int)0)).start.fixed = true;
        ((Edge)boundary_edges.elementAt((int)(boundary_edges.size() - 1))).end.fixed = true;
        System.out.println("crease0");
        Seam surrounding_seam = new Seam();
        Vector surrounding_edges = Crease.surrounding(boundary_edges, surrounding_seam, seam);
        System.out.println("crease1");
        Pop.set_original_mesh(Pop.h, true);
        System.out.println("crease2");
        Skin.drift(Pop.h, 5);
        Skin.refine_mesh_connectivity(Pop.h);
        Skin.drift(Pop.h, 3);
        Skin.refine_mesh_connectivity(Pop.h);
        Skin.drift(Pop.h, 3);
        Pop.h.set_normals();
        System.out.println("crease3");
        boundary_edges = Pop.find_boundary_edges(seam);
        surrounding_edges = Pop.find_boundary_edges(surrounding_seam);
        System.out.println("crease4");
        Vector spokes = Crease.fill(boundary_edges, surrounding_edges);
        Crease.sink_spine(boundary_edges, surrounding_edges, spokes);
        int i2 = 0;
        while (i2 < Pop.h.n_polygons) {
            if (Pop.h.polygons[i2].patch == null || Pop.h.polygons[i2].patch.unit_length == 0.0) {
                Pop.h.polygons[i2].patch = patch;
            }
            ++i2;
        }
        Pop.remove_sharp(surrounding_seam);
        System.out.println("crease " + seam + " " + surrounding_seam);
    }

    public static Object[] remesh_no_loop(SurfacePath surfacePath) {
        Vector<Edge> dead_edges = new Vector<Edge>();
        Hashtable vertices_on_edge = new Hashtable();
        int i = 0;
        while (i < surfacePath.size()) {
            if (surfacePath.onEdge(i)) {
                Edge edge = surfacePath.getEdge(i);
                Vertex vertex = surfacePath.getVertex(i);
                Vector vs = new Vector();
                if (vertices_on_edge.containsKey(edge)) {
                    vs = (Vector)vertices_on_edge.get(edge);
                } else {
                    vertices_on_edge.put(edge, vs);
                    dead_edges.addElement(edge);
                }
                vs.addElement(vertex);
            }
            ++i;
        }
        Vector<Vertex> fixed_vertices = new Vector<Vertex>();
        Vector<Polygon2> polygons = new Vector<Polygon2>();
        Polygon2 polygon = surfacePath.getPolygon(0);
        Vector<Edge> boundary_edges = new Vector<Edge>();
        Vertex prev_vertex = surfacePath.getVertex(0);
        polygons.addElement(polygon);
        Pop.h.append(prev_vertex);
        Hashtable<Polygon2, Vector> edges_on_polygon = new Hashtable<Polygon2, Vector>();
        int i2 = 1;
        while (i2 < surfacePath.size()) {
            Vertex vertex = surfacePath.getVertex(i2);
            Pop.h.append(vertex);
            Edge edge = new Edge(prev_vertex, vertex);
            Pop.h.append(edge);
            Vector vs = new Vector();
            if (edges_on_polygon.containsKey(polygon)) {
                vs = (Vector)edges_on_polygon.get(polygon);
            } else {
                edges_on_polygon.put(polygon, vs);
            }
            vs.addElement(edge);
            if (surfacePath.onEdge(i2)) {
                polygon = surfacePath.getEdge(i2).get_the_other_polygon(polygon);
                if (!polygons.contains(polygon)) {
                    polygons.addElement(polygon);
                }
                if (surfacePath.getEdge(i2).on_seam()) {
                    fixed_vertices.addElement(vertex);
                }
            }
            boundary_edges.addElement(edge);
            prev_vertex = vertex;
            ++i2;
        }
        Enumeration e = vertices_on_edge.keys();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vector vs = (Vector)vertices_on_edge.get(edge);
            vs = Pop.sort_vertices_on_edge(vs, edge.start);
            vs.addElement(edge.end);
            prev_vertex = edge.start;
            Vector<Edge> newEdges = new Vector<Edge>();
            int i3 = 0;
            while (i3 < vs.size()) {
                Vertex next_vertex = (Vertex)vs.elementAt(i3);
                Edge newEdge = new Edge(prev_vertex, next_vertex);
                newEdges.addElement(newEdge);
                newEdge.seam = edge.seam;
                newEdge.sharp = edge.sharp;
                Pop.h.append(newEdge);
                prev_vertex = next_vertex;
                ++i3;
            }
            vertices_on_edge.put(edge, newEdges);
        }
        i = 0;
        while (i < polygons.size()) {
            polygon = (Polygon2)polygons.elementAt(i);
            Vector newEdges = new Vector();
            int j = 0;
            while (j < 3) {
                Edge edge = polygon.edges[j];
                if (vertices_on_edge.containsKey(edge)) {
                    Vector vs = (Vector)vertices_on_edge.get(edge);
                    if (edge.left_polygon != polygon) {
                        vs = Util.reverseVector(vs);
                    }
                    newEdges = Util.connectVector(newEdges, vs);
                } else {
                    newEdges.addElement(edge);
                }
                ++j;
            }
            Vector possibleEdges = (Vector)edges_on_polygon.get(polygon);
            possibleEdges = Util.connectVector(possibleEdges, possibleEdges);
            possibleEdges = Util.connectVector(possibleEdges, newEdges);
            Vector<Vector> loops = new Vector<Vector>();
            Vector visited = new Vector();
            int j2 = 0;
            while (j2 < newEdges.size()) {
                Edge edge = (Edge)newEdges.elementAt(j2);
                Edge nextEdge = (Edge)newEdges.elementAt(Util.mod(j2 + 1, newEdges.size()));
                if (!visited.contains(edge)) {
                    loops.addElement(Pop.find_loop(edge, edge.get_common_vertex(nextEdge), polygon.normal, visited, dead_edges, possibleEdges, newEdges));
                }
                ++j2;
            }
            j2 = 0;
            while (j2 < loops.size()) {
                Vector loop = (Vector)loops.elementAt(j2);
                if (loop.size() == 3) {
                    Pop.h.append(new Polygon2((Edge)loop.elementAt(0), (Edge)loop.elementAt(1), (Edge)loop.elementAt(2), polygon.patch));
                } else {
                    Pop.triangulate(loop, polygon);
                }
                ++j2;
            }
            Pop.h.remove(polygon);
            ++i;
        }
        Pop.h.set_parameters();
        Vector patch_polygons = new Vector();
        Object[] result = new Object[]{boundary_edges, patch_polygons};
        return result;
    }

    public static void add_polygon(Vertex v0, Vertex v1, Vertex v2) {
        Edge edge0 = Crease.add_polygon_sub(v0, v1);
        Edge edge1 = Crease.add_polygon_sub(v1, v2);
        Edge edge2 = Crease.add_polygon_sub(v2, v0);
        Pop.h.append(new Polygon2(edge0, edge1, edge2));
    }

    public static void add_polygon(Edge edge, Vertex v) {
        Edge edge0 = Crease.add_polygon_sub(v, edge.start);
        Edge edge1 = Crease.add_polygon_sub(v, edge.end);
        Pop.h.append(new Polygon2(edge, edge1, edge0));
    }

    public static Edge add_polygon_sub(Vertex v, Vertex u) {
        Edge edge = v.get_common_edge(u);
        if (edge == null) {
            edge = new Edge(v, u);
            Pop.h.append(edge);
        }
        return edge;
    }
}

