/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.io.Serializable;
import teddy.Vector3;
import teddy.Vertex;

public class CoordSystem
implements Serializable {
    public Vector3 base_x;
    public Vector3 base_y;
    public Vector3 base_z;

    CoordSystem(Vector3 x, Vector3 y, Vector3 z) {
        this.base_x = x;
        this.base_y = y;
        this.base_z = z;
    }

    public Vertex translate(Vertex v) {
        double x = v.dot_product(this.base_x);
        double y = v.dot_product(this.base_y);
        double z = v.dot_product(this.base_z);
        return new Vertex(x, y, z);
    }

    public Vector3 translate(Vector3 v) {
        double x = v.dot_product(this.base_x);
        double y = v.dot_product(this.base_y);
        double z = v.dot_product(this.base_z);
        return new Vector3(x, y, z);
    }

    public Vertex reverse_translate(Vertex v) {
        Vector3 vx = this.base_x.multiple(v.x);
        Vector3 vy = this.base_y.multiple(v.y);
        Vector3 vz = this.base_z.multiple(v.z);
        return new Vertex(vx.add(vy).add(vz));
    }

    public Vertex reverse_translate(double x, double y, double z) {
        Vector3 vx = this.base_x.multiple(x);
        Vector3 vy = this.base_y.multiple(y);
        Vector3 vz = this.base_z.multiple(z);
        return new Vertex(vx.add(vy).add(vz));
    }

    public Vector3 reverse_translate(Vector3 v) {
        Vector3 vx = this.base_x.multiple(v.x);
        Vector3 vy = this.base_y.multiple(v.y);
        Vector3 vz = this.base_z.multiple(v.z);
        return vx.add(vy).add(vz);
    }
}

