/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.awt.Point;
import java.util.Vector;
import teddy.Node;
import teddy.Util;
import teddy.Vector2;
import teddy.Vertex2D;

public class CleanStroke {
    static Vector points;
    static Vector nodes;
    static Vector corners;
    static int MIN_EDGE_LENGTH;
    static int MAX_EDGE_LENGTH;
    public static final boolean LOOP = true;
    public static final int SHARP_CORNER_MERGIN = 20;

    public static Node node_traverse(Node prev, double distance) {
        double d = Vertex2D.distance(prev.p0, prev.p1) * (1.0 - prev.t);
        if (distance < d) {
            return new Node(prev.p0, prev.p1, prev.t + distance / Vertex2D.distance(prev.p0, prev.p1));
        }
        double total = Vertex2D.distance(prev.p0, prev.p1) * (1.0 - prev.t);
        Vertex2D p1 = prev.p1;
        Vertex2D next_p1;
        double l;
        while (!((l = Vertex2D.distance(p1, next_p1 = (Vertex2D)points.elementAt(Util.mod(p1.index + 1, points.size())))) > distance - total)) {
            total += l;
            p1 = next_p1;
        }
        return new Node(p1, next_p1, (distance - total) / l);
    }

    public static void remesh() {
        CleanStroke.remove_nodes();
        CleanStroke.insert_nodes();
    }

    public static Vector clean(Vector stroke, int min, int max) {
        return CleanStroke.clean(stroke, min, max, false);
    }

    public static Vector clean(Vector stroke, int min, int max, boolean loop) {
        Object p;
        MIN_EDGE_LENGTH = min;
        MAX_EDGE_LENGTH = max;
        points = new Vector();
        nodes = new Vector();
        Object prev_p = new Point();
        int n = 0;
        int i = 0;
        while (i < stroke.size()) {
            p = (Point)stroke.elementAt(i);
            if (Vector2.distance((Point)p, (Point)prev_p) != 0.0) {
                Vertex2D v = new Vertex2D((Point)p);
                points.addElement(v);
                v.index = n++;
            } else {
                System.out.println("incidental vertex (CleanStroke)");
            }
            prev_p = p;
            ++i;
        }
        corners = CleanStroke.find_local_minimums(points);
        i = 0;
        while (i < corners.size()) {
            p = (Vertex2D)corners.elementAt(i);
            ((Vertex2D)p).fixed = true;
            System.out.println("local_minimum");
            ++i;
        }
        points = CleanStroke.remove_short_or_sharp_edges(points);
        i = 0;
        while (i < points.size()) {
            Vertex2D p0 = (Vertex2D)points.elementAt(i);
            Vertex2D p1 = (Vertex2D)points.elementAt(Util.mod(i + 1, points.size()));
            Node node = new Node(p0, p1, 0.0);
            node.index = i++;
            nodes.addElement(node);
        }
        if (!loop) {
            ((Vertex2D)CleanStroke.points.elementAt((int)0)).fixed = true;
            ((Vertex2D)CleanStroke.points.elementAt((int)(CleanStroke.points.size() - 1))).fixed = true;
            ((Node)CleanStroke.nodes.elementAt((int)0)).fixed = true;
            ((Node)CleanStroke.nodes.elementAt((int)(CleanStroke.nodes.size() - 1))).fixed = true;
        }
        CleanStroke.drift(5);
        CleanStroke.remesh();
        CleanStroke.drift(5);
        CleanStroke.remesh();
        CleanStroke.drift(5);
        return nodes;
    }

    public static boolean insert_middle(Node prev, Node next) {
        double d = CleanStroke.node_distance(prev, next);
        if (d < (double)(MIN_EDGE_LENGTH * 2)) {
            return false;
        }
        if (d > (double)MAX_EDGE_LENGTH) {
            return true;
        }
        Vertex2D p = prev.p1;
        while (p != next.p1) {
            Vector2 vec0 = new Vector2(prev, (Vector2)p);
            Vector2 vec1 = new Vector2(p, (Vector2)next);
            if (Vector2.cos(vec0, vec1) < 0.8) {
                return true;
            }
            p = (Vertex2D)points.elementAt(Util.mod(p.index + 1, points.size()));
        }
        return false;
    }

    public static void remove_nodes() {
        CleanStroke.refresh_node_indices();
        Vector node_list = Util.shuffleVector(nodes);
        int i = 0;
        while (i < node_list.size()) {
            Node next;
            Node prev;
            Node node = (Node)node_list.elementAt(i);
            if (!node.fixed && CleanStroke.remove_middle(prev = (Node)nodes.elementAt(Util.mod(node.index - 1, nodes.size())), next = (Node)nodes.elementAt(Util.mod(node.index + 1, nodes.size())))) {
                nodes.removeElement(node);
                CleanStroke.refresh_node_indices();
            }
            ++i;
        }
    }

    public static void refresh_node_indices() {
        int i = 0;
        while (i < nodes.size()) {
            Node node = (Node)nodes.elementAt(Util.mod(i, nodes.size()));
            node.index = i++;
        }
    }

    public static void drift(int n) {
        int i = 0;
        while (i < n) {
            CleanStroke.drift();
            ++i;
        }
    }

    public static void drift() {
        Vector<Node> new_nodes = new Vector<Node>();
        int i = 0;
        while (i < nodes.size()) {
            Node node = (Node)nodes.elementAt(Util.mod(i, nodes.size()));
            if (!node.fixed) {
                Node prev = (Node)nodes.elementAt(Util.mod(i - 1, nodes.size()));
                Node next = (Node)nodes.elementAt(Util.mod(i + 1, nodes.size()));
                new_nodes.addElement(CleanStroke.drift_sub(node, prev, next));
            } else {
                new_nodes.addElement(node);
            }
            ++i;
        }
        nodes = new_nodes;
    }

    public static double node_distance(Node prev, Node next) {
        Vertex2D next_p1;
        if (prev.p1 == next.p1) {
            return Vertex2D.distance(prev.p0, prev.p1) * (next.t - prev.t);
        }
        double total = Vertex2D.distance(prev.p0, prev.p1) * (1.0 - prev.t);
        Vertex2D p1 = prev.p1;
        while ((next_p1 = (Vertex2D)points.elementAt(Util.mod(p1.index + 1, points.size()))) != next.p1) {
            total += Vertex2D.distance(p1, next_p1);
            p1 = next_p1;
        }
        return total += Vertex2D.distance(next.p0, next.p1) * next.t;
    }

    public static void set_node_as_points() {
        Node node;
        points = new Vector();
        int i = 0;
        while (i < nodes.size()) {
            node = (Node)nodes.elementAt(i);
            Vertex2D p = new Vertex2D(node);
            p.index = i++;
            points.addElement(p);
        }
        i = 0;
        while (i < nodes.size()) {
            node = (Node)nodes.elementAt(i);
            node.p0 = (Vertex2D)points.elementAt(i);
            node.p1 = (Vertex2D)points.elementAt(Util.mod(i + 1, points.size()));
            node.t = 0.0;
            ++i;
        }
    }

    public static void insert_nodes() {
        CleanStroke.refresh_node_indices();
        Vector node_list = Util.shuffleVector(nodes);
        int i = 0;
        while (i < node_list.size()) {
            Node node = (Node)node_list.elementAt(i);
            if (!node.fixed) {
                Node prev = (Node)nodes.elementAt(Util.mod(node.index - 1, nodes.size()));
                Node next = (Node)nodes.elementAt(Util.mod(node.index + 1, nodes.size()));
                if (CleanStroke.insert_middle(prev, node)) {
                    nodes.insertElementAt(CleanStroke.insertNode(prev, node), node.index);
                    CleanStroke.refresh_node_indices();
                } else if (CleanStroke.insert_middle(node, next)) {
                    nodes.insertElementAt(CleanStroke.insertNode(node, next), node.index + 1);
                    CleanStroke.refresh_node_indices();
                }
            }
            ++i;
        }
    }

    public static Vector remove_short_or_sharp_edges(Vector stroke) {
        int i = 1;
        while (i < stroke.size() - 1) {
            Vertex2D p0 = (Vertex2D)stroke.elementAt(i - 1);
            Vertex2D p1 = (Vertex2D)stroke.elementAt(i);
            Vertex2D p2 = (Vertex2D)stroke.elementAt(i + 1);
            if (!p1.fixed) {
                Vector2 v10 = new Vector2(p1, (Vector2)p0);
                Vector2 v12 = new Vector2(p1, (Vector2)p2);
                v10.normalize_self();
                v12.normalize_self();
                if (Vector2.cos(v10, v12) > -0.2 || Vertex2D.distance(p0, p1) < 10.0) {
                    stroke.removeElementAt(i);
                    i = Math.max(1, i - 2);
                }
            }
            ++i;
        }
        i = 0;
        while (i < stroke.size()) {
            ((Vertex2D)stroke.elementAt((int)i)).index = i;
            ++i;
        }
        return stroke;
    }

    public static Vertex2D vertex_traverse(Vertex2D base, double d, Vector points) {
        int step = 1;
        if (d < 0.0) {
            d *= -1.0;
            step = -1;
        }
        Vertex2D p = base;
        Vertex2D next_p;
        double l;
        while (!((l = Vertex2D.distance(p, next_p = (Vertex2D)points.elementAt(Util.mod(p.index + step, points.size())))) > d)) {
            d -= l;
            p = next_p;
        }
        return Vertex2D.interporate(p, next_p, d / l);
    }

    public static Node drift_sub(Node node, Node prev, Node next) {
        double prev_to_next = CleanStroke.node_distance(prev, next);
        double prev_to_node = CleanStroke.node_distance(prev, node);
        double t = prev_to_next / 2.0 + (prev_to_node - prev_to_next / 2.0) * 0.8;
        node = CleanStroke.node_traverse(prev, t);
        return node;
    }

    public static Vector find_local_minimums(Vector points) {
        Vector<Vertex2D> minimums = new Vector<Vertex2D>();
        Vertex2D prev_minimum = null;
        int i = 0;
        while (i < points.size()) {
            Vertex2D u1;
            Vector2 vec1;
            Vertex2D u0;
            Vector2 vec0;
            Vertex2D v0 = (Vertex2D)points.elementAt(Util.mod(i - 2, points.size()));
            Vertex2D v1 = (Vertex2D)points.elementAt(Util.mod(i - 1, points.size()));
            Vertex2D v2 = (Vertex2D)points.elementAt(Util.mod(i, points.size()));
            Vertex2D v3 = (Vertex2D)points.elementAt(Util.mod(i + 1, points.size()));
            Vertex2D v4 = (Vertex2D)points.elementAt(Util.mod(i + 2, points.size()));
            double d0 = Vertex2D.distance(v0, v1);
            double d1 = Vertex2D.distance(v1, v2);
            double d2 = Vertex2D.distance(v2, v3);
            double d3 = Vertex2D.distance(v3, v4);
            if (d1 <= d0 && d1 <= d2 && Vector2.cos(vec0 = new Vector2(u0 = CleanStroke.vertex_traverse(v2, -20.0, points), (Vector2)v2), vec1 = new Vector2(v2, (Vector2)(u1 = CleanStroke.vertex_traverse(v2, 20.0, points)))) < 0.0 && Vector2.sin(vec0, vec1) > 0.0 && (prev_minimum == null || Vertex2D.distance(prev_minimum, v2) > 20.0)) {
                prev_minimum = v2;
                minimums.addElement(v2);
            }
            ++i;
        }
        return minimums;
    }

    public static Node insertNode(Node prev, Node next) {
        double prev_to_next = CleanStroke.node_distance(prev, next);
        return CleanStroke.node_traverse(prev, prev_to_next / 2.0);
    }

    public static boolean remove_middle(Node prev, Node next) {
        double d = CleanStroke.node_distance(prev, next);
        if (d > (double)MAX_EDGE_LENGTH) {
            return false;
        }
        if (d < (double)MIN_EDGE_LENGTH) {
            return true;
        }
        Vertex2D p = prev.p1;
        while (p != next.p1) {
            Vector2 vec0 = new Vector2(prev, (Vector2)p);
            Vector2 vec1 = new Vector2(p, (Vector2)next);
            if (Vector2.cos(vec0, vec1) < 0.95) {
                return false;
            }
            p = (Vertex2D)points.elementAt(Util.mod(p.index + 1, points.size()));
        }
        return true;
    }
}

