/*
 * Decompiled with CFR 0.152.
 */
package teddy;

import java.util.Enumeration;
import java.util.Vector;
import teddy.ConjugateGradient;
import teddy.Edge;
import teddy.LinkedList;
import teddy.Polygon2;
import teddy.Polyhedron;
import teddy.Vector3;
import teddy.Vertex;

public class ButterflySubdivision {
    public static Vector3 get_new_position(Vertex v, Edge edge) {
        if (edge.sharp) {
            return ButterflySubdivision.get_new_position_crease(edge);
        }
        if (edge.start.edges.size() == 6 && edge.end.edges.size() == 6) {
            Vector3 sum = new Vector3();
            sum.add_self(Vector3.multiply(edge.start, 0.5));
            sum.add_self(Vector3.multiply(edge.end, 0.5));
            Vertex b0 = edge.left_polygon.get_opposite_vertex(edge);
            Vertex b1 = edge.right_polygon.get_opposite_vertex(edge);
            sum.add_self(Vector3.multiply(b0, 0.125));
            sum.add_self(Vector3.multiply(b1, 0.125));
            Vertex a0 = edge.start;
            Vertex a1 = edge.end;
            Polygon2 polygon0 = edge.left_polygon;
            Polygon2 polygon1 = edge.right_polygon;
            Edge edge_c0 = polygon0.get_opposite_edge(a0);
            Vertex c0 = edge_c0.get_another_polygon(polygon0).get_opposite_vertex(edge_c0);
            Edge edge_c1 = polygon0.get_opposite_edge(a1);
            Vertex c1 = edge_c1.get_another_polygon(polygon0).get_opposite_vertex(edge_c1);
            Edge edge_c2 = polygon1.get_opposite_edge(a0);
            Vertex c2 = edge_c2.get_another_polygon(polygon1).get_opposite_vertex(edge_c2);
            Edge edge_c3 = polygon1.get_opposite_edge(a1);
            Vertex c3 = edge_c3.get_another_polygon(polygon1).get_opposite_vertex(edge_c3);
            sum.add_self(Vector3.multiply(c0, -0.0625));
            sum.add_self(Vector3.multiply(c1, -0.0625));
            sum.add_self(Vector3.multiply(c2, -0.0625));
            sum.add_self(Vector3.multiply(c3, -0.0625));
            return sum;
        }
        if (edge.start.edges.size() != 6 && edge.end.edges.size() == 6) {
            return ButterflySubdivision.get_edge_position_sub(edge.start, edge);
        }
        if (edge.start.edges.size() == 6 && edge.end.edges.size() != 6) {
            return ButterflySubdivision.get_edge_position_sub(edge.end, edge);
        }
        Vector3 v0 = ButterflySubdivision.get_edge_position_sub(edge.start, edge);
        Vector3 v1 = ButterflySubdivision.get_edge_position_sub(edge.end, edge);
        return Vector3.multiply(Vector3.add(v0, v1), 0.5);
    }

    public static double[] get_new_weights(Vertex v) {
        if (v.weight_vector == null) {
            return null;
        }
        if (ButterflySubdivision.is_crease_vertex(v)) {
            return ButterflySubdivision.get_new_weights_crease(v);
        }
        double[] sum = new double[v.weight_vector.length];
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex w = edge.get_the_other_vertex(v);
            sum = ConjugateGradient.add(sum, w.weight_vector);
        }
        int n = v.edges.size();
        double k = 3.0 + 2.0 * Math.cos(Math.PI * 2 / (double)n);
        double a = 0.625 - k * k / 64.0;
        double alpha = (double)n * (1.0 - a) / a;
        double[] w = ConjugateGradient.multiply(v.weight_vector, alpha);
        w = ConjugateGradient.add(w, sum);
        w = ConjugateGradient.multiply(w, 1.0 / (alpha + (double)n));
        return w;
    }

    public static double[] get_new_weights(Edge edge) {
        if (edge.start.weight_vector == null) {
            return null;
        }
        if (edge.sharp) {
            return ButterflySubdivision.get_new_weights_crease(edge);
        }
        double[] sum = ConjugateGradient.add(edge.start.weight_vector, edge.end.weight_vector);
        sum = ConjugateGradient.multiply(sum, 3.0);
        Vertex v0 = edge.left_polygon.get_opposite_vertex(edge);
        Vertex v1 = edge.right_polygon.get_opposite_vertex(edge);
        sum = ConjugateGradient.add(sum, v0.weight_vector);
        sum = ConjugateGradient.add(sum, v1.weight_vector);
        sum = ConjugateGradient.multiply(sum, 0.125);
        return sum;
    }

    public static Vector3 get_new_position_crease(Vertex v) {
        if (v.fixed) {
            return new Vector3(v);
        }
        Vector3 sum = new Vector3();
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            Vertex w = edge.get_the_other_vertex(v);
            sum.add_self(w);
        }
        Vector3 original = v.copyVector3();
        original.multiple_self(6.0);
        sum.add_self(original);
        sum.multiple_self(0.125);
        return sum;
    }

    public static Vector3 get_new_position_crease(Edge edge) {
        Vector3 sum = new Vector3();
        sum.add_self(edge.start);
        sum.add_self(edge.end);
        sum.multiple_self(0.5);
        return sum;
    }

    public static double[] get_new_weights_crease(Vertex v) {
        if (v.fixed) {
            return v.weight_vector;
        }
        double[] sum = new double[v.weight_vector.length];
        int n = 0;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            Vertex w = edge.get_the_other_vertex(v);
            sum = ConjugateGradient.add(sum, w.weight_vector);
            ++n;
        }
        if (n != 2) {
            sum = ConjugateGradient.multiply(sum, 2.0 / (double)n);
        }
        double[] w = ConjugateGradient.multiply(v.weight_vector, 6.0);
        w = ConjugateGradient.add(w, sum);
        w = ConjugateGradient.multiply(w, 0.125);
        return w;
    }

    public static double[] get_new_weights_crease(Edge edge) {
        double[] sum = ConjugateGradient.add(edge.start.weight_vector, edge.end.weight_vector);
        sum = ConjugateGradient.multiply(sum, 0.5);
        return sum;
    }

    public static Vector3 get_edge_position_sub(Vertex v, Edge edge) {
        int K = v.edges.size();
        Vector3 sum = new Vector3();
        Vector edges = v.get_edges_clockwise(edge);
        if (edges.size() != K) {
            System.out.println("error in Subdivision");
        }
        double total = 0.0;
        if (K >= 5) {
            int i = 0;
            while (i < edges.size()) {
                Edge _edge = (Edge)edges.elementAt(i);
                Vertex u = _edge.get_the_other_vertex(v);
                double s = (0.25 + Math.cos(Math.PI * 2 * (double)i / (double)K) + 0.5 * Math.cos(Math.PI * 4 * (double)i / (double)K)) / (double)K;
                total += s;
                sum.add_self(Vector3.multiply(u, s));
                ++i;
            }
        } else if (K == 3) {
            Vertex u0 = ((Edge)edges.elementAt(0)).get_the_other_vertex(v);
            double s0 = 0.4166666666666667;
            Vertex u1 = ((Edge)edges.elementAt(1)).get_the_other_vertex(v);
            double s1 = -0.08333333333333333;
            Vertex u2 = ((Edge)edges.elementAt(2)).get_the_other_vertex(v);
            double s2 = -0.08333333333333333;
            sum.add_self(Vector3.multiply(u0, s0));
            sum.add_self(Vector3.multiply(u1, s1));
            sum.add_self(Vector3.multiply(u2, s2));
            total = s0 + s1 + s2;
        } else if (K == 4) {
            Vertex u0 = ((Edge)edges.elementAt(0)).get_the_other_vertex(v);
            double s0 = 0.375;
            Vertex u2 = ((Edge)edges.elementAt(2)).get_the_other_vertex(v);
            double s2 = -0.125;
            sum.add_self(Vector3.multiply(u0, s0));
            sum.add_self(Vector3.multiply(u2, s2));
            total = s0 + s2;
        }
        sum.add_self(Vector3.multiply(v, 1.0 - total));
        return sum;
    }

    public static boolean is_crease_vertex(Vertex v) {
        int crease_count = 0;
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (!edge.sharp) continue;
            ++crease_count;
        }
        return crease_count >= 2;
    }

    public static void subdivide(Polyhedron h) {
        Vertex mid_vertex;
        h._vertices = new LinkedList();
        h._edges = new LinkedList();
        h._polygons = new LinkedList();
        Vector3[] new_positions = new Vector3[h.n_vertices];
        double[][] new_weights = new double[h.n_vertices][];
        int i = 0;
        while (i < h.n_vertices) {
            Vertex v = h.vertices[i];
            new_positions[i] = ButterflySubdivision.get_new_position(v);
            new_weights[i] = ButterflySubdivision.get_new_weights(v);
            ++i;
        }
        Vector3[] new_edge_positions = new Vector3[h.n_edges];
        double[][] new_weights_edge = new double[h.n_edges][];
        int i2 = 0;
        while (i2 < h.n_edges) {
            mid_vertex = h.edges[i2].get_mid_vertex();
            new_edge_positions[i2] = ButterflySubdivision.get_new_position(mid_vertex, h.edges[i2]);
            new_weights_edge[i2] = ButterflySubdivision.get_new_weights(h.edges[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_vertices) {
            Vertex v = h.vertices[i2];
            v.warp(new_positions[i2]);
            v.weight_vector = new_weights[i2];
            h._vertices.append(v);
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_edges) {
            mid_vertex = h.edges[i2].get_mid_vertex();
            mid_vertex.warp(new_edge_positions[i2]);
            mid_vertex.weight_vector = new_weights_edge[i2];
            h._vertices.append(mid_vertex);
            h._edges.append(new Edge(h.edges[i2].start, mid_vertex, h.edges[i2].sharp));
            h._edges.append(new Edge(mid_vertex, h.edges[i2].end, h.edges[i2].sharp));
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_polygons) {
            Polygon2 polygon = h.polygons[i2];
            Vertex v0 = polygon.get_vertex(0);
            Vertex v1 = polygon.edges[0].mid_vertex;
            Vertex v2 = polygon.get_vertex(1);
            Vertex v3 = polygon.edges[1].mid_vertex;
            Vertex v4 = polygon.get_vertex(2);
            Vertex v5 = polygon.edges[2].mid_vertex;
            Edge edge13 = new Edge(v1, v3);
            Edge edge35 = new Edge(v3, v5);
            Edge edge51 = new Edge(v5, v1);
            Edge edge01 = v0.get_shared_edge(v1);
            Edge edge12 = v1.get_shared_edge(v2);
            Edge edge23 = v2.get_shared_edge(v3);
            Edge edge34 = v3.get_shared_edge(v4);
            Edge edge45 = v4.get_shared_edge(v5);
            Edge edge50 = v5.get_shared_edge(v0);
            edge01.seam = edge12.seam = polygon.edges((int)0).seam;
            edge23.seam = edge34.seam = polygon.edges((int)1).seam;
            edge45.seam = edge50.seam = polygon.edges((int)2).seam;
            edge01.sharp = edge12.sharp = polygon.edges((int)0).sharp;
            edge23.sharp = edge34.sharp = polygon.edges((int)1).sharp;
            edge45.sharp = edge50.sharp = polygon.edges((int)2).sharp;
            h._polygons.append(new Polygon2(edge13, edge35, edge51, polygon.patch));
            h._polygons.append(new Polygon2(edge01, edge51, edge50, polygon.patch));
            h._polygons.append(new Polygon2(edge12, edge23, edge13, polygon.patch));
            h._polygons.append(new Polygon2(edge34, edge45, edge35, polygon.patch));
            h._edges.append(edge13);
            h._edges.append(edge35);
            h._edges.append(edge51);
            ++i2;
        }
        i2 = 0;
        while (i2 < h.n_edges) {
            Edge edge = h.edges[i2];
            edge.start.remove_edge(edge);
            edge.end.remove_edge(edge);
            ++i2;
        }
        int c = 0;
        Enumeration e = h._edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            if (edge.left_polygon() != null && edge.right_polygon() != null) continue;
            ++c;
        }
        h.postprocess_list_to_array();
        h.set_parameters();
    }

    public static Vector3 get_new_position(Vertex v) {
        if (ButterflySubdivision.is_crease_vertex(v)) {
            return ButterflySubdivision.get_new_position_crease(v);
        }
        Vector3 sum = new Vector3();
        Enumeration e = v.edges.elements();
        while (e.hasMoreElements()) {
            Edge edge = (Edge)e.nextElement();
            Vertex w = edge.get_the_other_vertex(v);
            sum.add_self(w);
        }
        sum = v.copyVector3();
        return sum;
    }
}

