/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.util;

import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.PropertyValuePair;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class Property {
    private Method m_getter;
    private Method m_setter;
    private Method m_setterHowMuch;
    private Class m_elementClass;
    private Class m_valueClass;
    private String m_capsAndUnderscoresName;
    private String m_mixedCaseName;
    private boolean m_isPersistent;
    static Class class$edu$cmu$cs$stage3$util$Property;
    static Class class$edu$cmu$cs$stage3$util$HowMuch;

    public Property(Class elementClass, String capsAndUnderscoresName, boolean isPersistent) {
        Class[] parameterTypes;
        this.m_capsAndUnderscoresName = capsAndUnderscoresName;
        this.m_mixedCaseName = new String(Property.convertAllCapsAndUnderscoresToMixedCase(capsAndUnderscoresName));
        try {
            parameterTypes = new Class[]{};
            this.m_getter = elementClass.getDeclaredMethod("get".concat(String.valueOf(String.valueOf(this.m_mixedCaseName))), parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        this.m_valueClass = this.m_getter.getReturnType();
        try {
            parameterTypes = new Class[]{this.m_valueClass};
            this.m_setter = elementClass.getDeclaredMethod("set".concat(String.valueOf(String.valueOf(this.m_mixedCaseName))), parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        try {
            parameterTypes = new Class[]{this.m_valueClass, class$edu$cmu$cs$stage3$util$HowMuch == null ? (class$edu$cmu$cs$stage3$util$HowMuch = Property.class$("edu.cmu.cs.stage3.util.HowMuch")) : class$edu$cmu$cs$stage3$util$HowMuch};
            this.m_setterHowMuch = elementClass.getDeclaredMethod("set".concat(String.valueOf(String.valueOf(this.m_mixedCaseName))), parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (this.m_getter == null || this.m_setter == null) {
            throw new NullPointerException();
        }
        this.m_elementClass = elementClass;
        this.m_isPersistent = isPersistent;
    }

    public Property(Class elementClass, String capsAndUnderscoresName) {
        this(elementClass, capsAndUnderscoresName, true);
    }

    public boolean acceptsHowMuch() {
        return this.m_setterHowMuch != null;
    }

    public Object get(Object o) {
        Object[] getParameters = new Object[]{};
        try {
            Object object = this.m_getter.invoke(o, getParameters);
            return object;
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(this.m_getter);
            System.err.println(o);
            if (o != null) {
                System.err.println(o.getClass());
            }
            e.printStackTrace();
        }
        return null;
    }

    public double getDouble(Object o) {
        return ((Number)this.get(o)).doubleValue();
    }

    public int getInt(Object o) {
        return ((Number)this.get(o)).intValue();
    }

    public boolean getBoolean(Object o) {
        return (Boolean)this.get(o);
    }

    public void set(Object o, Object value) {
        try {
            Object[] setParameters = new Object[]{value};
            this.m_setter.invoke(o, setParameters);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NullPointerException npe) {
            System.err.println(npe);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println(this.m_setter);
            if (o != null) {
                System.err.println(o);
                System.err.println(o.getClass());
            } else {
                System.err.println("null");
            }
            if (value != null) {
                System.err.println(value);
                System.err.println(value.getClass());
            } else {
                System.err.println("null");
            }
            e.printStackTrace();
        }
    }

    public void set(Object o, Object value, HowMuch howMuch) {
        try {
            if (this.m_setterHowMuch != null) {
                Object[] setParameters = new Object[]{value, howMuch};
                this.m_setterHowMuch.invoke(o, setParameters);
            } else {
                System.err.println("ignoring howMuch");
                this.set(o, value);
            }
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (NullPointerException npe) {
            System.err.println(npe);
        }
    }

    public Class getElementClass() {
        return this.m_elementClass;
    }

    public Class getValueClass() {
        return this.m_valueClass;
    }

    public boolean getIsPersistent() {
        return this.m_isPersistent;
    }

    public String getMixedCaseName() {
        return this.m_mixedCaseName;
    }

    public String getCapsAndUnderscoresName() {
        return this.m_capsAndUnderscoresName;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.m_elementClass.getName()))).append(".").append(this.m_capsAndUnderscoresName).append("_PROPERTY")));
    }

    public static Property valueOf(String propertyName) {
        int i = propertyName.lastIndexOf(46);
        String classPart = propertyName.substring(0, i);
        String fieldPart = propertyName.substring(i + 1);
        try {
            Object o;
            Class<?> cls = Class.forName(classPart);
            Field field = cls.getField(fieldPart);
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) && (o = field.get(null)) instanceof Property) {
                Property property = (Property)o;
                return property;
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (NoSuchFieldException nsfe) {
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("backward compatibility? skipping: ").append(propertyName).append(" ").append(nsfe))));
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return null;
    }

    public static Vector getProperties(Class cls, boolean persistentOnly, boolean declaredOnly) {
        Vector<Property> v = new Vector<Property>();
        Field[] fields = declaredOnly ? cls.getDeclaredFields() : cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                if (!(class$edu$cmu$cs$stage3$util$Property == null ? Property.class$("edu.cmu.cs.stage3.util.Property") : class$edu$cmu$cs$stage3$util$Property).isAssignableFrom(fields[i].getType())) continue;
                Property property = (Property)fields[i].get(null);
                if (persistentOnly && !property.getIsPersistent()) continue;
                v.addElement(property);
                continue;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
        }
        return v;
    }

    public static Vector getProperties(Class cls) {
        return Property.getProperties(cls, false, false);
    }

    public static Vector getPropertyValuePairs(Object o, boolean persistentOnly, boolean declaredOnly) {
        Vector<PropertyValuePair> v = new Vector<PropertyValuePair>();
        Enumeration enumeration = Property.getProperties(o.getClass(), persistentOnly, declaredOnly).elements();
        while (enumeration.hasMoreElements()) {
            Property property = (Property)enumeration.nextElement();
            v.addElement(new PropertyValuePair(property, property.get(o)));
        }
        return v;
    }

    public static Vector getPropertyValuePairs(Object o) {
        return Property.getPropertyValuePairs(o, false, false);
    }

    public static StringBuffer convertAllCapsAndUnderscoresToMixedCase(String allCapsAndUnderscores) {
        StringBuffer mixedCase = new StringBuffer();
        mixedCase.append(allCapsAndUnderscores.charAt(0));
        boolean lowerCase = true;
        for (int lcv = 1; lcv < allCapsAndUnderscores.length(); ++lcv) {
            char c = allCapsAndUnderscores.charAt(lcv);
            if (c == '_') {
                lowerCase = false;
                continue;
            }
            if (lowerCase) {
                mixedCase.append(Character.toLowerCase(c));
            } else {
                mixedCase.append(c);
            }
            lowerCase = true;
        }
        return mixedCase;
    }

    public static StringBuffer convertMixedCaseToAllCapsAndUnderscores(String mixedCase) {
        StringBuffer allCapsAndUnderscores = new StringBuffer();
        allCapsAndUnderscores.append(mixedCase.charAt(0));
        for (int lcv = 1; lcv < mixedCase.length(); ++lcv) {
            char c = mixedCase.charAt(lcv);
            if (Character.isUpperCase(c)) {
                allCapsAndUnderscores.append("_".concat(String.valueOf(String.valueOf(c))));
                continue;
            }
            allCapsAndUnderscores.append(Character.toUpperCase(c));
        }
        return allCapsAndUnderscores;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

