; PureBasic Visual Designer v3.90 build 1361
IncludeFile "Common.pb"
;Get Old File
Procedure GetOldFile()
OldFile$=OpenFileRequester("Choose old version executable file ", "", "Executable files(*.exe)|*.exe", 0)
If OldFile$="" :  ProcedureReturn : EndIf
SetGadgetText(#StringOldFile,OldFile$) 
EndProcedure
;Get New File
Procedure GetNewFile()
NewFile$=OpenFileRequester("Choose new version executable file ", "", "Executable files(*.exe)|*.exe", 0)
If NewFile$="" :  ProcedureReturn : EndIf
SetGadgetText(#StringNewFile,NewFile$) 
EndProcedure
;generate
Procedure Generate()
WinTitle$=GetGadgetText(#StringWindowTitle) 
If WinTitle$="" :  MessageRequester("Error!", "Window title is empty") :  error=1 : EndIf
ProgTitle$=GetGadgetText(#StringProgramTitle) 
If ProgTitle$="" :  MessageRequester("Error!", "Program title is empty") :  error=1: EndIf
ProgDesc$=GetGadgetText(#StringProgramDesc) 
If ProgDesc$="" :  MessageRequester("Error!", "Program description is empty") :  error=1: EndIf
SystemNotice$=GetGadgetText(#StringSystem) 
If SystemNotice$="" :  MessageRequester("Error!", "System notice is empty") :  error=1: EndIf
FolderTip$=GetGadgetText(#StringFolderTip) 
If FolderTip$="" :  MessageRequester("Error!", "FolderTip is empty") :  error=1: EndIf
DefFolder$=GetGadgetText(#StringDefaultFolder) 
If DefFolder$="" :  MessageRequester("Error!", "Default folder is empty") :  error=1: EndIf
ButtonOpen$=GetGadgetText(#StringOpenButton) 
If ButtonOpen$="" :  MessageRequester("Error!", "Button open is empty") :  error=1: EndIf
ButtonInstall$=GetGadgetText(#StringInstallButton) 
If ButtonInstall$="" :  MessageRequester("Error!", "Button install is empty") :  error=1: EndIf
ButtonExit$=GetGadgetText(#StringExitButton) 
If ButtonExit$="" :  MessageRequester("Error!", "Button exit is empty") :  error=1: EndIf
If error=1
answer=MessageRequester("Error!", "Found error. Continue anyway?",#PB_MessageRequester_YesNo) 
If answer=7 :  ProcedureReturn : EndIf
EndIf 
OldFileName$=GetGadgetText(#StringOldFile) 
If OldFileName$="" :  MessageRequester("Fatal error!", "Old version file not found") :  ProcedureReturn : EndIf
If  FileSize(OldFileName$)<1 : MessageRequester("Fatal error!", "Old version file not found") : ProcedureReturn : EndIf

NewFileName$=GetGadgetText(#StringNewFile) 
If NewFileName$="" :  MessageRequester("Fatal error!", "New version file not found") :  ProcedureReturn : EndIf
If  FileSize(NewFileName$)<1 : MessageRequester("Fatal error!", "New version file not found") : ProcedureReturn : EndIf

OutFileName$ = SaveFileRequester("Select patch executable file ", "patch.exe", "Executable files(*.exe)|*.exe", 1)
If OutFileName$="" :ProcedureReturn:EndIf
If Right(LCase( OutFileName$),4)<>".exe" :OutFileName$=OutFileName$+".exe":EndIf

ReadFile(#oldexefile,OldFileName$)
MD5OldFileName$ = MD5FileFingerprint(OldFileName$)
OldFileSize=FileSize(OldFileName$)

ReadFile(#newexefile,NewFileName$)
MD5NewFileName$ = MD5FileFingerprint(NewFileName$)
NewFileSize=FileSize(NewFileName$)

ReadFile(#patcherfilein,"patch.dat")
CreateFile(#patcherfileout,OutFileName$)

If FileSize("patch.dat")<>25088 : MessageRequester("Fatal error!", "'patch.dat' corrupted, can't continue.") : ProcedureReturn : EndIf

For i=1 To 25088
UseFile(#patcherfilein)
b=ReadByte()
UseFile(#patcherfileout)
WriteByte(b)
Next

UseFile(#patcherfileout)
WriteStringN(WinTitle$)
WriteStringN(ProgTitle$)
WriteStringN(ProgDesc$)
WriteStringN(SystemNotice$)
WriteStringN(FolderTip$)
WriteStringN(DefFolder$)
WriteStringN(ButtonOpen$)
WriteStringN(ButtonInstall$)
WriteStringN(ButtonExit$)
WriteStringN(MD5OldFileName$)
WriteStringN(MD5NewFileName$)
WriteStringN(Str(OldFileSize))
WriteStringN(Str(NewFileSize))
WriteStringN(GetFilePart(OldFileName$))

kuskov=NewFileSize/25600
ostatok=NewFileSize-(25600*kuskov)

For k=1 To kuskov
  For i=(k-1)*25600+1 To (k)*25600
  UseFile(#oldexefile)
  ofb=ReadByte()
  UseFile(#newexefile)
  nfb=ReadByte()
  If ofb=nfb
  UseFile(#patcherfileout)
  WriteByte(0)
  EndIf
  If ofb<>nfb
  UseFile(#patcherfileout)
  WriteByte(1)
  WriteByte(nfb)
  EndIf
  Next
SetGadgetState(#ProgressBar,k*100/kuskov)
Next

If ostatok>0
  For i=(kuskov)*25600+1 To (kuskov)*25600+ostatok
  UseFile(#oldexefile)
  ofb=ReadByte()
  UseFile(#newexefile)
  nfb=ReadByte()
  If ofb=nfb
  UseFile(#patcherfileout)
  WriteByte(0)
  EndIf
  If ofb<>nfb
  UseFile(#patcherfileout)
  WriteByte(1)
  WriteByte(nfb)
  EndIf
  Next
EndIf 


CloseFile(#patcherfileout)
CloseFile(#oldexefile)
CloseFile(#newexefile)
CloseFile(#patcherfilein)
MessageRequester("Done!", "Process done")

EndProcedure 









Open_Window_0()
Repeat
EventID = WaitWindowEvent()
If EventID =#PB_Event_Gadget
Select EventGadgetID()
  Case #ButtonExit  : EventID = #PB_Event_CloseWindow
  Case #ButtonGenerate  : Generate()
  Case #ButtonOldFile: GetOldFile()
  Case #ButtonNewFile: GetNewFile()


EndSelect
EndIf
Until EventID = #PB_Event_CloseWindow
End 



; ExecutableFormat=
; Executable=C:\pfiles\PureBasic\MyProj\2\Release\MMPatchCreator.exe
; DisableDebugger
; EOF