
Graphics3D 1024,768

Collisions 1,2,2,2

player=CreatePivot()
PositionEntity player,0,1,-1
EntityRadius player,.6
EntityType player,1

camera=CreateCamera( player )
CameraRange camera,.1,200

light=CreateLight()
LightColor light,32,32,32
TurnEntity light,45,45,0

light=CreateLight()
LightColor light,32,32,32
TurnEntity light,45,-45,0

mesh=LoadMesh( "test.b3d" )
;ScaleEntity mesh,1,2,1
EntityFX mesh,1
EntityType mesh,2

sp#=.05
ey#=EntityY(player)

sky=LoadSkyBox( "sky" )
EntityParent sky,camera

While Not KeyHit(1)

	If KeyHit(17)
		wire=1-wire
		WireFrame wire
	EndIf

	yv#=EntityY(player)-ey
	ey=EntityY(player)
	
	If KeyHit(57) yv=.1

	MoveEntity player,0,yv-.005,0
	
	If KeyDown(30) TurnEntity camera,-2,0,0
	If KeyDown(44) TurnEntity camera,+2,0,0
	
	If KeyDown(203) TurnEntity player,0,2,0
	If KeyDown(205) TurnEntity player,0,-2,0
	
	If KeyDown(200) MoveEntity player,0,0,sp
	If KeyDown(208) MoveEntity player,0,0,-sp
	
	RotateEntity sky,0,0,0,True
	
	UpdateWorld
	RenderWorld
	Text 0,0,TrisRendered()
	Flip
Wend

End

;skybox code stolen from castle demo!
Function LoadSkyBox( file$ )
	m=CreateMesh()
	;front face
	b=LoadBrush( file$+"_FR.jpg",49 )
	s=CreateSurface( m,b )
	AddVertex s,-1,+1,-1,0,0:AddVertex s,+1,+1,-1,1,0
	AddVertex s,+1,-1,-1,1,1:AddVertex s,-1,-1,-1,0,1
	AddTriangle s,0,1,2:AddTriangle s,0,2,3
	FreeBrush b
	;right face
	b=LoadBrush( file$+"_LF.jpg",49 )
	s=CreateSurface( m,b )
	AddVertex s,+1,+1,-1,0,0:AddVertex s,+1,+1,+1,1,0
	AddVertex s,+1,-1,+1,1,1:AddVertex s,+1,-1,-1,0,1
	AddTriangle s,0,1,2:AddTriangle s,0,2,3
	FreeBrush b
	;back face
	b=LoadBrush( file$+"_BK.jpg",49 )
	s=CreateSurface( m,b )
	AddVertex s,+1,+1,+1,0,0:AddVertex s,-1,+1,+1,1,0
	AddVertex s,-1,-1,+1,1,1:AddVertex s,+1,-1,+1,0,1
	AddTriangle s,0,1,2:AddTriangle s,0,2,3
	FreeBrush b
	;left face
	b=LoadBrush( file$+"_RT.jpg",49 )
	s=CreateSurface( m,b )
	AddVertex s,-1,+1,+1,0,0:AddVertex s,-1,+1,-1,1,0
	AddVertex s,-1,-1,-1,1,1:AddVertex s,-1,-1,+1,0,1
	AddTriangle s,0,1,2:AddTriangle s,0,2,3
	FreeBrush b
	;top face
	b=LoadBrush( file$+"_UP.jpg",49 )
	s=CreateSurface( m,b )
	AddVertex s,-1,+1,+1,0,1:AddVertex s,+1,+1,+1,0,0
	AddVertex s,+1,+1,-1,1,0:AddVertex s,-1,+1,-1,1,1
	AddTriangle s,0,1,2:AddTriangle s,0,2,3
	FreeBrush b
	;bottom face	
	b=LoadBrush( file$+"_DN.jpg",49 )
	s=CreateSurface( m,b )
	AddVertex s,-1,-1,-1,1,0:AddVertex s,+1,-1,-1,1,1
	AddVertex s,+1,-1,+1,0,1:AddVertex s,-1,-1,+1,0,0
	AddTriangle s,0,1,2:AddTriangle s,0,2,3
	
	FreeBrush b
	ScaleMesh m,100,100,100
	FlipMesh m
	EntityFX m,1
	EntityOrder m,1
	Return m
End Function