// Name        : Text size /  .
// Version     : 01 nov 2013
// Author      : LODka3D
// Discription :   .
// 

{$INCLUDE 'vectorgeometry.dws'}
{$INCLUDE 'LODkaFont1.dws'}

procedure LODPCreateControls;
begin
  if LOD('GetLanguage') = '25' then begin 
    LOD('AddPControl', 'Number1',        'Float', '707.5', '',     
      ' .',             '0.000001', '100000000');
    LOD('AddPControl', 'NmbCnt1',        'Int',   '4', ' ', 
      '  .',        '-1', '1000');
    LOD('AddPControl', 'TxtScale',       'Float', '0.5', ' ',     
      ' .',                   '0.', '100000000');
    LOD('AddPControl', 'ArrIndent',      'Float', '0.01', '',       
      '    .', '0.', '100000000');
    LOD('AddPControl', 'VertLineW',      'Float', '0.01', '.',     
      '  .',         '0.', '100000000');
    LOD('AddPControl', 'ArrLineWidth',   'Float', '0.01', '',     
      '  .',          '0.', '100000000');
    LOD('AddPControl', 'ArrHeadWidth',   'Float', '0.01', '',     
      '  .',        '0.', '100000000');
    LOD('AddPControl', 'ArrHeadLength',  'Float', '0.05', '',     
      '  .',          '0.', '100000000');
    LOD('AddPControl', 'OrigSize1', 'Bool',  '1', '. ', 
      '  .      ""');
    LOD('AddPControl', 'UpNumber1', 'Bool',  '1', ' ',  
      '   .');
    LOD('AddPControl', 'HorPos1',   'Combo', '1', '. .',  
      '   .',  ''#13#10''#13#10'');
    LOD('AddPControl', 'ArrInside', 'Bool', '', '. ',  
      '  .');
    LOD('AddPControl', 'DownSide1', 'Bool', '1', ' ', 
      '     .');
    LOD('AddPControl', 'LSizeLine', 'Bool', '1', ' ',  
      '    .');
    LOD('AddPControl', 'RSizeLine', 'Bool', '1', '. .',  
      '    .');
  end else begin
    LOD('AddPControl', 'Number1',       'Float', '707.5', 'Number',     
      'Output value.',                  '0.000001', '100000000');
    LOD('AddPControl', 'NmbCnt1',       'Int',   '4', 'Numbers count', 
      'Count of numbers. -1 means ignore.', '-1', '1000');
    LOD('AddPControl', 'TxtScale',      'Float', '0.5', 'TextScale',     
      'Scale of text.',                 '0.', '100000000');
    LOD('AddPControl', 'ArrIndent',     'Float', '0.01', 'ArrowIndent',       
      'Arrow indent from numbers.',     '0.', '100000000');
    LOD('AddPControl', 'VertLineW',     'Float', '0.01', 'VertLineWidth',     
      'Vertical line width.',           '0.', '100000000');
    LOD('AddPControl', 'ArrLineWidth',  'Float', '0.01', 'ArrLineWidth',     
      'Arrow line width.',              '0.', '100000000');
    LOD('AddPControl', 'ArrHeadWidth',  'Float', '0.01', 'ArrHeadWidth',     
      'Arrow head width.',              '0.', '100000000');
    LOD('AddPControl', 'ArrHeadLength', 'Float', '0.05', 'ArrHeadLength',     
      'Arrow head length.',             '0.', '100000000');
    LOD('AddPControl', 'OrigSize1', 'Bool', '1', 'OrigSize', 
      'Get original size from 3D editor or show "Number".');
    LOD('AddPControl', 'UpNumber1', 'Bool', '1', 'UpLine', 
      'Text is under line.');
    LOD('AddPControl', 'HorPos1',   'Combo', '1', 'Horiz. pos.',  
      'Horizontal numbers align.',  'left'#13#10'center'#13#10'right');
    LOD('AddPControl', 'ArrInside', 'Bool', '', 'ArrInide',  
      'Show arrows inside.');
    LOD('AddPControl', 'DownSide1', 'Bool', '1', 'MeasureDown', 
      'Measure down or up.');
    LOD('AddPControl', 'LSizeLine', 'Bool', '1', 'LeftSizeLine',   
      'Show left size line');
    LOD('AddPControl', 'RSizeLine', 'Bool', '1', 'RightSizeLine',  
      'Show right size line');
  end;
end;


  //       .
procedure LODPCreatePrimitive;
var
  s1 : string;
  DownSide1, UpNumber1, OrigSize1, LSL, RSL, ArrInside : Boolean;
  i1, ChPt1, ChPt2, p1, t1, HorPos1, pCnt1, NmbCnt     : Integer;
  ArrHdL, ArrHdW, ArrLnW, ArrInd, ArrOts2, VLnW1, 
  f1, f2, TxtSc1, VL1, VR1, fNmb1   : Float;
  vSc1, vPs1, vPs2, PSc, vSc3, vSc5 : TVector;    
begin
    //    .     .
  LOD('SetPMessage', '');
  LOD('SetPCubeIgnore', '0', '1', '0');
    //     .
  HorPos1 := StrToInt(LOD('GetPControl', 'HorPos1'));  
    //      .
  PSc := StrToVector(LOD('GetPPreviewScale'));
  if (PSc[0] = 0) or (PSc[1] = 0) then exit; //    .
  DownSide1 := LOD('GetPControl', 'DownSide1') = '1';
  UpNumber1 := LOD('GetPControl', 'UpNumber1') = '1';
  OrigSize1 := LOD('GetPControl', 'OrigSize1') = '1';
  LSL       := LOD('GetPControl', 'LSizeLine') = '1';  
  RSL       := LOD('GetPControl', 'RSizeLine') = '1';
  ArrInside := LOD('GetPControl', 'ArrInside') = '1';  
  if UpNumber1 then fNmb1 := 1 else fNmb1 := 0;
  
    //  .
  ArrHdW  := StrToFloat(LOD('GetPControl', 'ArrHeadWidth')); 
  ArrLnW  := StrToFloat(LOD('GetPControl', 'ArrLineWidth')); 
  ArrHdL  := StrToFloat(LOD('GetPControl', 'ArrHeadLength'));
  ArrInd  := StrToFloat(LOD('GetPControl', 'ArrIndent'));
  VLnW1   := StrToFloat(LOD('GetPControl', 'VertLineW'));      
  TxtSc1  := StrToFloat(LOD('GetPControl', 'TxtScale'));
  NmbCnt  := StrToInt(  LOD('GetPControl', 'NmbCnt1'));
  
    //      .
  ChPt1 := StrToInt(LOD('GetPPointsCount'));
  if OrigSize1 then begin
    s1 := Flt2Str(PSc[0], NmbCnt)
    // s1 := FloatToStr(PSc[0])
    // s1 := Format('%3.4f', [PSc[0]]); 
  end  
               else s1 := LOD('GetPControl', 'Number1'); //  .
  LODPAddTextFont1( s1, NmbCnt );
  ChPt2 := StrToInt(LOD('GetPPointsCount'));

    //      .
  vSc1 := StrToVector(LOD('GetPPointsScale'));
  vPs1 := StrToVector(LOD('GetPPointsPos'));
  vPs2 := VectorNegate(vPs1);
  vPs2[1] := -0.5; //    .

    //   ,    .      
  LOD('PPtsAddVector', VectorToStr(vPs2), IntToStr(ChPt1), IntToStr(ChPt2));
  if UpNumber1 then begin //    .
    LOD('PPtsAddVector',   XYZWToStr(0, -vPs2[1] +(ArrHdW +ArrLnW)/TxtSc1, 0), 
      IntToStr(ChPt1), IntToStr(ChPt2));
  end;
  
    //  .
  LOD('PPtsScaleVector', XYZWToStr(0.5*TxtSc1, TxtSc1, 1)
    , IntToStr(ChPt1), IntToStr(ChPt2));
  vSc5 := StrToVector(LOD('GetPPointsScale'));
  // vPs5 := StrToVector(LOD('GetPPointsPos'));
  if HorPos1 = 0 then begin //   .
    LOD('PPtsAddVector', XYZWToStr( -(+vSc5[0] +PSc[0]/2 +ArrInd +ArrHdL*2)
       , 0, 0), IntToStr(ChPt1), IntToStr(ChPt2));
  end else if HorPos1 = 2 then begin
    LOD('PPtsAddVector', XYZWToStr( +(+vSc5[0] +PSc[0]/2 +ArrInd +ArrHdL*2)
      , 0, 0), IntToStr(ChPt1), IntToStr(ChPt2));
  end; 



      //  .
    //     .
  p1 := StrToInt(LOD('GetPPointsCount'));
  t1 := StrToInt(LOD('GetPTxCoordCount')); 
    //  .
    //   .     
  vSc3 := StrToVector(LOD('GetPPointsScale'));
  ArrOts2 := ArrInd;
  if Abs(vSc3[0]) >= 100000000 then begin //   .
    vSc3 := StrToVector(XYZWToStr(0, 0, 0, 0));
    ArrOts2 := 0;
  end;
  if UpNumber1 or (HorPos1 = 0) or (HorPos1 = 2) then begin
    vSc3 := StrToVector(XYZWToStr(0, 0, 0, 0));
    ArrOts2 := 0;
  end;
     
  for i1 := 0 to 1 do begin
    if i1 = 0 then begin
      f1 := 1;
      if LSL then VL1 := VLnW1 else VL1 := 0;  
    end else begin 
      f1 := -1;
      if RSL then VL1 := VLnW1 else VL1 := 0;  
    end;
    if    ((i1 = 0) and (HorPos1 = 0))
       or ((i1 = 1) and (HorPos1 = 2)) 
    then f2 := 1
    else f2 := 0;
  
    if ArrInside then begin //  .
        //   .
      LODPAddPoint(-f1*(0.5*PSc[0]),            0, 0);
        //  .
      LODPAddPoint(-f1*(0.5*PSc[0] +ArrHdL), -(ArrHdW +ArrLnW)*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] +ArrHdL),          -ArrLnW *0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] +ArrHdL),          +ArrLnW *0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] +ArrHdL), +(ArrHdW +ArrLnW)*0.5, 0);
        //   .
      LODPAddPoint(-f1*(0.5*PSc[0] +ArrHdL*2 +fNmb1*f2*vSc5[0]*2 +ArrInd*2*f2*fNmb1),         -ArrLnW*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] +ArrHdL*2 +fNmb1*f2*vSc5[0]*2 +ArrInd*2*f2*fNmb1),         +ArrLnW*0.5, 0);
    end else begin //  .
        //   .
      LODPAddPoint(-f1*(0.5*PSc[0] -VL1),            0, 0);
        //  .
      LODPAddPoint(-f1*(0.5*PSc[0] -ArrHdL -VL1), +(ArrHdW +ArrLnW)*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] -ArrHdL -VL1),          +ArrLnW *0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] -ArrHdL -VL1),          -ArrLnW *0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] -ArrHdL -VL1), -(ArrHdW +ArrLnW)*0.5, 0);
        //   .
      LODPAddPoint(-f1*(vSc3[0] +ArrOts2),                 +ArrLnW*0.5, 0);
      LODPAddPoint(-f1*(vSc3[0] +ArrOts2),                 -ArrLnW*0.5, 0);
    end;  
      //   .
    if DownSide1 then begin //    .
      LODPAddPoint(-f1*(0.5*PSc[0]),      +(ArrHdW +ArrLnW)*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0]),              -PSc[1]*0.5, 0);      
      LODPAddPoint(-f1*(0.5*PSc[0] -VL1), +(ArrHdW +ArrLnW)*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] -VL1),         -PSc[1]*0.5, 0);
    end else begin //    .
      LODPAddPoint(-f1*(0.5*PSc[0]),              +PSc[1]*0.5, 0);      
      LODPAddPoint(-f1*(0.5*PSc[0]),      -(ArrHdW +ArrLnW)*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] -VL1),         +PSc[1]*0.5, 0);
      LODPAddPoint(-f1*(0.5*PSc[0] -VL1), -(ArrHdW +ArrLnW)*0.5, 0);
    end;
  end;

    //      .
  pCnt1 := 0;
  if ArrInside then begin //  .
    if LSL then VL1 := VLnW1 else VL1 := 0;  
    if RSL then VR1 := VLnW1 else VR1 := 0;  
    if (HorPos1 = 0) or (HorPos1 = 2) or UpNumber1 then begin 
      //    .
      LODPAddPoint(- 0.5*PSc[0] +VL1, +ArrLnW*0.5, 0);
      LODPAddPoint(- 0.5*PSc[0] +VL1, -ArrLnW*0.5, 0);      
      LODPAddPoint(  0.5*PSc[0] -VR1, +ArrLnW*0.5, 0);
      LODPAddPoint(  0.5*PSc[0] -VR1, -ArrLnW*0.5, 0);      
      pCnt1 := pCnt1 +4;
    end else begin
      //     .
      LODPAddPoint(- 0.5*PSc[0] +VL1, +ArrLnW*0.5, 0);
      LODPAddPoint(- 0.5*PSc[0] +VL1, -ArrLnW*0.5, 0);      
      LODPAddPoint(-vSc3[0] -ArrOts2, +ArrLnW*0.5, 0);
      LODPAddPoint(-vSc3[0] -ArrOts2, -ArrLnW*0.5, 0);      
      
      LODPAddPoint(  0.5*PSc[0] -VR1, -ArrLnW*0.5, 0);      
      LODPAddPoint(  0.5*PSc[0] -VR1, +ArrLnW*0.5, 0);
      LODPAddPoint( vSc3[0] +ArrOts2, -ArrLnW*0.5, 0);      
      LODPAddPoint( vSc3[0] +ArrOts2, +ArrLnW*0.5, 0);
      pCnt1 := pCnt1 +8;
    end;
  end else begin
    //      .
    if HorPos1 = 0 then begin //   .
      // LOD('AddPMessage', 'vSc5: ' +FloatToStr(vSc5[0])   +#13#10);
      // LOD('AddPMessage', 'ArrInd: ' +FloatToStr(ArrInd)   +#13#10);
      LODPAddPoint(- 0.5*PSc[0],                      -ArrLnW*0.5, 0);      
      LODPAddPoint(- 0.5*PSc[0],                      +ArrLnW*0.5, 0);
      LODPAddPoint(-(0.5*PSc[0] +fNmb1*vSc5[0]*2 +ArrInd*2*fNmb1 +ArrHdL*2), -ArrLnW*0.5, 0);      
      LODPAddPoint(-(0.5*PSc[0] +fNmb1*vSc5[0]*2 +ArrInd*2*fNmb1 +ArrHdL*2), +ArrLnW*0.5, 0);
      pCnt1 := pCnt1 +4;
    end else if HorPos1 = 2 then begin //   .
      LODPAddPoint( 0.5*PSc[0],                      +ArrLnW*0.5, 0);
      LODPAddPoint( 0.5*PSc[0],                      -ArrLnW*0.5, 0);      
      LODPAddPoint((0.5*PSc[0] +fNmb1*vSc5[0]*2 +ArrInd*2*fNmb1 +ArrHdL*2), +ArrLnW*0.5, 0);      
      LODPAddPoint((0.5*PSc[0] +fNmb1*vSc5[0]*2 +ArrInd*2*fNmb1 +ArrHdL*2), -ArrLnW*0.5, 0);
      pCnt1 := pCnt1 +4;
    end;
  end;  
    
    //   .
  LODPAddTxCoord(0, 0);

    //  .
    //   .
    //  .
  if (ArrLnW +ArrHdW > 0) then begin
    LODPAddFaceInd(p1+0, p1+2, p1+1,   1,   t1+0, t1+0, t1+0);
    if ArrLnW > 0 then LODPAddFaceInd(p1+0, p1+3, p1+2,   1,   t1+0, t1+0, t1+0);
    LODPAddFaceInd(p1+0, p1+4, p1+3,   1,   t1+0, t1+0, t1+0);
  end;
    //  .
  if (ArrHdW > 0) or (ArrHdL > 0) then begin 
    LODPAddFaceInd(p1+2, p1+3, p1+5,   1,   t1+0, t1+0, t1+0);
    LODPAddFaceInd(p1+3, p1+6, p1+5,   1,   t1+0, t1+0, t1+0);
  end;
    //   .
  LODPAddFaceInd(p1+7, p1+8,  p1+9,   1,   t1+0, t1+0, t1+0);
  LODPAddFaceInd(p1+8, p1+10, p1+9,   1,   t1+0, t1+0, t1+0);

    //   .
  p1 := p1 +7 +4;   
    //  .
  if (ArrLnW +ArrHdW > 0) then begin
    LODPAddFaceInd(p1+0, p1+1, p1+2,   1,   t1+0, t1+0, t1+0);
    if ArrLnW > 0 then LODPAddFaceInd(p1+0, p1+2, p1+3,   1,   t1+0, t1+0, t1+0);
    LODPAddFaceInd(p1+0, p1+3, p1+4,   1,   t1+0, t1+0, t1+0);
  end;
    //  .
  if ArrHdW > 0 then begin 
    LODPAddFaceInd(p1+2, p1+5, p1+3,   1,   t1+0, t1+0, t1+0);
    LODPAddFaceInd(p1+3, p1+5, p1+6,   1,   t1+0, t1+0, t1+0);
  end;  
    //   .
  LODPAddFaceInd(p1+7, p1+9,  p1+8,   1,   t1+0, t1+0, t1+0);
  LODPAddFaceInd(p1+8, p1+9, p1+10,   1,   t1+0, t1+0, t1+0);
  
    //   .
  p1 := p1 +7 +4;   
  if pCnt1 > 0 then begin
    LODPAddFaceInd(p1+0, p1+1,  p1+2,   1,   t1+0, t1+0, t1+0);
    LODPAddFaceInd(p1+2, p1+1,  p1+3,   1,   t1+0, t1+0, t1+0);
    if pCnt1 > 4 then begin
      p1 := p1 +4;   
      LODPAddFaceInd(p1+0, p1+1,  p1+2,   1,   t1+0, t1+0, t1+0);
      LODPAddFaceInd(p1+2, p1+1,  p1+3,   1,   t1+0, t1+0, t1+0);
    end;
  end;  
  p1 := p1 +4;   
end;
