// Name        : Lesson 05 - 3 axis /  05  .
// Version     : 19 dec 2012
// Author      : LODka3D
// Discription :  05          
//                   .
//

{$INCLUDE 'func-demo1.dws'}
{$INCLUDE 'vectorgeometry.dws'}

procedure LODPCreatePrimitive;
var
  p1, p2,  t1, t2,  i1 : Integer;
  vSc1 : TVector;
begin
      // ==      (   ). == 
    //       .
  p1  := StrToInt(LOD('GetPPointsCount'));
    //  .
  AddArrow;
    //       .
    //  p1  p2         
    //  ,    ,    .
  p2  := StrToInt(LOD('GetPPointsCount')) -1;

    //  ,    .  -  
    //       (0.5;0.5;0.5).
    //         [p1..p2].
  LOD('PPtsScaleVector', '(0.5;0.5;0.5)',     IntToStr(p1), IntToStr(p2));
    //     (0;0;1;0; 0;-1;0;0), 
    //        , 
    //       ,    .
  LOD('PPtsTransform', '(0;0;1;0; 0;-1;0;0)', IntToStr(p1), IntToStr(p2));
    //     .     
    //  [p1..p2]   (0.25;0;0).
  LOD('PPtsAddVector', '(0.25;0;0)',          IntToStr(p1), IntToStr(p2));


      // ==     Y (   ). == 
    //  ,      .
  p1  := StrToInt(LOD('GetPPointsCount'));
  AddArrow;
  p2  := StrToInt(LOD('GetPPointsCount')) -1;

  LOD('PPtsScaleVector', '(0.5;0.5;0.5)',     IntToStr(p1), IntToStr(p2));
  LOD('PPtsTransform', '(1;0;0;0; 0;0;-1;0)', IntToStr(p1), IntToStr(p2));
  LOD('PPtsAddVector', '(0;0.25;0)',          IntToStr(p1), IntToStr(p2));


      // ==      Z (   ). == 
  p1  := StrToInt(LOD('GetPPointsCount'));
  t1  := StrToInt(LOD('GetPFaceCount'));
  AddArrow;
  p2  := StrToInt(LOD('GetPPointsCount')) -1;
  t2  := StrToInt(LOD('GetPFaceCount')) -1;
  LOD('PPtsScaleVector', '(0.5;0.5;0.5)',     IntToStr(p1), IntToStr(p2));
  LOD('PPtsAddVector', '(0;0;0.25)',          IntToStr(p1), IntToStr(p2));


    //      Invert .
  if LOD('GetPControl', 'Invert') = '1' then begin
      //    .
    LOD('PFaceInvert');
      //       
      //   .
      //  ,       
      //   t1,t2,     p1, pt2 .
    // LOD('PFaceInvert'), IntToStr(t1), IntToStr(t2));
  end;


    //     .
  if LOD('GetPControl', 'Scale') = '1' then begin
      //      .
    vSc1 := StrToVector(LOD('GetPPreviewScale'));
      //      .
    for i1 := 0 to 2 do
      if vSc1[i1] <> 0 then vSc1[i1] := 1/vSc1[i1];
      //      .
    LOD('PPtsScaleVector', VectorToStr(vSc1));
  end;
end;


procedure LODPCreateControls;
begin
  if LOD('GetLanguage') = '25' then begin
    LOD('AddPControl', 'Invert', 'Bool', '0', '', 
                                                '  .');
    LOD('AddPControl', 'Scale',  'Bool', '0', ' ', 
                                                ' .');
  end else begin
    LOD('AddPControl', 'Invert', 'Bool', '0', 'Invert',   'Invert normals');
    LOD('AddPControl', 'Scale',  'Bool', '0', 'No scale', 'Ignore scale.');
  end;
end;