/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class WeakArrayList<E>
extends ArrayList<WeakReference<E>> {
    private static final long serialVersionUID = 1L;
    private final ReferenceQueue<E> queue = new ReferenceQueue();

    @Override
    public int size() {
        this.expungeStaleEntries();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.expungeStaleEntries();
        return super.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.expungeStaleEntries();
        return super.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        this.expungeStaleEntries();
        return super.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.expungeStaleEntries();
        return super.lastIndexOf(o);
    }

    @Override
    public Iterator<WeakReference<E>> iterator() {
        this.expungeStaleEntries();
        return super.iterator();
    }

    @Override
    public ListIterator<WeakReference<E>> listIterator() {
        this.expungeStaleEntries();
        return super.listIterator();
    }

    @Override
    public void trimToSize() {
        this.expungeStaleEntries();
        super.trimToSize();
    }

    @Override
    public Object[] toArray() {
        this.expungeStaleEntries();
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.expungeStaleEntries();
        return super.toArray(a);
    }

    private void expungeStaleEntries() {
        Reference<E> r;
        while ((r = this.queue.poll()) != null) {
            this.remove(r);
        }
    }
}

