/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.util;

import java.util.HashMap;

public abstract class SetTraverser<E, P> {
    private HashMap<E, Node> previous;
    private final Node header = new Node(null, null);

    public final boolean add(E e) {
        if (this.previous != null && this.previous.containsKey(e)) {
            return false;
        }
        new ElementNode(this.header, e);
        return true;
    }

    public final boolean remove(E e) {
        if (this.previous == null) {
            return false;
        }
        Node p = this.previous.get(e);
        if (p == null) {
            return false;
        }
        p.removeNext();
        return true;
    }

    public final void traverse(P p) {
        ElementNode n = this.header.next;
        while (n != null) {
            this.visit(n.element, p);
            n = n.next;
        }
    }

    protected abstract void visit(E var1, P var2);

    private class ElementNode
    extends Node {
        public final E element;

        public ElementNode(Node p, E e) {
            this.next = p.next;
            p.next = this;
            if (SetTraverser.this.previous == null) {
                SetTraverser.this.previous = new HashMap();
            }
            if (this.next != null) {
                SetTraverser.this.previous.put(this.next.element, this);
            }
            SetTraverser.this.previous.put(e, p);
            this.element = e;
        }
    }

    private class Node {
        protected ElementNode next;

        private Node() {
        }

        public void removeNext() {
            SetTraverser.this.previous.remove(this.next.element);
            this.next = this.next.next;
            if (this.next == null) {
                return;
            }
            SetTraverser.this.previous.put(this.next.element, this);
        }

        /* synthetic */ Node(Node node, Node node2) {
            this();
        }
    }
}

