/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.util;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.lateralgm.main.UpdateSource;

public class PropertyMap<K extends Enum<K>>
extends EnumMap<K, Object> {
    private static final long serialVersionUID = 1L;
    private final UpdateSource.UpdateTrigger updateTrigger = new UpdateSource.UpdateTrigger();
    public final UpdateSource updateSource = new UpdateSource(this, this.updateTrigger);
    private EnumMap<K, TriggerSourcePair> updatePairs;
    private final Class<K> keyType;
    private final PropertyValidator<K> validator;

    public PropertyMap(Class<K> type, PropertyValidator<K> v, EnumMap<K, Object> defaults) {
        super(defaults == null ? new EnumMap(type) : defaults);
        this.keyType = type;
        this.validator = v;
    }

    public UpdateSource getUpdateSource(K key) {
        TriggerSourcePair p = null;
        if (this.updatePairs == null) {
            this.updatePairs = new EnumMap(this.keyType);
        } else {
            p = this.updatePairs.get(key);
        }
        if (p == null) {
            p = new TriggerSourcePair();
            this.updatePairs.put(key, p);
        }
        return p.source;
    }

    protected void fireUpdate(K k) {
        TriggerSourcePair p;
        PropertyUpdateEvent<K> e = new PropertyUpdateEvent<K>(this.updateSource, this, k);
        this.updateTrigger.fire(e);
        if (this.updatePairs != null && (p = this.updatePairs.get(k)) != null) {
            p.trigger.fire(e);
        }
    }

    @Override
    public <V> V get(K key) {
        return super.get(key);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(K key, Object value) {
        boolean ck = super.containsKey(key);
        if (ck && super.get(key) == value) {
            return value;
        }
        Object vv = this.validator == null ? value : this.validator.validate(key, value);
        Object o = super.put(key, vv);
        if (!ck || vv != value || o != value) {
            this.fireUpdate(key);
        }
        return o;
    }

    @Override
    public Set<Map.Entry<K, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public void putAll(Map<? extends K, ? extends Object> m) {
        for (Map.Entry<K, Object> e : m.entrySet()) {
            this.put((K)((Enum)e.getKey()), e.getValue());
        }
    }

    @Override
    public PropertyMap<K> clone() {
        return (PropertyMap)super.clone();
    }

    @Override
    public Object remove(Object key) {
        int s = this.size();
        Object o = super.remove(key);
        if (o != null || s != this.size()) {
            this.fireUpdate((Enum)key);
        }
        return o;
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    public static <K extends Enum<K>> EnumMap<K, Object> makeDefaultMap(Class<K> type, Object ... values) {
        Enum[] ec = (Enum[])type.getEnumConstants();
        if (ec.length != values.length) {
            throw new IllegalArgumentException();
        }
        EnumMap<Enum, Object> m = new EnumMap<Enum, Object>(type);
        Enum[] enumArray = ec;
        int n = ec.length;
        int n2 = 0;
        while (n2 < n) {
            Enum k = enumArray[n2];
            m.put(k, values[k.ordinal()]);
            ++n2;
        }
        return m;
    }

    public static class PropertyUpdateEvent<K extends Enum<K>>
    extends UpdateSource.UpdateEvent {
        public final PropertyMap<K> map;
        public final K key;

        public PropertyUpdateEvent(UpdateSource s, PropertyMap<K> m, K k) {
            super(s);
            this.map = m;
            this.key = k;
        }
    }

    public static abstract class PropertyUpdateListener<K extends Enum<K>>
    implements UpdateSource.UpdateListener {
        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            this.updated((PropertyUpdateEvent)e);
        }

        public abstract void updated(PropertyUpdateEvent<K> var1);
    }

    public static class PropertyValidationException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
    }

    public static interface PropertyValidator<K extends Enum<K>> {
        public Object validate(K var1, Object var2);
    }

    private class TriggerSourcePair {
        public final UpdateSource.UpdateTrigger trigger = new UpdateSource.UpdateTrigger();
        public final UpdateSource source;

        public TriggerSourcePair() {
            this.source = new UpdateSource(PropertyMap.this, this.trigger);
        }
    }
}

