/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.util;

import java.beans.ExceptionListener;
import org.lateralgm.util.PropertyMap;

public abstract class PropertyLink<K extends Enum<K>, V>
extends PropertyMap.PropertyUpdateListener<K> {
    protected PropertyMap<K> map;
    protected final K key;
    private ExceptionListener exceptionListener;

    public PropertyLink(PropertyMap<K> m, K k) {
        this.map = m;
        this.key = k;
        m.getUpdateSource(k).addListener(this);
    }

    public void remove() {
        this.map.getUpdateSource(this.key).removeListener(this);
    }

    public void setMap(PropertyMap<K> m) {
        this.map.getUpdateSource(this.key).removeListener(this);
        this.map = m;
        this.reset();
        this.map.getUpdateSource(this.key).addListener(this);
    }

    protected abstract void setComponent(V var1);

    protected void reset() {
        Object v = this.map.get(this.key);
        this.editComponent(v);
    }

    protected void editComponentIfChanged(V old) {
        Object v = this.map.get(this.key);
        if (v == null ? old == null : v.equals(old)) {
            return;
        }
        this.editComponent(v);
    }

    protected void editComponent(V v) {
        this.setComponent(v);
    }

    protected void editProperty(Object v) {
        try {
            this.map.put(this.key, v);
        }
        catch (RuntimeException re) {
            this.reset();
            if (this.exceptionListener != null) {
                this.exceptionListener.exceptionThrown(re);
            }
            throw re;
        }
    }

    public void setExceptionListener(ExceptionListener l) {
        this.exceptionListener = l;
    }

    @Override
    public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
        Object v = this.map.get(this.key);
        this.editComponent(v);
    }

    public static void removeAll(PropertyLink<?, ?> ... links) {
        PropertyLink<?, ?>[] propertyLinkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyLink<?, ?> l = propertyLinkArray[n2];
            if (l != null) {
                l.remove();
            }
            ++n2;
        }
    }
}

