/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.util;

import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class BinPlane {
    public final int binShift;
    private final ConcurrentHashMap<Integer, WeakReference<Bin>> bins;

    public BinPlane(int s, int w, int h) {
        this.binShift = 32 - Integer.numberOfLeadingZeros(s - 1);
        int c = (1 + (w - 1 >> this.binShift)) * (1 + (h - 1 >> this.binShift)) * 2;
        this.bins = new ConcurrentHashMap(c, 0.5f, 2);
    }

    public Bin[] getEdgeBins(Edge edge) {
        ArrayList<Bin> l = new ArrayList<Bin>();
        int s = 0;
        for (Map.Entry<Integer, WeakReference<Bin>> e : this.bins.entrySet()) {
            Bin b = (Bin)e.getValue().get();
            if (b == null || b.candidates.size() == 0) continue;
            if (s == 0) {
                s = 1;
                l.add(b);
                continue;
            }
            switch (edge.compareBin(b.index, ((Bin)l.get((int)(s - 1))).index)) {
                case 0: {
                    if (l.size() > s++) {
                        l.set(s - 1, b);
                        break;
                    }
                    l.add(b);
                    break;
                }
                case 1: {
                    s = 1;
                    if (l.size() > 0) {
                        l.set(0, b);
                        break;
                    }
                    l.add(b);
                    break;
                }
            }
        }
        return l.subList(0, s).toArray(new Bin[s]);
    }

    public Candidate getEdgeCandidate(Edge edge) {
        Candidate ec = null;
        Bin[] binArray = this.getEdgeBins(edge);
        int n = binArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bin b = binArray[n2];
            for (Candidate c : b.candidates) {
                if (ec != null && edge.compareBounds(c.bounds, ec.bounds) <= 0) continue;
                ec = c;
            }
            ++n2;
        }
        return ec;
    }

    public Iterator<Candidate> getBin(int bx, int by) {
        int bi = BinPlane.binindex(bx, by);
        WeakReference<Bin> r = this.bins.get(bi);
        if (r == null) {
            return null;
        }
        Bin b = (Bin)r.get();
        if (b == null) {
            return null;
        }
        return b.candidates.iterator();
    }

    public Iterator<Candidate> getBin(final int bx, final int by, final boolean cutLeft, final boolean cutAbove) {
        final Iterator<Candidate> b = this.getBin(bx, by);
        if (b == null) {
            return null;
        }
        return new Iterator<Candidate>(){
            private Candidate c = this.findNext();

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public Candidate next() {
                if (this.c == null) {
                    throw new NoSuchElementException();
                }
                Candidate r = this.c;
                this.c = this.findNext();
                return r;
            }

            private Candidate findNext() {
                Candidate bc;
                do {
                    if (!b.hasNext()) {
                        return null;
                    }
                    bc = (Candidate)b.next();
                } while (cutLeft && ((Candidate)bc).bounds.x >> BinPlane.this.binShift != bx || cutAbove && ((Candidate)bc).bounds.y >> BinPlane.this.binShift != by);
                return bc;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Candidate> intersect(int bx, int by, final Rectangle r, boolean cut) {
        final Iterator<Candidate> b = this.getBin(bx, by, cut && r.x >> this.binShift != bx, cut && r.y >> this.binShift != by);
        if (b == null) {
            return null;
        }
        return new Iterator<Candidate>(){
            private Candidate c = this.findNext();

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public Candidate next() {
                if (this.c == null) {
                    throw new NoSuchElementException();
                }
                Candidate r2 = this.c;
                this.c = this.findNext();
                return r2;
            }

            private Candidate findNext() {
                Candidate bc;
                do {
                    if (b.hasNext()) continue;
                    return null;
                } while (!(bc = (Candidate)b.next()).bounds.intersects(r));
                return bc;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<CandidateBin> intersect(final Rectangle r, final boolean cut) {
        return new Iterator<CandidateBin>(){
            private boolean inside;
            private Iterator<Candidate> b;
            private boolean end = false;
            private int x0;
            private int x1;
            private int y0;
            private int y1;
            private int bx;
            private int by;
            private CandidateBin c;
            {
                this.x0 = rectangle.x >> BinPlane.this.binShift;
                this.x1 = rectangle.x + rectangle.width - 1 >> BinPlane.this.binShift;
                this.y0 = rectangle.y >> BinPlane.this.binShift;
                this.y1 = rectangle.y + rectangle.height - 1 >> BinPlane.this.binShift;
                this.bx = this.x0 - 1;
                this.by = this.y0;
                this.c = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public CandidateBin next() {
                if (this.c == null) {
                    throw new NoSuchElementException();
                }
                CandidateBin r2 = this.c;
                this.c = this.findNext();
                return r2;
            }

            private void nextBin() {
                ++this.bx;
                if (this.bx > this.x1) {
                    ++this.by;
                    if (this.by > this.y1) {
                        this.b = null;
                        this.end = true;
                        return;
                    }
                    this.bx = this.x0;
                }
                boolean bl = this.inside = this.bx << BinPlane.this.binShift >= r.x && this.by << BinPlane.this.binShift >= r.y && this.bx < this.x1 - 1 && this.by < this.y1 - 1;
                this.b = this.inside ? (cut ? BinPlane.this.getBin(this.bx, this.by, true, true) : BinPlane.this.getBin(this.bx, this.by)) : BinPlane.this.intersect(this.bx, this.by, r, cut);
            }

            private CandidateBin findNext() {
                block1: {
                    do {
                        this.nextBin();
                        if (this.b != null) break block1;
                    } while (!this.end);
                    return null;
                }
                return new CandidateBin(this.bx << BinPlane.this.binShift, this.by << BinPlane.this.binShift, 1 << BinPlane.this.binShift, 1 << BinPlane.this.binShift, this.b);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<CandidateBin> all(final boolean cut) {
        final Iterator<Map.Entry<Integer, WeakReference<Bin>>> es = this.bins.entrySet().iterator();
        return new Iterator<CandidateBin>(){
            private CandidateBin cb = this.findNext();

            @Override
            public boolean hasNext() {
                return this.cb != null;
            }

            @Override
            public CandidateBin next() {
                if (this.cb == null) {
                    throw new NoSuchElementException();
                }
                CandidateBin r = this.cb;
                this.cb = this.findNext();
                return r;
            }

            private CandidateBin findNext() {
                if (!es.hasNext()) {
                    return null;
                }
                Map.Entry e = (Map.Entry)es.next();
                int i = (Integer)e.getKey();
                int bx = i << 16 >> 16;
                int by = i >> 16;
                Bin b = (Bin)((WeakReference)e.getValue()).get();
                if (b == null) {
                    return null;
                }
                return new CandidateBin(bx << BinPlane.this.binShift, by << BinPlane.this.binShift, 1 << BinPlane.this.binShift, 1 << BinPlane.this.binShift, cut ? BinPlane.this.getBin(bx, by, true, true) : b.iterator());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static int binindex(int x, int y) {
        if (x << 16 >> 16 != x || y << 16 >> 16 != y) {
            throw new IllegalArgumentException();
        }
        return x & 0xFFFF | y << 16;
    }

    public final class Bin {
        private TreeSet<Candidate> candidates = new TreeSet();
        public final int index;
        public final WeakReference<Bin> reference;

        public Bin(int idx) {
            this.index = idx;
            this.reference = new WeakReference<Bin>(this);
            BinPlane.this.bins.put(idx, this.reference);
        }

        public Iterator<Candidate> iterator() {
            return this.candidates.iterator();
        }

        protected void finalize() {
            BinPlane.this.bins.remove(this.index, this.reference);
        }
    }

    public class Candidate
    implements Comparable<Candidate> {
        public Object data;
        private int binx;
        private int biny;
        private int binw;
        private int binh;
        private final Rectangle bounds = new Rectangle(-1, -1);
        private int depth;
        private boolean isSelected = false;
        private Bin[] cBins;

        public void setDepth(int d) {
            this.setDepth(d, false);
        }

        public void setDepth(int d, boolean selected) {
            Bin b;
            if (this.cBins == null) {
                this.depth = d;
                this.isSelected = selected;
                return;
            }
            Bin[] binArray = this.cBins;
            int n = this.cBins.length;
            int n2 = 0;
            while (n2 < n) {
                b = binArray[n2];
                b.candidates.remove(this);
                ++n2;
            }
            this.depth = d;
            this.isSelected = selected;
            binArray = this.cBins;
            n = this.cBins.length;
            n2 = 0;
            while (n2 < n) {
                b = binArray[n2];
                b.candidates.add(this);
                ++n2;
            }
        }

        public void setBounds(Rectangle b) {
            int x;
            this.bounds.setBounds(b);
            int obx = this.binx;
            int oby = this.biny;
            int obw = this.binw;
            int obh = this.binh;
            this.binx = b.x >> BinPlane.this.binShift;
            this.biny = b.y >> BinPlane.this.binShift;
            this.binw = 1 + (b.x + b.width - 1 >> BinPlane.this.binShift) - this.binx;
            this.binh = 1 + (b.y + b.height - 1 >> BinPlane.this.binShift) - this.biny;
            if (this.binx == obx && this.biny == oby && this.binw == obw && this.binh == obh) {
                return;
            }
            Bin[] ob = this.cBins;
            this.cBins = new Bin[this.binw * this.binh];
            int i = 0;
            int y = 0;
            while (y < obh) {
                x = 0;
                while (x < obw) {
                    int xo = obx + x - this.binx;
                    if (xo < 0 || xo >= this.binw) {
                        ob[i++].candidates.remove(this);
                    } else {
                        int yo = oby + y - this.biny;
                        if (yo < 0 || yo >= this.binh) {
                            ob[i++].candidates.remove(this);
                        } else {
                            this.cBins[xo + this.binw * yo] = ob[i++];
                        }
                    }
                    ++x;
                }
                ++y;
            }
            i = 0;
            y = 0;
            while (y < this.binh) {
                x = 0;
                while (x < this.binw) {
                    if (this.cBins[i] == null) {
                        Bin bin;
                        int idx = BinPlane.binindex(this.binx + x, this.biny + y);
                        WeakReference r = (WeakReference)BinPlane.this.bins.get(idx);
                        Bin bin2 = bin = r == null ? null : (Bin)r.get();
                        if (bin == null) {
                            bin = new Bin(idx);
                        }
                        this.cBins[i] = bin;
                        bin.candidates.add(this);
                    }
                    ++i;
                    ++x;
                }
                ++y;
            }
        }

        public Rectangle getBounds(Rectangle b) {
            if (b == null) {
                return this.bounds.getBounds();
            }
            b.setBounds(this.bounds);
            return b;
        }

        public void remove() {
            Bin[] binArray = this.cBins;
            int n = this.cBins.length;
            int n2 = 0;
            while (n2 < n) {
                Bin b = binArray[n2];
                b.candidates.remove(this);
                ++n2;
            }
            this.cBins = null;
            this.bounds.setSize(-1, -1);
            this.binw = 0;
            this.binh = 0;
        }

        @Override
        public int compareTo(Candidate c) {
            if (this == c) {
                return 0;
            }
            if (this.isSelected) {
                return 1;
            }
            return c.depth > this.depth ? 1 : (c.depth < this.depth ? -1 : Integer.valueOf(c.hashCode()).compareTo(this.hashCode()));
        }
    }

    public static final class CandidateBin {
        public final int x;
        public final int y;
        public final int w;
        public final int h;
        public final Iterator<Candidate> iterator;

        public CandidateBin(int x, int y, int w, int h, Iterator<Candidate> i) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.iterator = i;
        }
    }

    public static final class CandidateDataIterator<T>
    extends ConversionIterator<Candidate, T> {
        private final Class<T> ct;

        public CandidateDataIterator(Iterator<CandidateBin> i, Class<T> t) {
            super(new CandidateIterator(i));
            this.ct = t;
        }

        @Override
        protected T convert(Candidate c) {
            return this.ct.isInstance(c.data) ? (T)this.ct.cast(c.data) : null;
        }
    }

    public static final class CandidateDepthDataIterator<T>
    extends ConversionIterator<Candidate, T> {
        private final Class<T> ct;
        private final int depth;

        public CandidateDepthDataIterator(Iterator<CandidateBin> i, Class<T> t, int depth) {
            super(new CandidateIterator(i));
            this.ct = t;
            this.depth = depth;
        }

        @Override
        protected T convert(Candidate c) {
            return this.ct.isInstance(c.data) && c.depth == this.depth ? (T)this.ct.cast(c.data) : null;
        }
    }

    public static final class CandidateIterator
    extends LateralIterator<Candidate> {
        final Iterator<CandidateBin> cbi;

        public CandidateIterator(Iterator<CandidateBin> i) {
            this.cbi = i;
        }

        @Override
        protected Iterator<Candidate> getNextIterator() {
            while (this.cbi.hasNext()) {
                Iterator<Candidate> r = this.cbi.next().iterator;
                if (r == null || !r.hasNext()) continue;
                return r;
            }
            return null;
        }
    }

    public static abstract class ConversionIterator<T1, T2>
    implements Iterator<T2> {
        protected final Iterator<T1> iter;
        private T2 next;

        public ConversionIterator(Iterator<T1> t1) {
            this.iter = t1;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.findNext();
            }
            return this.next != null;
        }

        @Override
        public T2 next() {
            T2 n = this.next == null ? this.findNext() : this.next;
            this.next = null;
            return n;
        }

        @Override
        @Deprecated
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private T2 findNext() {
            while (this.iter.hasNext()) {
                T1 c = this.iter.next();
                T2 r = this.convert(c);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        protected abstract T2 convert(T1 var1);
    }

    public static enum Edge {
        LEFT(null){

            @Override
            public int compareBin(int i0, int i1) {
                return Integer.valueOf(i1 << 16 >> 16).compareTo(i0 << 16 >> 16);
            }

            @Override
            public int getValue(int left, int right, int top, int bottom) {
                return -left;
            }
        }
        ,
        RIGHT(LEFT),
        TOP(null){

            @Override
            public int compareBin(int i0, int i1) {
                return Integer.valueOf(i1 >> 16).compareTo(i0 >> 16);
            }

            @Override
            public int getValue(int left, int right, int top, int bottom) {
                return -top;
            }
        }
        ,
        BOTTOM(TOP);

        private Edge opposite;

        private Edge(Edge o) {
            this.opposite = o;
            if (o != null) {
                o.opposite = this;
            }
        }

        public int compareBin(int i0, int i1) {
            return this.opposite.compareBin(i1, i0);
        }

        public int getValue(int left, int right, int top, int bottom) {
            return this.opposite.getValue(-right, -left, -bottom, -top);
        }

        public int compareBounds(Rectangle b0, Rectangle b1) {
            int v1;
            int v0 = this.getValue(b0.x, b0.x + b0.width, b0.y, b0.y + b0.height);
            return v0 > (v1 = this.getValue(b1.x, b1.x + b1.width, b1.y, b1.y + b1.height)) ? 1 : (v0 < v1 ? -1 : 0);
        }
    }

    public static abstract class LateralIterator<T>
    implements Iterator<T> {
        protected Iterator<T> iter;

        @Override
        public boolean hasNext() {
            if (this.iter == null || !this.iter.hasNext()) {
                this.iter = this.getNextIterator();
                if (this.iter == null) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        protected abstract Iterator<T> getNextIterator();
    }
}

