/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lateralgm.main.UpdateSource;

public class ActiveArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    public final UpdateSource updateSource;
    private final UpdateSource.UpdateTrigger trigger = new UpdateSource.UpdateTrigger();

    public ActiveArrayList() {
        this.updateSource = new UpdateSource(this, this.trigger);
    }

    @Override
    public boolean add(E e) {
        int i = this.size();
        super.add(e);
        this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.ADDED, i, i));
        return true;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.ADDED, index, index));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int s = this.size();
        if (super.addAll(c)) {
            this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.ADDED, s, this.size() - 1));
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int s = this.size();
        if (super.addAll(index, c)) {
            this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.ADDED, index, index + this.size() - s - 1));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        int s = this.size();
        super.clear();
        if (s > 0) {
            this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.REMOVED, 0, s - 1));
        }
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.REMOVED, index, index));
        return e;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i >= 0) {
            super.remove(i);
            this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.REMOVED, i, i));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int s = c.size();
        if (s == 0) {
            return false;
        }
        if (s == 1) {
            return this.remove(c.iterator().next());
        }
        if (super.removeAll(c)) {
            this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.CHANGED, 0, Integer.MAX_VALUE));
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (super.retainAll(c)) {
            this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.CHANGED, 0, Integer.MAX_VALUE));
            return true;
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        E e = super.set(index, element);
        this.trigger.fire(new ListUpdateEvent(this.updateSource, ListUpdateEvent.Type.CHANGED, index, index));
        return e;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    public static class ListUpdateEvent
    extends UpdateSource.UpdateEvent {
        public final Type type;
        public final int fromIndex;
        public final int toIndex;

        public ListUpdateEvent(UpdateSource s, Type t, int from, int to) {
            super(s);
            this.type = t;
            this.fromIndex = from;
            this.toIndex = to;
        }

        public static enum Type {
            ADDED,
            REMOVED,
            CHANGED;

        }
    }
}

