/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.visuals;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.View;
import org.lateralgm.ui.swing.visuals.AbstractVisual;
import org.lateralgm.ui.swing.visuals.BinVisual;
import org.lateralgm.ui.swing.visuals.BoundedVisual;
import org.lateralgm.ui.swing.visuals.GridVisual;
import org.lateralgm.ui.swing.visuals.VisualBox;
import org.lateralgm.ui.swing.visuals.VisualContainer;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class RoomVisual
extends AbstractVisual
implements BoundedVisual,
UpdateSource.UpdateListener {
    protected static final ImageIcon EMPTY_SPRITE = LGM.getIconForKey("Resource.EMPTY_OBJ");
    protected static final BufferedImage EMPTY_IMAGE = EMPTY_SPRITE.getIconWidth() <= 0 ? null : new BufferedImage(EMPTY_SPRITE.getIconWidth(), EMPTY_SPRITE.getIconHeight(), 2);
    private final BinVisual binVisual;
    private final GridVisual gridVisual;
    public final Room room;
    protected final InstanceVisualListManager ivlm;
    protected final TileVisualListManager tvlm;
    private final RoomPropertyListener rpl = new RoomPropertyListener();
    private final BgDefPropertyListener bdpl = new BgDefPropertyListener();
    private final ViewPropertyListener viewPropertyListener = new ViewPropertyListener();
    private Rectangle selection = null;
    private Point mousePosition = null;
    private BufferedImage selectionImage = null;
    private boolean pasteMode = false;
    private EnumSet<Show> show;
    private int gridFactor = 1;
    private int gridX;
    private int gridY;
    private boolean viewsVisible;
    private Integer visibleLayer = null;

    public RoomVisual(VisualContainer vc, Room r) {
        this(vc, r, EnumSet.range(Show.BACKGROUNDS, Show.GRID));
    }

    public RoomVisual(VisualContainer vc, Room r, EnumSet<Show> s) {
        super(vc);
        this.room = r;
        this.show = EnumSet.copyOf(s);
        this.binVisual = new BinVisual(vc, 128, (Integer)r.get(Room.PRoom.WIDTH), (Integer)r.get(Room.PRoom.HEIGHT));
        this.gridVisual = new GridVisual((Boolean)r.get(Room.PRoom.ISOMETRIC), (Integer)r.get(Room.PRoom.SNAP_X), (Integer)r.get(Room.PRoom.SNAP_Y));
        r.properties.updateSource.addListener(this.rpl);
        this.ivlm = new InstanceVisualListManager();
        this.tvlm = new TileVisualListManager();
        for (BackgroundDef bd : this.room.backgroundDefs) {
            bd.properties.updateSource.addListener(this.bdpl);
            bd.updateSource.addListener(this);
        }
        for (View view : this.room.views) {
            view.properties.updateSource.addListener(this.viewPropertyListener);
        }
    }

    public int getSelectionImageWidth() {
        return this.selectionImage.getWidth();
    }

    public int getSelectionImageHeight() {
        return this.selectionImage.getHeight();
    }

    public void deactivatePasteMode() {
        this.pasteMode = false;
        this.repaint(null);
    }

    public void activatePasteMode() {
        this.pasteMode = true;
        this.repaint(null);
    }

    public void setSelectionImage(List<Instance> selectedInstances, List<Tile> selectedTiles) {
        BufferedImage selectionImage = new BufferedImage(this.selection.width, this.selection.height, 2);
        Graphics g = selectionImage.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setColor(Util.convertGmColorWithAlpha(Prefs.multipleSelectionInsideColor));
        if (Prefs.useFilledRectangleForMultipleSelection) {
            g2.fillRect(1, 1, this.selection.width - 2, this.selection.height - 2);
        } else {
            g2.drawRect(1, 1, this.selection.width - 3, this.selection.height - 3);
        }
        g.setColor(Util.convertGmColorWithAlpha(Prefs.multipleSelectionOutsideColor));
        if (Prefs.useFilledRectangleForMultipleSelection) {
            g2.drawRect(0, 0, this.selection.width - 1, this.selection.height - 1);
        } else {
            g2.drawRect(0, 0, this.selection.width - 1, this.selection.height - 1);
        }
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
        g2.setComposite(ac);
        if (selectedInstances != null) {
            for (Instance instance : selectedInstances) {
                Image newImage;
                Graphics2D g3 = (Graphics2D)g2.create();
                Point2D scale = instance.getScale();
                int alpha = instance.getAlpha();
                double rotation = instance.getRotation();
                Point position = instance.getPosition();
                int originx = 0;
                int originy = 0;
                int offsetx = 0;
                int offsety = 0;
                Point newPosition = new Point(position.x - this.selection.x, position.y - this.selection.y);
                ResourceReference instanceObject = (ResourceReference)instance.properties.get(Instance.PInstance.OBJECT);
                BufferedImage instanceImage = ((GmObject)instanceObject.get()).getDisplayImage();
                if (instanceImage == null || alpha == 0) {
                    g3.drawImage(EMPTY_SPRITE.getImage(), newPosition.x, newPosition.y, null);
                    g3.dispose();
                    continue;
                }
                ResourceReference sprite = (ResourceReference)((GmObject)instanceObject.get()).get(GmObject.PGmObject.SPRITE);
                originx = (Integer)((Sprite)sprite.get()).get(Sprite.PSprite.ORIGIN_X);
                originy = (Integer)((Sprite)sprite.get()).get(Sprite.PSprite.ORIGIN_Y);
                if (originx != 0 || originy != 0) {
                    newPosition.translate(-((int)((double)originx * scale.getX())), -((int)((double)originy * scale.getY())));
                }
                if (scale.getX() != 1.0 || scale.getY() != 1.0) {
                    offsetx = (int)((double)newPosition.x * scale.getX() - (double)newPosition.x);
                    offsety = (int)((double)newPosition.y * scale.getY() - (double)newPosition.y);
                }
                if (offsetx != 0 || offsety != 0) {
                    g3.translate(-offsetx, -offsety);
                }
                if (rotation != 0.0) {
                    g3.rotate(Math.toRadians(-rotation), newPosition.x + offsetx, newPosition.y + offsety);
                }
                g3.scale(scale.getX(), scale.getY());
                Color selectedColor = instance.getAWTColor();
                if (!Color.WHITE.equals(selectedColor)) {
                    ColorFilter filter = new ColorFilter(selectedColor);
                    FilteredImageSource filteredSrc = new FilteredImageSource(instanceImage.getSource(), filter);
                    newImage = Toolkit.getDefaultToolkit().createImage(filteredSrc);
                } else {
                    newImage = instanceImage;
                }
                if (alpha > 0 && (float)alpha < ac.getAlpha() * 255.0f) {
                    AlphaComposite newAc = AlphaComposite.getInstance(3, (float)((double)alpha / 255.0));
                    g3.setComposite(newAc);
                }
                g3.drawImage(newImage, newPosition.x, newPosition.y, null);
                g3.dispose();
            }
        } else {
            for (Tile tile : selectedTiles) {
                Point newPosition = tile.getPosition();
                ResourceReference background = (ResourceReference)tile.properties.get(Tile.PTile.BACKGROUND);
                BufferedImage backgroundImage = ((Background)background.get()).getDisplayImage();
                Point tilePosition = tile.getBackgroundPosition();
                Dimension tileSize = tile.getSize();
                BufferedImage tileImage = backgroundImage.getSubimage(tilePosition.x, tilePosition.y, tileSize.width, tileSize.height);
                g2.drawImage((Image)tileImage, newPosition.x - this.selection.x, newPosition.y - this.selection.y, null);
            }
        }
        this.selectionImage = selectionImage;
    }

    public void setMousePosition(Point mousePosition) {
        this.mousePosition = mousePosition;
        this.repaint(null);
    }

    public void setSelection(Rectangle selection) {
        this.selection = selection;
        this.repaint(null);
    }

    public void setViewsVisible(boolean visible) {
        this.viewsVisible = visible;
        this.repaint(null);
    }

    public void setVisibleLayer(Integer layer) {
        this.visibleLayer = layer;
        this.repaint(null);
    }

    @Override
    public void extendBounds(Rectangle b) {
        b.add(new Rectangle(0, 0, (Integer)this.room.get(Room.PRoom.WIDTH), (Integer)this.room.get(Room.PRoom.HEIGHT)));
        this.binVisual.extendBounds(b);
    }

    @Override
    public void paint(Graphics g) {
        boolean viewsEnabled;
        int width = (Integer)this.room.get(Room.PRoom.WIDTH);
        int height = (Integer)this.room.get(Room.PRoom.HEIGHT);
        Graphics g2 = g.create();
        g2.clipRect(0, 0, width, height);
        if (((Boolean)this.room.get(Room.PRoom.DRAW_BACKGROUND_COLOR)).booleanValue()) {
            g2.setColor((Color)this.room.get(Room.PRoom.BACKGROUND_COLOR));
            g2.fillRect(0, 0, width, height);
        }
        if (this.show.contains((Object)Show.BACKGROUNDS)) {
            for (BackgroundDef bd : this.room.backgroundDefs) {
                if (!RoomVisual.shouldPaint(bd, false)) continue;
                RoomVisual.paintBackground(g2, bd, width, height);
            }
        }
        if (this.show.contains((Object)Show.INSTANCES) || this.show.contains((Object)Show.TILES)) {
            this.binVisual.paint(g);
        }
        if (this.show.contains((Object)Show.FOREGROUNDS)) {
            for (BackgroundDef bd : this.room.backgroundDefs) {
                if (!RoomVisual.shouldPaint(bd, true)) continue;
                RoomVisual.paintBackground(g2, bd, width, height);
            }
        }
        if (this.show.contains((Object)Show.GRID)) {
            g2.translate(this.gridX - ((Boolean)this.room.get(Room.PRoom.ISOMETRIC) != false ? (Integer)this.room.get(Room.PRoom.SNAP_X) * (this.gridFactor - 1) / 2 : 0), this.gridY);
            this.gridVisual.paint(g2);
        }
        if ((this.show.contains((Object)Show.VIEWS) || this.viewsVisible) && (viewsEnabled = ((Boolean)this.room.get(Room.PRoom.VIEWS_ENABLED)).booleanValue())) {
            for (View view : this.room.views) {
                if (!((Boolean)view.properties.get(View.PView.VISIBLE)).booleanValue()) continue;
                this.paintView(g2, view);
            }
        }
        if (this.pasteMode) {
            g2.drawImage(this.selectionImage, this.mousePosition.x, this.mousePosition.y, null);
        }
        if (this.selection != null) {
            this.paintSelection(g2);
        }
        g2.dispose();
    }

    private void paintSelection(Graphics g) {
        if (Prefs.useInvertedColorForMultipleSelection) {
            g.setXORMode(Util.convertGmColorWithAlpha(Prefs.multipleSelectionInsideColor));
        } else {
            g.setColor(Util.convertGmColorWithAlpha(Prefs.multipleSelectionInsideColor));
        }
        if (Prefs.useFilledRectangleForMultipleSelection) {
            g.fillRect(this.selection.x + 1, this.selection.y + 1, this.selection.width - 1, this.selection.height - 1);
        } else {
            g.drawRect(this.selection.x + 1, this.selection.y + 1, this.selection.width - 2, this.selection.height - 2);
        }
        if (Prefs.useInvertedColorForMultipleSelection) {
            g.setXORMode(Util.convertGmColorWithAlpha(Prefs.multipleSelectionOutsideColor));
        } else {
            g.setColor(Util.convertGmColorWithAlpha(Prefs.multipleSelectionOutsideColor));
        }
        g.drawRect(this.selection.x, this.selection.y, this.selection.width, this.selection.height);
    }

    private void paintView(Graphics g, View view) {
        int borderV;
        int borderH;
        int y;
        int x;
        Graphics2D g2 = (Graphics2D)g;
        int objectFollowingX = (Integer)view.properties.get(View.PView.OBJECT_FOLLOWING_X);
        int objectFollowingY = (Integer)view.properties.get(View.PView.OBJECT_FOLLOWING_Y);
        int width = (Integer)view.properties.get(View.PView.VIEW_W);
        int height = (Integer)view.properties.get(View.PView.VIEW_H);
        if (objectFollowingX > -1) {
            x = objectFollowingX;
            y = objectFollowingY;
        } else {
            x = (Integer)view.properties.get(View.PView.VIEW_X);
            y = (Integer)view.properties.get(View.PView.VIEW_Y);
        }
        if (Prefs.useInvertedColorForViews) {
            g2.setXORMode(Util.convertGmColorWithAlpha(Prefs.viewOutsideColor));
        } else {
            g2.setColor(Util.convertGmColorWithAlpha(Prefs.viewOutsideColor));
        }
        if (Prefs.useFilledRectangleForViews) {
            g2.drawRect(x - 2, y - 2, width + 3, height + 3);
            g2.drawRect(x - 1, y - 1, width + 1, height + 1);
        } else {
            g2.drawRect(x, y, width, height);
            g2.drawRect(x + 2, y + 2, width - 4, height - 4);
        }
        if (Prefs.useInvertedColorForViews) {
            g2.setXORMode(Util.convertGmColorWithAlpha(Prefs.viewInsideColor));
        } else {
            g2.setColor(Util.convertGmColorWithAlpha(Prefs.viewInsideColor));
        }
        if (Prefs.useFilledRectangleForViews) {
            g2.fillRect(x, y, width, height);
        } else {
            g2.drawRect(x + 1, y + 1, width - 2, height - 2);
        }
        if (objectFollowingX > -1 && !((borderH = ((Integer)view.properties.get(View.PView.BORDER_H)).intValue()) == 0 & (borderV = ((Integer)view.properties.get(View.PView.BORDER_V)).intValue()) == 0)) {
            if (Prefs.useFilledRectangleForViews) {
                float[] dash = new float[]{10.0f};
                BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f);
                g2.setColor(Util.convertGmColorWithAlpha(Prefs.viewOutsideColor));
                g2.setStroke(dashed);
                g2.drawRect(x + borderH, y + borderV, width - borderH * 2, height - borderV * 2);
            } else {
                float[] outside = new float[]{10.0f};
                float[] inside = new float[]{8.0f, 12.0f};
                BasicStroke dashed_black = new BasicStroke(3.0f, 0, 0, 10.0f, outside, 0.0f);
                BasicStroke dashed_white = new BasicStroke(1.0f, 0, 0, 10.0f, inside, 19.0f);
                g2.setColor(Util.convertGmColorWithAlpha(Prefs.viewOutsideColor));
                g2.setStroke(dashed_black);
                g2.drawRect(x + borderH, y + borderV, width - borderH * 2, height - borderV * 2);
                g2.setColor(Util.convertGmColorWithAlpha(Prefs.viewInsideColor));
                g2.setStroke(dashed_white);
                g2.drawRect(x + borderH, y + borderV, width - borderH * 2, height - borderV * 2);
            }
            g2.setStroke(new BasicStroke());
        }
    }

    private static boolean shouldPaint(BackgroundDef bd, Boolean fg) {
        if (!((Boolean)bd.properties.get(BackgroundDef.PBackgroundDef.VISIBLE)).booleanValue()) {
            return false;
        }
        return fg.equals(bd.properties.get(BackgroundDef.PBackgroundDef.FOREGROUND));
    }

    public void setVisible(Show s, boolean v) {
        if (v ? this.show.add(s) : this.show.remove((Object)s)) {
            if (s == Show.GRID && !v) {
                this.gridVisual.flush(true);
            }
            this.repaint(null);
        }
    }

    public void setGridFactor(int f) {
        this.gridFactor = f;
        this.gridVisual.setWidth(this.gridFactor * (Integer)this.room.get(Room.PRoom.SNAP_X));
        this.gridVisual.setHeight(this.gridFactor * (Integer)this.room.get(Room.PRoom.SNAP_Y));
    }

    public void setGridOffset(int x, int y) {
        if (this.gridX == x && this.gridY == y) {
            return;
        }
        this.gridX = x;
        this.gridY = y;
        if (this.show.contains((Object)Show.GRID)) {
            this.repaint(null);
        }
    }

    public void setGridXOffset(int x) {
        if (this.gridX == x) {
            return;
        }
        this.gridX = x;
        if (this.show.contains((Object)Show.GRID)) {
            this.repaint(null);
        }
    }

    public void setGridYOffset(int y) {
        if (this.gridY == y) {
            return;
        }
        this.gridY = y;
        if (this.show.contains((Object)Show.GRID)) {
            this.repaint(null);
        }
    }

    public <P extends Room.Piece> Iterator<P> intersect(Rectangle r, Class<P> p) {
        return new PieceIterator(this.binVisual.intersect(r, RoomVisual.getVisualClass(p)));
    }

    public <P extends Room.Piece> Iterator<P> intersect(Rectangle r, Class<P> p, int depth) {
        return new PieceIterator(this.binVisual.intersect(r, RoomVisual.getVisualClass(p), depth));
    }

    public boolean intersects(Rectangle r, Room.Piece p) {
        Iterator<Room.Piece> pi = this.intersect(r);
        while (pi.hasNext()) {
            if (pi.next() != p) continue;
            return true;
        }
        return false;
    }

    private static <P extends Room.Piece, V extends PieceVisual<P>> Class<V> getVisualClass(Class<P> p) {
        if (p == Room.Piece.class) {
            return PieceVisual.class;
        }
        if (p == Instance.class) {
            return InstanceVisual.class;
        }
        if (p == Tile.class) {
            return TileVisual.class;
        }
        throw new IllegalArgumentException();
    }

    public Iterator<Tile> intersectTiles(Rectangle r, int depth) {
        return this.intersect(r, Tile.class, depth);
    }

    public Iterator<Instance> intersectInstances(Rectangle r) {
        return this.intersect(r, Instance.class);
    }

    public Iterator<Room.Piece> intersect(Rectangle r) {
        return this.intersect(r, Room.Piece.class);
    }

    private static void paintBackground(Graphics g, BackgroundDef bd, int width, int height) {
        Rectangle c = g.getClipBounds();
        ResourceReference rb = (ResourceReference)bd.properties.get(BackgroundDef.PBackgroundDef.BACKGROUND);
        Background b = (Background)Util.deRef(rb);
        if (b == null) {
            return;
        }
        BufferedImage bi = b.getDisplayImage();
        if (bi == null) {
            return;
        }
        boolean stretch = (Boolean)bd.properties.get(BackgroundDef.PBackgroundDef.STRETCH);
        int w = stretch ? width : bi.getWidth();
        int h = stretch ? height : bi.getHeight();
        boolean tileHoriz = (Boolean)bd.properties.get(BackgroundDef.PBackgroundDef.TILE_HORIZ);
        boolean tileVert = (Boolean)bd.properties.get(BackgroundDef.PBackgroundDef.TILE_VERT);
        int x = (Integer)bd.properties.get(BackgroundDef.PBackgroundDef.X);
        int y = (Integer)bd.properties.get(BackgroundDef.PBackgroundDef.Y);
        if (tileHoriz || tileVert) {
            int ncol = 1;
            int nrow = 1;
            if (tileHoriz) {
                x = 1 + c.x + (x + w - 1 - c.x) % w - w;
                ncol = 1 + (c.x + c.width - x - 1) / w;
            }
            if (tileVert) {
                y = 1 + c.y + (y + h - 1 - c.y) % h - h;
                nrow = 1 + (c.y + c.height - y - 1) / h;
            }
            int row = 0;
            while (row < nrow) {
                int col = 0;
                while (col < ncol) {
                    g.drawImage(bi, x + w * col, y + h * row, w, h, null);
                    ++col;
                }
                ++row;
            }
        } else {
            g.drawImage(bi, x, y, w, h, null);
        }
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        if (e.source.owner instanceof BackgroundDef) {
            boolean bg = this.show.contains((Object)Show.BACKGROUNDS);
            boolean fg = this.show.contains((Object)Show.FOREGROUNDS);
            if (!bg && !fg) {
                return;
            }
            BackgroundDef bd = (BackgroundDef)e.source.owner;
            if (((Boolean)bd.properties.get(BackgroundDef.PBackgroundDef.VISIBLE)).booleanValue() && (bg && fg || ((Boolean)bd.properties.get(BackgroundDef.PBackgroundDef.FOREGROUND) != false ? fg : bg))) {
                this.repaint(null);
            }
        }
    }

    private class BgDefPropertyListener
    extends PropertyMap.PropertyUpdateListener<BackgroundDef.PBackgroundDef> {
        private BgDefPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<BackgroundDef.PBackgroundDef> e) {
            boolean bg = RoomVisual.this.show.contains((Object)Show.BACKGROUNDS);
            boolean fg = RoomVisual.this.show.contains((Object)Show.FOREGROUNDS);
            if (!bg && !fg) {
                return;
            }
            switch ((BackgroundDef.PBackgroundDef)((Object)e.key)) {
                case FOREGROUND: {
                    if (!((Boolean)e.map.get(BackgroundDef.PBackgroundDef.VISIBLE)).booleanValue()) {
                        return;
                    }
                }
                case VISIBLE: {
                    RoomVisual.this.repaint(null);
                }
                case H_SPEED: 
                case V_SPEED: {
                    return;
                }
            }
            if (((Boolean)e.map.get(BackgroundDef.PBackgroundDef.VISIBLE)).booleanValue() && (bg && fg || ((Boolean)e.map.get(BackgroundDef.PBackgroundDef.FOREGROUND) != false ? fg : bg))) {
                RoomVisual.this.repaint(null);
            }
        }
    }

    class ColorFilter
    extends RGBImageFilter {
        byte newColorRed;
        byte newColorGreen;
        byte newColorBlue;

        public ColorFilter(Color color) {
            this.newColorRed = (byte)color.getRed();
            this.newColorGreen = (byte)color.getGreen();
            this.newColorBlue = (byte)color.getBlue();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb >> 24 & 0xFF;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            return alpha << 24 | (red &= this.newColorRed) << 16 | (green &= this.newColorGreen) << 8 | (blue &= this.newColorBlue);
        }
    }

    private class InstanceVisual
    extends PieceVisual<Instance> {
        private BufferedImage image;
        private final InstancePropertyListener ipl;
        private AffineTransform at;

        public InstanceVisual(Instance i) {
            super(RoomVisual.this, (Room.Piece)i);
            this.ipl = new InstancePropertyListener();
            this.at = null;
            i.updateSource.addListener(this.rul);
            i.properties.updateSource.addListener(this.ipl);
            this.invalidate();
        }

        @Override
        protected void validate() {
            ResourceReference ro = (ResourceReference)((Instance)this.piece).properties.get(Instance.PInstance.OBJECT);
            GmObject o = ro == null ? null : (GmObject)ro.get();
            ResourceReference rs = null;
            if (o != null) {
                rs = (ResourceReference)o.get(GmObject.PGmObject.SPRITE);
            }
            Sprite s = rs == null ? null : (Sprite)rs.get();
            BufferedImage bufferedImage = this.image = s == null ? null : s.getDisplayImage();
            if (this.image == null) {
                this.image = EMPTY_IMAGE;
            }
            Point position = ((Instance)this.piece).getPosition();
            int newWidth = this.image.getWidth();
            int newHeight = this.image.getHeight();
            int originx = 0;
            int originy = 0;
            if (s != null) {
                originx = (Integer)s.get(Sprite.PSprite.ORIGIN_X);
                originy = (Integer)s.get(Sprite.PSprite.ORIGIN_Y);
            }
            Point2D scale = ((Instance)this.piece).getScale();
            double angle = ((Instance)this.piece).getRotation();
            if (((Instance)this.piece).isSelected()) {
                RoomVisual.this.binVisual.setDepth(this, o == null ? 0 : Integer.MIN_VALUE, true);
                newWidth += 4;
                newHeight += 4;
                originx += 2;
                originy += 2;
            } else {
                RoomVisual.this.binVisual.setDepth(this, o == null ? 0 : (Integer)o.get(GmObject.PGmObject.DEPTH), false);
            }
            Rectangle newBounds = new Rectangle(0, 0, newWidth, newHeight);
            if (angle != 0.0 || scale.getX() != 1.0 || scale.getY() != 1.0 || originx != 0 || originy != 0) {
                this.at = new AffineTransform();
                if (angle != 0.0) {
                    this.at.rotate(Math.toRadians(-angle));
                }
                if (scale.getX() != 1.0 || scale.getY() != 1.0) {
                    this.at.scale(scale.getX(), scale.getY());
                }
                if (originx != 0 && originy != 0) {
                    this.at.translate(-originx, -originy);
                }
                Shape newRect = this.at.createTransformedShape(newBounds);
                Rectangle2D newBounds2D = newRect.getBounds2D();
                int offsetx = (int)Math.round(newBounds2D.getX());
                int offsety = (int)Math.round(newBounds2D.getY());
                newWidth = (int)Math.round(newBounds2D.getWidth());
                newHeight = (int)Math.round(newBounds2D.getHeight());
                newBounds = new Rectangle(offsetx, offsety, newWidth, newHeight);
                this.at.preConcatenate(AffineTransform.getTranslateInstance(-offsetx, -offsety));
            } else {
                this.at = null;
            }
            newBounds.translate(position.x, position.y);
            this.setBounds(newBounds);
        }

        @Override
        public void paint(Graphics g) {
            if (RoomVisual.this.show.contains((Object)Show.INSTANCES)) {
                Image newImage;
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                if (this.at != null) {
                    g2.transform(this.at);
                }
                Color selectedColor = ((Instance)this.piece).getAWTColor();
                int alpha = ((Instance)this.piece).getAlpha();
                if (!Color.WHITE.equals(selectedColor)) {
                    ColorFilter filter = new ColorFilter(selectedColor);
                    FilteredImageSource filteredSrc = new FilteredImageSource(this.image.getSource(), filter);
                    newImage = Toolkit.getDefaultToolkit().createImage(filteredSrc);
                } else {
                    newImage = this.image;
                }
                Composite oc = null;
                if (alpha > 0 && alpha < 255) {
                    oc = g2.getComposite();
                    AlphaComposite ac = AlphaComposite.getInstance(3, (float)((double)alpha / 255.0));
                    g2.setComposite(ac);
                }
                if (((Instance)this.piece).isSelected()) {
                    g2.drawImage(this.image == EMPTY_IMAGE || alpha == 0 ? EMPTY_SPRITE.getImage() : newImage, 2, 2, null);
                } else {
                    g2.drawImage(this.image == EMPTY_IMAGE || alpha == 0 ? EMPTY_SPRITE.getImage() : newImage, 0, 0, null);
                }
                if (((Instance)this.piece).isSelected()) {
                    if (oc != null) {
                        g2.setComposite(oc);
                    }
                    if (Prefs.useInvertedColorForSelection) {
                        g2.setXORMode(Util.convertGmColorWithAlpha(Prefs.selectionInsideColor));
                    } else {
                        g2.setColor(Util.convertGmColorWithAlpha(Prefs.selectionInsideColor));
                    }
                    if (Prefs.useFilledRectangleForSelection) {
                        g2.fillRect(1, 1, this.image.getWidth() + 2, this.image.getHeight() + 2);
                    } else {
                        g2.drawRect(1, 1, this.image.getWidth() + 2, this.image.getHeight() + 2);
                    }
                    if (Prefs.useInvertedColorForSelection) {
                        g2.setXORMode(Util.convertGmColorWithAlpha(Prefs.selectionOutsideColor));
                    } else {
                        g2.setColor(Util.convertGmColorWithAlpha(Prefs.selectionOutsideColor));
                    }
                    g2.drawRect(0, 0, this.image.getWidth() + 4, this.image.getHeight() + 4);
                }
            }
        }

        @Override
        public void remove() {
            ((Instance)this.piece).updateSource.removeListener(this.rul);
            ((Instance)this.piece).properties.updateSource.removeListener(this.ipl);
            this.image = null;
            super.remove();
        }

        class InstancePropertyListener
        extends PropertyMap.PropertyUpdateListener<Instance.PInstance> {
            InstancePropertyListener() {
            }

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<Instance.PInstance> e) {
                switch ((Instance.PInstance)((Object)e.key)) {
                    case X: 
                    case Y: 
                    case OBJECT: {
                        InstanceVisual.this.invalidate();
                        break;
                    }
                }
            }
        }
    }

    private class InstanceVisualListManager
    extends VisualListManager<Instance, InstanceVisual> {
        public InstanceVisualListManager() {
            super(RoomVisual.this.room.instances);
        }

        @Override
        protected InstanceVisual createVisual(Instance t) {
            return new InstanceVisual(t);
        }

        @Override
        protected Instance getT(InstanceVisual v) {
            return (Instance)v.piece;
        }
    }

    private static class PieceIterator<P extends Room.Piece>
    implements Iterator<P> {
        private Iterator<PieceVisual<P>> vi;

        public PieceIterator(Iterator<PieceVisual<P>> vi) {
            this.vi = vi;
        }

        @Override
        public boolean hasNext() {
            return this.vi.hasNext();
        }

        @Override
        public P next() {
            return this.vi.next().piece;
        }

        @Override
        public void remove() {
            this.vi.remove();
        }
    }

    private static abstract class PieceVisual<P extends Room.Piece>
    extends VisualBox {
        protected final ResourceUpdateListener rul;
        public final P piece;
        private boolean invalid;
        final /* synthetic */ RoomVisual this$0;

        public PieceVisual(P p) {
            this.this$0 = var1_1;
            super(((RoomVisual)var1_1).binVisual);
            this.rul = new ResourceUpdateListener();
            this.piece = p;
        }

        protected abstract void validate();

        protected final void invalidate() {
            if (this.invalid) {
                return;
            }
            this.invalid = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PieceVisual.this.invalid) {
                            PieceVisual.this.validate();
                        }
                    }
                    finally {
                        PieceVisual.this.invalid = false;
                    }
                }
            });
        }

        protected class ResourceUpdateListener
        implements UpdateSource.UpdateListener {
            protected ResourceUpdateListener() {
            }

            @Override
            public void updated(UpdateSource.UpdateEvent e) {
                PieceVisual.this.invalidate();
            }
        }
    }

    private class RoomPropertyListener
    extends PropertyMap.PropertyUpdateListener<Room.PRoom> {
        private RoomPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Room.PRoom> e) {
            switch ((Room.PRoom)((Object)e.key)) {
                case BACKGROUND_COLOR: {
                    if (!((Boolean)RoomVisual.this.room.get(Room.PRoom.DRAW_BACKGROUND_COLOR)).booleanValue()) break;
                    RoomVisual.this.repaint(null);
                    break;
                }
                case DRAW_BACKGROUND_COLOR: {
                    RoomVisual.this.repaint(null);
                    break;
                }
                case VIEWS_ENABLED: {
                    if (!RoomVisual.this.show.contains((Object)Show.VIEWS) && !RoomVisual.this.viewsVisible) break;
                    RoomVisual.this.repaint(null);
                    break;
                }
                case ISOMETRIC: {
                    RoomVisual.this.gridVisual.setRhombic((Boolean)RoomVisual.this.room.get(Room.PRoom.ISOMETRIC));
                    if (!RoomVisual.this.show.contains((Object)Show.GRID)) break;
                    RoomVisual.this.repaint(null);
                    break;
                }
                case SNAP_X: {
                    RoomVisual.this.gridVisual.setWidth(RoomVisual.this.gridFactor * (Integer)RoomVisual.this.room.get(Room.PRoom.SNAP_X));
                    if (!RoomVisual.this.show.contains((Object)Show.GRID)) break;
                    RoomVisual.this.repaint(null);
                    break;
                }
                case SNAP_Y: {
                    RoomVisual.this.gridVisual.setHeight(RoomVisual.this.gridFactor * (Integer)RoomVisual.this.room.get(Room.PRoom.SNAP_Y));
                    if (!RoomVisual.this.show.contains((Object)Show.GRID)) break;
                    RoomVisual.this.repaint(null);
                    break;
                }
                case WIDTH: 
                case HEIGHT: {
                    RoomVisual.this.parent.updateBounds();
                    break;
                }
            }
        }
    }

    public static enum Show {
        BACKGROUNDS,
        INSTANCES,
        TILES,
        FOREGROUNDS,
        GRID,
        VIEWS;

    }

    private class TileVisual
    extends PieceVisual<Tile> {
        private BufferedImage image;
        private final TilePropertyListener tpl;

        public TileVisual(Tile t) {
            super(RoomVisual.this, (Room.Piece)t);
            this.tpl = new TilePropertyListener();
            t.updateSource.addListener(this.rul);
            t.properties.updateSource.addListener(this.tpl);
            this.invalidate();
        }

        @Override
        protected void validate() {
            BufferedImage bi;
            ResourceReference rb = (ResourceReference)((Tile)this.piece).properties.get(Tile.PTile.BACKGROUND);
            Background b = rb == null ? null : (Background)rb.get();
            BufferedImage bufferedImage = bi = b == null ? null : b.getDisplayImage();
            if (bi == null) {
                this.image = EMPTY_IMAGE;
            } else {
                Point p = ((Tile)this.piece).getBackgroundPosition();
                Dimension d = ((Tile)this.piece).getSize();
                try {
                    this.image = bi.getSubimage(p.x, p.y, d.width, d.height);
                }
                catch (RasterFormatException e) {
                    this.image = EMPTY_IMAGE;
                }
            }
            if (((Tile)this.piece).isSelected()) {
                RoomVisual.this.binVisual.setDepth(this, ((Tile)this.piece).getDepth(), true);
                Point piecePosition = ((Tile)this.piece).getPosition();
                Dimension pieceSize = ((Tile)this.piece).getSize();
                this.setBounds(new Rectangle(piecePosition.x - 2, piecePosition.y - 2, pieceSize.width + 4, pieceSize.height + 4));
            } else {
                RoomVisual.this.binVisual.setDepth(this, ((Tile)this.piece).getDepth(), false);
                Rectangle r = new Rectangle(((Tile)this.piece).getPosition(), ((Tile)this.piece).getSize());
                this.setBounds(r);
            }
        }

        @Override
        public void paint(Graphics g) {
            if (RoomVisual.this.show.contains((Object)Show.TILES)) {
                Graphics2D g2 = (Graphics2D)g;
                if (RoomVisual.this.visibleLayer != null && ((Tile)this.piece).getDepth() != RoomVisual.this.visibleLayer.intValue()) {
                    return;
                }
                if (((Tile)this.piece).isSelected()) {
                    g2.drawImage((Image)this.image, 2, 2, null);
                    if (Prefs.useInvertedColorForSelection) {
                        g2.setXORMode(Util.convertGmColorWithAlpha(Prefs.selectionInsideColor));
                    } else {
                        g2.setColor(Util.convertGmColorWithAlpha(Prefs.selectionInsideColor));
                    }
                    if (Prefs.useFilledRectangleForSelection) {
                        g2.fillRect(1, 1, this.image.getWidth() + 2, this.image.getHeight() + 2);
                    } else {
                        g2.drawRect(1, 1, this.image.getWidth() + 1, this.image.getHeight() + 1);
                    }
                    if (Prefs.useInvertedColorForSelection) {
                        g2.setXORMode(Util.convertGmColorWithAlpha(Prefs.selectionOutsideColor));
                    } else {
                        g2.setColor(Util.convertGmColorWithAlpha(Prefs.selectionOutsideColor));
                    }
                    g2.drawRect(0, 0, this.image.getWidth() + 3, this.image.getHeight() + 3);
                } else {
                    g.drawImage(this.image, 0, 0, null);
                }
            }
        }

        @Override
        public void remove() {
            ((Tile)this.piece).updateSource.removeListener(this.rul);
            ((Tile)this.piece).properties.updateSource.removeListener(this.tpl);
            this.image = null;
            super.remove();
        }

        class TilePropertyListener
        extends PropertyMap.PropertyUpdateListener<Tile.PTile> {
            TilePropertyListener() {
            }

            @Override
            public void updated(PropertyMap.PropertyUpdateEvent<Tile.PTile> e) {
                switch ((Tile.PTile)((Object)e.key)) {
                    case ROOM_X: 
                    case ROOM_Y: 
                    case DEPTH: {
                        TileVisual.this.invalidate();
                        break;
                    }
                }
            }
        }
    }

    private class TileVisualListManager
    extends VisualListManager<Tile, TileVisual> {
        public TileVisualListManager() {
            super(RoomVisual.this.room.tiles);
        }

        @Override
        protected TileVisual createVisual(Tile t) {
            return new TileVisual(t);
        }

        @Override
        protected Tile getT(TileVisual v) {
            return (Tile)v.piece;
        }
    }

    private class ViewPropertyListener
    extends PropertyMap.PropertyUpdateListener<View.PView> {
        private ViewPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<View.PView> e) {
            switch ((View.PView)((Object)e.key)) {
                case VISIBLE: 
                case VIEW_X: 
                case VIEW_Y: 
                case VIEW_W: 
                case VIEW_H: 
                case BORDER_H: 
                case BORDER_V: {
                    RoomVisual.this.repaint(null);
                }
            }
        }
    }

    private static abstract class VisualListManager<T, V extends VisualBox>
    implements UpdateSource.UpdateListener {
        public final ActiveArrayList<T> tList;
        private final ArrayList<V> vList;

        public VisualListManager(ActiveArrayList<T> tl) {
            this.tList = tl;
            this.vList = new ArrayList(tl.size());
            for (Object t : tl) {
                this.vList.add(this.createVisual(t));
            }
            tl.updateSource.addListener(this);
        }

        protected abstract V createVisual(T var1);

        protected abstract T getT(V var1);

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            ActiveArrayList.ListUpdateEvent lue = (ActiveArrayList.ListUpdateEvent)e;
            switch (lue.type) {
                case ADDED: {
                    int i = lue.fromIndex;
                    while (i <= lue.toIndex) {
                        Object t = this.tList.get(i);
                        V v = this.createVisual(t);
                        this.vList.add(i, v);
                        ++i;
                    }
                    break;
                }
                case REMOVED: {
                    int i = lue.toIndex;
                    while (i >= lue.fromIndex) {
                        ((VisualBox)this.vList.remove(i)).remove();
                        --i;
                    }
                    break;
                }
                case CHANGED: {
                    HashSet<T> ts = new HashSet<T>(this.tList);
                    HashMap<T, VisualBox> tm = new HashMap<T, VisualBox>(Math.min(this.vList.size(), this.tList.size()));
                    for (VisualBox v : this.vList) {
                        T t = this.getT(v);
                        if (ts.contains(t)) {
                            tm.put(t, v);
                            continue;
                        }
                        v.remove();
                    }
                    this.vList.clear();
                    for (Object t : this.tList) {
                        VisualBox v = (VisualBox)tm.get(t);
                        this.vList.add(v == null ? this.createVisual(t) : v);
                    }
                    break;
                }
            }
            assert (this.tList.size() == this.vList.size());
        }
    }
}

