/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.visuals;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.lateralgm.main.Util;
import org.lateralgm.ui.swing.visuals.Visual;

public class GridVisual
implements Visual {
    private static final Color GRID_DARK = new Color(0, 0, 0, 96);
    private static final Color GRID_BRIGHT = new Color(255, 255, 255, 96);
    private static final WeakHashMap<GraphicsConfiguration, SoftReference<LineImageData>> IMAGE_DATA = new WeakHashMap(4);
    private boolean rhombic;
    private int width;
    private int height;
    private BufferedImage gridImage;
    private LineImageData imageData;

    public GridVisual(boolean r, int w, int h) {
        this.rhombic = r;
        this.width = w;
        this.height = h;
    }

    public void setRhombic(boolean r) {
        if (r == this.rhombic) {
            return;
        }
        this.rhombic = r;
        this.flush(r);
    }

    public void setWidth(int w) {
        if (this.width == w) {
            return;
        }
        this.width = w;
        this.flush(false);
    }

    public void setHeight(int h) {
        if (this.height == h) {
            return;
        }
        this.height = h;
        this.flush(false);
    }

    public void flush(boolean full) {
        if (this.gridImage != null) {
            this.gridImage.flush();
        }
        this.gridImage = null;
        if (full) {
            this.imageData = null;
        }
    }

    private void paintGrid(Graphics g, int x0, int y0, int x1, int y1) {
        boolean ry;
        boolean rx = this.width >= 2;
        boolean bl = ry = this.height >= 2;
        if (this.rhombic) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int y = Util.negDiv(y0, this.height) * this.height;
            while (y <= y1) {
                int x = Util.negDiv(x0, this.width) * this.width;
                while (x <= x1) {
                    int cx0 = x + (this.width >> 1);
                    int cy0 = y + (this.height >> 1);
                    int cx1 = x + (this.width + 1 >> 1);
                    int cy1 = y + (this.height + 1 >> 1);
                    g.setColor(GRID_DARK);
                    g.drawLine(x + 1, cy1, cx0, y + this.height - 1);
                    g.drawLine(cx1, y + this.height - 1, x + this.width - 1, cy1);
                    g.drawLine(x + this.width, cy0 - 1, cx1 + 1, y);
                    g.drawLine(cx0 - 1, y, x, cy0 - 1);
                    g.setColor(GRID_BRIGHT);
                    g.drawLine(x + this.width - 1, cy0, cx1, y + 1);
                    g.drawLine(cx0, y + 1, x + 1, cy0);
                    g.drawLine(x, cy1 + 1, cx0 - 1, y + this.height);
                    g.drawLine(cx1 + 1, y + this.height, x + this.width, cy1 + 1);
                    x += this.width;
                }
                y += this.height;
            }
        } else {
            GraphicsConfiguration gc;
            GraphicsConfiguration graphicsConfiguration = gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
            if (this.imageData == null || !this.imageData.configuration.equals(gc)) {
                SoftReference<LineImageData> idr = IMAGE_DATA.get(gc);
                LineImageData lineImageData = this.imageData = idr == null ? null : idr.get();
                if (this.imageData == null) {
                    this.imageData = new LineImageData(gc);
                    IMAGE_DATA.put(gc, new SoftReference<LineImageData>(this.imageData));
                }
            }
            if (!ry) {
                int x = Util.negDiv(x0, this.width) * this.width;
                while (x <= x1) {
                    this.imageData.paintVertical(g, x - 1, y0, y1 - y0);
                    x += this.width;
                }
            } else if (!rx) {
                int y = Util.negDiv(y0, this.height) * this.height;
                while (y <= y1) {
                    this.imageData.paintHorizontal(g, x0, y - 1, x1 - x0, false);
                    y += this.height;
                }
            } else {
                int y = Util.negDiv(y0, this.height) * this.height;
                while (y <= y1) {
                    int x = Util.negDiv(x0, this.width) * this.width;
                    while (x <= x1) {
                        this.imageData.paintHorizontal(g, x - 1, y - 1, Math.min(this.width, x1 - x + 1), true);
                        this.imageData.paintVertical(g, x - 1, y + 1, Math.min(this.height - 2, y1 - y - 1));
                        x += this.width;
                    }
                    y += this.height;
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int ih;
        boolean ry;
        boolean rx = this.width >= 2;
        boolean bl = ry = this.height >= 2;
        if (!rx && !ry || this.rhombic && (!rx || !ry)) {
            return;
        }
        int iw = rx ? this.width * ((48 + this.width - 1) / this.width) : 64;
        int n = ih = ry ? this.height * ((48 + this.height - 1) / this.height) : 64;
        if (this.gridImage == null && (rx && ry ? this.width * this.height <= (this.rhombic ? 65536 : 9216) : (rx ? this.width : this.height) < 16)) {
            GraphicsConfiguration gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
            this.gridImage = gc == null ? new BufferedImage(iw, ih, 2) : gc.createCompatibleImage(iw, ih, 3);
            Graphics2D g2 = this.gridImage.createGraphics();
            this.paintGrid(g2, 0, 0, iw, ih);
        }
        Rectangle clip = g.getClipBounds();
        int x0 = clip.x;
        int x1 = x0 + clip.width;
        int y0 = clip.y;
        int y1 = y0 + clip.height;
        if (this.gridImage != null) {
            int y = Util.negDiv(y0, ih) * ih;
            while (y <= y1) {
                int x = Util.negDiv(x0, iw) * iw;
                while (x <= x1) {
                    g.drawImage(this.gridImage, x, y, null);
                    x += iw;
                }
                y += ih;
            }
        } else {
            this.paintGrid(g, x0, y0, x1, y1);
        }
    }

    class LineImageData {
        private final BufferedImage horizSub;
        private final BufferedImage horizontal;
        private final BufferedImage vertical;
        public final GraphicsConfiguration configuration;

        public LineImageData(GraphicsConfiguration gc) {
            this.configuration = gc;
            if (gc != null) {
                this.horizontal = gc.createCompatibleImage(130, 2, 3);
                this.vertical = gc.createCompatibleImage(2, 128, 3);
            } else {
                this.horizontal = new BufferedImage(130, 2, 2);
                this.vertical = new BufferedImage(2, 128, 2);
            }
            int[] rgba = new int[128];
            Arrays.fill(rgba, GRID_DARK.getRGB());
            this.horizontal.setRGB(0, 0, rgba[0]);
            this.horizontal.setRGB(2, 0, 128, 1, rgba, 0, 128);
            this.vertical.setRGB(0, 0, 1, 128, rgba, 0, 1);
            Arrays.fill(rgba, GRID_BRIGHT.getRGB());
            this.horizontal.setRGB(1, 1, rgba[0]);
            this.horizontal.setRGB(2, 1, 128, 1, rgba, 0, 128);
            this.vertical.setRGB(1, 0, 1, 128, rgba, 0, 1);
            this.horizSub = this.horizontal.getSubimage(2, 0, 128, 2);
        }

        public void paintHorizontal(Graphics g, int x, int y, int l, boolean start) {
            if (start) {
                if (l >= 130) {
                    g.drawImage(this.horizontal, x, y, null);
                } else {
                    g.drawImage(this.horizontal, x, y, x + l, y + 2, 0, 0, l, 2, null);
                }
            }
            int t = start ? 130 : 0;
            while (t <= l - 128) {
                g.drawImage(this.horizSub, x + t, y, null);
                t += 128;
            }
            if (t < l) {
                g.drawImage(this.horizSub, x + t, y, x + l, y + 2, 0, 0, l - t, 2, null);
            }
        }

        public void paintVertical(Graphics g, int x, int y, int l) {
            int t = 0;
            while (t <= l - 128) {
                g.drawImage(this.vertical, x, y + t, null);
                t += 128;
            }
            if (t < l) {
                g.drawImage(this.vertical, x, y + t, x + 2, y + l, 0, 0, 2, l - t, null);
            }
        }
    }
}

