/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.visuals;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lateralgm.ui.swing.visuals.AbstractVisual;
import org.lateralgm.ui.swing.visuals.BoundedVisual;
import org.lateralgm.ui.swing.visuals.Visual;
import org.lateralgm.ui.swing.visuals.VisualBox;
import org.lateralgm.ui.swing.visuals.VisualContainer;
import org.lateralgm.util.BinPlane;

public class BinVisual
extends AbstractVisual
implements VisualContainer,
BoundedVisual {
    private static final Rectangle ZERO_RECTANGLE = new Rectangle();
    private final BinPlane binPlane;
    private Visual vLeft;
    private Visual vRight;
    private Visual vTop;
    private Visual vBottom;
    private final Rectangle boxBounds = new Rectangle();
    private Map<Visual, BinPlane.Candidate> candidates;

    public BinVisual(VisualContainer c, int s, int x, int y) {
        super(c);
        this.binPlane = new BinPlane(s, x, y);
    }

    @Override
    public void repaint(Rectangle r) {
        super.repaint(r);
    }

    void add(Visual v, Rectangle b, int d) {
        BinPlane.Candidate c = new BinPlane.Candidate(this.binPlane);
        c.data = v;
        c.setDepth(d);
        if (this.candidates == null) {
            this.candidates = new HashMap<Visual, BinPlane.Candidate>();
        }
        this.candidates.put(v, c);
        if (b != null) {
            this.setBounds(c, b);
        }
    }

    boolean remove(Visual v) {
        if (this.candidates == null) {
            return false;
        }
        BinPlane.Candidate c = this.candidates.remove(v);
        if (c == null) {
            return false;
        }
        this.repaint(c.getBounds(null));
        c.remove();
        Rectangle obb = this.boxBounds.getBounds();
        if (v == this.vLeft) {
            this.vLeft = null;
        }
        if (v == this.vRight) {
            this.vRight = null;
        }
        if (v == this.vTop) {
            this.vTop = null;
        }
        if (v == this.vBottom) {
            this.vBottom = null;
        }
        this.fixBounds();
        if (!obb.equals(this.boxBounds)) {
            this.parent.updateBounds();
        }
        return true;
    }

    public void setDepth(Visual v, int d) {
        this.setDepth(v, d, false);
    }

    public void setDepth(Visual v, int d, boolean selected) {
        BinPlane.Candidate c = this.getCandidate(v);
        if (c == null) {
            return;
        }
        c.setDepth(d, selected);
        Rectangle ob = c.getBounds(null);
        if (ob != null && !ob.isEmpty()) {
            this.repaint(ob);
        }
    }

    public void setBounds(Visual v, Rectangle b) {
        this.setBounds(this.getCandidate(v), b);
    }

    private BinPlane.Candidate getCandidate(Visual v) {
        return this.candidates == null ? null : this.candidates.get(v);
    }

    private void setBounds(BinPlane.Candidate c, Rectangle b) {
        Rectangle ob = c.getBounds(null);
        if (!ob.isEmpty()) {
            this.repaint(ob);
        }
        Visual v = (Visual)c.data;
        c.setBounds(b);
        Rectangle obb = this.boxBounds.getBounds();
        if (b.x <= this.boxBounds.x) {
            this.vLeft = v;
            this.boxBounds.width += this.boxBounds.x - b.x;
            this.boxBounds.x = b.x;
        } else if (v == this.vLeft) {
            this.vLeft = null;
        }
        int w = b.x + b.width - this.boxBounds.x;
        if (w >= this.boxBounds.width) {
            this.vRight = v;
            this.boxBounds.width = w;
        } else if (v == this.vRight) {
            this.vRight = null;
        }
        if (b.y <= this.boxBounds.y) {
            this.vTop = v;
            this.boxBounds.height += this.boxBounds.y - b.y;
            this.boxBounds.y = b.y;
        } else if (v == this.vTop) {
            this.vTop = null;
        }
        int h = b.y + b.height - this.boxBounds.y;
        if (h >= this.boxBounds.height) {
            this.vBottom = v;
            this.boxBounds.height = h;
        } else if (v == this.vBottom) {
            this.vBottom = null;
        }
        this.fixBounds();
        if (!obb.equals(this.boxBounds)) {
            this.parent.updateBounds();
        }
        this.repaint(b);
    }

    private void fixBounds() {
        BinPlane.Candidate ec;
        if (this.vLeft == null) {
            int l;
            ec = this.binPlane.getEdgeCandidate(BinPlane.Edge.LEFT);
            int n = l = ec == null ? 0 : ec.getBounds(null).x;
            if (ec != null) {
                this.vLeft = (VisualBox)ec.data;
            }
            this.boxBounds.width += this.boxBounds.x - l;
            this.boxBounds.x = l;
        }
        if (this.vRight == null) {
            Rectangle cb;
            ec = this.binPlane.getEdgeCandidate(BinPlane.Edge.RIGHT);
            Rectangle rectangle = cb = ec == null ? ZERO_RECTANGLE : ec.getBounds(null);
            if (ec != null) {
                this.vRight = (VisualBox)ec.data;
            }
            this.boxBounds.width = cb.x + cb.width - this.boxBounds.x;
        }
        if (this.vTop == null) {
            int t;
            ec = this.binPlane.getEdgeCandidate(BinPlane.Edge.TOP);
            int n = t = ec == null ? 0 : ec.getBounds(null).y;
            if (ec != null) {
                this.vTop = (VisualBox)ec.data;
            }
            this.boxBounds.height += this.boxBounds.y - t;
            this.boxBounds.y = t;
        }
        if (this.vBottom == null) {
            Rectangle cb;
            ec = this.binPlane.getEdgeCandidate(BinPlane.Edge.BOTTOM);
            Rectangle rectangle = cb = ec == null ? ZERO_RECTANGLE : ec.getBounds(null);
            if (ec != null) {
                this.vBottom = (VisualBox)ec.data;
            }
            this.boxBounds.height = cb.y + cb.height - this.boxBounds.y;
        }
    }

    public Iterator<Visual> intersect(Rectangle r) {
        return this.intersect(r, Visual.class);
    }

    public <V extends Visual> Iterator<V> intersect(Rectangle r, Class<V> v) {
        return new BinPlane.CandidateDataIterator<V>(this.binPlane.intersect(r, true), v);
    }

    public <V extends Visual> Iterator<V> intersect(Rectangle r, Class<V> v, int depth) {
        return new BinPlane.CandidateDepthDataIterator<V>(this.binPlane.intersect(r, true), v, depth);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Iterator<BinPlane.CandidateBin> cbi = clip == null ? this.binPlane.all(false) : this.binPlane.intersect(clip, false);
        Rectangle b = null;
        while (cbi.hasNext()) {
            BinPlane.CandidateBin cb = cbi.next();
            g.clipRect(cb.x, cb.y, cb.w, cb.h);
            while (cb.iterator.hasNext()) {
                BinPlane.Candidate c = cb.iterator.next();
                Visual v = (Visual)c.data;
                b = c.getBounds(b);
                Graphics g2 = g.create(b.x, b.y, b.width, b.height);
                v.paint(g2);
                g2.dispose();
            }
            g.setClip(clip);
        }
    }

    @Override
    public void updateBounds() {
    }

    @Override
    public void extendBounds(Rectangle b) {
        b.add(this.boxBounds);
    }
}

