/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.util;

import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.util.ActiveArrayList;

public class ArrayListModel<E>
implements ListModel<E>,
UpdateSource.UpdateListener {
    ActiveArrayList<E> list;
    ArrayList<ListDataListener> listeners;

    public ArrayListModel(ActiveArrayList<E> l) {
        this.list = l;
        l.updateSource.addListener(this);
        this.listeners = new ArrayList();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public E getElementAt(int index) {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        ListDataEvent lde;
        if (e instanceof ActiveArrayList.ListUpdateEvent) {
            int t;
            ActiveArrayList.ListUpdateEvent lue = (ActiveArrayList.ListUpdateEvent)e;
            switch (lue.type) {
                case ADDED: {
                    t = 1;
                    break;
                }
                case REMOVED: {
                    t = 2;
                    break;
                }
                case CHANGED: {
                    t = 0;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            lde = new ListDataEvent(e.source.owner, t, lue.fromIndex, lue.toIndex);
        } else {
            lde = new ListDataEvent(e.source.owner, 0, 0, Integer.MAX_VALUE);
        }
        for (ListDataListener l : this.listeners) {
            switch (lde.getType()) {
                case 1: {
                    l.intervalAdded(lde);
                }
                case 2: {
                    l.intervalRemoved(lde);
                }
            }
            l.contentsChanged(lde);
        }
    }
}

