/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.propertylink;

import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.text.Document;
import org.lateralgm.ui.swing.propertylink.BoundedRangeLink;
import org.lateralgm.ui.swing.propertylink.ButtonGroupLink;
import org.lateralgm.ui.swing.propertylink.ButtonIncrementLink;
import org.lateralgm.ui.swing.propertylink.ButtonModelLink;
import org.lateralgm.ui.swing.propertylink.ComboBoxLink;
import org.lateralgm.ui.swing.propertylink.DocumentLink;
import org.lateralgm.ui.swing.propertylink.FormattedLink;
import org.lateralgm.ui.swing.propertylink.ListLink;
import org.lateralgm.util.PropertyEditor;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class PropertyLinkFactory<K extends Enum<K>> {
    private PropertyMap<K> map;
    private final ExceptionListener exceptionListener;
    private List<PropertyLink<K, ?>> mapLinks = new ArrayList();

    public void removeAllLinks() {
        for (PropertyLink<K, ?> link : this.mapLinks) {
            link.remove();
        }
        this.mapLinks.clear();
    }

    public void setMap(PropertyMap<K> m) {
        this.map = m;
        for (PropertyLink<K, ?> link : this.mapLinks) {
            link.setMap(this.map);
        }
    }

    public PropertyLinkFactory(PropertyMap<K> m, ExceptionListener el) {
        this.map = m;
        this.exceptionListener = el;
    }

    public <L extends PropertyLink<K, ?>> L init(L l) {
        this.mapLinks.add(l);
        l.setExceptionListener(this.exceptionListener);
        return l;
    }

    public <V> PropertyLink<K, V> make(PropertyEditor<V> pe, K k) {
        return this.init(pe.getLink(this.map, k));
    }

    public <V> ComboBoxLink<K, V> make(JComboBox<?> b, K k) {
        return this.init(new ComboBoxLink(b, this.map, k, new ComboBoxLink.DefaultComboBoxConversion()));
    }

    public <V> ComboBoxLink<K, V> make(JComboBox<?> b, K k, ComboBoxLink.ComboBoxConversion<V> conv) {
        return this.init(new ComboBoxLink<K, V>(b, this.map, k, conv));
    }

    public <V> ListLink<K, V> make(JList<?> l, K k) {
        return this.init(new ListLink(l, this.map, k));
    }

    public FormattedLink<K> make(JFormattedTextField f, K k) {
        return this.init(new FormattedLink<K>(f, this.map, k));
    }

    public DocumentLink<K> make(Document d, K k) {
        return this.init(new DocumentLink<K>(d, this.map, k));
    }

    public ButtonModelLink<K> make(ButtonModel m, K k) {
        return this.init(new ButtonModelLink<K>(m, this.map, k));
    }

    public ButtonModelLink<K> make(AbstractButton b, K k) {
        return this.init(new ButtonModelLink<K>(b.getModel(), this.map, k));
    }

    public BoundedRangeLink<K, Integer> make(BoundedRangeModel m, K k) {
        return this.init(new BoundedRangeLink<K, Integer>(m, new BoundedRangeLink.IntegerConverter(), this.map, k));
    }

    public BoundedRangeLink<K, Double> make(BoundedRangeModel m, K k, double s) {
        return this.init(new BoundedRangeLink<K, Double>(m, new BoundedRangeLink.DoubleConverter(s), this.map, k));
    }

    public <V extends Enum<V>> ButtonGroupLink<K, V> make(ButtonGroup g, K k, Class<V> vt) {
        return this.init(new ButtonGroupLink<K, V>(g, vt, this.map, k));
    }

    public ButtonIncrementLink<K, Integer> make(AbstractButton ab, K k, int i, int l) {
        return this.init(ButtonIncrementLink.make(ab, i, l, this.map, k));
    }
}

