/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.propertylink;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.lateralgm.main.LGM;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class DocumentLink<K extends Enum<K>>
extends PropertyLink<K, String>
implements DocumentListener {
    public final Document document;

    public DocumentLink(Document d, PropertyMap<K> m, K k) {
        super(m, k);
        this.document = d;
        this.reset();
        d.addDocumentListener(this);
    }

    @Override
    protected void setComponent(String t) {
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, t, null);
        }
        catch (BadLocationException e) {
            LGM.showDefaultExceptionHandler(e);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.document.removeDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    private void update() {
        try {
            this.editProperty(this.document.getText(0, this.document.getLength()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
        String t = (String)this.map.get(this.key);
        if (t == null) {
            t = "";
        }
        int l = t.length();
        try {
            if (l == this.document.getLength() && t.equals(this.document.getText(0, l))) {
                return;
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.editComponent(t);
    }
}

