/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.propertylink;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class ComboBoxLink<K extends Enum<K>, V>
extends PropertyLink<K, V>
implements ActionListener {
    public final JComboBox<?> box;
    private final ComboBoxConversion<V> conv;

    public ComboBoxLink(JComboBox<?> b, PropertyMap<K> m, K k, ComboBoxConversion<V> conv) {
        super(m, k);
        this.box = b;
        this.conv = conv == null ? new DefaultComboBoxConversion() : conv;
        this.reset();
        this.box.addActionListener(this);
    }

    @Override
    protected void setComponent(V i) {
        this.setConvertedSelection(i);
    }

    public void setConvertedSelection(V o) {
        if (this.conv instanceof ComboBoxSelectable) {
            ((ComboBoxSelectable)((Object)this.conv)).select(this.box, o);
            return;
        }
        if (o == null) {
            return;
        }
        int i = 0;
        while (i < this.box.getItemCount()) {
            V it = this.conv.convertItem(i, this.box.getItemAt(i));
            if (o.equals(it)) {
                this.box.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    public V getConvertedSelection() {
        return this.conv.convertItem(this.box.getSelectedIndex(), this.box.getSelectedItem());
    }

    @Override
    public void remove() {
        super.remove();
        this.box.removeActionListener(this);
    }

    @Override
    public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
        this.editComponentIfChanged(this.getConvertedSelection());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        V i = this.getConvertedSelection();
        if (i.equals(this.map.get(this.key))) {
            return;
        }
        this.editProperty(i);
    }

    public static interface ComboBoxConversion<T> {
        public T convertItem(int var1, Object var2);
    }

    public static interface ComboBoxSelectable<V> {
        public void select(JComboBox<?> var1, V var2);
    }

    public static class DefaultComboBoxConversion<V>
    implements ComboBoxConversion<V>,
    ComboBoxSelectable<V> {
        @Override
        public V convertItem(int ind, Object o) {
            return (V)o;
        }

        @Override
        public void select(JComboBox<?> b, V o) {
            b.setSelectedItem(o);
        }
    }

    public static class IndexComboBoxConversion
    implements ComboBoxConversion<Integer>,
    ComboBoxSelectable<Integer> {
        @Override
        public Integer convertItem(int ind, Object o) {
            return ind;
        }

        @Override
        public void select(JComboBox<?> b, Integer o) {
            b.setSelectedIndex(o);
        }
    }

    public static class KeyComboBoxConversion<V>
    implements ComboBoxConversion<V>,
    ComboBoxSelectable<V> {
        private final V[] items;
        private final Map<?, Integer> map;

        public KeyComboBoxConversion(V[] items) {
            this.items = items;
            this.map = null;
        }

        public KeyComboBoxConversion(V[] items, Map<?, Integer> map) {
            this.items = items;
            this.map = map;
        }

        @Override
        public V convertItem(int ind, Object o) {
            return this.items[ind];
        }

        @Override
        public void select(JComboBox<?> b, V o) {
            if (this.map != null) {
                b.setSelectedIndex(this.map.get(o));
                return;
            }
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].equals(o)) {
                    b.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }
    }
}

