/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.propertylink;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class ButtonIncrementLink<K extends Enum<K>, V extends Number>
extends PropertyLink<K, V>
implements ActionListener {
    public final AbstractButton button;
    public final Incrementor<V> incrementor;
    public final V min;
    public final V max;
    private V value;

    public ButtonIncrementLink(AbstractButton ab, Incrementor<V> i, V min, V max, PropertyMap<K> m, K k) {
        super(m, k);
        this.button = ab;
        this.incrementor = i;
        this.min = min;
        this.max = max;
        this.reset();
        ab.addActionListener(this);
    }

    @Override
    protected void setComponent(V v) {
        this.value = ((Comparable)this.min).compareTo(v) > 0 ? this.min : (((Comparable)this.max).compareTo(v) < 0 ? this.max : v);
        V n = this.incrementor.increment(this.value);
        this.button.setEnabled(((Comparable)this.min).compareTo(n) <= 0 && ((Comparable)this.max).compareTo(n) >= 0);
    }

    @Override
    public void remove() {
        super.remove();
        this.button.removeActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        V n = this.incrementor.increment(this.value);
        this.editProperty(n);
    }

    public static <K extends Enum<K>> ButtonIncrementLink<K, Integer> make(AbstractButton ab, int i, int l, PropertyMap<K> m, K k) {
        return new ButtonIncrementLink<K, Integer>(ab, new IntegerIncrementor(i), i < 0 ? l : Integer.MIN_VALUE, i > 0 ? l : Integer.MAX_VALUE, m, k);
    }

    public static interface Incrementor<V extends Number> {
        public V increment(V var1);
    }

    public static class IntegerIncrementor
    implements Incrementor<Integer> {
        public final int increment;

        public IntegerIncrementor(int i) {
            this.increment = i;
        }

        @Override
        public Integer increment(Integer i) {
            return i + this.increment;
        }
    }
}

