/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.propertylink;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class ButtonGroupLink<K extends Enum<K>, V extends Enum<V>>
extends PropertyLink<K, V>
implements ActionListener {
    public final ButtonGroup group;
    public final V[] values;
    private final EnumMap<V, AbstractButton> buttons;
    private final Map<ButtonModel, V> buttonValues;

    public ButtonGroupLink(ButtonGroup g, Class<V> vt, PropertyMap<K> m, K k) {
        super(m, k);
        this.values = (Enum[])vt.getEnumConstants();
        if (g.getButtonCount() != this.values.length) {
            throw new IllegalArgumentException();
        }
        this.group = g;
        this.buttons = new EnumMap(vt);
        this.buttonValues = new HashMap<ButtonModel, V>(this.values.length);
        Enumeration<AbstractButton> e = g.getElements();
        V[] VArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            V v = VArray[n2];
            AbstractButton b = e.nextElement();
            this.buttonValues.put(b.getModel(), v);
            this.buttons.put((AbstractButton)v, b);
            ++n2;
        }
        this.reset();
        for (AbstractButton b : this.buttons.values()) {
            b.addActionListener(this);
        }
    }

    @Override
    protected void setComponent(V v) {
        if (v == null) {
            this.group.clearSelection();
        } else {
            this.group.setSelected(this.buttons.get(v).getModel(), true);
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (AbstractButton b : this.buttons.values()) {
            b.removeActionListener(this);
        }
    }

    @Override
    public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
        Enum v = (Enum)this.map.get(this.key);
        if (this.buttons.get(v).getModel() == this.group.getSelection()) {
            return;
        }
        this.editComponent(v);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Enum v = (Enum)this.buttonValues.get(this.group.getSelection());
        if (v == this.map.get(this.key)) {
            return;
        }
        this.editProperty(v);
    }
}

