/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.ui.swing.propertylink;

import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class BoundedRangeLink<K extends Enum<K>, V extends Number>
extends PropertyLink<K, V>
implements ChangeListener {
    public final BoundedRangeModel model;
    public final Converter<V> converter;

    public BoundedRangeLink(BoundedRangeModel brm, Converter<V> c, PropertyMap<K> m, K k) {
        super(m, k);
        this.model = brm;
        this.converter = c;
        this.reset();
        this.model.addChangeListener(this);
    }

    @Override
    protected void setComponent(V v) {
        this.model.setValue(this.converter.fromProperty(v));
    }

    @Override
    public void remove() {
        super.remove();
        this.model.removeChangeListener(this);
    }

    @Override
    public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
        Number v = (Number)this.map.get(this.key);
        if (this.converter.fromProperty(v) == this.model.getValue()) {
            return;
        }
        this.editComponent(v);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        V v = this.converter.toProperty(this.model.getValue());
        if (v.equals(this.map.get(this.key))) {
            return;
        }
        this.editProperty(v);
    }

    public static interface Converter<V extends Number> {
        public V toProperty(int var1);

        public int fromProperty(V var1);
    }

    public static class DoubleConverter
    implements Converter<Double> {
        public final double step;

        public DoubleConverter(double s) {
            this.step = s;
        }

        @Override
        public int fromProperty(Double v) {
            return (int)Math.round(v * this.step);
        }

        @Override
        public Double toProperty(int v) {
            return (double)v / this.step;
        }
    }

    public static class IntegerConverter
    implements Converter<Integer> {
        @Override
        public int fromProperty(Integer v) {
            return v;
        }

        @Override
        public Integer toProperty(int v) {
            return v;
        }
    }
}

