/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lateralgm.components.ActionList;
import org.lateralgm.components.ActionListEditor;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.mdi.MDIFrame;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.subframes.ResourceInfoFrame;

public class TimelineFrame
extends InstantiableResourceFrame<Timeline, Timeline.PTimeline>
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    public JButton add;
    public JButton edit;
    public JButton change;
    public JButton delete;
    public JButton duplicate;
    public JButton shift;
    public JButton merge;
    public JButton clear;
    public JButton showInfo;
    public JList<Moment> moments;
    public ActionList actions;
    public CodeTextArea code;
    private JComponent editor;
    private ResourceInfoFrame infoFrame;

    public TimelineFrame(Timeline res, ResNode node) {
        super(res, node);
        this.getRootPane().setDefaultButton(this.save);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.setLayout(layout);
        JPanel propertiesSide = new JPanel();
        this.makeProperties(propertiesSide);
        JPanel momentsSide = new JPanel(new BorderLayout());
        JPanel labPane = Util.makeLabelPane(Messages.getString("TimelineFrame.MOMENTS"));
        momentsSide.add((Component)labPane, "North");
        this.moments = new JList<Moment>(res.moments.toArray(new Moment[res.moments.size()]));
        this.moments.setSelectionMode(0);
        this.moments.addListSelectionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimelineFrame.this.editSelectedMoment();
                }
            }
        };
        this.moments.addMouseListener(ml);
        JScrollPane scroll = new JScrollPane(this.moments);
        if (Prefs.enableDragAndDrop) {
            scroll.setPreferredSize(new Dimension(100, 300));
        } else {
            scroll.setPreferredSize(new Dimension(200, 400));
        }
        momentsSide.add((Component)scroll, "Center");
        this.actions = new ActionList(this);
        if (Prefs.enableDragAndDrop) {
            this.editor = new ActionListEditor(this.actions);
        }
        GroupLayout.SequentialGroup orientationGroup = layout.createSequentialGroup();
        if (Prefs.rightOrientation) {
            if (Prefs.enableDragAndDrop) {
                orientationGroup.addComponent(this.editor);
            }
            orientationGroup.addComponent(momentsSide).addComponent(propertiesSide, -1, -2, -2);
        } else {
            orientationGroup.addComponent(propertiesSide, -1, -2, -2).addComponent(momentsSide);
            if (Prefs.enableDragAndDrop) {
                orientationGroup.addComponent(this.editor);
            }
        }
        layout.setHorizontalGroup(orientationGroup);
        GroupLayout.ParallelGroup verticalGroup = layout.createParallelGroup().addComponent(propertiesSide).addComponent(momentsSide);
        if (Prefs.enableDragAndDrop) {
            verticalGroup.addComponent(this.editor);
        }
        layout.setVerticalGroup(verticalGroup);
        this.pack();
        this.moments.setSelectedIndex(0);
    }

    private void makeProperties(JPanel side1) {
        GroupLayout layout = new GroupLayout(side1);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        side1.setLayout(layout);
        JLabel lab = new JLabel(Messages.getString("TimelineFrame.NAME"));
        this.edit = new JButton(Messages.getString("TimelineFrame.EDIT"));
        this.edit.addActionListener(this);
        this.add = new JButton(Messages.getString("TimelineFrame.ADD"));
        this.add.addActionListener(this);
        this.change = new JButton(Messages.getString("TimelineFrame.CHANGE"));
        this.change.addActionListener(this);
        this.delete = new JButton(Messages.getString("TimelineFrame.DELETE"));
        this.delete.addActionListener(this);
        this.duplicate = new JButton(Messages.getString("TimelineFrame.DUPLICATE"));
        this.duplicate.addActionListener(this);
        this.shift = new JButton(Messages.getString("TimelineFrame.SHIFT"));
        this.shift.addActionListener(this);
        this.merge = new JButton(Messages.getString("TimelineFrame.MERGE"));
        this.merge.addActionListener(this);
        this.clear = new JButton(Messages.getString("TimelineFrame.CLEAR"));
        this.clear.addActionListener(this);
        this.showInfo = new JButton(Messages.getString("TimelineFrame.SHOWINFORMATION"));
        this.showInfo.addActionListener(this);
        this.showInfo.setIcon(LGM.getIconForKey("TimelineFrame.SHOWINFORMATION"));
        this.save.setText(Messages.getString("TimelineFrame.SAVE"));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lab).addComponent(this.name, -1, 120, Integer.MAX_VALUE)).addComponent(this.edit, -1, -1, Integer.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.add, -1, -1, Integer.MAX_VALUE).addComponent(this.delete, -1, -1, Integer.MAX_VALUE)).addGroup(layout.createParallelGroup().addComponent(this.change, -1, -1, Integer.MAX_VALUE).addComponent(this.duplicate, -1, -1, Integer.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.shift, -1, -1, Integer.MAX_VALUE).addComponent(this.merge, -1, -1, Integer.MAX_VALUE)).addComponent(this.clear, -1, -1, Integer.MAX_VALUE).addComponent(this.showInfo, -1, -1, Integer.MAX_VALUE).addComponent(this.save, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lab).addComponent(this.name)).addGap(32).addComponent(this.edit).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.add).addComponent(this.change)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.delete).addComponent(this.duplicate)).addGap(32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.shift).addComponent(this.merge)).addComponent(this.clear).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 0, Integer.MAX_VALUE).addComponent(this.showInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.save));
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return Util.areInherentlyUniquesEqual(((Timeline)this.res).moments, ((Timeline)this.resOriginal).moments);
    }

    @Override
    public void commitChanges() {
        this.actions.save();
        ((Timeline)this.res).setName(this.name.getText());
    }

    public int findMoment(int step) {
        ListModel<Moment> model = this.moments.getModel();
        int i = 0;
        while (i < model.getSize()) {
            Moment mom = model.getElementAt(i);
            if (mom.stepNo == step) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setSelectedMoment(int step) {
        int index = this.findMoment(step);
        if (index != -1) {
            this.moments.setSelectedIndex(index);
        }
    }

    public void showInfoFrame() {
        Moment node;
        ListModel<Moment> mommodel = this.moments.getModel();
        if (mommodel.getSize() > 0 && (node = mommodel.getElementAt(this.moments.getSelectedIndex())) != null) {
            this.actions.setActionContainer(node);
        }
        if (this.infoFrame == null) {
            this.infoFrame = new ResourceInfoFrame();
        }
        this.infoFrame.updateTimelineInfo(((Timeline)this.res).reference);
        this.infoFrame.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.infoFrame != null) {
            this.infoFrame.dispose();
        }
        if (this.editor != null) {
            ((ActionListEditor)this.editor).dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Moment m;
        if (!(e.getSource() instanceof JButton)) {
            super.actionPerformed(e);
            return;
        }
        JButton but = (JButton)e.getSource();
        if (but == this.add || but == this.change || but == this.duplicate) {
            Moment m2 = this.moments.getSelectedValue();
            if (m2 == null && but != this.add) {
                return;
            }
            int sn = m2 == null ? -1 : m2.stepNo;
            String msg = Messages.getString("TimelineFrame.MOM_NUM");
            String ttl = but == this.add ? "TimelineFrame.MOM_ADD" : (but == this.change ? "TimelineFrame.MOM_CHANGE" : "TimelineFrame.MOM_DUPLICATE");
            ttl = Messages.getString(ttl);
            JPanel pane = new JPanel();
            pane.add(new JLabel(msg));
            NumberField field = new NumberField(sn + (but == this.add ? 1 : 0));
            pane.add(field);
            int ret = JOptionPane.showConfirmDialog(this, pane, ttl, 2);
            if (ret == 2) {
                return;
            }
            ret = field.getIntValue();
            if (ret == sn) {
                return;
            }
            int p = -Collections.binarySearch(((Timeline)this.res).moments, ret) - 1;
            if (but == this.add) {
                if (p < 0) {
                    this.moments.setSelectedIndex(-p);
                    return;
                }
                Moment m22 = new Moment();
                m22.stepNo = ret;
                ((Timeline)this.res).moments.add(p, m22);
            } else if (but == this.change) {
                if (p < 0) {
                    JOptionPane.showMessageDialog(this, Messages.getString("TimelineFrame.MOM_EXIST"));
                    return;
                }
                if (ret > sn) {
                    --p;
                }
                m2.stepNo = ret;
                ((Timeline)this.res).moments.remove(this.moments.getSelectedIndex());
                ((Timeline)this.res).moments.add(p, m2);
            } else {
                if (p >= 0) {
                    JOptionPane.showMessageDialog(this, Messages.getString("TimelineFrame.MOM_EXIST"));
                    return;
                }
                Moment m23 = m2.copy();
                m23.stepNo = ret;
                ((Timeline)this.res).moments.add(p, m23);
            }
            this.moments.setListData((Moment[])((Timeline)this.res).moments.toArray(new Moment[((Timeline)this.res).moments.size()]));
            this.moments.setSelectedIndex(p);
            return;
        }
        if (but == this.delete) {
            String ttl;
            String msg;
            int r;
            int p = this.moments.getSelectedIndex();
            if (p == -1) {
                return;
            }
            if (((Timeline)this.res).moments.get((int)p).actions.size() != 0 && (r = JOptionPane.showConfirmDialog(this, msg = Messages.getString("TimelineFrame.MOM_DELETE"), ttl = Messages.getString("TimelineFrame.MOM_CONFIRM"), 0)) == 1) {
                return;
            }
            ((Timeline)this.res).moments.remove(p);
            this.moments.setListData((Moment[])((Timeline)this.res).moments.toArray(new Moment[((Timeline)this.res).moments.size()]));
            this.moments.setSelectedIndex(Math.min(((Timeline)this.res).moments.size() - 1, p));
            return;
        }
        if (but == this.showInfo) {
            this.showInfoFrame();
            return;
        }
        if (but == this.edit) {
            this.editSelectedMoment();
            return;
        }
        if (but == this.clear) {
            String ttl;
            if (((Timeline)this.res).moments.size() == 0) {
                return;
            }
            String msg = Messages.getString("TimelineFrame.MOM_CLEAR");
            int r = JOptionPane.showConfirmDialog(this, msg, ttl = Messages.getString("TimelineFrame.MOM_CONFIRM"), 0);
            if (r == 1) {
                return;
            }
            ((Timeline)this.res).moments.clear();
            this.moments.setListData((Moment[])((Timeline)this.res).moments.toArray(new Moment[((Timeline)this.res).moments.size()]));
        }
        if (but == this.shift) {
            if (((Timeline)this.res).moments.size() == 0) {
                return;
            }
            m = this.moments.getSelectedValue();
            int sn = m == null ? 0 : m.stepNo;
            String ttl = Messages.getString("TimelineFrame.MOM_SHIFT");
            JPanel pane = new JPanel(new GridLayout(0, 2));
            pane.add(new JLabel(Messages.getString("TimelineFrame.MOM_START")));
            NumberField iStart = new NumberField(sn);
            iStart.setPreferredSize(new Dimension(80, 20));
            pane.add(iStart);
            pane.add(new JLabel(Messages.getString("TimelineFrame.MOM_END")));
            NumberField iEnd = new NumberField(sn);
            iEnd.setPreferredSize(new Dimension(80, 20));
            pane.add(iEnd);
            pane.add(new JLabel(Messages.getString("TimelineFrame.MOM_AMOUNT")));
            NumberField iAmt = new NumberField(1);
            iAmt.setPreferredSize(new Dimension(80, 20));
            pane.add(iAmt);
            int ret = JOptionPane.showConfirmDialog(this, pane, ttl, 2);
            if (ret == 2) {
                return;
            }
            int p = ((Timeline)this.res).shiftMoments(iStart.getIntValue(), iEnd.getIntValue(), iAmt.getIntValue());
            this.moments.setListData((Moment[])((Timeline)this.res).moments.toArray(new Moment[((Timeline)this.res).moments.size()]));
            this.moments.setSelectedIndex(p);
            return;
        }
        if (but == this.merge) {
            if (((Timeline)this.res).moments.size() == 0) {
                return;
            }
            m = this.moments.getSelectedValue();
            int sn = m == null ? 0 : m.stepNo;
            String ttl = Messages.getString("TimelineFrame.MOM_MERGE");
            JPanel pane = new JPanel(new GridLayout(0, 2));
            pane.add(new JLabel(Messages.getString("TimelineFrame.MOM_START")));
            NumberField iStart = new NumberField(0, Integer.MAX_VALUE, sn);
            iStart.setPreferredSize(new Dimension(80, 20));
            pane.add(iStart);
            pane.add(new JLabel(Messages.getString("TimelineFrame.MOM_END")));
            NumberField iEnd = new NumberField(0, Integer.MAX_VALUE, sn);
            iEnd.setPreferredSize(new Dimension(80, 20));
            pane.add(iEnd);
            int ret = JOptionPane.showConfirmDialog(this, pane, ttl, 2);
            if (ret == 2) {
                return;
            }
            this.actions.save();
            int p = ((Timeline)this.res).mergeMoments(iStart.getIntValue(), iEnd.getIntValue());
            this.moments.setListData((Moment[])((Timeline)this.res).moments.toArray(new Moment[((Timeline)this.res).moments.size()]));
            this.moments.setSelectedIndex(p);
            return;
        }
        super.actionPerformed(e);
    }

    private void editSelectedMoment() {
        int p = this.moments.getSelectedIndex();
        if (p == -1) {
            return;
        }
        Action a = null;
        LibAction la = null;
        Boolean prependNew = true;
        int i = 0;
        while (i < this.actions.model.list.size()) {
            a = this.actions.model.list.get(i);
            la = a.getLibAction();
            if (la.actionKind == 7) {
                prependNew = false;
                break;
            }
            ++i;
        }
        if (prependNew.booleanValue()) {
            a = new Action(LibManager.codeAction);
            ((ActionList.ActionListModel)this.actions.getModel()).add(0, a);
            this.actions.setSelectedValue(a, true);
        }
        MDIFrame af = this.actions.openActionFrame((MDIFrame)this.actions.parent.get(), a);
        Moment momentitem = this.moments.getSelectedValue();
        af.setTitle(String.valueOf(this.name.getText()) + " : " + ((Object)momentitem).toString());
        af.setFrameIcon(LGM.getIconForKey("MomentNode.STEP"));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Moment m = this.moments.getSelectedValue();
        this.actions.setActionContainer(m);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = this.getContentPane().getSize();
        Dimension l = this.getContentPane().getMinimumSize();
        Dimension s = this.getSize();
        l.width += s.width - p.width;
        l.height += s.height - p.height;
        return l;
    }
}

