/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;
import org.lateralgm.components.EffectsFrame;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.impl.SpriteStripDialog;
import org.lateralgm.components.visual.SubimagePreview;
import org.lateralgm.file.FileChangeMonitor;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.main.FileChooser;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Sprite;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.propertylink.ComboBoxLink;
import org.lateralgm.ui.swing.util.SwingExecutor;
import org.lateralgm.util.PropertyMap;

public class SpriteFrame
extends InstantiableResourceFrame<Sprite, Sprite.PSprite>
implements UpdateSource.UpdateListener,
NumberField.ValueChangeListener,
ClipboardOwner,
EffectsFrame.EffectsFrameListener {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon PLAY_ICON = LGM.getIconForKey("SpriteFrame.PLAY");
    private static final ImageIcon STOP_ICON = LGM.getIconForKey("SpriteFrame.STOP");
    public JButton load;
    public JButton loadSubimages;
    public JButton loadStrip;
    public JButton saveSubimages;
    public JButton zoomIn;
    public JButton zoomOut;
    public JToggleButton zoomButton;
    public NumberField originX;
    public NumberField originY;
    public JButton centre;
    public NumberField bboxLeft;
    public NumberField bboxRight;
    public NumberField bboxTop;
    public NumberField bboxBottom;
    public JCheckBox smooth;
    public JCheckBox preload;
    public JCheckBox transparent;
    public JCheckBox separateMasks;
    public JLabel statusLabel;
    public JList<ImageIcon> subList;
    public JScrollPane previewScroll;
    public JScrollPane subimagesScroll;
    public SubimagePreview preview;
    public NumberField show;
    public NumberField speed;
    public JButton subLeft;
    public JButton subRight;
    public JButton play;
    public JButton cut;
    public JButton copy;
    public JButton paste;
    public JLabel showLab;
    public int currSub;
    public JCheckBox showBbox;
    public JCheckBox showOrigin;
    public JCheckBox wrapBox;
    public JCheckBox shiftBox;
    public boolean imageChanged = false;
    public JSplitPane splitPane;
    public Timer timer;
    private boolean updateSub = true;
    private final SpritePropertyListener spl = new SpritePropertyListener();
    private Map<BufferedImage, ImageEditor> editors;
    private MouseAdapter previewMouseAdapter;
    BufferedImage transparencyBackground = null;
    private static DataFlavor imgClipFlavor = new DataFlavor(ClipboardImages.class, "Buffered Images Clipboard");

    public SpriteFrame(Sprite res, ResNode node) {
        super(res, node);
        this.getRootPane().setDefaultButton(this.save);
        res.properties.getUpdateSource(Sprite.PSprite.BB_MODE).addListener(this.spl);
        res.reference.updateSource.addListener(this);
        this.setLayout(new BorderLayout());
        final JSplitPane previewPane = new JSplitPane(0, true, this.makePreviewPane(), this.makeSubimagesPane());
        previewPane.setResizeWeight(1.0);
        this.splitPane = new JSplitPane(1, true);
        Util.orientSplit(this.splitPane, Prefs.rightOrientation, this.makePropertiesPane(), previewPane);
        this.add((Component)this.splitPane, "Center");
        this.previewMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.getButton() == 1) {
                    SpriteFrame.this.preview.setCursor(LGM.zoomInCursor);
                }
                if (ev.getButton() == 3) {
                    SpriteFrame.this.preview.setCursor(LGM.zoomOutCursor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() == 1) {
                    SpriteFrame.this.preview.zoomIn(ev.getPoint(), SpriteFrame.this.previewScroll);
                }
                if (ev.getButton() == 3) {
                    SpriteFrame.this.preview.zoomOut(ev.getPoint(), SpriteFrame.this.previewScroll);
                }
                SpriteFrame.this.preview.setCursor(LGM.zoomCursor);
            }
        };
        this.updateImageList();
        this.updateStatusLabel();
        this.pack();
        this.setSize(this.getWidth(), 586);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                previewPane.setDividerLocation(0.6);
            }
        });
        this.updateScrollBars();
    }

    private JToolBar makeToolBar() {
        JToolBar tool = new JToolBar();
        tool.setFloatable(false);
        tool.setAlignmentX(0.0f);
        this.zoomButton = new JToggleButton(LGM.getIconForKey("SpriteFrame.ZOOM"));
        this.zoomButton.setToolTipText(Messages.getString("SpriteFrame.ZOOM"));
        this.zoomButton.addActionListener(this);
        tool.add(this.zoomButton);
        this.zoomIn = this.makeJButton("SpriteFrame.ZOOM_IN");
        this.zoomOut = this.makeJButton("SpriteFrame.ZOOM_OUT");
        tool.add(this.zoomIn);
        tool.add(this.zoomOut);
        tool.addSeparator();
        this.showBbox = new JCheckBox(Messages.getString("SpriteFrame.SHOW_BBOX"), true);
        this.showBbox.addActionListener(this);
        this.showBbox.setOpaque(false);
        tool.add(this.showBbox);
        this.showOrigin = new JCheckBox(Messages.getString("SpriteFrame.SHOW_ORIGIN"), true);
        this.showOrigin.addActionListener(this);
        this.showOrigin.setOpaque(false);
        tool.add(this.showOrigin);
        tool.addSeparator();
        JLabel lab2 = new JLabel(Messages.getString("SpriteFrame.ANIM_SPEED"));
        tool.add(lab2);
        this.speed = new NumberField(1, Integer.MAX_VALUE, 30);
        this.speed.setColumns(10);
        this.speed.setMaximumSize(this.speed.getPreferredSize());
        this.speed.setToolTipText(Messages.getString("SpriteFrame.CALC_TIP"));
        this.speed.addValueChangeListener(this);
        this.speed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiersEx() & 0x80) != 0) {
                    SpriteFrame.this.showSpeedDialog();
                    return;
                }
            }
        });
        tool.add(this.speed);
        this.play = new JButton(PLAY_ICON);
        this.play.addActionListener(this);
        tool.add(this.play);
        return tool;
    }

    private void updateStatusLabel() {
        String stat = " " + Messages.getString("SpriteFrame.WIDTH") + ": " + ((Sprite)this.res).getWidth() + " | " + Messages.getString("SpriteFrame.HEIGHT") + ": " + ((Sprite)this.res).getHeight() + " | " + Messages.getString("SpriteFrame.NO_OF_SUBIMAGES") + ": " + ((Sprite)this.res).subImages.size() + " | " + Messages.getString("SpriteFrame.MEMORY") + ": ";
        stat = ((Sprite)this.res).subImages != null ? String.valueOf(stat) + Util.formatDataSize(((Sprite)this.res).subImages.getSize()) : String.valueOf(stat) + Util.formatDataSize(0L);
        String zoom = new DecimalFormat("#,##0.##").format(this.getZoom() * 100.0);
        stat = String.valueOf(stat) + " | " + Messages.getString("SpriteFrame.ZOOM") + ": " + zoom + "%";
        this.statusLabel.setText(stat);
    }

    private JPanel makeStatusBar() {
        JPanel status = new JPanel(new FlowLayout());
        BoxLayout layout = new BoxLayout(status, 0);
        status.setLayout(layout);
        status.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
        this.statusLabel = new JLabel();
        status.add(this.statusLabel);
        return status;
    }

    private JPanel makeOriginPane() {
        JPanel pane = new JPanel();
        GroupLayout oLayout = new GroupLayout(pane);
        oLayout.setAutoCreateGaps(true);
        pane.setLayout(oLayout);
        pane.setBorder(BorderFactory.createTitledBorder(Messages.getString("SpriteFrame.ORIGIN")));
        JLabel oxLab = new JLabel(Messages.getString("SpriteFrame.X"));
        oxLab.setHorizontalAlignment(4);
        this.originX = new NumberField(0);
        this.originX.setColumns(4);
        this.plf.make(this.originX, Sprite.PSprite.ORIGIN_X);
        JLabel oyLab = new JLabel(Messages.getString("SpriteFrame.Y"));
        oyLab.setHorizontalAlignment(4);
        this.originY = new NumberField(0);
        this.originY.setColumns(4);
        this.plf.make(this.originY, Sprite.PSprite.ORIGIN_Y);
        this.centre = new JButton(Messages.getString("SpriteFrame.CENTER"));
        this.centre.addActionListener(this);
        oLayout.setHorizontalGroup(oLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(oLayout.createSequentialGroup().addGap(12).addComponent(oxLab).addGap(4).addComponent(this.originX).addGap(12).addComponent(oyLab).addGap(4).addComponent(this.originY).addGap(12)).addComponent(this.centre));
        oLayout.setVerticalGroup(oLayout.createSequentialGroup().addGroup(oLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(oxLab).addComponent(this.originX).addComponent(oyLab).addComponent(this.originY)).addGap(8).addComponent(this.centre).addGap(8));
        return pane;
    }

    private JPanel makeCollisionPane() {
        JPanel pane = new JPanel();
        GroupLayout cLayout = new GroupLayout(pane);
        cLayout.setAutoCreateGaps(true);
        cLayout.setAutoCreateContainerGaps(true);
        pane.setLayout(cLayout);
        pane.setBorder(BorderFactory.createTitledBorder(Messages.getString("SpriteFrame.MASK")));
        JLabel toleranceLabel = new JLabel(Messages.getString("SpriteFrame.ALPHA_TOLERANCE"));
        NumberField tolerance = new NumberField(0, 255);
        this.plf.make(tolerance, Sprite.PSprite.ALPHA_TOLERANCE);
        JSlider toleranceSlider = new JSlider(0, 255);
        this.plf.make(toleranceSlider.getModel(), Sprite.PSprite.ALPHA_TOLERANCE);
        String[] bboxOptions = new String[]{"SpriteFrame.AUTO", "SpriteFrame.FULL", "SpriteFrame.MANUAL"};
        Messages.translate(bboxOptions);
        JLabel bboxLabel = new JLabel(Messages.getString("SpriteFrame.MASK_MODE"));
        JComboBox<String> bboxCombo = new JComboBox<String>(bboxOptions);
        this.plf.make(bboxCombo, Sprite.PSprite.BB_MODE, new ComboBoxLink.KeyComboBoxConversion<Sprite.BBMode>(ProjectFile.SPRITE_BB_MODE, ProjectFile.SPRITE_BB_CODE));
        String[] shapeOptions = new String[]{"SpriteFrame.PRECISE", "SpriteFrame.RECTANGLE", "SpriteFrame.DISK", "SpriteFrame.DIAMOND"};
        Messages.translate(shapeOptions);
        JLabel shapeLabel = new JLabel(Messages.getString("SpriteFrame.MASK_TYPE"));
        JComboBox<String> shapeCombo = new JComboBox<String>(shapeOptions);
        this.plf.make(shapeCombo, Sprite.PSprite.SHAPE, new ComboBoxLink.KeyComboBoxConversion<Sprite.MaskShape>(ProjectFile.SPRITE_MASK_SHAPE, ProjectFile.SPRITE_MASK_CODE));
        JLabel lLab = new JLabel(Messages.getString("SpriteFrame.LEFT"));
        lLab.setHorizontalAlignment(4);
        this.bboxLeft = new NumberField(0);
        this.bboxLeft.setColumns(3);
        this.plf.make(this.bboxLeft, Sprite.PSprite.BB_LEFT);
        JLabel rLab = new JLabel(Messages.getString("SpriteFrame.RIGHT"));
        rLab.setHorizontalAlignment(4);
        this.bboxRight = new NumberField(0);
        this.bboxRight.setColumns(3);
        this.plf.make(this.bboxRight, Sprite.PSprite.BB_RIGHT);
        JLabel tLab = new JLabel(Messages.getString("SpriteFrame.TOP"));
        tLab.setHorizontalAlignment(4);
        this.bboxTop = new NumberField(0);
        this.bboxTop.setColumns(3);
        this.plf.make(this.bboxTop, Sprite.PSprite.BB_TOP);
        JLabel bLab = new JLabel(Messages.getString("SpriteFrame.BOTTOM"));
        bLab.setHorizontalAlignment(4);
        this.bboxBottom = new NumberField(0);
        this.bboxBottom.setColumns(3);
        this.plf.make(this.bboxBottom, Sprite.PSprite.BB_BOTTOM);
        this.updateBoundingBoxEditors();
        cLayout.setHorizontalGroup(cLayout.createParallelGroup().addGroup(cLayout.createSequentialGroup().addGroup(cLayout.createParallelGroup().addComponent(bboxLabel).addComponent(shapeLabel)).addGroup(cLayout.createParallelGroup().addComponent(bboxCombo).addComponent(shapeCombo))).addGroup(cLayout.createSequentialGroup().addComponent(toleranceLabel)).addGroup(cLayout.createSequentialGroup().addComponent(toleranceSlider, 0, 0, Short.MAX_VALUE).addComponent(tolerance, -2, -2, -2)).addGroup(cLayout.createSequentialGroup().addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lLab).addComponent(tLab)).addGroup(cLayout.createParallelGroup().addComponent(this.bboxLeft, -2, -2, -1).addComponent(this.bboxTop, -2, -2, -1)).addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(rLab).addComponent(bLab)).addGroup(cLayout.createParallelGroup().addComponent(this.bboxRight, -2, -2, -1).addComponent(this.bboxBottom, -2, -2, -1))));
        cLayout.setVerticalGroup(cLayout.createSequentialGroup().addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(bboxLabel).addComponent(bboxCombo, -2, -2, -2)).addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(shapeLabel).addComponent(shapeCombo, -2, -2, -2)).addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(toleranceLabel)).addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(toleranceSlider).addComponent(tolerance, -2, -2, -2)).addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lLab).addComponent(this.bboxLeft).addComponent(rLab).addComponent(this.bboxRight)).addGroup(cLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(tLab).addComponent(this.bboxTop).addComponent(bLab).addComponent(this.bboxBottom)));
        return pane;
    }

    private JPanel makePropertiesPane() {
        JPanel pane = new JPanel();
        GroupLayout layout = new GroupLayout(pane);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        pane.setLayout(layout);
        this.smooth = new JCheckBox(Messages.getString("SpriteFrame.SMOOTH"));
        this.plf.make(this.smooth, Sprite.PSprite.SMOOTH_EDGES);
        this.preload = new JCheckBox(Messages.getString("SpriteFrame.PRELOAD"));
        this.plf.make(this.preload, Sprite.PSprite.PRELOAD);
        this.transparent = new JCheckBox(Messages.getString("SpriteFrame.TRANSPARENT"));
        this.transparent.setToolTipText(Messages.getString("SpriteFrame.TRANSP_TIP"));
        this.plf.make(this.transparent, Sprite.PSprite.TRANSPARENT);
        this.separateMasks = new JCheckBox(Messages.getString("SpriteFrame.SEPARATE"));
        this.separateMasks.setToolTipText(Messages.getString("SpriteFrame.SEPARATE_TIP"));
        this.plf.make(this.separateMasks, Sprite.PSprite.SEPARATE_MASK);
        JPanel origin = this.makeOriginPane();
        JPanel mask = this.makeCollisionPane();
        JLabel nameLabel = new JLabel(Messages.getString("SpriteFrame.NAME"));
        this.save.setText(Messages.getString("SpriteFrame.SAVE"));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(nameLabel).addComponent(this.name, -1, 120, Integer.MAX_VALUE)).addComponent(this.smooth).addComponent(this.preload).addComponent(this.transparent).addComponent(this.separateMasks).addComponent(origin).addComponent(mask).addComponent(this.save, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.name)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.smooth).addComponent(this.preload).addComponent(this.transparent).addComponent(this.separateMasks).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(origin).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(mask).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 0, Integer.MAX_VALUE).addComponent(this.save));
        return pane;
    }

    private JButton makeJButton(String key) {
        JButton but = new JButton(LGM.getIconForKey(key));
        but.setToolTipText(Messages.getString(key));
        but.addActionListener(this);
        but.setActionCommand(key);
        return but;
    }

    private JMenuItem makeJMenuItem(String key) {
        JMenuItem but = new JMenuItem(LGM.getIconForKey(key));
        but.setText(Messages.getString(key));
        but.addActionListener(this);
        but.setActionCommand(key);
        return but;
    }

    private JPanel makeSubimagesPane() {
        JPanel pane = new JPanel(new BorderLayout());
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.makeJMenuItem("SpriteFrame.EDIT"));
        popup.addSeparator();
        popup.add(this.makeJMenuItem("SpriteFrame.SELECT_ALL"));
        JToolBar tool = new JToolBar();
        tool.setFloatable(false);
        pane.add((Component)tool, "North");
        this.load = this.makeJButton("SpriteFrame.LOAD");
        this.loadSubimages = this.makeJButton("SpriteFrame.LOAD_SUBIMAGE");
        this.loadStrip = this.makeJButton("SpriteFrame.LOAD_STRIP");
        this.saveSubimages = this.makeJButton("SpriteFrame.SAVE_SUBIMAGE");
        tool.add(this.makeJButton("SpriteFrame.ADD"));
        tool.add(this.load);
        tool.add(this.loadSubimages);
        tool.add(this.loadStrip);
        tool.add(this.saveSubimages);
        tool.addSeparator();
        tool.add(this.makeJButton("SpriteFrame.REMOVE"));
        tool.addSeparator();
        tool.add(this.makeJButton("SpriteFrame.EDIT"));
        tool.add(this.makeJButton("SpriteFrame.EFFECT"));
        tool.addSeparator();
        tool.add(this.makeJButton("SpriteFrame.CUT"));
        tool.add(this.makeJButton("SpriteFrame.COPY"));
        tool.add(this.makeJButton("SpriteFrame.PASTE"));
        tool.addSeparator();
        this.subLeft = new JButton(LGM.getIconForKey("SpriteFrame.PREVIOUS"));
        this.subLeft.addActionListener(this);
        tool.add(this.subLeft);
        this.show = new NumberField(0, ((Sprite)this.res).subImages.size() - 1);
        this.show.setHorizontalAlignment(0);
        this.show.addValueChangeListener(this);
        this.show.setColumns(4);
        this.show.setMaximumSize(this.show.getPreferredSize());
        this.show.setMinimumSize(this.show.getPreferredSize());
        tool.add(this.show);
        this.subRight = new JButton(LGM.getIconForKey("SpriteFrame.NEXT"));
        this.subRight.addActionListener(this);
        tool.add(this.subRight);
        this.shiftBox = new JCheckBox(Messages.getString("SpriteFrame.SHIFT"), true);
        this.shiftBox.setSelected(false);
        this.shiftBox.setOpaque(false);
        tool.add(this.shiftBox);
        this.wrapBox = new JCheckBox(Messages.getString("SpriteFrame.WRAP"), true);
        this.wrapBox.setOpaque(false);
        this.wrapBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (!SpriteFrame.this.wrapBox.isSelected()) {
                    SpriteFrame.this.subLeft.setEnabled(SpriteFrame.this.timer == null && SpriteFrame.this.currSub > 0);
                    SpriteFrame.this.subRight.setEnabled(SpriteFrame.this.timer == null && SpriteFrame.this.currSub < ((Sprite)SpriteFrame.this.res).subImages.size() - 1);
                } else {
                    SpriteFrame.this.subLeft.setEnabled(true);
                    SpriteFrame.this.subRight.setEnabled(true);
                }
            }
        });
        tool.add(this.wrapBox);
        this.subList = new JList();
        this.subList.setLayoutOrientation(2);
        this.subList.setVisibleRowCount(-1);
        this.subList.setBackground(Color.LIGHT_GRAY);
        this.subList.setDragEnabled(true);
        this.subList.setDropMode(DropMode.INSERT);
        this.subList.setTransferHandler(new SubImageTransfer());
        this.subList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object s = e.getSource();
                if (e.getClickCount() == 2 && s == SpriteFrame.this.subList) {
                    int i = SpriteFrame.this.subList.getSelectedIndex();
                    if (i == -1 || i >= ((Sprite)SpriteFrame.this.res).subImages.size()) {
                        return;
                    }
                    SpriteFrame.this.editSubimage((BufferedImage)((Sprite)SpriteFrame.this.res).subImages.get(i));
                }
            }
        });
        this.subList.setDragEnabled(true);
        this.subList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                EffectsFrame.getInstance().setEffectsListener(SpriteFrame.this, SpriteFrame.this.getSelectedImages());
                int ind = SpriteFrame.this.subList.getSelectedIndex();
                if (ind < 0) {
                    return;
                }
                if (SpriteFrame.this.timer == null) {
                    SpriteFrame.this.setSubIndex(ind);
                }
            }
        });
        this.subList.setCellRenderer(new ImageCellRenderer(this.subList));
        this.subList.setComponentPopupMenu(popup);
        this.subimagesScroll = new JScrollPane(this.subList);
        this.subimagesScroll.getVerticalScrollBar().setUnitIncrement(0);
        this.subimagesScroll.getHorizontalScrollBar().setUnitIncrement(0);
        this.subimagesScroll.setHorizontalScrollBarPolicy(31);
        pane.add((Component)this.subimagesScroll, "Center");
        pane.add((Component)this.makeStatusBar(), "South");
        return pane;
    }

    private JPanel makePreviewPane() {
        JPanel pane = new JPanel(new BorderLayout());
        this.preview = new SubimagePreview((Sprite)this.res);
        this.previewScroll = new JScrollPane(this.preview);
        this.previewScroll.setPreferredSize(this.previewScroll.getSize());
        pane.add((Component)this.makeToolBar(), "North");
        pane.add((Component)this.previewScroll, "Center");
        return pane;
    }

    private void showSpeedDialog() {
        JPanel p = new JPanel();
        GroupLayout layout = new GroupLayout(p);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(false);
        p.setLayout(layout);
        JLabel caption = new JLabel(Messages.getString("SpriteFrame.CALC_CAPTION"));
        JLabel lrs = new JLabel(Messages.getString("SpriteFrame.CALC_ROOM_SPEED"));
        JLabel lis = new JLabel(Messages.getString("SpriteFrame.CALC_IMAGE_SPEED"));
        NumberField rs = new NumberField(1, Integer.MAX_VALUE, (int)this.speed.getIntValue());
        JTextField is = new JTextField("1.0");
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(caption, GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(lrs).addComponent(lis)).addGap(5).addGroup(layout.createParallelGroup().addComponent(rs).addComponent(is))));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(caption).addGap(5).addGroup(layout.createParallelGroup().addComponent(lrs).addComponent(rs)).addGroup(layout.createParallelGroup().addComponent(lis).addComponent(is)));
        JOptionPane.showMessageDialog(this, p);
        int i = rs.getIntValue();
        double d = 1.0;
        try {
            d = Double.parseDouble(is.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.speed.setValue((int)((double)i * d));
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return !this.imageChanged;
    }

    @Override
    public void commitChanges() {
        ((Sprite)this.res).setName(this.name.getText());
    }

    @Override
    public void updateResource(boolean commit) {
        super.updateResource(commit);
        this.imageChanged = false;
    }

    @Override
    public void valueChange(NumberField.ValueChangeEvent e) {
        if (e.getSource() == this.show) {
            this.subList.setSelectedIndex(this.show.getIntValue());
            return;
        }
        if (e.getSource() == this.speed) {
            if (this.timer != null) {
                this.timer.setDelay(1000 / this.speed.getIntValue());
            }
            return;
        }
    }

    private BufferedImage createNewImage(boolean askforsize) {
        int width = ((Sprite)this.res).getWidth();
        int height = ((Sprite)this.res).getHeight();
        if (width == 0 || height == 0) {
            width = 32;
            height = 32;
        }
        if (askforsize) {
            NumberFormatter nf = new NumberFormatter();
            nf.setMinimum(Integer.valueOf(1));
            JFormattedTextField wField = new JFormattedTextField(nf);
            wField.setValue(width);
            JFormattedTextField hField = new JFormattedTextField(nf);
            hField.setValue(height);
            JPanel myPanel = new JPanel();
            GridLayout layout = new GridLayout(0, 2, 0, 3);
            myPanel.setLayout(layout);
            myPanel.add(new JLabel(Messages.getString("SpriteFrame.NEW_WIDTH")));
            myPanel.add(wField);
            myPanel.add(new JLabel(Messages.getString("SpriteFrame.NEW_HEIGHT")));
            myPanel.add(hField);
            int result = JOptionPane.showConfirmDialog(this, myPanel, Messages.getString("SpriteFrame.NEW_TITLE"), 2, -1);
            if (result == 2) {
                return null;
            }
            width = (Integer)wField.getValue();
            height = (Integer)hField.getValue();
        }
        BufferedImage bi = new BufferedImage(width, height, 2);
        this.imageChanged = true;
        return bi;
    }

    public void editActionsPerformed(String cmd) {
        int pos = this.subList.getSelectedIndex();
        int n = pos = pos >= 0 ? pos + 1 : ((Sprite)this.res).subImages.size();
        if (cmd.endsWith(".SELECT_ALL")) {
            this.subList.setSelectionInterval(0, ((Sprite)this.res).subImages.size() - 1);
            return;
        }
        if (cmd.endsWith(".CUT")) {
            int[] selections = this.subList.getSelectedIndices();
            if (selections.length == 0) {
                return;
            }
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(selections.length);
            int i = 0;
            while (i < selections.length) {
                images.add((BufferedImage)((Sprite)this.res).subImages.get(selections[i] - i));
                ((Sprite)this.res).subImages.remove(selections[i] - i);
                ++i;
            }
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new TransferableImages(new ClipboardImages(images)), this);
            this.imageChanged = true;
            return;
        }
        if (cmd.endsWith(".COPY")) {
            int[] selections = this.subList.getSelectedIndices();
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(selections.length);
            int i = 0;
            while (i < selections.length) {
                images.add((BufferedImage)((Sprite)this.res).subImages.get(selections[i]));
                ++i;
            }
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new TransferableImages(new ClipboardImages(images)), this);
            return;
        }
        if (cmd.endsWith(".PASTE")) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(this);
            if (content.isDataFlavorSupported(imgClipFlavor)) {
                ClipboardImages images = null;
                try {
                    images = (ClipboardImages)content.getTransferData(imgClipFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    LGM.showDefaultExceptionHandler(e);
                }
                catch (IOException e) {
                    LGM.showDefaultExceptionHandler(e);
                }
                this.imageChanged = true;
                int i = 0;
                while (i < images.bi.size()) {
                    ((Sprite)this.res).subImages.add(pos + i, Util.cloneImage(images.bi.get(i)));
                    ++i;
                }
                this.subList.setSelectionInterval(pos, pos + images.bi.size() - 1);
            }
            return;
        }
        if (cmd.endsWith(".ADD")) {
            BufferedImage bi = this.createNewImage(((Sprite)this.res).subImages.size() == 0);
            if (bi != null) {
                this.imageChanged = true;
                ((Sprite)this.res).subImages.add(pos, bi);
                this.subList.setSelectedIndex(pos);
                this.setSubIndex(pos);
            }
            return;
        }
        if (cmd.endsWith(".EDIT")) {
            int[] selections = this.subList.getSelectedIndices();
            int i = 0;
            while (i < selections.length) {
                this.editSubimage((BufferedImage)((Sprite)this.res).subImages.get(selections[i]));
                ++i;
            }
            return;
        }
        if (cmd.endsWith(".EFFECT")) {
            EffectsFrame ef = EffectsFrame.getInstance();
            ef.setEffectsListener(this, this.getSelectedImages());
            ef.setVisible(true);
        } else if (cmd.endsWith(".REMOVE")) {
            int[] selections = this.subList.getSelectedIndices();
            int i = 0;
            while (i < selections.length) {
                ImageEditor ie = this.editors == null ? null : this.editors.get(((Sprite)this.res).subImages.get(selections[i] - i));
                this.imageChanged = true;
                ((Sprite)this.res).subImages.remove(selections[i] - i);
                if (ie != null) {
                    ie.stop();
                }
                ++i;
            }
            this.subList.setSelectedIndex(Math.min(((Sprite)this.res).subImages.size() - 1, pos));
            return;
        }
    }

    public double getZoom() {
        return this.preview.getZoom();
    }

    public void setZoom(double nzoom) {
        this.preview.setZoom(nzoom);
        this.updateStatusLabel();
        this.updateScrollBars();
    }

    public ArrayList<BufferedImage> getSelectedImages() {
        int[] selected = this.subList.getSelectedIndices();
        if (selected.length <= 0) {
            return ((Sprite)this.res).subImages;
        }
        if (((Sprite)this.res).subImages.getSize() <= 0L) {
            return null;
        }
        ArrayList<BufferedImage> subimages = new ArrayList<BufferedImage>(selected.length);
        int[] nArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            subimages.add((BufferedImage)((Sprite)this.res).subImages.get(id));
            ++n2;
        }
        return subimages;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd != null) {
            this.editActionsPerformed(cmd);
        }
        int pos = this.subList.getSelectedIndex();
        if (e.getSource() == this.load) {
            BufferedImage[] img = Util.getValidImages();
            if (img != null) {
                this.addSubimages(img, true);
            }
            return;
        }
        if (e.getSource() == this.loadStrip) {
            this.addFromStrip(false);
            return;
        }
        if (e.getSource() == this.loadSubimages) {
            BufferedImage[] img = Util.getValidImages();
            if (img != null) {
                this.addSubimages(img, false);
            }
            return;
        }
        if (e.getSource() == this.saveSubimages) {
            ArrayList<BufferedImage> imgs = this.getSelectedImages();
            if (imgs != null) {
                Util.saveImages(imgs);
            }
            return;
        }
        if (e.getSource() == this.showBbox) {
            this.preview.setShowBbox(this.showBbox.isSelected());
            return;
        }
        if (e.getSource() == this.showOrigin) {
            this.preview.setShowOrigin(this.showOrigin.isSelected());
            return;
        }
        if (e.getSource() == this.subLeft) {
            if (pos <= 0 && !this.wrapBox.isSelected()) {
                this.subList.setSelectedIndex(this.currSub - 1);
                return;
            }
            if (this.shiftBox.isSelected()) {
                int[] selections = this.subList.getSelectedIndices();
                int i = 0;
                while (i < selections.length) {
                    pos = selections[i];
                    BufferedImage bi = ((Sprite)this.res).subImages.remove(pos);
                    if (pos <= 0 && this.wrapBox.isSelected()) {
                        pos = ((Sprite)this.res).subImages.size() + 1;
                    }
                    ((Sprite)this.res).subImages.add(pos - 1, bi);
                    ++i;
                }
                this.imageChanged = true;
                this.subList.setSelectedIndex(pos - 1);
            } else if (this.currSub > 0) {
                this.subList.setSelectedIndex(this.currSub - 1);
            } else if (this.wrapBox.isSelected()) {
                this.subList.setSelectedIndex(((Sprite)this.res).subImages.size() - 1);
            }
            return;
        }
        if (e.getSource() == this.subRight) {
            if (pos >= ((Sprite)this.res).subImages.size() - 1 && !this.wrapBox.isSelected()) {
                this.subList.setSelectedIndex(((Sprite)this.res).subImages.size());
                return;
            }
            if (this.shiftBox.isSelected()) {
                int[] selections = this.subList.getSelectedIndices();
                int i = 0;
                while (i < selections.length) {
                    pos = selections[i];
                    this.preview.setIndex(pos);
                    BufferedImage bi = ((Sprite)this.res).subImages.remove(pos);
                    if (pos > ((Sprite)this.res).subImages.size() - 1 && this.wrapBox.isSelected()) {
                        pos = -1;
                    }
                    ((Sprite)this.res).subImages.add(pos + 1, bi);
                    ++i;
                }
                this.imageChanged = true;
                this.subList.setSelectedIndex(pos + 1);
            } else if (this.currSub < ((Sprite)this.res).subImages.size() - 1) {
                this.subList.setSelectedIndex(this.currSub + 1);
            } else if (this.wrapBox.isSelected()) {
                this.subList.setSelectedIndex(0);
            }
            return;
        }
        if (e.getSource() == this.zoomButton) {
            if (this.zoomButton.isSelected()) {
                this.preview.enableMouse = false;
                this.preview.setCursor(LGM.zoomCursor);
                this.preview.addMouseListener(this.previewMouseAdapter);
            } else {
                this.preview.enableMouse = true;
                this.preview.removeMouseListener(this.previewMouseAdapter);
                this.preview.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            if (e.getSource() == this.zoomIn) {
                this.preview.zoomIn(this.previewScroll);
                return;
            }
            if (e.getSource() == this.zoomOut) {
                this.preview.zoomOut(this.previewScroll);
                return;
            }
            if (e.getSource() == this.play) {
                if (this.timer != null) {
                    this.play.setIcon(PLAY_ICON);
                    this.stopAnimation();
                    this.updateImageControls();
                } else if (((Sprite)this.res).subImages.size() > 1) {
                    this.play.setIcon(STOP_ICON);
                    this.timer = new Timer(1000 / this.speed.getIntValue(), this);
                    this.timer.start();
                    this.updateImageControls();
                }
                return;
            }
            if (e.getSource() == this.timer) {
                int s = ((Sprite)this.res).subImages.size();
                if (s > 0) {
                    this.setSubIndex((this.currSub + 1) % s);
                }
                return;
            }
            if (e.getSource() == this.centre) {
                ((Sprite)this.res).put(Sprite.PSprite.ORIGIN_X, ((Sprite)this.res).getWidth() / 2);
                ((Sprite)this.res).put(Sprite.PSprite.ORIGIN_Y, ((Sprite)this.res).getHeight() / 2);
                return;
            }
        }
        super.actionPerformed(e);
    }

    private void realizeScrollBarIncrement(JScrollPane scroll) {
        JScrollBar vertical = scroll.getVerticalScrollBar();
        JScrollBar horizontal = scroll.getHorizontalScrollBar();
        if (vertical != null) {
            vertical.setUnitIncrement((int)this.getZoom());
        }
        if (horizontal != null) {
            horizontal.setUnitIncrement((int)this.getZoom());
        }
    }

    private void updateScrollBars() {
        this.realizeScrollBarIncrement(this.previewScroll);
        this.realizeScrollBarIncrement(this.subimagesScroll);
    }

    public void addSubimages(BufferedImage[] img, boolean clear) {
        if (img.length == 0) {
            return;
        }
        if (clear) {
            this.cleanup();
            ((Sprite)this.res).subImages.clear();
        }
        clear = ((Sprite)this.res).subImages.isEmpty();
        this.imageChanged = true;
        BufferedImage[] bufferedImageArray = img;
        int n = img.length;
        int n2 = 0;
        while (n2 < n) {
            BufferedImage i = bufferedImageArray[n2];
            ((Sprite)this.res).subImages.add(i);
            ++n2;
        }
        this.show.setRange(0, ((Sprite)this.res).subImages.size());
        if (clear) {
            this.setSubIndex(0);
        }
        this.updateStatusLabel();
        this.updateScrollBars();
    }

    public void addFromStrip(boolean clear) {
        BufferedImage bi = Util.getValidImage();
        if (bi == null) {
            return;
        }
        SpriteStripDialog d = new SpriteStripDialog((Frame)LGM.frame, bi);
        d.setLocationRelativeTo(LGM.frame);
        d.setVisible(true);
        BufferedImage[] img = d.getStrip();
        if (img == null) {
            return;
        }
        this.addSubimages(img, clear);
    }

    private void stopAnimation() {
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        this.timer = null;
    }

    private void updateImageControls() {
        int s = ((Sprite)this.res).subImages.size();
        if (s > 0) {
            if (this.subList.getSelectedIndex() > s) {
                this.setSubIndex(s - 1);
                return;
            }
            if (!this.wrapBox.isSelected()) {
                this.subLeft.setEnabled(this.timer == null && this.subList.getSelectedIndex() > 0);
                this.subRight.setEnabled(this.timer == null && this.subList.getSelectedIndex() < s - 1);
            } else {
                this.subLeft.setEnabled(this.timer == null);
                this.subRight.setEnabled(this.timer == null);
            }
            this.play.setEnabled(s > 1);
            if (this.updateSub) {
                try {
                    this.show.setRange(0, s - 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.show.setEnabled(this.timer == null);
            }
        } else {
            this.subLeft.setEnabled(false);
            this.subRight.setEnabled(false);
            this.play.setEnabled(false);
            if (this.updateSub) {
                this.show.setValue(0);
                this.show.setEnabled(false);
            }
        }
    }

    private void updateImageList() {
        ImageIcon[] ii = new ImageIcon[((Sprite)this.res).subImages.size()];
        int maxWidth = -1;
        int i = 0;
        while (i < ((Sprite)this.res).subImages.size()) {
            ii[i] = new ImageIcon((Image)((Sprite)this.res).subImages.get(i));
            maxWidth = Math.max(maxWidth, ii[i].getIconWidth());
            ++i;
        }
        this.subList.setListData((ImageIcon[])ii);
        this.updateImageControls();
    }

    private void setSubIndex(int i) {
        if (this.currSub == i) {
            return;
        }
        this.currSub = i;
        this.preview.setIndex(i);
        if (this.timer == null) {
            this.updateImageControls();
        }
    }

    private void updateBoundingBoxEditors() {
        boolean m = ((Sprite)this.res).get(Sprite.PSprite.BB_MODE) == Sprite.BBMode.MANUAL;
        this.bboxLeft.setEnabled(m);
        this.bboxRight.setEnabled(m);
        this.bboxTop.setEnabled(m);
        this.bboxBottom.setEnabled(m);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = this.getContentPane().getSize();
        Dimension l = this.getContentPane().getMinimumSize();
        Dimension s = this.getSize();
        l.width += s.width - p.width;
        l.height += s.height - p.height;
        return l;
    }

    public void editSubimage(BufferedImage img) {
        if (img == null) {
            return;
        }
        try {
            ImageEditor ie;
            ImageEditor imageEditor = ie = this.editors == null ? null : this.editors.get(img);
            if (ie == null) {
                new ImageEditor(img);
            } else {
                ie.start();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        this.updateStatusLabel();
        this.updateImageList();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.stopAnimation();
        this.cleanup();
    }

    protected void cleanup() {
        if (this.editors != null) {
            Iterator<ImageEditor> it = this.editors.values().iterator();
            while (it.hasNext()) {
                ImageEditor ie = it.next();
                it.remove();
                ie.stop();
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
        System.out.println("Sprite editor has lost clipboard ownership.");
    }

    @Override
    public void applyEffects(List<BufferedImage> imgs) {
        int[] selection = this.subList.getSelectedIndices();
        int i = 0;
        while (i < selection.length) {
            ((Sprite)this.res).subImages.set(selection[i], imgs.get(i));
            ++i;
        }
        this.imageChanged = true;
        this.subList.setSelectedIndices(selection);
        this.preview.repaint();
    }

    private static class ClipboardImages {
        List<BufferedImage> bi;

        public ClipboardImages(List<BufferedImage> images) {
            this.bi = images;
        }
    }

    public class ImageCellRenderer
    implements ListCellRenderer<ImageIcon> {
        private final JList<ImageIcon> list;

        public ImageCellRenderer(JList<ImageIcon> l) {
            this.list = l;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ImageIcon> genericlist, ImageIcon value, int index, boolean isSelected, boolean hasFocus) {
            JPanel p = new JPanel(new BorderLayout(0, 0));
            ImageLabel l = new ImageLabel();
            BufferedImage img = (BufferedImage)((Sprite)SpriteFrame.this.res).subImages.get(index);
            if (img == null) {
                return null;
            }
            int imgwidth = img.getWidth();
            int imgheight = img.getHeight();
            int width = 64;
            int height = 64;
            if (imgheight < imgwidth) {
                width = (int)((float)height / (float)imgheight * (float)imgwidth);
            } else if (imgwidth < imgheight) {
                height = (int)((float)width / (float)imgwidth * (float)imgheight);
            }
            l.setPreferredSize(new Dimension(width + 1, height + 1));
            if (((Boolean)((Sprite)SpriteFrame.this.res).get(Sprite.PSprite.TRANSPARENT)).booleanValue()) {
                img = Util.getTransparentImage(img);
            }
            int bwidth = (int)Math.ceil((float)width / 10.0f);
            int bheight = (int)Math.ceil((float)height / 10.0f);
            bwidth = bwidth < 1 ? 1 : bwidth;
            int n = bheight = bheight < 1 ? 1 : bheight;
            if (SpriteFrame.this.transparencyBackground == null || SpriteFrame.this.transparencyBackground.getWidth() != bwidth || SpriteFrame.this.transparencyBackground.getHeight() != bheight) {
                SpriteFrame.this.transparencyBackground = Util.paintBackground(bwidth, bheight);
            }
            BufferedImage cimg = new BufferedImage(width, height, 2);
            Graphics2D g = cimg.createGraphics();
            g.drawImage(SpriteFrame.this.transparencyBackground, 0, 0, bwidth * 10, bheight * 10, null);
            g.drawImage(img, 0, 0, width, height, null);
            g.dispose();
            l.img = cimg;
            l.index = index;
            l.list = this.list;
            p.add(l);
            return p;
        }
    }

    private class ImageEditor
    implements UpdateSource.UpdateListener {
        private BufferedImage image;
        private FileChangeMonitor monitor;
        private File f;

        public ImageEditor(BufferedImage i) throws IOException, UnsupportedOperationException {
            this.image = i;
            if (SpriteFrame.this.editors == null) {
                SpriteFrame.this.editors = new HashMap();
            }
            SpriteFrame.this.editors.put(i, this);
            this.start();
        }

        public void start() throws IOException, UnsupportedOperationException {
            if (this.monitor != null) {
                this.monitor.stop();
            }
            if (this.f == null || !this.f.exists()) {
                this.f = File.createTempFile(((Sprite)SpriteFrame.this.res).getName(), String.valueOf('.') + Prefs.externalSpriteExtension, LGM.tempDir);
                this.f.deleteOnExit();
            }
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream out = new FileOutputStream(this.f);){
                ImageIO.write((RenderedImage)this.image, Prefs.externalSpriteExtension, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.monitor = new FileChangeMonitor(this.f, (Executor)SwingExecutor.INSTANCE);
            this.monitor.updateSource.addListener(this, true);
            if (!Prefs.useExternalSpriteEditor || Prefs.externalSpriteEditorCommand == null) {
                Util.OpenDesktopEditor(this.monitor.file);
            } else {
                Runtime.getRuntime().exec(String.format(Prefs.externalSpriteEditorCommand, this.monitor.file.getAbsolutePath()));
            }
        }

        public void stop() {
            this.monitor.stop();
            this.monitor.file.delete();
            if (SpriteFrame.this.editors != null) {
                SpriteFrame.this.editors.remove(this.image);
            }
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            if (!(e instanceof FileChangeMonitor.FileUpdateEvent)) {
                return;
            }
            switch (((FileChangeMonitor.FileUpdateEvent)e).flag) {
                case CHANGED: {
                    BufferedImage img;
                    try {
                        Throwable throwable = null;
                        Object var4_5 = null;
                        try (FileInputStream stream = new FileInputStream(this.monitor.file);){
                            img = ImageIO.read(stream);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ioe) {
                        LGM.showDefaultExceptionHandler(ioe);
                        return;
                    }
                    ((Sprite)SpriteFrame.this.res).subImages.replace(this.image, img);
                    SpriteFrame.this.editors.remove(this.image);
                    SpriteFrame.this.editors.put(img, this);
                    this.image = img;
                    SpriteFrame.this.imageChanged = true;
                    break;
                }
                case DELETED: {
                    SpriteFrame.this.editors.remove(this.image);
                }
            }
        }
    }

    public class ImageLabel
    extends JLabel {
        private static final long serialVersionUID = 749151178684203437L;
        BufferedImage img;
        int index = -1;
        JList<ImageIcon> list;

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.img, 0, 0, this.getWidth() - 1, this.getHeight() - 1, null);
            if (this.list.isSelectedIndex(this.index)) {
                g.setColor(this.list.getSelectionBackground());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    private class SpritePropertyListener
    extends PropertyMap.PropertyUpdateListener<Sprite.PSprite> {
        private SpritePropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<Sprite.PSprite> e) {
            SpriteFrame.this.updateBoundingBoxEditors();
        }
    }

    class SubImageTransfer
    extends FileChooser.FileDropHandler
    implements Transferable {
        private static final long serialVersionUID = 1L;
        private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
        BufferedImage data;

        SubImageTransfer() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor != DataFlavor.imageFlavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            return Util.cloneImage(this.data);
        }

        public Transferable createTransferable(JList<ImageIcon> c) {
            JList<ImageIcon> l = c;
            int index = l.getSelectedIndex();
            if (index == -1) {
                return null;
            }
            this.data = (BufferedImage)((Sprite)SpriteFrame.this.res).subImages.get(index);
            return this;
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
            if (action == 2) {
                ((Sprite)SpriteFrame.this.res).subImages.remove(this.data);
            }
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            if (super.isDataFlavorSupported(df)) {
                return true;
            }
            return df == DataFlavor.imageFlavor;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport evt) {
            LinkedList<BufferedImage> bi = new LinkedList<BufferedImage>();
            try {
                BufferedImage b;
                if (evt.isDataFlavorSupported(DataFlavor.imageFlavor) && (b = (BufferedImage)evt.getTransferable().getTransferData(DataFlavor.imageFlavor)) != null) {
                    bi.add(b);
                }
                if (bi.isEmpty()) {
                    List<?> files = this.getDropList(evt);
                    if (files == null || files.isEmpty()) {
                        return false;
                    }
                    for (Object o : files) {
                        ImageInputStream iis = null;
                        if (o instanceof File) {
                            iis = ImageIO.createImageInputStream(o);
                        }
                        if (o instanceof URI) {
                            iis = ImageIO.createImageInputStream(((URI)o).toURL().openStream());
                        }
                        BufferedImage[] bia = Util.getValidImages(iis);
                        if (files.size() != 1 && bia.length > 1) {
                            return false;
                        }
                        Collections.addAll(bi, bia);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bi.isEmpty()) {
                return false;
            }
            int index = -1;
            if (evt.isDrop()) {
                JList.DropLocation loc = (JList.DropLocation)evt.getDropLocation();
                index = loc.getIndex();
                if (!loc.isInsert()) {
                    ((Sprite)SpriteFrame.this.res).subImages.remove(index);
                }
                System.out.println(loc.isInsert());
            }
            if (index < 0) {
                index = ((Sprite)SpriteFrame.this.res).subImages.size();
            }
            for (BufferedImage b : bi) {
                ((Sprite)SpriteFrame.this.res).subImages.add(index++, b);
            }
            return true;
        }
    }

    private static class TransferableImages
    implements Transferable {
        ClipboardImages ci;

        public TransferableImages(ClipboardImages images) {
            this.ci = images;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] ret = new DataFlavor[]{imgClipFlavor};
            return ret;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return imgClipFlavor.equals(flavor);
        }

        @Override
        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.ci;
            }
            throw new UnsupportedFlavorException(imgClipFlavor);
        }
    }
}

