/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.file.FileChangeMonitor;
import org.lateralgm.file.ProjectFile;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Sound;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.propertylink.ComboBoxLink;
import org.lateralgm.ui.swing.util.SwingExecutor;

public class SoundFrame
extends InstantiableResourceFrame<Sound, Sound.PSound> {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon LOAD_ICON = LGM.getIconForKey("SoundFrame.LOAD");
    private static final ImageIcon PLAY_ICON = LGM.getIconForKey("SoundFrame.PLAY");
    private static final ImageIcon STOP_ICON = LGM.getIconForKey("SoundFrame.STOP");
    private static final ImageIcon STORE_ICON = LGM.getIconForKey("SoundFrame.STORE");
    private static final ImageIcon EDIT_ICON = LGM.getIconForKey("SoundFrame.EDIT");
    public JButton load;
    public JButton play;
    public JButton stop;
    public JButton store;
    public JSlider volume;
    public JSlider pan;
    public JButton center;
    public JCheckBox preload;
    public JButton edit;
    public byte[] data;
    public boolean modified = false;
    private CustomFileChooser fc = new CustomFileChooser("/org/lateralgm", "LAST_SOUND_DIR");
    private SoundEditor editor;
    private JLabel fileLabel;
    private JLabel memoryLabel;
    private JLabel lPosition;
    private JSlider position;
    private Timer playbackTimer;
    public SoundPlayer soundPlayer = null;

    public String formatTime(long duration) {
        String formated = String.format("%dm%ds", TimeUnit.MICROSECONDS.toMinutes(duration), TimeUnit.MICROSECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MICROSECONDS.toMinutes(duration)));
        return formated;
    }

    public void updatePlayerPosition() {
        float pos = (float)this.position.getValue() / (float)this.position.getMaximum();
        this.soundPlayer.seek((long)(pos * (float)this.soundPlayer.getDuration()));
    }

    public void updatePlaybackPosition() {
        float pos = (float)this.soundPlayer.getPosition() / (float)this.soundPlayer.getDuration();
        this.position.setValue(Math.round(pos * (float)this.position.getMaximum()));
    }

    public SoundFrame(Sound res, ResNode node) {
        super(res, node);
        this.getRootPane().setDefaultButton(this.save);
        this.setLayout(new BorderLayout());
        String[] s = new String[]{".ogg", ".wav", ".mid", ".mp3", ".mod", ".xm", ".s3m", ".it", ".nfs", ".gfs", ".minigfs", ".flac"};
        String[] d = new String[]{Messages.getString("SoundFrame.FORMAT_SOUND"), Messages.getString("SoundFrame.FORMAT_OGG"), Messages.getString("SoundFrame.FORMAT_WAV"), Messages.getString("SoundFrame.FORMAT_MID"), Messages.getString("SoundFrame.FORMAT_MP3")};
        CustomFileFilter soundsFilter = new CustomFileFilter(d[0], s);
        this.fc.addChoosableFileFilter(soundsFilter);
        this.fc.addChoosableFileFilter(new CustomFileFilter(d[1], s[0]));
        this.fc.addChoosableFileFilter(new CustomFileFilter(d[2], s[1]));
        this.fc.addChoosableFileFilter(new CustomFileFilter(d[3], s[2]));
        this.fc.addChoosableFileFilter(new CustomFileFilter(d[4], s[3]));
        this.fc.setFileFilter(soundsFilter);
        JSplitPane orientationSplit = new JSplitPane(1, true);
        Util.orientSplit(orientationSplit, Prefs.rightOrientation, this.makeLeftPane(), this.makeRightPane());
        this.add((Component)orientationSplit, "Center");
        this.soundPlayer = new JavaSoundPlayer();
        this.updatePositionLabel();
        this.data = res.data;
        this.loadSound();
        this.pack();
    }

    private JButton makeJButton(String key, ImageIcon icon) {
        JButton button = new JButton(icon);
        button.setToolTipText(Messages.getString(key));
        button.addActionListener(this);
        return button;
    }

    private JToolBar makeToolBar() {
        JToolBar tool = new JToolBar();
        tool.setFloatable(false);
        this.load = this.makeJButton("SoundFrame.LOAD", LOAD_ICON);
        tool.add(this.load);
        this.store = this.makeJButton("SoundFrame.STORE", STORE_ICON);
        tool.add(this.store);
        this.edit = this.makeJButton("SoundFrame.EDIT", EDIT_ICON);
        tool.add(this.edit);
        tool.addSeparator();
        this.play = this.makeJButton("SoundFrame.PLAY", PLAY_ICON);
        tool.add(this.play);
        this.stop = this.makeJButton("SoundFrame.STOP", STOP_ICON);
        tool.add(this.stop);
        this.play.setEnabled(false);
        this.stop.setEnabled(false);
        return tool;
    }

    private JPanel makeLeftPane() {
        JPanel panel = new JPanel();
        this.name.setColumns(13);
        this.name.setMaximumSize(this.name.getPreferredSize());
        JLabel nameLabel = new JLabel(Messages.getString("SoundFrame.NAME"));
        this.preload = new JCheckBox(Messages.getString("SoundFrame.PRELOAD"));
        this.preload.setOpaque(false);
        this.plf.make(this.preload, Sound.PSound.PRELOAD);
        this.fileLabel = new JLabel();
        this.memoryLabel = new JLabel();
        JPanel pKind = this.makeKindPane();
        JPanel pEffects = this.makeEffectsPane();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(nameLabel).addComponent(this.name, -1, 120, Integer.MAX_VALUE)).addComponent(this.fileLabel, 0, -1, -2).addComponent(this.memoryLabel, 0, -1, -2).addComponent(this.preload).addComponent(pEffects, -1, -1, Integer.MAX_VALUE).addComponent(pKind, -1, -1, Integer.MAX_VALUE).addComponent(this.save, -1, -1, Integer.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(nameLabel).addComponent(this.name)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fileLabel).addComponent(this.memoryLabel).addComponent(this.preload).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(pKind).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(pEffects).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 8, Integer.MAX_VALUE).addComponent(this.save));
        panel.setLayout(layout);
        return panel;
    }

    private JPanel makeRightPane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel pFormat = this.makeFormatPane();
        final JLabel lVolume = new JLabel(String.valueOf(Messages.getString("SoundFrame.VOLUME")) + ": 100");
        this.volume = new JSlider(0, 100, 100);
        this.volume.setMajorTickSpacing(10);
        this.volume.setPaintTicks(true);
        this.volume.setSize(new Dimension(50, 50));
        this.volume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                lVolume.setText(String.valueOf(Messages.getString("SoundFrame.VOLUME")) + ": " + SoundFrame.this.volume.getValue());
            }
        });
        this.plf.make(this.volume.getModel(), Sound.PSound.VOLUME, 100.0);
        final JLabel lPan = new JLabel(String.valueOf(Messages.getString("SoundFrame.PAN")) + ": 0");
        this.pan = new JSlider(-100, 100, 0);
        this.pan.setMajorTickSpacing(20);
        this.pan.setPaintTicks(true);
        this.pan.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                lPan.setText(String.valueOf(Messages.getString("SoundFrame.PAN")) + ": " + SoundFrame.this.pan.getValue());
            }
        });
        this.plf.make(this.pan.getModel(), Sound.PSound.PAN, 100.0);
        this.lPosition = new JLabel();
        this.position = new JSlider(0, 100, 0);
        this.position.setMajorTickSpacing(10);
        this.position.setMinorTickSpacing(2);
        this.position.setPaintTicks(true);
        this.position.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                if (SoundFrame.this.position.getValueIsAdjusting()) {
                    SoundFrame.this.updatePlayerPosition();
                }
                SoundFrame.this.updatePositionLabel();
            }
        });
        this.playbackTimer = new Timer(16, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SoundFrame.this.position.getValueIsAdjusting()) {
                    return;
                }
                SoundFrame.this.updatePlaybackPosition();
            }
        });
        this.playbackTimer.setInitialDelay(0);
        this.save.setText(Messages.getString("ResourceFrame.SAVE"));
        JPanel content = new JPanel();
        GroupLayout layout = new GroupLayout(content);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(pFormat).addComponent(lPan).addComponent(this.pan).addComponent(lVolume).addComponent(this.volume).addComponent(this.position));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.position).addComponent(lVolume).addComponent(this.volume).addComponent(lPan).addComponent(this.pan).addComponent(pFormat));
        content.setLayout(layout);
        JToolBar playbackToolBar = this.makeToolBar();
        playbackToolBar.add(this.lPosition);
        panel.add((Component)playbackToolBar, "North");
        panel.add((Component)content, "Center");
        return panel;
    }

    private JPanel makeKindPane() {
        String[] kindOptions = new String[]{"SoundFrame.NORMAL", "SoundFrame.BACKGROUND", "SoundFrame.THREE", "SoundFrame.MULT"};
        Messages.translate(kindOptions);
        JComboBox<String> kindCombo = new JComboBox<String>(kindOptions);
        this.plf.make(kindCombo, Sound.PSound.KIND, new ComboBoxLink.KeyComboBoxConversion<Sound.SoundKind>(ProjectFile.SOUND_KIND, ProjectFile.SOUND_KIND_CODE));
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SoundFrame.KIND")));
        GroupLayout gl = new GroupLayout(panel);
        gl.setAutoCreateContainerGaps(true);
        gl.setHorizontalGroup(gl.createParallelGroup().addComponent(kindCombo));
        gl.setVerticalGroup(gl.createParallelGroup().addComponent(kindCombo, -2, -2, -2));
        panel.setLayout(gl);
        return panel;
    }

    private JPanel makeFormatPane() {
        JPanel pFormat = new JPanel();
        String[] typeOptions = new String[]{"SoundFrame.MONO", "SoundFrame.STEREO", "SoundFrame.THREE"};
        Messages.translate(typeOptions);
        JComboBox<String> typeCombo = new JComboBox<String>(typeOptions);
        this.plf.make(typeCombo, Sound.PSound.TYPE, new ComboBoxLink.KeyComboBoxConversion<Sound.SoundType>(ProjectFile.SOUND_TYPE, ProjectFile.SOUND_TYPE_CODE));
        Integer[] depthOptions = new Integer[]{8, 16};
        JComboBox<Integer> depthCombo = new JComboBox<Integer>(depthOptions);
        this.plf.make(depthCombo, Sound.PSound.BIT_DEPTH, new ComboBoxLink.DefaultComboBoxConversion());
        Integer[] sampleOptions = new Integer[]{5512, 11025, 22050, 32000, 44100, 48000};
        JComboBox<Integer> sampleCombo = new JComboBox<Integer>(sampleOptions);
        this.plf.make(sampleCombo, Sound.PSound.SAMPLE_RATE, new ComboBoxLink.DefaultComboBoxConversion());
        JLabel sampleLabel = new JLabel(Messages.getString("SoundFrame.SAMPLERATE"));
        ArrayList<Integer> bitOptions = new ArrayList<Integer>();
        int i = 8;
        while (i <= 512) {
            bitOptions.add(i);
            i = (int)((double)i + 8.0 * Math.floor(Math.log(i) / Math.log(8.0)));
        }
        JComboBox<Integer> bitCombo = new JComboBox<Integer>(bitOptions.toArray(new Integer[bitOptions.size()]));
        this.plf.make(bitCombo, Sound.PSound.BIT_RATE, new ComboBoxLink.DefaultComboBoxConversion());
        JLabel bitLabel = new JLabel(Messages.getString("SoundFrame.BITRATE"));
        JCheckBox compressedCB = new JCheckBox(Messages.getString("SoundFrame.COMPRESSED"));
        this.plf.make(compressedCB, Sound.PSound.COMPRESSED);
        JCheckBox streamedCB = new JCheckBox(Messages.getString("SoundFrame.STREAMED"));
        this.plf.make(streamedCB, Sound.PSound.STREAMED);
        JCheckBox decompressCB = new JCheckBox(Messages.getString("SoundFrame.DECOMPRESS"));
        this.plf.make(decompressCB, Sound.PSound.DECOMPRESS_ON_LOAD);
        GroupLayout aLayout = new GroupLayout(pFormat);
        aLayout.setAutoCreateGaps(true);
        aLayout.setAutoCreateContainerGaps(true);
        pFormat.setLayout(aLayout);
        pFormat.setBorder(BorderFactory.createTitledBorder(Messages.getString("SoundFrame.FORMAT")));
        aLayout.setHorizontalGroup(aLayout.createParallelGroup().addGroup(aLayout.createSequentialGroup().addGroup(aLayout.createParallelGroup().addComponent(typeCombo).addComponent(depthCombo)).addGroup(aLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(sampleLabel).addComponent(bitLabel)).addGroup(aLayout.createParallelGroup().addComponent(sampleCombo).addComponent(bitCombo))).addGroup(aLayout.createSequentialGroup().addComponent(compressedCB).addComponent(streamedCB).addComponent(decompressCB)));
        aLayout.setVerticalGroup(aLayout.createSequentialGroup().addGroup(aLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(typeCombo).addComponent(sampleLabel).addComponent(sampleCombo)).addGroup(aLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(depthCombo).addComponent(bitLabel).addComponent(bitCombo)).addGroup(aLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(compressedCB).addComponent(streamedCB).addComponent(decompressCB)));
        return pFormat;
    }

    private JPanel makeEffectsPane() {
        JCheckBox eChorus = new JCheckBox(Messages.getString("SoundFrame.CHORUS"));
        this.plf.make(eChorus, Sound.PSound.CHORUS);
        JCheckBox eEcho = new JCheckBox(Messages.getString("SoundFrame.ECHO"));
        this.plf.make(eEcho, Sound.PSound.ECHO);
        JCheckBox eFlanger = new JCheckBox(Messages.getString("SoundFrame.FLANGER"));
        this.plf.make(eFlanger, Sound.PSound.FLANGER);
        JCheckBox eGargle = new JCheckBox(Messages.getString("SoundFrame.GARGLE"));
        this.plf.make(eGargle, Sound.PSound.GARGLE);
        JCheckBox eReverb = new JCheckBox(Messages.getString("SoundFrame.REVERB"));
        this.plf.make(eReverb, Sound.PSound.REVERB);
        JPanel pEffects = new JPanel();
        GroupLayout eLayout = new GroupLayout(pEffects);
        eLayout.setAutoCreateGaps(true);
        eLayout.setAutoCreateContainerGaps(true);
        pEffects.setLayout(eLayout);
        pEffects.setBorder(BorderFactory.createTitledBorder(Messages.getString("SoundFrame.EFFECTS")));
        eLayout.setHorizontalGroup(eLayout.createSequentialGroup().addGroup(eLayout.createParallelGroup().addComponent(eChorus).addComponent(eFlanger).addComponent(eGargle)).addGroup(eLayout.createParallelGroup().addComponent(eEcho).addComponent(eReverb)));
        eLayout.setVerticalGroup(eLayout.createSequentialGroup().addGroup(eLayout.createParallelGroup().addComponent(eChorus).addComponent(eEcho)).addGroup(eLayout.createParallelGroup().addComponent(eFlanger).addComponent(eReverb)).addComponent(eGargle));
        return pEffects;
    }

    private void updatePositionLabel() {
        long position = this.soundPlayer.getPosition();
        long length = this.soundPlayer.getDuration();
        this.lPosition.setText(String.valueOf(this.formatTime(position)) + " / " + this.formatTime(length));
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return !this.modified;
    }

    @Override
    public void commitChanges() {
        ((Sound)this.res).setName(this.name.getText());
        ((Sound)this.res).data = this.data;
    }

    @Override
    public void updateResource(boolean commit) {
        super.updateResource(commit);
        this.modified = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.load) {
            File f;
            while (true) {
                if (this.fc.showOpenDialog(LGM.frame) != 0) {
                    return;
                }
                f = this.fc.getSelectedFile();
                if (f.exists()) break;
                JOptionPane.showMessageDialog(this.fc, String.valueOf(f.getName()) + Messages.getString("SoundFrame.FILE_MISSING"), Messages.getString("SoundFrame.FILE_OPEN"), 2);
            }
            try {
                String fn = f.getName();
                String extension = "";
                int i = fn.lastIndexOf(46);
                if (i > 0) {
                    extension = fn.substring(i + 1);
                }
                if (extension.toLowerCase().equals("mp3")) {
                    ((Sound)this.res).put(Sound.PSound.KIND, (Object)Sound.SoundKind.MULTIMEDIA);
                }
                ((Sound)this.res).put(Sound.PSound.FILE_NAME, fn);
                String ft = CustomFileFilter.getExtension(fn);
                if (ft == null) {
                    ft = "";
                }
                ((Sound)this.res).put(Sound.PSound.FILE_TYPE, ft);
                this.data = Util.readFully(f);
                this.loadSound();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.modified = true;
            return;
        }
        if (e.getSource() == this.play) {
            if (this.data == null || this.data.length == 0) {
                return;
            }
            try {
                if (!this.soundPlayer.play()) {
                    return;
                }
            }
            catch (Exception e1) {
                LGM.showDefaultExceptionHandler(e1);
            }
            this.updatePlayerPosition();
            this.play.setEnabled(false);
            this.stop.setEnabled(true);
            this.playbackTimer.start();
            return;
        }
        if (e.getSource() == this.stop) {
            this.soundPlayer.stop();
            this.play.setEnabled(true);
            return;
        }
        if (e.getSource() == this.store) {
            if (this.fc.showSaveDialog(LGM.frame) != 0) {
                return;
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.fc.getSelectedFile()));
                out.write(this.data);
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (e.getSource() == this.edit) {
            try {
                if (this.editor == null) {
                    new SoundEditor();
                } else {
                    this.editor.start();
                }
            }
            catch (IOException ex) {
                LGM.showDefaultExceptionHandler(ex);
            }
            return;
        }
        if (e.getSource() == this.center) {
            this.pan.setValue(0);
            return;
        }
        super.actionPerformed(e);
    }

    public void stopSound(boolean atEnd) {
        this.stop.setEnabled(false);
        this.playbackTimer.stop();
        if (!atEnd) {
            return;
        }
        this.play.setEnabled(true);
        this.position.setValue(0);
    }

    public void loadSound() {
        this.cleanup();
        this.position.setValue(0);
        this.playbackTimer.stop();
        this.play.setEnabled(false);
        this.updateStatusLabels();
        if (this.data != null && this.data.length > 0) {
            try {
                if (this.soundPlayer.load()) {
                    this.play.setEnabled(true);
                }
            }
            catch (Exception e) {
                LGM.showDefaultExceptionHandler(e);
            }
        }
        this.updatePositionLabel();
    }

    private void updateStatusLabels() {
        String fileName = (String)((Sound)this.res).get(Sound.PSound.FILE_NAME);
        String shortName = new File(fileName).getName();
        this.fileLabel.setText(Messages.format("SoundFrame.FILENAME", shortName));
        if (!fileName.isEmpty()) {
            this.fileLabel.setToolTipText(fileName);
        }
        long length = 0L;
        if (((Sound)this.res).data != null && ((Sound)this.res).data.length != 0) {
            length = ((Sound)this.res).data.length;
        } else if (this.data != null) {
            length = this.data.length;
        }
        String sizeString = Util.formatDataSize(length);
        this.memoryLabel.setText(Messages.format("SoundFrame.MEMORY", sizeString));
        this.memoryLabel.setToolTipText(sizeString);
    }

    @Override
    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    protected void cleanup() {
        if (this.editor != null) {
            this.editor.stop();
        }
        try {
            this.soundPlayer.cleanup();
        }
        catch (Exception e) {
            LGM.showDefaultExceptionHandler(e);
        }
    }

    public class JavaSoundPlayer
    implements SoundPlayer {
        private Clip clip;
        private AudioInputStream ais;

        @Override
        public boolean load() throws Exception {
            try {
                this.ais = AudioSystem.getAudioInputStream(new ByteArrayInputStream(SoundFrame.this.data));
                AudioFormat fmt = this.ais.getFormat();
                if (fmt.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                    fmt = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, fmt.getSampleRate(), fmt.getSampleSizeInBits() * 2, fmt.getChannels(), fmt.getFrameSize() * 2, fmt.getFrameRate(), true);
                    this.ais = AudioSystem.getAudioInputStream(fmt, this.ais);
                }
                this.clip = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, fmt));
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                if (this.ais != null) {
                    this.ais.close();
                }
                if (!(e instanceof UnsupportedAudioFileException)) {
                    throw e;
                }
                return false;
            }
            return true;
        }

        private boolean open() throws Exception {
            if (this.clip.isOpen()) {
                return true;
            }
            this.clip.open(this.ais);
            this.clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        boolean atEnd;
                        int lastFrameIndex = JavaSoundPlayer.this.clip.getFrameLength() - 1;
                        boolean bl = atEnd = event.getFramePosition() >= (long)lastFrameIndex;
                        if (atEnd) {
                            JavaSoundPlayer.this.clip.setFramePosition(0);
                            JavaSoundPlayer.this.clip.flush();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SoundFrame.this.stopSound(atEnd);
                            }
                        });
                    }
                }
            });
            return true;
        }

        @Override
        public boolean play() throws Exception {
            if (this.clip == null) {
                SoundFrame.this.loadSound();
            }
            if (this.clip == null) {
                return false;
            }
            if (!this.open()) {
                return false;
            }
            this.clip.start();
            return true;
        }

        @Override
        public void stop() {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.stop();
            }
        }

        @Override
        public long getPosition() {
            return this.clip == null || !this.clip.isOpen() ? 0L : this.clip.getMicrosecondPosition();
        }

        @Override
        public long getDuration() {
            return this.clip == null || !this.clip.isOpen() ? 0L : this.clip.getMicrosecondLength();
        }

        @Override
        public void seek(long microseconds) {
            if (this.clip == null || !this.clip.isOpen()) {
                return;
            }
            int lastFrameIndex = this.clip.getFrameLength() - 1;
            AudioFormat fmt = this.clip.getFormat();
            float microsecondsPerSecond = 1000000.0f;
            float frameSeconds = (float)microseconds * fmt.getFrameRate();
            int frame = (int)(frameSeconds / 1000000.0f);
            if (frame > lastFrameIndex) {
                frame = lastFrameIndex;
            }
            this.clip.setFramePosition(frame);
        }

        @Override
        public void cleanup() throws Exception {
            if (this.clip != null && this.clip.isOpen()) {
                this.clip.stop();
                this.clip.close();
                this.clip.flush();
            }
            if (this.ais != null) {
                this.ais.close();
            }
            this.clip = null;
        }
    }

    private class SoundEditor
    implements UpdateSource.UpdateListener {
        private FileChangeMonitor monitor;
        private File f;

        public SoundEditor() throws IOException {
            SoundFrame.this.editor = this;
            this.start();
        }

        public void start() throws IOException {
            if (this.monitor != null) {
                this.monitor.stop();
            }
            if (this.f == null || !this.f.exists()) {
                this.f = File.createTempFile(((Sound)SoundFrame.this.res).getName(), new File((String)((Sound)SoundFrame.this.res).get(Sound.PSound.FILE_NAME)).getName(), LGM.tempDir);
                this.f.deleteOnExit();
            }
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream out = new FileOutputStream(this.f);){
                out.write(SoundFrame.this.data);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.monitor = new FileChangeMonitor(this.f, (Executor)SwingExecutor.INSTANCE);
            this.monitor.updateSource.addListener(this);
            if (!Prefs.useExternalSoundEditor || Prefs.externalSoundEditorCommand == null) {
                Util.OpenDesktopEditor(this.monitor.file);
            } else {
                Runtime.getRuntime().exec(String.format(Prefs.externalSoundEditorCommand, this.monitor.file.getAbsolutePath()));
            }
        }

        public void stop() {
            this.monitor.stop();
            this.monitor.file.delete();
            SoundFrame.this.editor = null;
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            if (!(e instanceof FileChangeMonitor.FileUpdateEvent)) {
                return;
            }
            switch (((FileChangeMonitor.FileUpdateEvent)e).flag) {
                case CHANGED: {
                    try {
                        SoundFrame.this.data = Util.readFully(this.monitor.file);
                        SoundFrame.this.loadSound();
                    }
                    catch (IOException ioe) {
                        LGM.showDefaultExceptionHandler(ioe);
                        return;
                    }
                    SoundFrame.this.modified = true;
                    break;
                }
                case DELETED: {
                    SoundFrame.this.editor = null;
                }
            }
        }
    }

    public static interface SoundPlayer {
        public boolean load() throws Exception;

        public boolean play() throws Exception;

        public void stop();

        public void seek(long var1);

        public long getPosition();

        public long getDuration();

        public void cleanup() throws Exception;
    }
}

