/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.MarkerCache;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.impl.TextAreaFocusTraversalPolicy;
import org.lateralgm.file.FileChangeMonitor;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Shader;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.util.SwingExecutor;

public class ShaderFrame
extends InstantiableResourceFrame<Shader, Shader.PShader> {
    private static final long serialVersionUID = 1L;
    public JToolBar tool;
    public JTabbedPane editors;
    public CodeTextArea vcode;
    public CodeTextArea fcode;
    public JButton edit;
    public JPanel status;
    public JComboBox<String> typeCombo;
    public String currentLang = "";
    private ShaderEditor fragmentEditor;
    private ShaderEditor vertexEditor;

    public ShaderFrame(Shader res, ResNode node) {
        super(res, node);
        this.setSize(700, 430);
        this.setLayout(new BorderLayout());
        this.vcode = new CodeTextArea((String)res.get(Shader.PShader.VERTEX), MarkerCache.getMarker("glsles"));
        this.fcode = new CodeTextArea((String)res.get(Shader.PShader.FRAGMENT), MarkerCache.getMarker("glsles"));
        this.editors = new JTabbedPane();
        this.editors.addTab("Vertex", this.vcode);
        this.editors.addTab("Fragment", this.fcode);
        this.add((Component)this.editors, "Center");
        this.tool = new JToolBar();
        this.tool.setFloatable(false);
        this.tool.setAlignmentX(0.0f);
        this.add((Component)this.tool, "North");
        this.tool.add(this.save);
        this.tool.addSeparator();
        if (Prefs.useExternalScriptEditor) {
            this.vcode.setEnabled(false);
            this.edit = new JButton(LGM.getIconForKey("ShaderFrame.EDIT"));
            this.edit.setToolTipText(Messages.getString("ShaderFrame.EDIT"));
            this.edit.addActionListener(this);
            this.tool.add(this.edit);
            this.tool.addSeparator();
        }
        this.addEditorButtons(this.tool);
        this.tool.addSeparator();
        this.name.setColumns(13);
        this.name.setMaximumSize(this.name.getPreferredSize());
        this.tool.add(new JLabel(Messages.getString("ShaderFrame.NAME")));
        this.tool.add(this.name);
        this.tool.addSeparator();
        this.tool.add(new JLabel(Messages.getString("ShaderFrame.TYPE")));
        String[] typeOptions = new String[]{"GLSLES", "GLSL", "HLSL9", "HLSL11"};
        this.typeCombo = new JComboBox<String>(typeOptions){
            private static final long serialVersionUID = 868972443258270041L;

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                ShaderFrame.this.updateLexer();
            }
        });
        this.typeCombo.setSelectedItem(res.getType());
        this.tool.add(this.typeCombo);
        this.status = new JPanel(new FlowLayout());
        BoxLayout layout = new BoxLayout(this.status, 0);
        this.status.setLayout(layout);
        this.status.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
        final JLabel caretPos = new JLabel(" INS | UTF-8 | " + (this.vcode.getCaretLine() + 1) + " : " + (this.vcode.getCaretColumn() + 1));
        this.status.add(caretPos);
        this.vcode.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                caretPos.setText(" INS | UTF-8 | " + (ShaderFrame.this.vcode.getCaretLine() + 1) + " : " + (ShaderFrame.this.vcode.getCaretColumn() + 1));
            }
        });
        this.fcode.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                caretPos.setText(" INS | UTF-8 | " + (ShaderFrame.this.fcode.getCaretLine() + 1) + " : " + (ShaderFrame.this.fcode.getCaretColumn() + 1));
            }
        });
        this.add((Component)this.status, "South");
        this.setFocusTraversalPolicy(new TextAreaFocusTraversalPolicy(this.vcode.text));
        this.updateLexer();
    }

    private void updateLexer() {
        String val = this.typeCombo.getSelectedItem().toString();
        if (val.equals(this.currentLang)) {
            return;
        }
        DefaultTokenMarker marker = MarkerCache.getMarker(val);
        this.vcode.setTokenMarker(marker);
        this.fcode.setTokenMarker(marker);
        this.currentLang = val;
        this.repaint();
    }

    @Override
    public void commitChanges() {
        ((Shader)this.res).put(Shader.PShader.VERTEX, this.vcode.getTextCompat());
        ((Shader)this.res).put(Shader.PShader.FRAGMENT, this.fcode.getTextCompat());
        ((Shader)this.res).setName(this.name.getText());
        ((Shader)this.res).put(Shader.PShader.TYPE, this.typeCombo.getSelectedItem());
    }

    @Override
    public void fireInternalFrameEvent(int id) {
        if (id == 25551) {
            LGM.currentFile.updateSource.removeListener(this.vcode);
        }
        LGM.currentFile.updateSource.removeListener(this.fcode);
        super.fireInternalFrameEvent(id);
    }

    @Override
    public void dispose() {
        if (this.fragmentEditor != null) {
            this.fragmentEditor.stop();
        }
        if (this.vertexEditor != null) {
            this.vertexEditor.stop();
        }
        super.dispose();
    }

    private JButton makeToolbarButton(String name) {
        String key = "JoshText." + name;
        JButton b = new JButton(LGM.getIconForKey(key));
        b.setToolTipText(Messages.getString(key));
        b.setRequestFocusEnabled(false);
        b.setActionCommand(key);
        b.addActionListener(this);
        return b;
    }

    public void addEditorButtons(JToolBar tb) {
        tb.add(this.makeToolbarButton("LOAD"));
        tb.add(this.makeToolbarButton("SAVE"));
        tb.add(this.makeToolbarButton("PRINT"));
        tb.addSeparator();
        tb.add(this.makeToolbarButton("CUT"));
        tb.add(this.makeToolbarButton("COPY"));
        tb.add(this.makeToolbarButton("PASTE"));
        tb.addSeparator();
        final JButton undoButton = this.makeToolbarButton("UNDO");
        tb.add(undoButton);
        final JButton redoButton = this.makeToolbarButton("REDO");
        tb.add(redoButton);
        undoButton.setEnabled(this.vcode.text.canUndo());
        redoButton.setEnabled(this.vcode.text.canRedo());
        JoshText.LineChangeListener linelistener = new JoshText.LineChangeListener(){

            @Override
            public void linesChanged(Code code, int start, int end) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeTextArea selectedCode = ShaderFrame.this.getSelectedCode();
                        undoButton.setEnabled(selectedCode.text.canUndo());
                        redoButton.setEnabled(selectedCode.text.canRedo());
                    }
                });
            }
        };
        this.editors.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CodeTextArea selectedCode = ShaderFrame.this.getSelectedCode();
                if (selectedCode == null) {
                    return;
                }
                undoButton.setEnabled(selectedCode.text.canUndo());
                redoButton.setEnabled(selectedCode.text.canRedo());
            }
        });
        this.fcode.text.addLineChangeListener(linelistener);
        this.vcode.text.addLineChangeListener(linelistener);
        tb.addSeparator();
        tb.add(this.makeToolbarButton("FIND"));
        tb.add(this.makeToolbarButton("GOTO"));
    }

    public CodeTextArea getSelectedCode() {
        int stab = this.editors.getSelectedIndex();
        if (stab == 0) {
            return this.vcode;
        }
        if (stab == 1) {
            return this.fcode;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.edit) {
            try {
                int stab = this.editors.getSelectedIndex();
                if (stab == 0) {
                    if (this.vertexEditor == null) {
                        new ShaderEditor(EditorType.VERTEX);
                    } else {
                        this.vertexEditor.start();
                    }
                } else if (stab == 1) {
                    if (this.fragmentEditor == null) {
                        new ShaderEditor(EditorType.FRAGMENT);
                    } else {
                        this.fragmentEditor.start();
                    }
                }
            }
            catch (IOException ex) {
                LGM.showDefaultExceptionHandler(ex);
            }
            return;
        }
        String com = ev.getActionCommand();
        CodeTextArea selectedCode = this.getSelectedCode();
        if (com.equals("JoshText.LOAD")) {
            selectedCode.text.Load();
        } else if (com.equals("JoshText.SAVE")) {
            selectedCode.text.Save();
        } else if (com.equals("JoshText.PRINT")) {
            try {
                selectedCode.Print();
            }
            catch (PrinterException e) {
                LGM.showDefaultExceptionHandler(e);
            }
        } else if (com.equals("JoshText.UNDO")) {
            selectedCode.text.Undo();
        } else if (com.equals("JoshText.REDO")) {
            selectedCode.text.Redo();
        } else if (com.equals("JoshText.CUT")) {
            selectedCode.text.Cut();
        } else if (com.equals("JoshText.COPY")) {
            selectedCode.text.Copy();
        } else if (com.equals("JoshText.PASTE")) {
            selectedCode.text.Paste();
        } else if (com.equals("JoshText.FIND")) {
            selectedCode.text.ShowFind();
        } else if (com.equals("JoshText.GOTO")) {
            selectedCode.aGoto();
        } else if (com.equals("JoshText.SELALL")) {
            selectedCode.text.SelectAll();
        } else {
            super.actionPerformed(ev);
        }
    }

    private static enum EditorType {
        VERTEX,
        FRAGMENT;

    }

    private class ShaderEditor
    implements UpdateSource.UpdateListener {
        private FileChangeMonitor monitor;
        private EditorType type;
        private File f;

        public ShaderEditor(EditorType type) throws IOException {
            this.type = type;
            if (type == EditorType.VERTEX) {
                ShaderFrame.this.vertexEditor = this;
            } else {
                ShaderFrame.this.fragmentEditor = this;
            }
            this.start();
        }

        public void start() throws IOException {
            if (this.monitor != null) {
                this.monitor.stop();
            }
            if (this.f == null || !this.f.exists()) {
                this.f = File.createTempFile(((Shader)ShaderFrame.this.res).getName(), String.valueOf('.') + (this.type == EditorType.VERTEX ? "vert" : "frag"), LGM.tempDir);
                this.f.deleteOnExit();
            }
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileWriter out = new FileWriter(this.f);){
                out.write(this.type == EditorType.VERTEX ? ShaderFrame.this.vcode.getTextCompat() : ShaderFrame.this.fcode.getTextCompat());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.monitor = new FileChangeMonitor(this.f, (Executor)SwingExecutor.INSTANCE);
            this.monitor.updateSource.addListener(this, true);
            if (!Prefs.useExternalScriptEditor || Prefs.externalScriptEditorCommand == null) {
                Util.OpenDesktopEditor(this.monitor.file);
            } else {
                Runtime.getRuntime().exec(String.format(Prefs.externalScriptEditorCommand, this.monitor.file.getAbsolutePath()));
            }
        }

        public void stop() {
            this.monitor.stop();
            this.monitor.file.delete();
            if (this.type == EditorType.VERTEX) {
                ShaderFrame.this.vertexEditor = null;
            } else {
                ShaderFrame.this.fragmentEditor = null;
            }
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            if (!(e instanceof FileChangeMonitor.FileUpdateEvent)) {
                return;
            }
            switch (((FileChangeMonitor.FileUpdateEvent)e).flag) {
                case CHANGED: {
                    StringBuffer sb = new StringBuffer(1024);
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (BufferedReader reader = new BufferedReader(new FileReader(this.monitor.file));){
                            char[] chars = new char[1024];
                            int len = 0;
                            while ((len = reader.read(chars)) > -1) {
                                sb.append(chars, 0, len);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ioe) {
                        LGM.showDefaultExceptionHandler(ioe);
                        return;
                    }
                    String s = sb.toString();
                    if (this.type == EditorType.VERTEX) {
                        ((Shader)ShaderFrame.this.res).put(Shader.PShader.VERTEX, s);
                        ShaderFrame.this.vcode.setText(s);
                        break;
                    }
                    ((Shader)ShaderFrame.this.res).put(Shader.PShader.FRAGMENT, s);
                    ShaderFrame.this.fcode.setText(s);
                    break;
                }
                case DELETED: {
                    if (this.type == EditorType.VERTEX) {
                        ShaderFrame.this.vertexEditor = null;
                        break;
                    }
                    ShaderFrame.this.fragmentEditor = null;
                }
            }
        }
    }
}

