/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executor;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.lateralgm.components.CodeTextArea;
import org.lateralgm.components.MarkerCache;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.impl.TextAreaFocusTraversalPolicy;
import org.lateralgm.file.FileChangeMonitor;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Script;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.util.SwingExecutor;

public class ScriptFrame
extends InstantiableResourceFrame<Script, Script.PScript> {
    private static final long serialVersionUID = 1L;
    public JToolBar tool;
    public CodeTextArea code;
    public JButton edit;
    public JPanel status;
    private ScriptEditor editor;

    public ScriptFrame(Script res, ResNode node) {
        super(res, node);
        this.setSize(700, 430);
        this.setLayout(new BorderLayout());
        this.code = new CodeTextArea((String)res.get(Script.PScript.CODE), MarkerCache.getMarker("gml"));
        this.add((Component)this.code, "Center");
        this.tool = new JToolBar();
        this.tool.setFloatable(false);
        this.tool.setAlignmentX(0.0f);
        this.add((Component)this.tool, "North");
        this.tool.add(this.save);
        this.tool.addSeparator();
        if (Prefs.useExternalScriptEditor) {
            this.edit = new JButton(LGM.getIconForKey("ScriptFrame.EDIT"));
            this.edit.setToolTipText(Messages.getString("ScriptFrame.EDIT"));
            this.edit.addActionListener(this);
            this.tool.add(this.edit);
            this.tool.addSeparator();
        }
        this.code.addEditorButtons(this.tool);
        this.tool.addSeparator();
        this.name.setColumns(13);
        this.name.setMaximumSize(this.name.getPreferredSize());
        this.tool.add(new JLabel(Messages.getString("ScriptFrame.NAME")));
        this.tool.add(this.name);
        this.status = new JPanel(new FlowLayout());
        BoxLayout layout = new BoxLayout(this.status, 0);
        this.status.setLayout(layout);
        this.status.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
        final JLabel caretPos = new JLabel(" INS | UTF-8 | " + (this.code.getCaretLine() + 1) + " : " + (this.code.getCaretColumn() + 1));
        this.status.add(caretPos);
        this.code.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                caretPos.setText(" INS | UTF-8 | " + (ScriptFrame.this.code.getCaretLine() + 1) + " : " + (ScriptFrame.this.code.getCaretColumn() + 1));
            }
        });
        this.add((Component)this.status, "South");
        this.setFocusTraversalPolicy(new TextAreaFocusTraversalPolicy(this.code.text));
    }

    @Override
    public void commitChanges() {
        ((Script)this.res).put(Script.PScript.CODE, this.code.getTextCompat());
        ((Script)this.res).setName(this.name.getText());
    }

    @Override
    public void fireInternalFrameEvent(int id) {
        if (id == 25551) {
            LGM.currentFile.updateSource.removeListener(this.code);
        }
        super.fireInternalFrameEvent(id);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            if (e.getSource() == this.edit) {
                try {
                    if (this.editor == null) {
                        new ScriptEditor();
                        break block5;
                    }
                    this.editor.start();
                }
                catch (IOException ex) {
                    LGM.showDefaultExceptionHandler(ex);
                }
            } else {
                super.actionPerformed(e);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.editor != null) {
            this.editor.stop();
        }
        super.dispose();
    }

    private class ScriptEditor
    implements UpdateSource.UpdateListener {
        private FileChangeMonitor monitor;
        private File f;

        public ScriptEditor() throws IOException {
            ScriptFrame.this.editor = this;
            this.start();
        }

        public void start() throws IOException {
            if (this.monitor != null) {
                this.monitor.stop();
            }
            if (this.f == null || !this.f.exists()) {
                this.f = File.createTempFile(((Script)ScriptFrame.this.res).getName(), String.valueOf('.') + Prefs.externalScriptExtension, LGM.tempDir);
                this.f.deleteOnExit();
            }
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileWriter out = new FileWriter(this.f);){
                out.write(ScriptFrame.this.code.getTextCompat());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.monitor = new FileChangeMonitor(this.f, (Executor)SwingExecutor.INSTANCE);
            this.monitor.updateSource.addListener(this, true);
            if (!Prefs.useExternalScriptEditor || Prefs.externalScriptEditorCommand == null) {
                Util.OpenDesktopEditor(this.monitor.file);
            } else {
                Runtime.getRuntime().exec(String.format(Prefs.externalScriptEditorCommand, this.monitor.file.getAbsolutePath()));
            }
        }

        public void stop() {
            this.monitor.stop();
            this.monitor.file.delete();
            ScriptFrame.this.editor = null;
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            if (!(e instanceof FileChangeMonitor.FileUpdateEvent)) {
                return;
            }
            switch (((FileChangeMonitor.FileUpdateEvent)e).flag) {
                case CHANGED: {
                    StringBuffer sb = new StringBuffer(1024);
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (BufferedReader reader = new BufferedReader(new FileReader(this.monitor.file));){
                            char[] chars = new char[1024];
                            int len = 0;
                            while ((len = reader.read(chars)) > -1) {
                                sb.append(chars, 0, len);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException ioe) {
                        LGM.showDefaultExceptionHandler(ioe);
                        return;
                    }
                    String s = sb.toString();
                    ((Script)ScriptFrame.this.res).put(Script.PScript.CODE, s);
                    ScriptFrame.this.code.setText(s);
                    break;
                }
                case DELETED: {
                    ScriptFrame.this.editor = null;
                }
            }
        }
    }
}

