/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.lateralgm.components.ColorSelect;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.ResourceMenu;
import org.lateralgm.components.impl.AddPieceInstance;
import org.lateralgm.components.impl.EditorScrollPane;
import org.lateralgm.components.impl.ModifyPieceInstance;
import org.lateralgm.components.impl.RemovePieceInstance;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.impl.ShiftPieceInstances;
import org.lateralgm.components.visual.RoomEditor;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.BackgroundDef;
import org.lateralgm.resources.sub.Instance;
import org.lateralgm.resources.sub.Tile;
import org.lateralgm.resources.sub.View;
import org.lateralgm.subframes.CodeFrame;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.propertylink.PropertyLinkFactory;
import org.lateralgm.ui.swing.util.ArrayListModel;
import org.lateralgm.util.ActiveArrayList;
import org.lateralgm.util.PropertyMap;

public class RoomFrame
extends InstantiableResourceFrame<Room, Room.PRoom>
implements ListSelectionListener,
RoomEditor.CommandHandler,
UpdateSource.UpdateListener,
FocusListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon CODE_ICON = LGM.getIconForKey("RoomFrame.CODE");
    private final RoomEditor editor;
    private final EditorScrollPane editorPane;
    public final JTabbedPane tabs;
    public JLabel statX;
    public JLabel statY;
    public JLabel statId;
    public JLabel statSrc;
    private JButton zoomIn;
    private JButton zoomOut;
    private JButton undo;
    private JButton redo;
    private JButton deleteInstances;
    private JButton shiftInstances;
    private JButton roomControls;
    private JButton fill;
    private JButton cut;
    private JButton copy;
    private JButton paste;
    private JToggleButton gridVis;
    private JToggleButton gridIso;
    private JToggleButton selectObject;
    private JToggleButton selectRegion;
    private JToggleButton snapToGrid;
    private JToggleButton addOnTop;
    private JToggleButton addMultiple;
    public JCheckBox oUnderlying;
    public JCheckBox oLocked;
    public JList<Instance> oList;
    private Instance lastObj = null;
    private PropertyLinkFactory<Instance.PInstance> iplf;
    private JButton addObjectButton;
    private JButton deleteObjectButton;
    public ResourceMenu<GmObject> oNew;
    public ResourceMenu<GmObject> oSource;
    private JTextField objectName;
    public NumberField objectHorizontalPosition;
    public NumberField objectVerticalPosition;
    public NumberField objectScaleX;
    public NumberField objectScaleY;
    public NumberField objectRotation;
    public NumberField objectAlpha;
    public ColorSelect objectColor;
    private JButton oCreationCode;
    private JTextField sCaption;
    private JCheckBox sPersistent;
    private JButton sCreationCode;
    private JButton showButton;
    private JPopupMenu showMenu;
    public HashMap<CodeFrame.CodeHolder, CodeFrame> codeFrames = new HashMap();
    private JCheckBoxMenuItem sSObj;
    private JCheckBoxMenuItem sSTile;
    private JCheckBoxMenuItem sSBack;
    private JCheckBoxMenuItem sSFore;
    private JCheckBoxMenuItem sSView;
    public JComboBox<Integer> tileLayer;
    Vector<Integer> layers = new Vector();
    private JButton addLayer;
    private JButton deleteLayer;
    private JButton changeLayer;
    public JCheckBox tUnderlying;
    public JCheckBox tLocked;
    public JCheckBox tHideOtherLayers;
    public JCheckBox tEditOtherLayers;
    public TileSelector tSelect;
    private JScrollPane tScroll;
    public JList<Tile> tList;
    private Tile lastTile = null;
    private PropertyLinkFactory<Tile.PTile> tplf;
    private JButton deleteTileButton;
    public ResourceMenu<Background> taSource;
    public ResourceMenu<Background> teSource;
    public NumberField tsX;
    public NumberField tsY;
    public NumberField tileHorizontalPosition;
    public NumberField tileVerticalPosition;
    public NumberField teDepth;
    private JCheckBox bDrawColor;
    private JCheckBox bVisible;
    private JCheckBox bForeground;
    private JCheckBox bTileH;
    private JCheckBox bTileV;
    private JCheckBox bStretch;
    private ColorSelect bColor;
    private JList<JLabel> bList;
    private int lastValidBack = -1;
    private PropertyLinkFactory<BackgroundDef.PBackgroundDef> bdplf;
    private ResourceMenu<Background> bSource;
    private NumberField bX;
    private NumberField bY;
    private NumberField bH;
    private NumberField bV;
    private final BgDefPropertyListener bdpl = new BgDefPropertyListener();
    private JCheckBox vEnabled;
    private JCheckBox vVisible;
    private JList<JLabel> vList;
    private int lastValidView = -1;
    private PropertyLinkFactory<View.PView> vplf;
    private NumberField vRX;
    private NumberField vRY;
    private NumberField vRW;
    private NumberField vRH;
    private NumberField vPX;
    private NumberField vPY;
    private NumberField vPW;
    private NumberField vPH;
    private ResourceMenu<GmObject> vObj;
    private NumberField vOHBor;
    private NumberField vOVBor;
    private NumberField vOHSp;
    private NumberField vOVSp;
    private final ViewPropertyListener vpl = new ViewPropertyListener();
    private final PropertyLinkFactory<RoomEditor.PRoomEditor> prelf;
    private JCheckBox vClear;
    public UndoManager undoManager;
    public UndoableEditSupport undoSupport;
    private String pieceOriginalName = null;
    private Point pieceOriginalPosition = null;
    private Point2D pieceOriginalScale = null;
    private Double pieceOriginalRotation = null;
    private Integer pieceOriginalAlpha = null;
    public Room.Piece selectedPiece = null;
    public static final DataFlavor INSTANCE_FLAVOR = new DataFlavor(Instance.class, "Instance");
    private boolean maximize;
    private static JDialog roomControlsFrame;

    public RoomEditor getRoomEditor() {
        return this.editor;
    }

    private JToolBar makeToolBar() {
        JToolBar tool = new JToolBar();
        tool.setFloatable(false);
        tool.add(this.save);
        tool.addSeparator();
        AbstractAction deleteAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RoomFrame.this.deleteAction();
            }
        };
        AbstractAction cutAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RoomFrame.this.tabs.getSelectedIndex() == 2) {
                    RoomFrame.this.editor.copySelectionTiles();
                } else {
                    RoomFrame.this.editor.copySelectionInstances();
                }
                if (((RoomFrame)RoomFrame.this).editor.selection != null) {
                    RoomFrame.this.deleteAction(false);
                }
            }
        };
        this.cut = new JButton(LGM.getIconForKey("RoomFrame.CUT"));
        this.cut.setToolTipText(Messages.getString("RoomFrame.CUT"));
        KeyStroke ctrlXKey = KeyStroke.getKeyStroke(Messages.getKeyboardString("RoomFrame.CUT"));
        this.cut.getInputMap(2).put(ctrlXKey, "cut");
        this.cut.getActionMap().put("cut", cutAction);
        this.cut.addActionListener(cutAction);
        tool.add(this.cut);
        AbstractAction copyAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RoomFrame.this.tabs.getSelectedIndex() == 2) {
                    RoomFrame.this.editor.copySelectionTiles();
                } else {
                    RoomFrame.this.editor.copySelectionInstances();
                }
            }
        };
        this.copy = new JButton(LGM.getIconForKey("RoomFrame.COPY"));
        this.copy.setToolTipText(Messages.getString("RoomFrame.COPY"));
        KeyStroke ctrlCKey = KeyStroke.getKeyStroke(Messages.getKeyboardString("RoomFrame.COPY"));
        this.copy.getInputMap(2).put(ctrlCKey, "copy");
        this.copy.getActionMap().put("copy", copyAction);
        this.copy.addActionListener(copyAction);
        tool.add(this.copy);
        AbstractAction pasteAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RoomFrame.this.editor.activatePasteMode();
            }
        };
        this.paste = new JButton(LGM.getIconForKey("RoomFrame.PASTE"));
        this.paste.setToolTipText(Messages.getString("RoomFrame.PASTE"));
        KeyStroke ctrlVKey = KeyStroke.getKeyStroke(Messages.getKeyboardString("RoomFrame.PASTE"));
        this.paste.getInputMap(2).put(ctrlVKey, "paste");
        this.paste.getActionMap().put("paste", pasteAction);
        this.paste.addActionListener(pasteAction);
        tool.add(this.paste);
        tool.addSeparator();
        AbstractAction undoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Room.Piece selectedPiece = RoomFrame.this.editor.getSelectedPiece();
                if (selectedPiece != null) {
                    selectedPiece.setSelected(false);
                }
                RoomFrame.this.undoManager.undo();
                RoomFrame.this.refreshUndoRedoButtons();
            }
        };
        this.undo = new JButton(LGM.getIconForKey("RoomFrame.UNDO"));
        this.undo.setToolTipText(Messages.getString("RoomFrame.UNDO"));
        KeyStroke undoKey = KeyStroke.getKeyStroke(Messages.getKeyboardString("RoomFrame.UNDO"));
        this.undo.getInputMap(2).put(undoKey, "ctrlZ");
        this.undo.getActionMap().put("ctrlZ", undoAction);
        this.undo.addActionListener(undoAction);
        tool.add(this.undo);
        AbstractAction redoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RoomFrame.this.undoManager.redo();
                RoomFrame.this.refreshUndoRedoButtons();
            }
        };
        this.redo = new JButton(LGM.getIconForKey("RoomFrame.REDO"));
        this.redo.setToolTipText(Messages.getString("RoomFrame.REDO"));
        KeyStroke redoKey = KeyStroke.getKeyStroke(Messages.getKeyboardString("RoomFrame.REDO"));
        this.redo.getInputMap(2).put(redoKey, "ctrlY");
        this.redo.getActionMap().put("ctrlY", redoAction);
        this.redo.addActionListener(redoAction);
        tool.add(this.redo);
        tool.addSeparator();
        AbstractAction selectObjectAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RoomFrame.this.editor.deactivatePasteMode();
                if (RoomFrame.this.selectObject.isSelected()) {
                    RoomFrame.this.editor.deactivateSelectRegionMode();
                } else {
                    RoomFrame.this.editor.activateSelectRegionMode();
                }
            }
        };
        this.selectObject = new JToggleButton(LGM.getIconForKey("RoomFrame.SELECT_OBJECT"));
        this.selectObject.setToolTipText(Messages.getString("RoomFrame.SELECT_OBJECT"));
        this.selectObject.addActionListener(selectObjectAction);
        this.prelf.make(this.selectObject, RoomEditor.PRoomEditor.SINGLE_SELECTION);
        tool.add(this.selectObject);
        AbstractAction selectRegionAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RoomFrame.this.editor.deactivatePasteMode();
                if (RoomFrame.this.selectRegion.isSelected()) {
                    RoomFrame.this.editor.deactivateSelectObjectMode();
                } else {
                    RoomFrame.this.editor.activateSelectObjectMode();
                }
            }
        };
        this.selectRegion = new JToggleButton(LGM.getIconForKey("RoomFrame.SELECT_REGION"));
        this.selectRegion.setToolTipText(Messages.getString("RoomFrame.SELECT_REGION"));
        this.selectRegion.addActionListener(selectRegionAction);
        this.prelf.make(this.selectRegion, RoomEditor.PRoomEditor.MULTI_SELECTION);
        tool.add(this.selectRegion);
        this.fill = new JButton(LGM.getIconForKey("RoomFrame.FILL"));
        this.fill.setToolTipText(Messages.getString("RoomFrame.FILL"));
        this.fill.addActionListener(this);
        tool.add(this.fill);
        tool.addSeparator();
        this.deleteInstances = new JButton(LGM.getIconForKey("RoomFrame.DELETE"));
        this.deleteInstances.setToolTipText(Messages.getString("RoomFrame.DELETE"));
        KeyStroke deleteKey = KeyStroke.getKeyStroke(Messages.getKeyboardString("RoomFrame.DELETE"));
        this.deleteInstances.getInputMap(2).put(deleteKey, "delete");
        this.deleteInstances.getActionMap().put("delete", deleteAction);
        this.deleteInstances.addActionListener(deleteAction);
        tool.add(this.deleteInstances);
        this.shiftInstances = new JButton(LGM.getIconForKey("RoomFrame.SHIFT"));
        this.shiftInstances.setToolTipText(Messages.getString("RoomFrame.SHIFT"));
        this.shiftInstances.addActionListener(this);
        tool.add(this.shiftInstances);
        tool.addSeparator();
        AbstractAction altKeyPressedAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    return;
                }
                RoomFrame.this.editor.altKeyPressed();
            }
        };
        AbstractAction altKeyReleasedAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    return;
                }
                RoomFrame.this.editor.altKeyReleased();
            }
        };
        this.snapToGrid = new JToggleButton(LGM.getIconForKey("RoomFrame.SNAP_TO_GRID"));
        this.snapToGrid.setToolTipText(Messages.getString("RoomFrame.SNAP_TO_GRID"));
        this.snapToGrid.setActionCommand("snapToGrid");
        KeyStroke altKeyPressed = KeyStroke.getKeyStroke(18, 512, false);
        this.snapToGrid.getInputMap(2).put(altKeyPressed, "altKeyPressed");
        this.snapToGrid.getActionMap().put("altKeyPressed", altKeyPressedAction);
        this.snapToGrid.addActionListener(altKeyPressedAction);
        KeyStroke altKeyReleased = KeyStroke.getKeyStroke(18, 0, true);
        this.snapToGrid.getInputMap(2).put(altKeyReleased, "altKeyReleased");
        this.snapToGrid.getActionMap().put("altKeyReleased", altKeyReleasedAction);
        this.snapToGrid.addActionListener(altKeyReleasedAction);
        this.prelf.make(this.snapToGrid, RoomEditor.PRoomEditor.SNAP_TO_GRID);
        tool.add(this.snapToGrid);
        AbstractAction ctrlKeyPressedAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    return;
                }
                RoomFrame.this.editor.ctrlKeyPressed();
            }
        };
        AbstractAction ctrlKeyReleasedAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    return;
                }
                RoomFrame.this.editor.ctrlKeyReleased();
            }
        };
        this.addOnTop = new JToggleButton(LGM.getIconForKey("RoomFrame.ADD_ON_TOP"));
        this.addOnTop.setToolTipText(Messages.getString("RoomFrame.ADD_ON_TOP"));
        this.addOnTop.setActionCommand("addOnTop");
        KeyStroke ctrlKeyPressed = KeyStroke.getKeyStroke(17, 128, false);
        this.addOnTop.getInputMap(2).put(ctrlKeyPressed, "ctrlKeyPressed");
        this.addOnTop.getActionMap().put("ctrlKeyPressed", ctrlKeyPressedAction);
        this.addOnTop.addActionListener(ctrlKeyPressedAction);
        KeyStroke ctrlKeyReleased = KeyStroke.getKeyStroke(17, 0, true);
        this.addOnTop.getInputMap(2).put(ctrlKeyReleased, "ctrlKeyReleased");
        this.addOnTop.getActionMap().put("ctrlKeyReleased", ctrlKeyReleasedAction);
        this.addOnTop.addActionListener(ctrlKeyReleasedAction);
        this.prelf.make(this.addOnTop, RoomEditor.PRoomEditor.ADD_ON_TOP);
        tool.add(this.addOnTop);
        AbstractAction shiftKeyPressedAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    return;
                }
                RoomFrame.this.editor.shiftKeyPressed();
            }
        };
        AbstractAction shiftKeyReleasedAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    return;
                }
                RoomFrame.this.editor.shiftKeyReleased();
            }
        };
        this.addMultiple = new JToggleButton(LGM.getIconForKey("RoomFrame.ADD_MULTIPLE"));
        this.addMultiple.setToolTipText(Messages.getString("RoomFrame.ADD_MULTIPLE"));
        this.addMultiple.setActionCommand("addMultiple");
        KeyStroke shiftKeyPressed = KeyStroke.getKeyStroke(16, 64, false);
        this.addMultiple.getInputMap(2).put(shiftKeyPressed, "shiftKeyPressed");
        this.addMultiple.getActionMap().put("shiftKeyPressed", shiftKeyPressedAction);
        this.addMultiple.addActionListener(shiftKeyPressedAction);
        KeyStroke shiftKeyReleased = KeyStroke.getKeyStroke(16, 0, true);
        this.addMultiple.getInputMap(2).put(shiftKeyReleased, "shiftKeyReleased");
        this.addMultiple.getActionMap().put("shiftKeyReleased", shiftKeyReleasedAction);
        this.addMultiple.addActionListener(shiftKeyReleasedAction);
        this.prelf.make(this.addMultiple, RoomEditor.PRoomEditor.ADD_MULTIPLE);
        tool.add(this.addMultiple);
        tool.addSeparator();
        this.zoomIn = new JButton(LGM.getIconForKey("RoomFrame.ZOOM_IN"));
        this.zoomIn.setToolTipText(Messages.getString("RoomFrame.ZOOM_IN"));
        this.prelf.make(this.zoomIn, RoomEditor.PRoomEditor.ZOOM, 1, 2);
        tool.add(this.zoomIn);
        this.zoomOut = new JButton(LGM.getIconForKey("RoomFrame.ZOOM_OUT"));
        this.zoomOut.setToolTipText(Messages.getString("RoomFrame.ZOOM_OUT"));
        this.prelf.make(this.zoomOut, RoomEditor.PRoomEditor.ZOOM, -1, -1);
        tool.add(this.zoomOut);
        tool.addSeparator();
        this.gridVis = new JToggleButton(LGM.getIconForKey("RoomFrame.GRID_VISIBLE"));
        this.gridVis.setToolTipText(Messages.getString("RoomFrame.GRID_VISIBLE"));
        this.prelf.make(this.gridVis, RoomEditor.PRoomEditor.SHOW_GRID);
        tool.add(this.gridVis);
        this.gridIso = new JToggleButton(LGM.getIconForKey("RoomFrame.GRID_ISOMETRIC"));
        this.gridIso.setToolTipText(Messages.getString("RoomFrame.GRID_ISOMETRIC"));
        this.plf.make(this.gridIso, Room.PRoom.ISOMETRIC);
        tool.add(this.gridIso);
        JLabel lab = new JLabel(Messages.getString("RoomFrame.GRID_X"));
        NumberField nf = new NumberField(0, 999);
        nf.setMaximumSize(nf.getPreferredSize());
        this.prelf.make(nf, RoomEditor.PRoomEditor.GRID_OFFSET_X);
        tool.add(lab);
        tool.add(nf);
        lab = new JLabel(Messages.getString("RoomFrame.GRID_Y"));
        nf = new NumberField(0, 999);
        nf.setMaximumSize(nf.getPreferredSize());
        this.prelf.make(nf, RoomEditor.PRoomEditor.GRID_OFFSET_Y);
        tool.add(lab);
        tool.add(nf);
        lab = new JLabel(Messages.getString("RoomFrame.GRID_W"));
        nf = new NumberField(1, 999);
        nf.setMaximumSize(nf.getPreferredSize());
        this.plf.make(nf, Room.PRoom.SNAP_X);
        tool.add(lab);
        tool.add(nf);
        lab = new JLabel(Messages.getString("RoomFrame.GRID_H"));
        nf = new NumberField(1, 999);
        nf.setMaximumSize(nf.getPreferredSize());
        this.plf.make(nf, Room.PRoom.SNAP_Y);
        tool.add(lab);
        tool.add(nf);
        tool.addSeparator();
        this.showMenu = this.makeShowMenu();
        this.showButton = new JButton(Messages.getString("RoomFrame.SHOW"));
        this.showButton.addActionListener(this);
        tool.add(this.showButton);
        tool.addSeparator();
        this.roomControls = new JButton(LGM.getIconForKey("RoomFrame.ROOM_CONTROLS"));
        this.roomControls.setToolTipText(Messages.getString("RoomFrame.ROOM_CONTROLS"));
        this.roomControls.addActionListener(this);
        tool.add(this.roomControls);
        return tool;
    }

    public JPanel makeObjectsPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.oNew = new ResourceMenu(GmObject.class, Messages.getString("RoomFrame.NO_OBJECT"), true, 110);
        this.oNew.addActionListener(this);
        this.oUnderlying = new JCheckBox(Messages.getString("RoomFrame.OBJ_UNDERLYING"));
        this.prelf.make(this.oUnderlying, RoomEditor.PRoomEditor.DELETE_UNDERLYING_OBJECTS);
        MouseAdapter mouseListenerForInstances = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RoomFrame.this.showSelectedInstance();
            }
        };
        this.oList = new JList<Instance>(new ArrayListModel<Instance>(((Room)this.res).instances));
        this.oList.setSelectionMode(0);
        this.oList.setVisibleRowCount(8);
        this.oList.setCellRenderer(new ObjectListComponentRenderer());
        this.oList.setSelectedIndex(0);
        this.oList.addListSelectionListener(this);
        this.oList.addMouseListener(mouseListenerForInstances);
        JScrollPane sp = new JScrollPane(this.oList);
        this.addObjectButton = new JButton(Messages.getString("RoomFrame.OBJ_ADD"));
        this.addObjectButton.addActionListener(this);
        this.deleteObjectButton = new JButton(Messages.getString("RoomFrame.OBJ_DELETE"));
        this.deleteObjectButton.addActionListener(this);
        JPanel edit = new JPanel();
        String title = Messages.getString("RoomFrame.OBJ_INSTANCES");
        edit.setBorder(BorderFactory.createTitledBorder(title));
        GroupLayout layout2 = new GroupLayout(edit);
        layout2.setAutoCreateGaps(true);
        layout2.setAutoCreateContainerGaps(true);
        edit.setLayout(layout2);
        this.oSource = new ResourceMenu(GmObject.class, Messages.getString("RoomFrame.NO_OBJECT"), true, 110);
        this.oLocked = new JCheckBox(Messages.getString("RoomFrame.OBJ_LOCKED"));
        JLabel lObjName = new JLabel(Messages.getString("RoomFrame.OBJ_NAME"));
        this.objectName = new JTextField();
        this.objectName.addFocusListener(this);
        JLabel lObjX = new JLabel(Messages.getString("RoomFrame.OBJ_X"));
        this.objectHorizontalPosition = new NumberField(-99999, 99999);
        this.objectHorizontalPosition.setColumns(4);
        this.objectHorizontalPosition.addFocusListener(this);
        JLabel lObjY = new JLabel(Messages.getString("RoomFrame.OBJ_Y"));
        this.objectVerticalPosition = new NumberField(-99999, 99999);
        this.objectVerticalPosition.setColumns(4);
        this.objectVerticalPosition.addFocusListener(this);
        JLabel lObjScaleX = new JLabel(Messages.getString("RoomFrame.SCALE_X"));
        this.objectScaleX = new NumberField(-9999.0, 9999.0, 1.0, 2);
        this.objectScaleX.addFocusListener(this);
        JLabel lObjScaleY = new JLabel(Messages.getString("RoomFrame.SCALE_Y"));
        this.objectScaleY = new NumberField(-9999.0, 9999.0, 1.0, 2);
        this.objectScaleY.addFocusListener(this);
        JLabel lObjRotation = new JLabel(Messages.getString("RoomFrame.ROTATION"));
        this.objectRotation = new NumberField(0.0, 360.0, 0.0, 2);
        this.objectRotation.addFocusListener(this);
        JLabel lObjColour = new JLabel(Messages.getString("RoomFrame.COLOUR"));
        this.objectColor = new ColorSelect(Color.WHITE, false);
        this.objectColor.addItemListener(new ItemListener(){
            Color originalColor;
            {
                this.originalColor = RoomFrame.this.objectColor.getSelectedColor();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                RoomFrame.this.selectedPiece = RoomFrame.this.oList.getSelectedValue();
                if (RoomFrame.this.selectedPiece == null) {
                    return;
                }
                Color newColour = RoomFrame.this.objectColor.getSelectedColor();
                if (!this.originalColor.equals(newColour)) {
                    ModifyPieceInstance edit = new ModifyPieceInstance(RoomFrame.this, RoomFrame.this.selectedPiece, ModifyPieceInstance.Type.COLOR, this.originalColor, newColour);
                    RoomFrame.this.undoSupport.postEdit(edit);
                    this.originalColor = RoomFrame.this.objectColor.getSelectedColor();
                }
            }
        });
        JLabel lObjAlpha = new JLabel(Messages.getString("RoomFrame.ALPHA"));
        this.objectAlpha = new NumberField(0, 255, 255);
        this.objectAlpha.addFocusListener(this);
        this.oCreationCode = new JButton(Messages.getString("RoomFrame.OBJ_CODE"));
        this.oCreationCode.setIcon(CODE_ICON);
        this.oCreationCode.addActionListener(this);
        layout2.setHorizontalGroup(layout2.createParallelGroup().addComponent(this.oSource).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lObjName).addComponent(lObjX).addComponent(lObjScaleX).addComponent(lObjRotation).addComponent(lObjColour)).addGroup(layout2.createParallelGroup().addComponent(this.oLocked).addComponent(this.objectName).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup().addComponent(this.objectHorizontalPosition).addComponent(this.objectScaleX).addComponent(this.objectRotation)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lObjY).addComponent(lObjScaleY).addComponent(lObjAlpha)).addGroup(layout2.createParallelGroup().addComponent(this.objectVerticalPosition).addComponent(this.objectScaleY).addComponent(this.objectAlpha))).addGroup(layout2.createSequentialGroup().addComponent(this.objectColor)))).addComponent(this.oCreationCode, -1, -1, Integer.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createSequentialGroup().addComponent(this.oSource).addComponent(this.oLocked).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lObjName).addComponent(this.objectName)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lObjX).addComponent(this.objectHorizontalPosition).addComponent(lObjY).addComponent(this.objectVerticalPosition)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lObjScaleX).addComponent(this.objectScaleX).addComponent(lObjScaleY).addComponent(this.objectScaleY)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lObjRotation).addComponent(this.objectRotation).addComponent(lObjAlpha).addComponent(this.objectAlpha)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(lObjColour).addComponent(this.objectColor)).addComponent(this.oCreationCode));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.oNew).addComponent(this.oUnderlying).addComponent(sp, -1, 120, Integer.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addObjectButton, -1, -1, Integer.MAX_VALUE).addComponent(this.deleteObjectButton, -1, -1, Integer.MAX_VALUE)).addComponent(edit));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.oNew).addComponent(this.oUnderlying).addComponent(sp).addGroup(layout.createParallelGroup().addComponent(this.addObjectButton).addComponent(this.deleteObjectButton)).addComponent(edit, -2, -2, -2));
        this.fireObjUpdate();
        return panel;
    }

    private JPopupMenu makeShowMenu() {
        JPopupMenu showMenu = new JPopupMenu();
        String st = Messages.getString("RoomFrame.SHOW_OBJECTS");
        this.sSObj = new JCheckBoxMenuItem(st);
        this.prelf.make(this.sSObj, RoomEditor.PRoomEditor.SHOW_OBJECTS);
        showMenu.add(this.sSObj);
        st = Messages.getString("RoomFrame.SHOW_TILES");
        this.sSTile = new JCheckBoxMenuItem(st);
        this.prelf.make(this.sSTile, RoomEditor.PRoomEditor.SHOW_TILES);
        showMenu.add(this.sSTile);
        st = Messages.getString("RoomFrame.SHOW_BACKGROUNDS");
        this.sSBack = new JCheckBoxMenuItem(st);
        this.prelf.make(this.sSBack, RoomEditor.PRoomEditor.SHOW_BACKGROUNDS);
        showMenu.add(this.sSBack);
        st = Messages.getString("RoomFrame.SHOW_FOREGROUNDS");
        this.sSFore = new JCheckBoxMenuItem(st);
        this.prelf.make(this.sSFore, RoomEditor.PRoomEditor.SHOW_FOREGROUNDS);
        showMenu.add(this.sSFore);
        st = Messages.getString("RoomFrame.SHOW_VIEWS");
        this.sSView = new JCheckBoxMenuItem(st);
        this.prelf.make(this.sSView, RoomEditor.PRoomEditor.SHOW_VIEWS);
        showMenu.add(this.sSView);
        return showMenu;
    }

    public JPanel makeSettingsPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        JLabel lName = new JLabel(Messages.getString("RoomFrame.NAME"));
        JLabel lCaption = new JLabel(Messages.getString("RoomFrame.CAPTION"));
        this.sCaption = new JTextField();
        this.plf.make(this.sCaption.getDocument(), Room.PRoom.CAPTION);
        JLabel lWidth = new JLabel(Messages.getString("RoomFrame.WIDTH"));
        NumberField sWidth = new NumberField(1, 999999);
        this.plf.make(sWidth, Room.PRoom.WIDTH);
        JLabel lHeight = new JLabel(Messages.getString("RoomFrame.HEIGHT"));
        NumberField sHeight = new NumberField(1, 999999);
        this.plf.make(sHeight, Room.PRoom.HEIGHT);
        JLabel lSpeed = new JLabel(Messages.getString("RoomFrame.SPEED"));
        NumberField sSpeed = new NumberField(1, 9999);
        this.plf.make(sSpeed, Room.PRoom.SPEED);
        String str = Messages.getString("RoomFrame.PERSISTENT");
        this.sPersistent = new JCheckBox(str);
        this.plf.make(this.sPersistent, Room.PRoom.PERSISTENT);
        str = Messages.getString("RoomFrame.CREATION_CODE");
        this.sCreationCode = new JButton(str, CODE_ICON);
        this.sCreationCode.addActionListener(this);
        JPanel pg = this.makeGridPane();
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lName).addComponent(this.name, -1, 120, Integer.MAX_VALUE)).addComponent(lCaption).addComponent(this.sCaption, -1, 120, Integer.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lWidth).addComponent(lHeight).addComponent(lSpeed)).addGroup(layout.createParallelGroup().addComponent(sWidth).addComponent(sHeight).addComponent(sSpeed))).addComponent(this.sPersistent).addComponent(this.sCreationCode, -1, -1, Integer.MAX_VALUE).addComponent(pg));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lName).addComponent(this.name)).addComponent(lCaption).addComponent(this.sCaption, -1, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lWidth).addComponent(sWidth)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lHeight).addComponent(sHeight)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lSpeed).addComponent(sSpeed)).addComponent(this.sPersistent).addComponent(this.sCreationCode).addComponent(pg));
        return panel;
    }

    public JPanel makeGridPane() {
        JPanel pg = new JPanel();
        GroupLayout lr = new GroupLayout(pg);
        pg.setLayout(lr);
        pg.setBorder(BorderFactory.createTitledBorder(Messages.getString("RoomFrame.GRID")));
        JLabel lGX = new JLabel(Messages.getString("RoomFrame.GRID_X"));
        NumberField sGX = new NumberField(0, 999);
        this.prelf.make(sGX, RoomEditor.PRoomEditor.GRID_OFFSET_X);
        JLabel lGY = new JLabel(Messages.getString("RoomFrame.GRID_Y"));
        NumberField sGY = new NumberField(0, 999);
        this.prelf.make(sGY, RoomEditor.PRoomEditor.GRID_OFFSET_Y);
        JLabel lGW = new JLabel(Messages.getString("RoomFrame.GRID_W"));
        NumberField sGW = new NumberField(1, 999);
        this.plf.make(sGW, Room.PRoom.SNAP_X);
        JLabel lGH = new JLabel(Messages.getString("RoomFrame.GRID_H"));
        NumberField sGH = new NumberField(1, 999);
        this.plf.make(sGH, Room.PRoom.SNAP_Y);
        lr.setHorizontalGroup(lr.createSequentialGroup().addContainerGap().addGroup(lr.createParallelGroup().addComponent(lGX).addComponent(lGY)).addGap(4).addGroup(lr.createParallelGroup().addComponent(sGX).addComponent(sGY)).addGap(8).addGroup(lr.createParallelGroup().addComponent(lGW).addComponent(lGH)).addGap(4).addGroup(lr.createParallelGroup().addComponent(sGW).addComponent(sGH)).addContainerGap());
        lr.setVerticalGroup(lr.createSequentialGroup().addGap(4).addGroup(lr.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lGX).addComponent(sGX).addComponent(lGW).addComponent(sGW)).addGap(4).addGroup(lr.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lGY).addComponent(sGY).addComponent(lGH).addComponent(sGH)).addGap(8));
        return pg;
    }

    public JPanel makeTilesPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        JLabel layer = new JLabel(Messages.getString("RoomFrame.CURRENT_TILE_LAYER"));
        Room currentRoom = this.editor.getRoom();
        if (!currentRoom.tiles.isEmpty()) {
            this.layers = new Vector();
            for (Tile tile : currentRoom.tiles) {
                int depth = tile.getDepth();
                if (this.layers.contains(depth)) continue;
                this.layers.add(depth);
            }
        } else {
            this.layers.add(0);
        }
        Collections.sort(this.layers, Collections.reverseOrder());
        this.tileLayer = new JComboBox<Integer>(this.layers);
        this.tileLayer.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.tileLayer.getHeight()));
        this.addLayer = new JButton(Messages.getString("RoomFrame.TILE_LAYER_ADD"));
        this.addLayer.addActionListener(this);
        this.deleteLayer = new JButton(Messages.getString("RoomFrame.TILE_LAYER_DELETE"));
        this.deleteLayer.addActionListener(this);
        this.changeLayer = new JButton(Messages.getString("RoomFrame.TILE_LAYER_CHANGE"));
        this.changeLayer.addActionListener(this);
        this.tHideOtherLayers = new JCheckBox(Messages.getString("RoomFrame.TILE_HIDE_OTHER_LAYERS"));
        this.tHideOtherLayers.addActionListener(this);
        this.tEditOtherLayers = new JCheckBox(Messages.getString("RoomFrame.TILE_EDIT_OTHER_LAYERS"));
        this.tEditOtherLayers.addActionListener(this);
        JTabbedPane tab = new JTabbedPane();
        tab.addTab(Messages.getString("RoomFrame.TILE_ADD"), this.makeTilesAddPane());
        tab.addTab(Messages.getString("RoomFrame.TILE_EDIT"), this.makeTilesEditPane());
        tab.setSelectedIndex(0);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(layer).addComponent(this.tileLayer)).addGroup(layout.createSequentialGroup().addComponent(this.addLayer, -1, -2, Integer.MAX_VALUE).addComponent(this.deleteLayer, -1, -2, Integer.MAX_VALUE).addComponent(this.changeLayer, -1, -2, Integer.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.tHideOtherLayers, -2, -1, -2).addComponent(this.tEditOtherLayers)).addComponent(tab));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(layer).addComponent(this.tileLayer)).addGroup(layout.createParallelGroup().addComponent(this.addLayer).addComponent(this.deleteLayer).addComponent(this.changeLayer)).addGroup(layout.createParallelGroup().addComponent(this.tHideOtherLayers).addComponent(this.tEditOtherLayers)).addComponent(tab));
        this.fireTileUpdate();
        return panel;
    }

    public JPanel makeTilesAddPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.taSource = new ResourceMenu(Background.class, Messages.getString("RoomFrame.NO_BACKGROUND"), true, 110);
        this.taSource.addActionListener(this);
        this.tSelect = new TileSelector();
        this.tScroll = new JScrollPane(this.tSelect);
        this.tScroll.setPreferredSize(this.tScroll.getSize());
        this.tUnderlying = new JCheckBox(Messages.getString("RoomFrame.TILE_UNDERLYING"));
        this.prelf.make(this.tUnderlying, RoomEditor.PRoomEditor.DELETE_UNDERLYING_TILES);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.tScroll).addComponent(this.taSource).addComponent(this.tUnderlying));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.tScroll).addComponent(this.taSource).addComponent(this.tUnderlying));
        return panel;
    }

    public JPanel makeTilesEditPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        MouseAdapter mouseListenerForTiles = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RoomFrame.this.showSelectedTile();
            }
        };
        this.tList = new JList<Tile>(new ArrayListModel<Tile>(((Room)this.res).tiles));
        this.tList.addListSelectionListener(this);
        this.tList.addMouseListener(mouseListenerForTiles);
        this.tList.setSelectionMode(0);
        this.tList.setCellRenderer(new TileListComponentRenderer());
        JScrollPane sp = new JScrollPane(this.tList);
        this.deleteTileButton = new JButton(Messages.getString("RoomFrame.TILE_DELETE"));
        this.deleteTileButton.addActionListener(this);
        this.tLocked = new JCheckBox(Messages.getString("RoomFrame.TILE_LOCKED"));
        JPanel pSet = new JPanel();
        pSet.setBorder(BorderFactory.createTitledBorder(Messages.getString("RoomFrame.TILESET")));
        GroupLayout psl = new GroupLayout(pSet);
        psl.setAutoCreateGaps(true);
        psl.setAutoCreateContainerGaps(true);
        pSet.setLayout(psl);
        this.teSource = new ResourceMenu(Background.class, Messages.getString("RoomFrame.NO_BACKGROUND"), true, 110);
        JLabel ltsx = new JLabel(Messages.getString("RoomFrame.TILESET_X"));
        this.tsX = new NumberField(0);
        this.tsX.setColumns(4);
        JLabel ltsy = new JLabel(Messages.getString("RoomFrame.TILESET_Y"));
        this.tsY = new NumberField(0);
        this.tsY.setColumns(4);
        psl.setHorizontalGroup(psl.createParallelGroup().addComponent(this.teSource).addGroup(psl.createSequentialGroup().addComponent(ltsx).addComponent(this.tsX).addComponent(ltsy).addComponent(this.tsY)));
        psl.setVerticalGroup(psl.createSequentialGroup().addComponent(this.teSource).addGroup(psl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ltsx).addComponent(this.tsX).addComponent(ltsy).addComponent(this.tsY)));
        JPanel pTile = new JPanel();
        pTile.setBorder(BorderFactory.createTitledBorder(Messages.getString("RoomFrame.TILE")));
        GroupLayout ptl = new GroupLayout(pTile);
        ptl.setAutoCreateGaps(true);
        ptl.setAutoCreateContainerGaps(true);
        pTile.setLayout(ptl);
        JLabel ltx = new JLabel(Messages.getString("RoomFrame.TILE_X"));
        this.tileHorizontalPosition = new NumberField(0);
        this.tileHorizontalPosition.setColumns(4);
        this.tileHorizontalPosition.addFocusListener(this);
        JLabel lty = new JLabel(Messages.getString("RoomFrame.TILE_Y"));
        this.tileVerticalPosition = new NumberField(0);
        this.tileVerticalPosition.setColumns(4);
        this.tileVerticalPosition.addFocusListener(this);
        JLabel ltl = new JLabel(Messages.getString("RoomFrame.TILE_LAYER"));
        this.teDepth = new NumberField(0);
        this.teDepth.setColumns(8);
        ptl.setHorizontalGroup(ptl.createParallelGroup().addGroup(ptl.createSequentialGroup().addComponent(ltx).addComponent(this.tileHorizontalPosition).addComponent(lty).addComponent(this.tileVerticalPosition)).addGroup(ptl.createSequentialGroup().addComponent(ltl).addComponent(this.teDepth)));
        ptl.setVerticalGroup(ptl.createSequentialGroup().addGroup(ptl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ltx).addComponent(this.tileHorizontalPosition).addComponent(lty).addComponent(this.tileVerticalPosition)).addGroup(ptl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(ltl).addComponent(this.teDepth)));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(sp, -1, 120, Integer.MAX_VALUE).addComponent(this.deleteTileButton, -1, -1, Integer.MAX_VALUE).addComponent(this.tLocked).addComponent(pSet).addComponent(pTile));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(sp, -1, 60, Integer.MAX_VALUE).addComponent(this.deleteTileButton).addComponent(this.tLocked).addComponent(pSet).addComponent(pTile));
        return panel;
    }

    public JPanel makeBackgroundsPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.bDrawColor = new JCheckBox(Messages.getString("RoomFrame.DRAW_COLOR"));
        this.plf.make(this.bDrawColor, Room.PRoom.DRAW_BACKGROUND_COLOR);
        JLabel lColor = new JLabel(Messages.getString("RoomFrame.COLOR"));
        this.bColor = new ColorSelect();
        this.plf.make(this.bColor, Room.PRoom.BACKGROUND_COLOR);
        JLabel[] backLabs = new JLabel[((Room)this.res).backgroundDefs.size()];
        int i = 0;
        while (i < backLabs.length) {
            backLabs[i] = new JLabel(" " + Messages.getString("RoomFrame.BACK") + i);
            boolean v = (Boolean)((Room)this.res).backgroundDefs.get((int)i).properties.get(BackgroundDef.PBackgroundDef.VISIBLE);
            backLabs[i].setFont(backLabs[i].getFont().deriveFont(v ? 1 : 0));
            backLabs[i].setOpaque(true);
            ++i;
        }
        this.bList = new JList<JLabel>(backLabs);
        this.bList.setCellRenderer(new ListComponentRenderer());
        this.bList.addListSelectionListener(this);
        this.bList.setSelectionMode(0);
        this.bList.setVisibleRowCount(4);
        JScrollPane sp = new JScrollPane(this.bList);
        for (BackgroundDef d : ((Room)this.res).backgroundDefs) {
            d.properties.getUpdateSource(BackgroundDef.PBackgroundDef.VISIBLE).addListener(this.bdpl);
        }
        this.bVisible = new JCheckBox(Messages.getString("RoomFrame.BACK_VISIBLE"));
        this.bForeground = new JCheckBox(Messages.getString("RoomFrame.BACK_FOREGROUND"));
        this.bSource = new ResourceMenu(Background.class, Messages.getString("RoomFrame.NO_BACKGROUND"), true, 150);
        this.bTileH = new JCheckBox(Messages.getString("RoomFrame.BACK_TILE_HOR"));
        JLabel lbx = new JLabel(Messages.getString("RoomFrame.BACK_X"));
        this.bX = new NumberField(0);
        this.bX.setColumns(4);
        this.bTileV = new JCheckBox(Messages.getString("RoomFrame.BACK_TILE_VERT"));
        JLabel lby = new JLabel(Messages.getString("RoomFrame.BACK_Y"));
        this.bY = new NumberField(0);
        this.bY.setColumns(4);
        this.bStretch = new JCheckBox(Messages.getString("RoomFrame.BACK_STRETCH"));
        JLabel lbh = new JLabel(Messages.getString("RoomFrame.BACK_HSPEED"));
        this.bH = new NumberField(-999, 999);
        JLabel lbv = new JLabel(Messages.getString("RoomFrame.BACK_VSPEED"));
        this.bV = new NumberField(-999, 999);
        this.bList.setSelectedIndex(0);
        Insets spi = sp.getInsets();
        int spmh = this.bList.getMaximumSize().height + spi.bottom + spi.top;
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.bDrawColor).addGroup(layout.createSequentialGroup().addComponent(lColor).addComponent(this.bColor)).addComponent(sp).addGroup(layout.createSequentialGroup().addComponent(this.bVisible).addComponent(this.bForeground)).addComponent(this.bSource).addGroup(layout.createSequentialGroup().addComponent(lbx).addComponent(this.bX).addComponent(lby).addComponent(this.bY)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lbh).addComponent(lbv)).addGroup(layout.createParallelGroup().addComponent(this.bH).addComponent(this.bV))).addComponent(this.bTileH).addComponent(this.bTileV).addComponent(this.bStretch));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.bDrawColor).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(lColor).addComponent(this.bColor)).addComponent(sp, -1, -1, spmh).addGroup(layout.createParallelGroup().addComponent(this.bVisible).addComponent(this.bForeground)).addComponent(this.bSource).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lbx).addComponent(this.bX).addComponent(lby).addComponent(this.bY)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lbh).addComponent(this.bH)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lbv).addComponent(this.bV)).addComponent(this.bTileH).addComponent(this.bTileV).addComponent(this.bStretch));
        return panel;
    }

    public JPanel makePhysicsPane() {
        JPanel panel = new JPanel();
        JCheckBox phyWorldCB = new JCheckBox(Messages.getString("RoomFrame.PHY_WORLD_ENABLED"));
        this.plf.make(phyWorldCB, Room.PRoom.PHYSICS_WORLD);
        JLabel pixMetersLabel = new JLabel(Messages.getString("RoomFrame.PHY_PIXELSPERMETER"));
        NumberField pixMetersField = new NumberField(0.1);
        this.plf.make(pixMetersField, Room.PRoom.PHYSICS_PIXTOMETERS);
        pixMetersField.setColumns(16);
        JLabel gravityXLabel = new JLabel(Messages.getString("RoomFrame.PHY_GRAVITY_X"));
        NumberField gravityXField = new NumberField(0.0);
        this.plf.make(gravityXField, Room.PRoom.PHYSICS_GRAVITY_X);
        gravityXField.setColumns(16);
        JLabel gravityYLabel = new JLabel(Messages.getString("RoomFrame.PHY_GRAVITY_Y"));
        NumberField gravityYField = new NumberField(10.0);
        this.plf.make(gravityYField, Room.PRoom.PHYSICS_GRAVITY_Y);
        gravityYField.setColumns(16);
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(phyWorldCB).addGroup(layout.createSequentialGroup().addComponent(pixMetersLabel).addComponent(pixMetersField)).addGroup(layout.createSequentialGroup().addComponent(gravityXLabel).addComponent(gravityXField)).addGroup(layout.createSequentialGroup().addComponent(gravityYLabel).addComponent(gravityYField)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(phyWorldCB).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(pixMetersLabel).addComponent(pixMetersField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(gravityXLabel).addComponent(gravityXField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(gravityYLabel).addComponent(gravityYField)));
        return panel;
    }

    public JPanel makeViewsPane() {
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        panel.setLayout(layout);
        this.vEnabled = new JCheckBox(Messages.getString("RoomFrame.VIEWS_ENABLED"));
        this.plf.make(this.vEnabled, Room.PRoom.VIEWS_ENABLED);
        this.vClear = new JCheckBox(Messages.getString("RoomFrame.VIEWS_CLEAR"));
        this.plf.make(this.vClear, Room.PRoom.VIEWS_CLEAR);
        JLabel[] viewLabs = new JLabel[((Room)this.res).views.size()];
        int i = 0;
        while (i < viewLabs.length) {
            viewLabs[i] = new JLabel(" " + Messages.getString("RoomFrame.VIEW") + i);
            boolean v = (Boolean)((Room)this.res).views.get((int)i).properties.get(View.PView.VISIBLE);
            viewLabs[i].setFont(viewLabs[i].getFont().deriveFont(v ? 1 : 0));
            viewLabs[i].setOpaque(true);
            ++i;
        }
        this.vList = new JList<JLabel>(viewLabs);
        this.vList.setCellRenderer(new ListComponentRenderer());
        this.vList.addListSelectionListener(this);
        this.vList.setSelectionMode(0);
        JScrollPane sp = new JScrollPane(this.vList);
        for (View v : ((Room)this.res).views) {
            v.properties.getUpdateSource(View.PView.VISIBLE).addListener(this.vpl);
            v.properties.getUpdateSource(View.PView.OBJECT).addListener(this.vpl);
            v.properties.getUpdateSource(View.PView.VIEW_W).addListener(this.vpl);
            v.properties.getUpdateSource(View.PView.VIEW_H).addListener(this.vpl);
            v.properties.getUpdateSource(View.PView.BORDER_H).addListener(this.vpl);
            v.properties.getUpdateSource(View.PView.BORDER_V).addListener(this.vpl);
        }
        this.vVisible = new JCheckBox(Messages.getString("RoomFrame.VIEW_ENABLED"));
        JTabbedPane tp = this.makeViewsDimensionsPane();
        JPanel pf = this.makeViewsFollowPane();
        this.vList.setSelectedIndex(0);
        Insets spi = sp.getInsets();
        int spmh = this.vList.getMaximumSize().height + spi.bottom + spi.top;
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.vEnabled).addComponent(this.vClear).addComponent(sp).addComponent(this.vVisible).addComponent(tp).addComponent(pf));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.vEnabled).addComponent(this.vClear).addComponent(sp, -1, -1, spmh).addComponent(this.vVisible).addComponent(tp, -1, -1, -2).addComponent(pf));
        return panel;
    }

    private JTabbedPane makeViewsDimensionsPane() {
        JPanel pr = new JPanel();
        GroupLayout lr = new GroupLayout(pr);
        pr.setLayout(lr);
        JLabel lRX = new JLabel(Messages.getString("RoomFrame.VIEW_X"));
        this.vRX = new NumberField(0, 999999);
        JLabel lRW = new JLabel(Messages.getString("RoomFrame.VIEW_W"));
        this.vRW = new NumberField(1, 999999);
        JLabel lRY = new JLabel(Messages.getString("RoomFrame.VIEW_Y"));
        this.vRY = new NumberField(0, 999999);
        JLabel lRH = new JLabel(Messages.getString("RoomFrame.VIEW_H"));
        this.vRH = new NumberField(1, 999999);
        lr.setHorizontalGroup(lr.createSequentialGroup().addContainerGap().addGroup(lr.createParallelGroup().addComponent(lRX).addComponent(lRY)).addGap(4).addGroup(lr.createParallelGroup().addComponent(this.vRX).addComponent(this.vRY)).addGap(8).addGroup(lr.createParallelGroup().addComponent(lRW).addComponent(lRH)).addGap(4).addGroup(lr.createParallelGroup().addComponent(this.vRW).addComponent(this.vRH)).addContainerGap());
        lr.setVerticalGroup(lr.createSequentialGroup().addGap(4).addGroup(lr.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lRX).addComponent(this.vRX).addComponent(lRW).addComponent(this.vRW)).addGap(4).addGroup(lr.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lRY).addComponent(this.vRY).addComponent(lRH).addComponent(this.vRH)).addGap(8));
        JPanel pp = new JPanel();
        GroupLayout lp = new GroupLayout(pp);
        pp.setLayout(lp);
        JLabel lPX = new JLabel(Messages.getString("RoomFrame.PORT_X"));
        this.vPX = new NumberField(0, 999999);
        JLabel lPW = new JLabel(Messages.getString("RoomFrame.PORT_W"));
        this.vPW = new NumberField(1, 999999);
        JLabel lPY = new JLabel(Messages.getString("RoomFrame.PORT_Y"));
        this.vPY = new NumberField(0, 999999);
        JLabel lPH = new JLabel(Messages.getString("RoomFrame.PORT_H"));
        this.vPH = new NumberField(1, 999999);
        lp.setHorizontalGroup(lp.createSequentialGroup().addContainerGap().addGroup(lp.createParallelGroup().addComponent(lPX).addComponent(lPY)).addGap(4).addGroup(lp.createParallelGroup().addComponent(this.vPX).addComponent(this.vPY)).addGap(8).addGroup(lp.createParallelGroup().addComponent(lPW).addComponent(lPH)).addGap(4).addGroup(lp.createParallelGroup().addComponent(this.vPW).addComponent(this.vPH)).addContainerGap());
        lp.setVerticalGroup(lp.createSequentialGroup().addGap(4).addGroup(lp.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lPX).addComponent(this.vPX).addComponent(lPW).addComponent(this.vPW)).addGap(4).addGroup(lp.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lPY).addComponent(this.vPY).addComponent(lPH).addComponent(this.vPH)).addGap(8));
        JTabbedPane tp = new JTabbedPane();
        tp.setTabLayoutPolicy(1);
        tp.addTab(Messages.getString("RoomFrame.VIEW_IN_ROOM"), pr);
        tp.addTab(Messages.getString("RoomFrame.PORT"), pp);
        return tp;
    }

    private JPanel makeViewsFollowPane() {
        JPanel pf = new JPanel();
        pf.setBorder(BorderFactory.createTitledBorder(Messages.getString("RoomFrame.FOLLOW")));
        GroupLayout lf = new GroupLayout(pf);
        pf.setLayout(lf);
        this.vObj = new ResourceMenu(GmObject.class, Messages.getString("RoomFrame.NO_OBJECT"), true, 110);
        JLabel lH = new JLabel(Messages.getString("RoomFrame.VIEW_HORIZONTAL"));
        JLabel lV = new JLabel(Messages.getString("RoomFrame.VIEW_VERTICAL"));
        JLabel lBorder = new JLabel(Messages.getString("RoomFrame.VIEW_BORDER"));
        JLabel lSpeed = new JLabel(Messages.getString("RoomFrame.VIEW_SPEED"));
        this.vOHBor = new NumberField(0, 32000);
        this.vOHSp = new NumberField(-1, 32000);
        this.vOVBor = new NumberField(0, 32000);
        this.vOVSp = new NumberField(-1, 32000);
        lf.setHorizontalGroup(lf.createSequentialGroup().addContainerGap().addGroup(lf.createParallelGroup().addComponent(this.vObj).addGroup(lf.createSequentialGroup().addGroup(lf.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lH).addComponent(lV)).addGap(4).addGroup(lf.createParallelGroup().addComponent(lBorder).addComponent(this.vOHBor).addComponent(this.vOVBor)).addGap(4).addGroup(lf.createParallelGroup().addComponent(lSpeed).addComponent(this.vOHSp).addComponent(this.vOVSp)))).addContainerGap());
        lf.setVerticalGroup(lf.createSequentialGroup().addGap(4).addComponent(this.vObj).addGap(4).addGroup(lf.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lBorder).addComponent(lSpeed)).addGap(4).addGroup(lf.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lH).addComponent(this.vOHBor).addComponent(this.vOHSp)).addGap(4).addGroup(lf.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lV).addComponent(this.vOVBor).addComponent(this.vOVSp)).addGap(8));
        return pf;
    }

    private JPanel makeStatsPane() {
        JPanel stat = new JPanel();
        stat.setLayout(new BoxLayout(stat, 0));
        stat.setMaximumSize(new Dimension(Integer.MAX_VALUE, 11));
        this.statX = new JLabel(Messages.getString("RoomFrame.STAT_X"));
        this.statX.setMaximumSize(new Dimension(50, 14));
        stat.add(this.statX);
        JSeparator sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(8, sep.getMaximumSize().height));
        stat.add(sep);
        this.statY = new JLabel(Messages.getString("RoomFrame.STAT_Y"));
        this.statY.setMaximumSize(new Dimension(50, 13));
        stat.add(this.statY);
        sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(8, sep.getMaximumSize().height));
        stat.add(sep);
        this.statId = new JLabel();
        stat.add(this.statId);
        sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(8, sep.getMaximumSize().height));
        stat.add(sep);
        this.statSrc = new JLabel();
        stat.add(this.statSrc);
        return stat;
    }

    public RoomFrame(Room res, ResNode node) {
        super(res, node);
        this.editor = new RoomEditor(res, this);
        this.prelf = new PropertyLinkFactory<RoomEditor.PRoomEditor>(this.editor.properties, null);
        this.addSecondaryPropertyLinkFactory(this.prelf);
        this.iplf = new PropertyLinkFactory(null, null);
        this.addSecondaryPropertyLinkFactory(this.iplf);
        this.tplf = new PropertyLinkFactory(null, null);
        this.addSecondaryPropertyLinkFactory(this.tplf);
        GroupLayout layout = new GroupLayout(this.getContentPane()){

            @Override
            public void layoutContainer(Container parent) {
                Dimension m = RoomFrame.this.getMinimumSize();
                Dimension s = RoomFrame.this.getSize();
                Dimension r = new Dimension(Math.max(m.width, s.width), Math.max(m.height, s.height));
                if (!r.equals(s)) {
                    RoomFrame.this.setSize(r);
                } else {
                    super.layoutContainer(parent);
                }
            }
        };
        this.setLayout(layout);
        JToolBar tools = this.makeToolBar();
        this.tabs = new JTabbedPane();
        this.tabs.setTabLayoutPolicy(0);
        this.tabs.addTab(Messages.getString("RoomFrame.TAB_OBJECTS"), this.makeObjectsPane());
        this.tabs.addTab(Messages.getString("RoomFrame.TAB_SETTINGS"), this.makeSettingsPane());
        this.tabs.addTab(Messages.getString("RoomFrame.TAB_TILES"), this.makeTilesPane());
        String bks = Messages.getString("RoomFrame.TAB_BACKGROUNDS");
        this.tabs.addTab(bks, this.makeBackgroundsPane());
        this.tabs.addTab(Messages.getString("RoomFrame.TAB_VIEWS"), this.makeViewsPane());
        this.tabs.addTab(Messages.getString("RoomFrame.TAB_PHYSICS"), this.makePhysicsPane());
        int selectedTab = (Integer)res.get(Room.PRoom.CURRENT_TAB);
        this.tabs.setSelectedIndex(selectedTab);
        this.tabs.addChangeListener(this);
        res.instanceUpdateSource.addListener(this);
        res.tileUpdateSource.addListener(this);
        this.editorPane = new EditorScrollPane(this.editor, true);
        this.prelf.make(this.editorPane, RoomEditor.PRoomEditor.ZOOM);
        if (selectedTab == 4) {
            this.showSelectedView();
            this.editor.roomVisual.setViewsVisible(true);
        }
        JPanel stats = this.makeStatsPane();
        GroupLayout.SequentialGroup orientationGroup = layout.createSequentialGroup();
        if (!Prefs.rightOrientation) {
            orientationGroup.addComponent(this.tabs, -2, -2, -2);
        }
        orientationGroup.addGroup(layout.createParallelGroup().addComponent(this.editorPane, 200, 640, -1).addComponent(stats));
        if (Prefs.rightOrientation) {
            orientationGroup.addComponent(this.tabs, -2, -2, -2);
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(tools, -2, -2, Integer.MAX_VALUE).addGroup(orientationGroup));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(tools, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.tabs).addGroup(layout.createSequentialGroup().addComponent(this.editorPane, -1, 480, -1).addComponent(stats))));
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(Prefs.undoHistorySize);
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(new UndoAdapter());
        this.refreshUndoRedoButtons();
        if (((Boolean)res.get(Room.PRoom.REMEMBER_WINDOW_SIZE)).booleanValue()) {
            int h = (Integer)res.get(Room.PRoom.EDITOR_HEIGHT);
            int w = (Integer)res.get(Room.PRoom.EDITOR_WIDTH);
            Dimension d = LGM.mdi.getSize();
            if (d.width <= w && d.height <= h) {
                this.maximize = true;
            } else {
                this.setSize(w, h);
            }
        } else {
            this.pack();
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!this.maximize) {
            return;
        }
        try {
            this.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            this.setSize((Integer)((Room)this.res).get(Room.PRoom.EDITOR_WIDTH), (Integer)((Room)this.res).get(Room.PRoom.EDITOR_HEIGHT));
            e.printStackTrace();
        }
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return ((Room)this.res).backgroundDefs.equals(((Room)this.resOriginal).backgroundDefs) && ((Room)this.res).views.equals(((Room)this.resOriginal).views) && ((Room)this.res).instances.equals(((Room)this.resOriginal).instances) && ((Room)this.res).tiles.equals(((Room)this.resOriginal).tiles);
    }

    @Override
    public void commitChanges() {
        ((Room)this.res).setName(this.name.getText());
        for (CodeFrame cf : this.codeFrames.values()) {
            cf.commitChanges();
        }
        if (((Boolean)((Room)this.res).get(Room.PRoom.REMEMBER_WINDOW_SIZE)).booleanValue()) {
            ((Room)this.res).put(Room.PRoom.CURRENT_TAB, this.tabs.getSelectedIndex());
            Dimension s = this.getSize();
            ((Room)this.res).put(Room.PRoom.EDITOR_WIDTH, s.width);
            ((Room)this.res).put(Room.PRoom.EDITOR_HEIGHT, s.height);
        }
    }

    private void deleteAction() {
        this.deleteAction(true);
    }

    private void deleteAction(boolean askConfirmation) {
        boolean tilesTabIsSelected = this.tabs.getSelectedIndex() == 2;
        int result = 0;
        if (askConfirmation) {
            String message = tilesTabIsSelected ? Messages.getString("RoomFrame.DELETE_TILES") : Messages.getString("RoomFrame.DELETE_OBJECTS");
            result = JOptionPane.showConfirmDialog(this, message, Messages.getString("RoomFrame.DELETE_TITLE"), 0);
        }
        if (result == 0 || !askConfirmation) {
            Room.Piece selectedPiece = this.editor.getSelectedPiece();
            if (selectedPiece != null) {
                selectedPiece.setSelected(false);
            }
            Room currentRoom = this.editor.getRoom();
            CompoundEdit compoundEdit = new CompoundEdit();
            if (this.editor.selection != null) {
                Rectangle selection = this.editor.selection;
                if (tilesTabIsSelected) {
                    this.deleteTilesInSelection(selection, compoundEdit);
                } else {
                    this.deleteInstancesInSelection(selection, compoundEdit);
                }
            } else if (tilesTabIsSelected) {
                int i = currentRoom.tiles.size() - 1;
                while (i >= 0) {
                    RemovePieceInstance edit = new RemovePieceInstance(this, (Room.Piece)currentRoom.tiles.get(i), i);
                    compoundEdit.addEdit(edit);
                    --i;
                }
                currentRoom.tiles.clear();
            } else {
                int i = currentRoom.instances.size() - 1;
                while (i >= 0) {
                    RemovePieceInstance edit = new RemovePieceInstance(this, (Room.Piece)currentRoom.instances.get(i), i);
                    compoundEdit.addEdit(edit);
                    --i;
                }
                currentRoom.instances.clear();
            }
            compoundEdit.end();
            this.undoSupport.postEdit(compoundEdit);
        }
    }

    public void deleteInstancesInSelection(Rectangle selection, CompoundEdit compoundEdit) {
        Room currentRoom = this.editor.getRoom();
        int i = currentRoom.instances.size() - 1;
        while (i >= 0) {
            Point instancePosition = ((Instance)currentRoom.instances.get(i)).getPosition();
            if (instancePosition.x >= selection.x && instancePosition.x < selection.x + selection.width && instancePosition.y >= selection.y && instancePosition.y < selection.y + selection.height) {
                RemovePieceInstance edit = new RemovePieceInstance(this, (Room.Piece)currentRoom.instances.get(i), i);
                compoundEdit.addEdit(edit);
                currentRoom.instances.remove(i);
            }
            --i;
        }
    }

    public void deleteTilesInSelection(Rectangle selection, CompoundEdit compoundEdit) {
        Room currentRoom = this.editor.getRoom();
        Integer depth = (Integer)this.tileLayer.getSelectedItem();
        int i = currentRoom.tiles.size() - 1;
        while (i >= 0) {
            Point tilePosition = ((Tile)currentRoom.tiles.get(i)).getPosition();
            if (tilePosition.x >= selection.x && tilePosition.x < selection.x + selection.width && tilePosition.y >= selection.y && tilePosition.y < selection.y + selection.height && (this.tEditOtherLayers.isSelected() || ((Tile)currentRoom.tiles.get(i)).getDepth() == depth.intValue())) {
                RemovePieceInstance edit = new RemovePieceInstance(this, (Room.Piece)currentRoom.tiles.get(i), i);
                compoundEdit.addEdit(edit);
                currentRoom.tiles.remove(i);
            }
            --i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        Room currentRoom;
        Object eventSource = e.getSource();
        if (eventSource == this.fill) {
            if (this.editor.selection == null) {
                return;
            }
            boolean tilesTabIsSelected = this.tabs.getSelectedIndex() == 2;
            boolean objectsTabIsSelected = this.tabs.getSelectedIndex() == 0;
            boolean snapToGridMode = (Boolean)this.editor.properties.get(RoomEditor.PRoomEditor.SNAP_TO_GRID);
            boolean deleteUnderlyingObjects = (Boolean)this.editor.properties.get(RoomEditor.PRoomEditor.DELETE_UNDERLYING_OBJECTS);
            boolean deleteUnderlyingTiles = (Boolean)this.editor.properties.get(RoomEditor.PRoomEditor.DELETE_UNDERLYING_TILES);
            if (objectsTabIsSelected && this.oNew.getSelected() == null) {
                return;
            }
            if (tilesTabIsSelected && this.taSource.getSelected() == null) {
                return;
            }
            if (this.selectedPiece != null) {
                this.selectedPiece.setSelected(false);
            }
            currentRoom = this.editor.getRoom();
            Rectangle selection = this.editor.selection;
            int snapX = (Integer)currentRoom.properties.get(Room.PRoom.SNAP_X);
            int snapY = (Integer)currentRoom.properties.get(Room.PRoom.SNAP_Y);
            Dimension cellDimension = null;
            Dimension tileDimension = null;
            CompoundEdit compoundEdit = new CompoundEdit();
            if (tilesTabIsSelected) {
                ResourceReference<Background> bkg;
                Background b;
                if (deleteUnderlyingTiles) {
                    this.deleteTilesInSelection(selection, compoundEdit);
                }
                tileDimension = (Boolean)(b = (bkg = this.taSource.getSelected()).get()).get(Background.PBackground.USE_AS_TILESET) == false ? new Dimension(b.getWidth(), b.getHeight()) : new Dimension((Integer)b.get(Background.PBackground.TILE_WIDTH), (Integer)b.get(Background.PBackground.TILE_HEIGHT));
            }
            if (objectsTabIsSelected && deleteUnderlyingObjects) {
                this.deleteInstancesInSelection(selection, compoundEdit);
            }
            if (!snapToGridMode) {
                if (objectsTabIsSelected) {
                    ResourceReference<GmObject> instanceObject = this.oNew.getSelected();
                    BufferedImage image = instanceObject.get().getDisplayImage();
                    if (image == null) {
                        ImageIcon emptySprite = LGM.getIconForKey("Resource.EMPTY_OBJ");
                        cellDimension = new Dimension(emptySprite.getIconWidth(), emptySprite.getIconHeight());
                    } else {
                        cellDimension = new Dimension(image.getWidth(), image.getHeight());
                    }
                } else {
                    cellDimension = tileDimension;
                }
            } else {
                cellDimension = new Dimension(snapX, snapY);
            }
            int numberOfColumns = this.editor.selection.width / cellDimension.width;
            int numberOfRows = this.editor.selection.height / cellDimension.height;
            int i = 0;
            while (i < numberOfColumns) {
                int j = 0;
                while (j < numberOfRows) {
                    Point newPosition = new Point(selection.x + cellDimension.width * i, selection.y + cellDimension.height * j);
                    if (objectsTabIsSelected) {
                        Instance newInstance = ((Room)this.res).addInstance();
                        newInstance.properties.put(Instance.PInstance.OBJECT, (Object)this.oNew.getSelected());
                        newInstance.setPosition(newPosition);
                        AddPieceInstance edit = new AddPieceInstance(this, newInstance, currentRoom.instances.size() - 1);
                        compoundEdit.addEdit(edit);
                    }
                    if (tilesTabIsSelected) {
                        ResourceReference<Background> bkg = this.taSource.getSelected();
                        Tile newTile = new Tile(currentRoom, LGM.currentFile);
                        newTile.properties.put(Tile.PTile.BACKGROUND, (Object)bkg);
                        newTile.setBackgroundPosition(new Point(this.tSelect.tx, this.tSelect.ty));
                        newTile.setPosition(newPosition);
                        newTile.setSize(tileDimension);
                        newTile.setDepth((Integer)this.tileLayer.getSelectedItem());
                        currentRoom.tiles.add(newTile);
                        AddPieceInstance edit = new AddPieceInstance(this, newTile, currentRoom.tiles.size() - 1);
                        compoundEdit.addEdit(edit);
                    }
                    ++j;
                }
                ++i;
            }
            compoundEdit.end();
            this.undoSupport.postEdit(compoundEdit);
        }
        if (eventSource == this.addLayer) {
            Integer newDepth;
            JPanel myPanel = new JPanel();
            myPanel.add(new JLabel(Messages.getString("RoomFrame.TILE_DEPTH")));
            NumberField depth = new NumberField(Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
            myPanel.add(depth);
            int result2 = JOptionPane.showConfirmDialog(this, myPanel, Messages.getString("RoomFrame.ADD_NEW_TILE"), 2, -1);
            if (result2 == 0 && !this.layers.contains(newDepth = depth.getIntValue())) {
                this.layers.add(newDepth);
                Collections.sort(this.layers, Collections.reverseOrder());
                this.tileLayer.setSelectedItem(newDepth);
            }
        }
        if (eventSource == this.deleteLayer && (result = JOptionPane.showConfirmDialog(this, Messages.getString("RoomFrame.DELETE_TILE_LAYER"), Messages.getString("RoomFrame.DELETE_TITLE"), 0)) == 0) {
            Room currentRoom2 = this.editor.getRoom();
            Integer depth = (Integer)this.tileLayer.getSelectedItem();
            CompoundEdit compoundEdit = new CompoundEdit();
            int i = currentRoom2.tiles.size() - 1;
            while (i >= 0) {
                if (((Tile)currentRoom2.tiles.get(i)).getDepth() == depth.intValue()) {
                    RemovePieceInstance edit = new RemovePieceInstance(this, (Room.Piece)currentRoom2.tiles.get(i), i);
                    compoundEdit.addEdit(edit);
                    currentRoom2.tiles.remove(i);
                }
                --i;
            }
            compoundEdit.end();
            this.undoSupport.postEdit(compoundEdit);
            this.layers.remove(depth);
            if (this.layers.size() == 0) {
                this.layers.add(0);
            }
            this.tileLayer.setSelectedIndex(0);
        }
        if (eventSource == this.changeLayer) {
            JPanel myPanel = new JPanel();
            myPanel.add(new JLabel(Messages.getString("RoomFrame.TILE_DEPTH")));
            Integer depth = (Integer)this.tileLayer.getSelectedItem();
            NumberField depthField = new NumberField(Integer.MIN_VALUE, Integer.MAX_VALUE, (int)depth);
            myPanel.add(depthField);
            int result3 = JOptionPane.showConfirmDialog(this, myPanel, Messages.getString("RoomFrame.CHANGE_TILE_LAYER"), 2, -1);
            Integer newDepth = depthField.getIntValue();
            if (result3 == 0 && newDepth != depth) {
                currentRoom = this.editor.getRoom();
                int i = currentRoom.tiles.size() - 1;
                while (i >= 0) {
                    Tile tile = (Tile)currentRoom.tiles.get(i);
                    if (tile.getDepth() == depth.intValue()) {
                        tile.setDepth(newDepth);
                    }
                    --i;
                }
                this.layers.remove(depth);
                if (!this.layers.contains(newDepth)) {
                    this.layers.add(newDepth);
                }
                Collections.sort(this.layers, Collections.reverseOrder());
                this.tileLayer.setSelectedItem(newDepth);
            }
        }
        if (eventSource == this.tEditOtherLayers) {
            if (this.tEditOtherLayers.isSelected()) {
                this.editor.editOtherLayers(true);
            } else {
                this.editor.editOtherLayers(false);
            }
        }
        if (eventSource == this.tHideOtherLayers) {
            if (this.tHideOtherLayers.isSelected()) {
                this.editor.roomVisual.setVisibleLayer((Integer)this.tileLayer.getSelectedItem());
            } else {
                this.editor.roomVisual.setVisibleLayer(null);
            }
        }
        if (eventSource == this.roomControls) {
            if (roomControlsFrame == null) {
                roomControlsFrame = new JDialog((Frame)LGM.frame, Messages.getString("RoomControls.TITLE"));
                roomControlsFrame.setIconImage(LGM.getIconForKey("RoomFrame.ROOM_CONTROLS").getImage());
                Border padding = BorderFactory.createEmptyBorder(15, 15, 15, 15);
                JPanel contentPanel = new JPanel();
                contentPanel.setBorder(padding);
                roomControlsFrame.setContentPane(contentPanel);
                roomControlsFrame.setLayout(new BoxLayout(roomControlsFrame.getContentPane(), 1));
                roomControlsFrame.add(new JLabel(Messages.getString("RoomControls.LEFT_BUTTON")));
                roomControlsFrame.add(new JLabel(Messages.getString("RoomControls.LEFT_BUTTON_CTRl")));
                roomControlsFrame.add(new JLabel(Messages.getString("RoomControls.LEFT_BUTTON_ALT")));
                roomControlsFrame.add(new JLabel(Messages.getString("RoomControls.LEFT_BUTTON_SHIFT")));
                roomControlsFrame.add(Box.createRigidArea(new Dimension(0, 5)));
                roomControlsFrame.add(new JLabel(Messages.getString("RoomControls.RIGHT_BUTTON")));
                roomControlsFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        roomControlsFrame = null;
                    }
                });
                roomControlsFrame.pack();
                roomControlsFrame.setResizable(false);
            }
            roomControlsFrame.setLocationRelativeTo(LGM.frame);
            roomControlsFrame.setVisible(true);
        }
        if (eventSource == this.shiftInstances) {
            Room currentRoom3 = this.editor.getRoom();
            int snapX = (Integer)currentRoom3.properties.get(Room.PRoom.SNAP_X);
            int snapY = (Integer)currentRoom3.properties.get(Room.PRoom.SNAP_Y);
            NumberField txtHorizontalShift = new NumberField(-999999, 999999, snapX);
            NumberField txtVerticalShift = new NumberField(-999999, 999999, snapY);
            JPanel myPanel = new JPanel();
            myPanel.add(new JLabel(Messages.getString("RoomFrame.HORIZONTAL_SHIFT")));
            myPanel.add(txtHorizontalShift);
            myPanel.add(Box.createHorizontalStrut(7));
            myPanel.add(new JLabel(Messages.getString("RoomFrame.VERTICAL_SHIFT")));
            myPanel.add(txtVerticalShift);
            boolean tilesTabIsSelected = this.tabs.getSelectedIndex() == 2;
            String panelTitle = tilesTabIsSelected ? Messages.getString("RoomFrame.SHIFT_TILES_TITLE") : Messages.getString("RoomFrame.SHIFT_OBJECTS_TITLE");
            int result4 = JOptionPane.showConfirmDialog(this, myPanel, panelTitle, 2, -1);
            if (result4 == 0) {
                int verticalShift;
                if (currentRoom3.tiles.size() == 0 && tilesTabIsSelected) {
                    return;
                }
                if (currentRoom3.instances.size() == 0 && !tilesTabIsSelected) {
                    return;
                }
                int horizontalShift = txtHorizontalShift.getIntValue();
                if (horizontalShift == 0 & (verticalShift = txtVerticalShift.getIntValue().intValue()) == 0) {
                    return;
                }
                Room.Piece selectedPiece = this.editor.getSelectedPiece();
                if (selectedPiece != null) {
                    selectedPiece.setSelected(false);
                }
                if (tilesTabIsSelected) {
                    for (Tile tile : currentRoom3.tiles) {
                        this.tList.setSelectedValue(tile, false);
                        Point newPosition = new Point(tile.getPosition().x + horizontalShift, tile.getPosition().y + verticalShift);
                        tile.setPosition(newPosition);
                    }
                } else {
                    for (Instance instance : currentRoom3.instances) {
                        this.oList.setSelectedValue(instance, false);
                        Point newPosition = new Point(instance.getPosition().x + horizontalShift, instance.getPosition().y + verticalShift);
                        instance.setPosition(newPosition);
                    }
                }
                ShiftPieceInstances edit = new ShiftPieceInstances(this, tilesTabIsSelected, horizontalShift, verticalShift);
                this.undoSupport.postEdit(edit);
            }
            return;
        }
        if (eventSource == this.showButton) {
            this.showMenu.show(this.showButton, 0, this.showButton.getHeight());
            return;
        }
        if (eventSource == this.addObjectButton) {
            if (this.oNew.getSelected() == null) {
                return;
            }
            Room.Piece selectedPiece = this.editor.getSelectedPiece();
            if (selectedPiece != null) {
                selectedPiece.setSelected(false);
            }
            Instance newObject = ((Room)this.res).addInstance();
            newObject.properties.put(Instance.PInstance.OBJECT, (Object)this.oNew.getSelected());
            newObject.setPosition(new Point());
            int numberOfObjects = ((Room)this.res).instances.size();
            AddPieceInstance edit = new AddPieceInstance(this, newObject, numberOfObjects - 1);
            this.undoSupport.postEdit(edit);
            this.oList.setSelectedIndex(numberOfObjects - 1);
            return;
        }
        if (eventSource == this.deleteObjectButton) {
            int selectedIndex = this.oList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            Instance instance = this.oList.getSelectedValue();
            if (instance == null) {
                return;
            }
            Room.Piece selectedPiece = this.editor.getSelectedPiece();
            if (selectedPiece != null) {
                selectedPiece.setSelected(false);
            }
            RemovePieceInstance edit = new RemovePieceInstance(this, instance, selectedIndex);
            this.undoSupport.postEdit(edit);
            CodeFrame codeFrame = this.codeFrames.get(((Room)this.res).instances.remove(selectedIndex));
            if (codeFrame != null) {
                codeFrame.dispose();
            }
            this.oList.setSelectedIndex(Math.min(((Room)this.res).instances.size() - 1, selectedIndex));
            return;
        }
        if (eventSource == this.taSource) {
            this.tSelect.setBackground(this.taSource.getSelected());
            return;
        }
        if (eventSource == this.deleteTileButton) {
            int selectedIndex = this.tList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            Room.Piece selectedPiece = this.editor.getSelectedPiece();
            if (selectedPiece != null) {
                selectedPiece.setSelected(false);
            }
            Tile tile = this.tList.getSelectedValue();
            RemovePieceInstance edit = new RemovePieceInstance(this, tile, selectedIndex);
            this.undoSupport.postEdit(edit);
            ((Room)this.res).tiles.remove(selectedIndex);
            this.tList.setSelectedIndex(Math.min(((Room)this.res).tiles.size() - 1, selectedIndex));
            return;
        }
        if (e.getSource() == this.sCreationCode) {
            this.openRoomCreationCode();
            return;
        }
        if (e.getSource() == this.oCreationCode) {
            if (this.lastObj != null) {
                this.openInstanceCodeFrame(this.lastObj);
            }
            return;
        }
        super.actionPerformed(e);
    }

    public void fireObjUpdate() {
        Instance selectedInstance = this.oList.getSelectedValue();
        if (this.lastObj == selectedInstance) {
            return;
        }
        this.lastObj = selectedInstance;
        this.iplf.removeAllLinks();
        if (selectedInstance == null) {
            return;
        }
        this.iplf.setMap(selectedInstance.properties);
        this.iplf.make(this.oLocked, Instance.PInstance.LOCKED);
        this.iplf.make(this.oSource, Instance.PInstance.OBJECT);
        this.iplf.make(this.objectName.getDocument(), Instance.PInstance.NAME);
        this.iplf.make(this.objectHorizontalPosition, Instance.PInstance.X);
        this.iplf.make(this.objectVerticalPosition, Instance.PInstance.Y);
        this.iplf.make(this.objectScaleX, Instance.PInstance.SCALE_X);
        this.iplf.make(this.objectScaleY, Instance.PInstance.SCALE_Y);
        this.iplf.make(this.objectRotation, Instance.PInstance.ROTATION);
        this.iplf.make(this.objectColor, Instance.PInstance.COLOR);
        this.iplf.make(this.objectAlpha, Instance.PInstance.ALPHA);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = this.getContentPane().getSize();
        Dimension l = this.getContentPane().getMinimumSize();
        Dimension s = this.getSize();
        l.width += s.width - p.width;
        l.height += s.height - p.height;
        return l;
    }

    public void fireTileUpdate() {
        Tile selectedTile = this.tList.getSelectedValue();
        if (this.lastTile == selectedTile) {
            return;
        }
        this.lastTile = selectedTile;
        this.tplf.removeAllLinks();
        if (selectedTile == null) {
            return;
        }
        this.tplf.setMap(selectedTile.properties);
        this.tplf.make(this.teDepth, Tile.PTile.DEPTH);
        this.tplf.make(this.tLocked, Tile.PTile.LOCKED);
        this.tplf.make(this.teSource, Tile.PTile.BACKGROUND);
        this.tplf.make(this.tsX, Tile.PTile.BG_X);
        this.tplf.make(this.tsY, Tile.PTile.BG_Y);
        this.tplf.make(this.tileHorizontalPosition, Tile.PTile.ROOM_X);
        this.tplf.make(this.tileVerticalPosition, Tile.PTile.ROOM_Y);
    }

    public void fireBackUpdate() {
        int i = this.bList.getSelectedIndex();
        if (this.lastValidBack == i) {
            return;
        }
        if (i < 0) {
            this.bList.setSelectedIndex(this.lastValidBack < 0 ? 0 : this.lastValidBack);
            return;
        }
        this.lastValidBack = i;
        BackgroundDef b = ((Room)this.res).backgroundDefs.get(i);
        if (this.bdplf != null) {
            this.bdplf.setMap(b.properties);
            return;
        }
        this.bdplf = new PropertyLinkFactory<BackgroundDef.PBackgroundDef>(b.properties, this);
        this.addSecondaryPropertyLinkFactory(this.bdplf);
        this.bdplf.make(this.bVisible, BackgroundDef.PBackgroundDef.VISIBLE);
        this.bdplf.make(this.bForeground, BackgroundDef.PBackgroundDef.FOREGROUND);
        this.bdplf.make(this.bSource, BackgroundDef.PBackgroundDef.BACKGROUND);
        this.bdplf.make(this.bX, BackgroundDef.PBackgroundDef.X);
        this.bdplf.make(this.bY, BackgroundDef.PBackgroundDef.Y);
        this.bdplf.make(this.bTileH, BackgroundDef.PBackgroundDef.TILE_HORIZ);
        this.bdplf.make(this.bTileV, BackgroundDef.PBackgroundDef.TILE_VERT);
        this.bdplf.make(this.bStretch, BackgroundDef.PBackgroundDef.STRETCH);
        this.bdplf.make(this.bH, BackgroundDef.PBackgroundDef.H_SPEED);
        this.bdplf.make(this.bV, BackgroundDef.PBackgroundDef.V_SPEED);
    }

    public void fireViewUpdate() {
        int i = this.vList.getSelectedIndex();
        if (this.lastValidView == i) {
            return;
        }
        if (i < 0) {
            this.bList.setSelectedIndex(this.lastValidView < 0 ? 0 : this.lastValidView);
            return;
        }
        this.lastValidView = i;
        View view = ((Room)this.res).views.get(i);
        if (this.vplf != null) {
            this.vplf.setMap(view.properties);
            return;
        }
        this.vplf = new PropertyLinkFactory<View.PView>(view.properties, this);
        this.addSecondaryPropertyLinkFactory(this.vplf);
        this.vplf.make(this.vVisible, View.PView.VISIBLE);
        this.vplf.make(this.vRX, View.PView.VIEW_X);
        this.vplf.make(this.vRY, View.PView.VIEW_Y);
        this.vplf.make(this.vRW, View.PView.VIEW_W);
        this.vplf.make(this.vRH, View.PView.VIEW_H);
        this.vplf.make(this.vPX, View.PView.PORT_X);
        this.vplf.make(this.vPY, View.PView.PORT_Y);
        this.vplf.make(this.vPW, View.PView.PORT_W);
        this.vplf.make(this.vPH, View.PView.PORT_H);
        this.vplf.make(this.vObj, View.PView.OBJECT);
        this.vplf.make(this.vOHBor, View.PView.BORDER_H);
        this.vplf.make(this.vOVBor, View.PView.BORDER_V);
        this.vplf.make(this.vOHSp, View.PView.SPEED_H);
        this.vplf.make(this.vOVSp, View.PView.SPEED_V);
    }

    private void showSelectedTile() {
        Tile tile;
        Room.Piece selectedPiece = this.editor.getSelectedPiece();
        if (selectedPiece != null) {
            selectedPiece.setSelected(false);
        }
        if ((tile = this.tList.getSelectedValue()) == null) {
            return;
        }
        tile.setSelected(true);
        this.editor.setSelectedPiece(tile);
        Point tilePosition = tile.getPosition();
        this.centerObjectInViewport(tilePosition, tile.getSize().width, tile.getSize().height, null);
    }

    private void showSelectedInstance() {
        GmObject inst;
        Instance instance;
        Room.Piece selectedPiece = this.editor.getSelectedPiece();
        if (selectedPiece != null) {
            selectedPiece.setSelected(false);
        }
        if ((instance = this.oList.getSelectedValue()) == null) {
            return;
        }
        instance.setSelected(true);
        this.editor.setSelectedPiece(instance);
        Point instancePosition = instance.getPosition();
        ResourceReference instanceObject = (ResourceReference)instance.properties.get(Instance.PInstance.OBJECT);
        BufferedImage instanceImage = null;
        if (instanceObject != null && (inst = (GmObject)instanceObject.get()) != null) {
            instanceImage = inst.getDisplayImage();
        }
        if (instanceImage == null) {
            ImageIcon emptySprite = LGM.getIconForKey("Resource.EMPTY_OBJ");
            this.centerObjectInViewport(instancePosition, emptySprite.getIconWidth(), emptySprite.getIconHeight(), null);
        } else {
            this.centerObjectInViewport(instancePosition, instanceImage.getWidth(), instanceImage.getHeight(), null);
        }
    }

    private void centerObjectInViewport(Point objectPosition, int objectWidth, int objectHeight, Instance instanceToFollow) {
        JViewport viewport = this.editorPane.getViewport();
        Point newViewportPosition = new Point(0, 0);
        int zoomLevel = (Integer)this.editor.properties.get(RoomEditor.PRoomEditor.ZOOM);
        int viewportScale = 0;
        if (zoomLevel == -1) {
            viewportScale = 3;
        }
        if (zoomLevel == 0) {
            viewportScale = 2;
        }
        if (zoomLevel < 1) {
            newViewportPosition.x = objectPosition.x - (viewport.getWidth() * viewportScale - objectWidth) / 2;
            newViewportPosition.y = objectPosition.y - (viewport.getHeight() * viewportScale - objectHeight) / 2;
        } else {
            newViewportPosition.x = objectPosition.x - (viewport.getWidth() - objectWidth * zoomLevel) / (2 * zoomLevel);
            newViewportPosition.y = objectPosition.y - (viewport.getHeight() - objectHeight * zoomLevel) / (2 * zoomLevel);
        }
        if (newViewportPosition.x < this.editor.getOverallBounds().x) {
            newViewportPosition.x = this.editor.getOverallBounds().x;
        }
        if (newViewportPosition.y < this.editor.getOverallBounds().y) {
            newViewportPosition.y = this.editor.getOverallBounds().y;
        }
        if (instanceToFollow == null) {
            if (objectPosition.x < newViewportPosition.x) {
                newViewportPosition.x = objectPosition.x;
            }
            if (objectPosition.y < newViewportPosition.y) {
                newViewportPosition.y = objectPosition.x;
            }
        }
        this.editor.visualToComponent(newViewportPosition);
        viewport.setViewPosition(newViewportPosition);
    }

    private void showSelectedView() {
        if (this.editorPane == null) {
            return;
        }
        Room currentRoom = this.editor.getRoom();
        if (!((Boolean)currentRoom.get(Room.PRoom.VIEWS_ENABLED)).booleanValue()) {
            return;
        }
        View view = ((Room)this.res).views.get(this.vList.getSelectedIndex());
        if (!((Boolean)view.properties.get(View.PView.VISIBLE)).booleanValue()) {
            return;
        }
        ResourceReference objectToFollowReference = null;
        if (view.properties.get(View.PView.OBJECT) != null) {
            objectToFollowReference = (ResourceReference)view.properties.get(View.PView.OBJECT);
        }
        Instance instanceToFollow = null;
        if (objectToFollowReference != null) {
            for (Instance instance : currentRoom.instances) {
                ResourceReference instanceObject = (ResourceReference)instance.properties.get(Instance.PInstance.OBJECT);
                if (instanceObject != objectToFollowReference) continue;
                instanceToFollow = instance;
                break;
            }
        }
        Point viewPosition = new Point(0, 0);
        int viewWidth = (Integer)view.properties.get(View.PView.VIEW_W);
        int viewHeight = (Integer)view.properties.get(View.PView.VIEW_H);
        if (instanceToFollow != null) {
            Point instancePosition = new Point(0, 0);
            instancePosition.x = (Integer)instanceToFollow.properties.get(Instance.PInstance.X);
            instancePosition.y = (Integer)instanceToFollow.properties.get(Instance.PInstance.Y);
            viewPosition.x = instancePosition.x - viewWidth / 2;
            viewPosition.y = instancePosition.y - viewHeight / 2;
            view.properties.put(View.PView.OBJECT_FOLLOWING_X, (Object)viewPosition.x);
            view.properties.put(View.PView.OBJECT_FOLLOWING_Y, (Object)viewPosition.y);
        } else {
            viewPosition.x = (Integer)view.properties.get(View.PView.VIEW_X);
            viewPosition.y = (Integer)view.properties.get(View.PView.VIEW_Y);
            view.properties.put(View.PView.OBJECT_FOLLOWING_X, (Object)-1);
            view.properties.put(View.PView.OBJECT_FOLLOWING_Y, (Object)-1);
        }
        this.centerObjectInViewport(viewPosition, viewWidth, viewHeight, instanceToFollow);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.oList) {
            this.fireObjUpdate();
        }
        if (e.getSource() == this.tList) {
            this.fireTileUpdate();
        }
        if (e.getSource() == this.bList) {
            this.fireBackUpdate();
        }
        if (e.getSource() == this.vList) {
            this.fireViewUpdate();
            this.showSelectedView();
        }
    }

    public CodeFrame openCodeFrame(CodeFrame.CodeHolder code, String titleFormat, Object titleArg) {
        CodeFrame frame = this.codeFrames.get(code);
        if (frame == null) {
            frame = new CodeFrame(code, titleFormat, titleArg);
            this.codeFrames.put(code, frame);
            frame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    CodeFrame f = (CodeFrame)e.getSource();
                    RoomFrame.this.codeFrames.remove(f.codeHolder);
                    f.removeInternalFrameListener(this);
                }
            });
            LGM.mdi.add(frame);
            LGM.mdi.addZChild(this, frame);
            frame.toTop();
        } else {
            frame.toTop();
        }
        return frame;
    }

    @Override
    public CodeFrame openInstanceCodeFrame(Instance inst) {
        return this.openCodeFrame(inst, Messages.getString("RoomFrame.TITLE_FORMAT_CREATION"), Messages.format("RoomFrame.INSTANCE", inst.properties.get(Instance.PInstance.ID)));
    }

    public CodeFrame openInstanceCodeFrame(int id, boolean select) {
        Instance inst = this.findInstance(id, select);
        if (inst != null) {
            return this.openCodeFrame(inst, Messages.getString("RoomFrame.TITLE_FORMAT_CREATION"), Messages.format("RoomFrame.INSTANCE", inst.properties.get(Instance.PInstance.ID)));
        }
        return null;
    }

    public CodeFrame openRoomCreationCode() {
        return this.openCodeFrame((CodeFrame.CodeHolder)((Object)this.res), Messages.getString("RoomFrame.TITLE_FORMAT_CREATION"), ((Room)this.res).getName());
    }

    public Instance findInstance(int id, boolean select) {
        ListModel<Instance> model = this.oList.getModel();
        int i = 0;
        while (i < model.getSize()) {
            Instance inst = model.getElementAt(i);
            if (inst.getID() == id) {
                if (select) {
                    this.oList.setSelectedIndex(i);
                }
                return inst;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        CodeFrame f = this.codeFrames.get(this.res);
        if (f != null) {
            f.setTitleFormatArg(this.name.getText());
        }
        super.removeUpdate(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        CodeFrame f = this.codeFrames.get(this.res);
        if (f != null) {
            f.setTitleFormatArg(this.name.getText());
        }
        super.insertUpdate(e);
    }

    @Override
    public void dispose() {
        Room.Piece selectedPiece = this.editor.getSelectedPiece();
        if (selectedPiece != null) {
            selectedPiece.setSelected(false);
        }
        super.dispose();
        for (CodeFrame cf : this.codeFrames.values()) {
            cf.dispose();
        }
        this.oNew.removeActionListener(this);
        this.oList.removeListSelectionListener(this);
        this.addObjectButton.removeActionListener(this);
        this.deleteObjectButton.removeActionListener(this);
        this.oCreationCode.removeActionListener(this);
        this.sCreationCode.removeActionListener(this);
        this.showButton.removeActionListener(this);
        this.taSource.removeActionListener(this);
        this.tList.removeListSelectionListener(this);
        this.deleteTileButton.removeActionListener(this);
        this.bList.removeListSelectionListener(this);
        this.vList.removeListSelectionListener(this);
        this.editorPane.setViewport(null);
        this.setLayout(null);
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        if (e.source == ((Room)this.res).instanceUpdateSource) {
            this.oList.setPrototypeCellValue(null);
        } else if (e.source == ((Room)this.res).tileUpdateSource) {
            this.tList.setPrototypeCellValue(null);
        }
    }

    private void bdvListUpdate(boolean isBgDef, UpdateSource s, boolean v) {
        int ls = (isBgDef ? ((Room)this.res).backgroundDefs : ((Room)this.res).views).size();
        int i = 0;
        while (i < ls) {
            UpdateSource s2 = (isBgDef ? ((Room)this.res).backgroundDefs.get((int)i).properties : ((Room)this.res).views.get((int)i).properties).updateSource;
            if (s2 == s) {
                JList<JLabel> l = isBgDef ? this.bList : this.vList;
                JLabel ll = l.getModel().getElementAt(i);
                ll.setFont(ll.getFont().deriveFont(v ? 1 : 0));
                l.setPrototypeCellValue(null);
                break;
            }
            ++i;
        }
    }

    public void resetUndoManager() {
        this.undoManager.discardAllEdits();
        this.refreshUndoRedoButtons();
    }

    public void refreshUndoRedoButtons() {
        this.undo.setEnabled(this.undoManager.canUndo());
        this.redo.setEnabled(this.undoManager.canRedo());
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.pieceOriginalName = null;
        this.pieceOriginalPosition = null;
        this.pieceOriginalScale = null;
        this.pieceOriginalRotation = null;
        this.pieceOriginalAlpha = null;
        this.selectedPiece = null;
        if (event.getSource() == this.objectName || event.getSource() == this.objectHorizontalPosition || event.getSource() == this.objectVerticalPosition || event.getSource() == this.objectScaleX || event.getSource() == this.objectScaleY || event.getSource() == this.objectRotation || event.getSource() == this.objectAlpha) {
            this.selectedPiece = this.oList.getSelectedValue();
            if (this.selectedPiece == null) {
                return;
            }
            if (event.getSource() == this.objectName) {
                this.pieceOriginalName = this.selectedPiece.getName();
                return;
            }
            if (event.getSource() == this.objectHorizontalPosition || event.getSource() == this.objectVerticalPosition) {
                this.pieceOriginalPosition = new Point(this.selectedPiece.getPosition());
                return;
            }
            if (event.getSource() == this.objectScaleX || event.getSource() == this.objectScaleY) {
                Point2D newScale = this.selectedPiece.getScale();
                this.pieceOriginalScale = new Point2D.Double(newScale.getX(), newScale.getY());
                return;
            }
            if (event.getSource() == this.objectRotation) {
                this.pieceOriginalRotation = this.selectedPiece.getRotation();
                return;
            }
            if (event.getSource() == this.objectAlpha) {
                this.pieceOriginalAlpha = this.selectedPiece.getAlpha();
                return;
            }
        } else {
            this.selectedPiece = this.tList.getSelectedValue();
            if (this.selectedPiece == null) {
                return;
            }
            this.pieceOriginalPosition = new Point(this.selectedPiece.getPosition());
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.processFocusLost();
    }

    public void processFocusLost() {
        if (this.selectedPiece == null) {
            return;
        }
        if (this.selectedPiece instanceof Instance) {
            Integer objectNewAlpha;
            Double objectNewRotation;
            Point2D.Double objectNewScale;
            Point objectNewPosition;
            ModifyPieceInstance edit;
            String objectNewName;
            int selectedIndex = this.oList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            if (this.pieceOriginalName != null && !this.pieceOriginalName.equals(objectNewName = this.selectedPiece.getName())) {
                edit = new ModifyPieceInstance(this, this.selectedPiece, ModifyPieceInstance.Type.NAME, this.pieceOriginalName, objectNewName);
                this.undoSupport.postEdit(edit);
            }
            if (this.pieceOriginalPosition != null && !this.pieceOriginalPosition.equals(objectNewPosition = new Point(this.selectedPiece.getPosition()))) {
                edit = new ModifyPieceInstance(this, this.selectedPiece, ModifyPieceInstance.Type.POSITION, this.pieceOriginalPosition, objectNewPosition);
                this.undoSupport.postEdit(edit);
            }
            if (this.pieceOriginalScale != null && !this.pieceOriginalScale.equals(objectNewScale = new Point2D.Double(this.selectedPiece.getScale().getX(), this.selectedPiece.getScale().getY()))) {
                edit = new ModifyPieceInstance(this, this.selectedPiece, ModifyPieceInstance.Type.SCALE, this.pieceOriginalScale, objectNewScale);
                this.undoSupport.postEdit(edit);
            }
            if (this.pieceOriginalRotation != null && !this.pieceOriginalRotation.equals(objectNewRotation = Double.valueOf(this.selectedPiece.getRotation()))) {
                edit = new ModifyPieceInstance(this, this.selectedPiece, ModifyPieceInstance.Type.ROTATION, this.pieceOriginalRotation, objectNewRotation);
                this.undoSupport.postEdit(edit);
            }
            if (this.pieceOriginalAlpha != null && !this.pieceOriginalAlpha.equals(objectNewAlpha = Integer.valueOf(this.selectedPiece.getAlpha()))) {
                edit = new ModifyPieceInstance(this, this.selectedPiece, ModifyPieceInstance.Type.ALPHA, this.pieceOriginalAlpha, objectNewAlpha);
                this.undoSupport.postEdit(edit);
            }
        } else {
            Point tileNewPosition;
            int selectedIndex = this.tList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            if (this.pieceOriginalPosition != null && !this.pieceOriginalPosition.equals(tileNewPosition = new Point(this.selectedPiece.getPosition()))) {
                ModifyPieceInstance edit = new ModifyPieceInstance(this, this.selectedPiece, ModifyPieceInstance.Type.POSITION, this.pieceOriginalPosition, tileNewPosition);
                this.undoSupport.postEdit(edit);
            }
        }
        this.selectedPiece = null;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.tabs.getSelectedIndex() == 4) {
            this.showSelectedView();
            this.editor.roomVisual.setViewsVisible(true);
        } else {
            this.editor.roomVisual.setViewsVisible(false);
        }
    }

    private class BgDefPropertyListener
    extends PropertyMap.PropertyUpdateListener<BackgroundDef.PBackgroundDef> {
        private BgDefPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<BackgroundDef.PBackgroundDef> e) {
            if (e.key == BackgroundDef.PBackgroundDef.VISIBLE) {
                RoomFrame.this.bdvListUpdate(true, e.source, (Boolean)e.map.get((BackgroundDef.PBackgroundDef)((Object)e.key)));
            }
        }
    }

    private static class ListComponentRenderer
    extends DefaultListCellRenderer {
        private ListComponentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object val, int ind, boolean selected, boolean focus) {
            super.getListCellRendererComponent(list, val, ind, selected, focus);
            JLabel lab = (JLabel)val;
            this.setText(lab.getText());
            Font font = this.getFont();
            if (lab.getFont().isBold()) {
                font = font.deriveFont(1);
            }
            this.setFont(font);
            return this;
        }
    }

    private static class ObjectListComponentRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -5630452177056734243L;

        private ObjectListComponentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object val, int ind, boolean selected, boolean focus) {
            super.getListCellRendererComponent(list, val, ind, selected, focus);
            if (!(val instanceof Instance)) {
                return this;
            }
            Instance i = (Instance)val;
            ResourceReference ro = (ResourceReference)i.properties.get(Instance.PInstance.OBJECT);
            GmObject o = (GmObject)Util.deRef(ro);
            String name = o == null ? Messages.getString("RoomFrame.NO_OBJECT") : o.getName();
            this.setText(String.valueOf(name) + "  " + i.properties.get(Instance.PInstance.ID) + "  " + i.properties.get(Instance.PInstance.NAME));
            this.setText(String.format("%10s %6s %s", name, i.properties.get(Instance.PInstance.ID), i.properties.get(Instance.PInstance.NAME)));
            ResNode rn = o == null ? null : o.getNode();
            this.setIcon(rn == null ? null : rn.getIcon());
            return this;
        }
    }

    public class ObjectListTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -5228856790388285912L;
        private int[] indices = null;
        private ArrayList<Instance> instanceList = null;
        private int addIndex = -1;
        private int addCount = 0;

        public ObjectListTransferHandler(ActiveArrayList<Instance> insts) {
            this.instanceList = insts;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(INSTANCE_FLAVOR);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            this.indices = list.getSelectedIndices();
            return new ObjectListTransferable(list.getSelectedValuesList());
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
            int index = dl.getIndex();
            boolean insert = dl.isInsert();
            Transferable t = info.getTransferable();
            List data = null;
            try {
                data = (List)t.getTransferData(INSTANCE_FLAVOR);
            }
            catch (Exception e) {
                LGM.showDefaultExceptionHandler(e);
            }
            this.addIndex = index;
            this.addCount = data.size();
            int i = 0;
            while (i < this.addCount) {
                this.instanceList.add(index++, (Instance)data.get(i));
                ++i;
            }
            return true;
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
            JList source = (JList)c;
            if (action == 2) {
                int i = this.indices.length - 1;
                while (i >= 0) {
                    this.instanceList.remove(this.indices[i]);
                    --i;
                }
            }
            this.indices = null;
            this.addCount = 0;
            this.addIndex = -1;
        }
    }

    public static class ObjectListTransferable
    implements Transferable {
        private static final DataFlavor[] FLAVORS = new DataFlavor[]{INSTANCE_FLAVOR};
        private final List<Instance> instanceList;

        public ObjectListTransferable(List<Instance> list) {
            this.instanceList = list;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor == INSTANCE_FLAVOR) {
                return this.instanceList;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == INSTANCE_FLAVOR;
        }
    }

    private static class TileListComponentRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -3949686932502303475L;
        private final TileIcon ti = new TileIcon();

        private TileListComponentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object val, int ind, boolean selected, boolean focus) {
            super.getListCellRendererComponent(list, val, ind, selected, focus);
            if (!(val instanceof Tile)) {
                return this;
            }
            Tile t = (Tile)val;
            ResourceReference rb = (ResourceReference)t.properties.get(Tile.PTile.BACKGROUND);
            Background bg = (Background)Util.deRef(rb);
            String name = bg == null ? Messages.getString("RoomFrame.NO_BACKGROUND") : bg.getName();
            this.setText(String.valueOf(name) + " " + t.properties.get(Tile.PTile.ID) + " " + t.properties.get(Tile.PTile.NAME));
            this.ti.tile = t;
            this.setIcon(this.ti);
            return this;
        }

        static class TileIcon
        implements Icon {
            Tile tile;

            TileIcon() {
            }

            @Override
            public int getIconHeight() {
                return this.tile.getSize().height;
            }

            @Override
            public int getIconWidth() {
                return this.tile.getSize().width;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                BufferedImage bi;
                ResourceReference rb = (ResourceReference)this.tile.properties.get(Tile.PTile.BACKGROUND);
                Background bg = (Background)Util.deRef(rb);
                BufferedImage bufferedImage = bi = bg == null ? null : bg.getBackgroundImage();
                if (bi != null) {
                    Point p = this.tile.getBackgroundPosition();
                    Dimension d = this.tile.getSize();
                    g.drawImage(bi, x, y, x + d.width, y + d.height, p.x, p.y, p.x + d.width, p.y + d.height, c);
                }
            }
        }
    }

    public static class TileSelector
    extends JLabel {
        private static final long serialVersionUID = 1L;
        public int tx;
        public int ty;
        private ResourceReference<Background> bkg;

        public TileSelector() {
            this.setVerticalAlignment(1);
            this.enableEvents(501L);
            this.enableEvents(506L);
        }

        public void setBackground(ResourceReference<Background> bkg) {
            this.bkg = bkg;
            Background b = Util.deRef(bkg);
            if (b == null) {
                this.setIcon(null);
                this.setPreferredSize(new Dimension(0, 0));
                return;
            }
            this.setPreferredSize(new Dimension(b.getWidth(), b.getHeight()));
            BufferedImage bi = b.getDisplayImage();
            this.setIcon(bi == null ? null : new ImageIcon(bi));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Background b = Util.deRef(this.bkg);
            if (b == null) {
                return;
            }
            Shape oldClip = g.getClip();
            Rectangle oldc = g.getClipBounds();
            g.setClip(new Rectangle(oldc.x, oldc.y, Math.min(oldc.x + oldc.width, b.getWidth()) - oldc.x, Math.min(oldc.y + oldc.height, b.getHeight()) - oldc.y));
            if (((Boolean)b.get(Background.PBackground.USE_AS_TILESET)).booleanValue()) {
                g.setXORMode(Color.BLACK);
                g.setColor(Color.WHITE);
                g.drawRect(this.tx, this.ty, (Integer)b.get(Background.PBackground.TILE_WIDTH), (Integer)b.get(Background.PBackground.TILE_HEIGHT));
                g.setPaintMode();
            }
            g.setClip(oldClip);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501 && e.getButton() == 1 && e.getX() < this.getPreferredSize().width && e.getY() < this.getPreferredSize().height) {
                this.selectTile(e.getX(), e.getY());
            }
            super.processMouseEvent(e);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            if (e.getID() == 506 && (e.getModifiersEx() & 0x400) != 0) {
                this.selectTile(e.getX(), e.getY());
            }
            super.processMouseMotionEvent(e);
        }

        public void selectTile(int x, int y) {
            Background hardBkg = Util.deRef(this.bkg);
            if (hardBkg == null) {
                this.tx = x;
                this.ty = y;
            } else if (!((Boolean)hardBkg.get(Background.PBackground.USE_AS_TILESET)).booleanValue()) {
                this.tx = 0;
                this.ty = 0;
            } else {
                int w = (Integer)hardBkg.get(Background.PBackground.TILE_WIDTH) + (Integer)hardBkg.get(Background.PBackground.H_SEP);
                int h = (Integer)hardBkg.get(Background.PBackground.TILE_HEIGHT) + (Integer)hardBkg.get(Background.PBackground.V_SEP);
                int ho = (Integer)hardBkg.get(Background.PBackground.H_OFFSET);
                int vo = (Integer)hardBkg.get(Background.PBackground.V_OFFSET);
                this.tx = (int)Math.floor((x - ho) / w) * w + ho;
                this.ty = (int)Math.floor((y - vo) / h) * h + vo;
            }
            this.repaint();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent evt) {
            UndoableEdit edit = evt.getEdit();
            RoomFrame.this.undoManager.addEdit(edit);
            RoomFrame.this.refreshUndoRedoButtons();
        }
    }

    private class ViewPropertyListener
    extends PropertyMap.PropertyUpdateListener<View.PView> {
        private ViewPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<View.PView> e) {
            if (e.key == View.PView.VISIBLE) {
                RoomFrame.this.bdvListUpdate(false, e.source, (Boolean)e.map.get((View.PView)((Object)e.key)));
            }
            if (e.key == View.PView.OBJECT || e.key == View.PView.VISIBLE) {
                RoomFrame.this.showSelectedView();
            }
            if (e.key == View.PView.VIEW_W || e.key == View.PView.VIEW_H || e.key == View.PView.BORDER_H || e.key == View.PView.BORDER_V) {
                View view = ((Room)RoomFrame.this.res).views.get(RoomFrame.this.vList.getSelectedIndex());
                if (view.properties.get(View.PView.OBJECT) != null) {
                    RoomFrame.this.showSelectedView();
                }
            }
        }
    }
}

