/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.FileWriter;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.lateralgm.components.CustomFileChooser;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.components.impl.TextAreaFocusTraversalPolicy;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.Timeline;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibArgument;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.resources.sub.Event;
import org.lateralgm.resources.sub.MainEvent;
import org.lateralgm.resources.sub.Moment;
import org.lateralgm.resources.sub.ShapePoint;

public class ResourceInfoFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JTextArea editor;
    protected Color fgColor;
    private CustomFileChooser fc;
    private int linesOfCode = 0;

    public JToolBar makeToolbar() {
        JToolBar tb = new JToolBar();
        tb.add(this.addToolbarItem("ResourceInfoFrame.CONFIRM"));
        tb.addSeparator();
        tb.add(this.addToolbarItem("ResourceInfoFrame.FILESAVE"));
        tb.add(this.addToolbarItem("ResourceInfoFrame.PRINT"));
        tb.addSeparator();
        tb.add(this.addToolbarItem("ResourceInfoFrame.COPY"));
        return tb;
    }

    public JPopupMenu makeContextMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = this.addItem("ResourceInfoFrame.COPY");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ResourceInfoFrame.COPY")));
        popup.add(item);
        popup.addSeparator();
        item = this.addItem("ResourceInfoFrame.SELECTALL");
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ResourceInfoFrame.SELECTALL")));
        popup.add(item);
        this.editor.setComponentPopupMenu(popup);
        return popup;
    }

    public JMenuItem addItem(String key) {
        JMenuItem item = new JMenuItem(Messages.getString(key));
        item.setIcon(LGM.getIconForKey(key));
        item.setActionCommand(key);
        item.addActionListener(this);
        return item;
    }

    public JButton addToolbarItem(String key) {
        JButton item = new JButton();
        item.setToolTipText(Messages.getString(key));
        item.setIcon(LGM.getIconForKey(key));
        item.setActionCommand(key);
        item.addActionListener(this);
        return item;
    }

    public static int countLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        int pos = 0;
        while (pos < len) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 < len && str.charAt(pos + 1) == '\n') {
                    ++pos;
                }
            } else if (c == '\n') {
                ++lines;
            }
            ++pos;
        }
        return lines;
    }

    public String loopActionsToString(List<Action> list) {
        String info = "";
        this.linesOfCode = 0;
        int lms = list.size();
        int i = 0;
        while (i < lms) {
            Action a = list.get(i);
            LibAction la = a.getLibAction();
            List<Argument> args = a.getArguments();
            LibArgument[] libargs = la.libArguments;
            String text = la.description;
            String code = "";
            if (la.actionKind == 7) {
                code = args.get(args.size() - 1).toString(libargs[args.size() - 1]);
                this.linesOfCode += ResourceInfoFrame.countLines(code);
                text = String.valueOf(text) + " (" + this.linesOfCode + " Lines)";
                text = String.valueOf(text) + "\n------ BEGIN ------";
                text = String.valueOf(text) + "\n" + code;
                text = String.valueOf(text) + "\n------  END  ------";
            }
            info = String.valueOf(info) + "\n" + i + " " + text;
            ++i;
        }
        return info;
    }

    public void updateTimelineInfo(ResourceReference<Timeline> res) {
        this.setIconImage(LGM.getIconForKey("Resource.TML").getImage());
        this.setTitle(Messages.getString("ResourceInfoFrame.TIMELINE_TITLE"));
        if (res == null) {
            this.editor.setText("ERROR! Timeline does not exist.");
            this.editor.setCaretPosition(0);
            this.editor.getCaret().setVisible(true);
            return;
        }
        int totalLinesOfCode = 0;
        Timeline tml = res.get();
        String propInfo = "**** Properties ****\n\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("TimelineFrame.NAME") + " " + tml.getName() + "\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("TimelineFrame.MOMENTS") + " " + tml.moments.size() + "\n";
        propInfo = String.valueOf(propInfo) + "Total Lines of Code: ";
        String momInfo = "\n**** Moments ****";
        for (Moment mom : tml.moments) {
            momInfo = String.valueOf(momInfo) + "\n\n  " + mom.toString();
            if (mom.actions.size() > 0) {
                String actInfo = this.loopActionsToString(mom.actions);
                totalLinesOfCode += this.linesOfCode;
                momInfo = String.valueOf(momInfo) + " (" + this.linesOfCode + " Lines Of Code) :";
                momInfo = String.valueOf(momInfo) + actInfo;
                continue;
            }
            momInfo = String.valueOf(momInfo) + ":\n " + Messages.getString("TimelineFrame.EMPTY");
        }
        this.editor.setText(String.valueOf(propInfo) + totalLinesOfCode + "\n" + momInfo + "\n");
        this.editor.setCaretPosition(0);
        this.editor.getCaret().setVisible(true);
    }

    public void updateObjectInfo(ResourceReference<GmObject> ref) {
        this.setIconImage(LGM.getIconForKey("Resource.OBJ").getImage());
        this.setTitle(Messages.getString("ResourceInfoFrame.OBJECT_TITLE"));
        if (ref == null) {
            this.editor.setText("ERROR! Object does not exist.");
            this.editor.setCaretPosition(0);
            this.editor.getCaret().setVisible(true);
            return;
        }
        int totalLinesOfCode = 0;
        GmObject obj = ref.get();
        String propInfo = "**** Properties ****\n\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.NAME") + ": " + obj.getName() + "\n";
        ResourceReference res = (ResourceReference)obj.get(GmObject.PGmObject.PARENT);
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.PARENT") + ": ";
        propInfo = res != null ? String.valueOf(propInfo) + ((Resource)res.get()).getName() : String.valueOf(propInfo) + Messages.getString("GmObjectFrame.NO_PARENT");
        propInfo = String.valueOf(propInfo) + "\n";
        res = (ResourceReference)obj.get(GmObject.PGmObject.SPRITE);
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.SPRITE") + ": ";
        propInfo = res != null ? String.valueOf(propInfo) + ((Resource)res.get()).getName() : String.valueOf(propInfo) + Messages.getString("GmObjectFrame.NO_SPRITE");
        propInfo = String.valueOf(propInfo) + "\n";
        res = (ResourceReference)obj.get(GmObject.PGmObject.MASK);
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.MASK") + ": ";
        propInfo = res != null ? String.valueOf(propInfo) + ((Resource)res.get()).getName() : String.valueOf(propInfo) + Messages.getString("GmObjectFrame.SAME_AS_SPRITE");
        propInfo = String.valueOf(propInfo) + "\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.VISIBLE") + ": " + obj.get(GmObject.PGmObject.VISIBLE) + "\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.SOLID") + ": " + obj.get(GmObject.PGmObject.SOLID) + "\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.DEPTH") + ": " + obj.get(GmObject.PGmObject.DEPTH) + "\n";
        propInfo = String.valueOf(propInfo) + Messages.getString("GmObjectFrame.PERSISTENT") + ": " + obj.get(GmObject.PGmObject.PERSISTENT) + "\n";
        propInfo = String.valueOf(propInfo) + "Total Lines of Code: ";
        String phyInfo = "**** Physics ****\n\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.USES_PHYSICS") + ": " + obj.get(GmObject.PGmObject.PHYSICS_OBJECT) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.AWAKE") + ": " + obj.get(GmObject.PGmObject.PHYSICS_AWAKE) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.SENSOR") + ": " + obj.get(GmObject.PGmObject.PHYSICS_SENSOR) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.KINEMATIC") + ": " + obj.get(GmObject.PGmObject.PHYSICS_KINEMATIC) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.DENSITY") + ": " + obj.get(GmObject.PGmObject.PHYSICS_DENSITY) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.RESTITUTION") + ": " + obj.get(GmObject.PGmObject.PHYSICS_RESTITUTION) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.COLLISION_GROUP") + ": " + obj.get(GmObject.PGmObject.PHYSICS_GROUP) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.DAMPING_LINEAR") + ": " + obj.get(GmObject.PGmObject.PHYSICS_DAMPING_LINEAR) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.DAMPING_ANGULAR") + ": " + obj.get(GmObject.PGmObject.PHYSICS_DAMPING_ANGULAR) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.FRICTION") + ": " + obj.get(GmObject.PGmObject.PHYSICS_FRICTION) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.COLLISION_SHAPE") + ": " + obj.get(GmObject.PGmObject.PHYSICS_SHAPE) + "\n";
        phyInfo = String.valueOf(phyInfo) + Messages.getString("GmObjectFrame.SHAPE_POINTS") + ": " + obj.shapePoints.size() + "\n";
        for (ShapePoint sp : obj.shapePoints) {
            phyInfo = String.valueOf(phyInfo) + sp.getX() + ", " + sp.getY() + "\n";
        }
        String evtInfo = "\n**** Events ****";
        for (MainEvent me : obj.mainEvents) {
            for (Event ev : me.events) {
                if (ev.actions.size() > 0) {
                    evtInfo = String.valueOf(evtInfo) + "\n\n  " + Event.eventName(ev.mainId, ev.id);
                    String actInfo = this.loopActionsToString(ev.actions);
                    totalLinesOfCode += this.linesOfCode;
                    evtInfo = String.valueOf(evtInfo) + " (" + this.linesOfCode + " Lines Of Code) :";
                    evtInfo = String.valueOf(evtInfo) + actInfo;
                    continue;
                }
                evtInfo = String.valueOf(evtInfo) + ":\n " + Messages.getString("GmObjectFrame.EMPTY");
            }
        }
        this.editor.setText(String.valueOf(propInfo) + totalLinesOfCode + "\n\n" + phyInfo + evtInfo + "\n");
        this.editor.setCaretPosition(0);
        this.editor.getCaret().setVisible(true);
    }

    public ResourceInfoFrame() {
        this.setDefaultCloseOperation(1);
        this.setSize(440, 500);
        this.setLocationRelativeTo(LGM.frame);
        this.fc = new CustomFileChooser("/org/lateralgm", "LAST_GAMEINFO_DIR");
        this.fc.setFileFilter(new CustomFileFilter(Messages.getString("ResourceInfoFrame.TYPE_TXT"), ".txt"));
        this.add((Component)this.makeToolbar(), "North");
        this.editor = new JTextArea();
        this.editor.setWrapStyleWord(false);
        JScrollPane scrollable = new JScrollPane(this.editor);
        this.add((Component)scrollable, "Center");
        this.setFocusTraversalPolicy(new TextAreaFocusTraversalPolicy(this.editor));
        this.editor.setFont(new Font("Monospaced", 0, 12));
        this.editor.setText("object info will be displayed here when loaded");
        this.editor.setEditable(false);
        this.editor.getCaret().setVisible(true);
        this.editor.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ResourceInfoFrame.this.editor.getCaret().setVisible(true);
            }
        });
        this.makeContextMenu();
    }

    public void saveToFile() {
        this.fc.setDialogTitle(Messages.getString("ResourceInfoFrame.SAVE_TITLE"));
        if (this.fc.showSaveDialog(this) != 0) {
            return;
        }
        String name = this.fc.getSelectedFile().getPath();
        if (CustomFileFilter.getExtension(name) == null) {
            name = String.valueOf(name) + ".txt";
        }
        try {
            FileWriter out = new FileWriter(name);
            out.write(this.editor.getText());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String com = ev.getActionCommand();
        if (com.equals("ResourceInfoFrame.FILESAVE")) {
            this.saveToFile();
            return;
        }
        if (com.equals("ResourceInfoFrame.COPY")) {
            this.editor.copy();
            return;
        }
        if (com.equals("ResourceInfoFrame.SELECTALL")) {
            this.editor.selectAll();
            return;
        }
        if (com.equals("ResourceInfoFrame.CONFIRM")) {
            this.setVisible(false);
            return;
        }
        if (com.equals("ResourceInfoFrame.PRINT")) {
            try {
                this.editor.print();
            }
            catch (Exception pex) {
                LGM.showDefaultExceptionHandler(pex);
            }
            return;
        }
        this.editor.getCaret().setVisible(true);
    }
}

