/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.ExceptionListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.mdi.RevertableMDIFrame;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Background;
import org.lateralgm.resources.Constants;
import org.lateralgm.resources.Extension;
import org.lateralgm.resources.ExtensionPackages;
import org.lateralgm.resources.Font;
import org.lateralgm.resources.GameInformation;
import org.lateralgm.resources.GameSettings;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.Include;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.Script;
import org.lateralgm.resources.Shader;
import org.lateralgm.resources.Sound;
import org.lateralgm.resources.Sprite;
import org.lateralgm.resources.Timeline;
import org.lateralgm.subframes.BackgroundFrame;
import org.lateralgm.subframes.ExtensionFrame;
import org.lateralgm.subframes.FontFrame;
import org.lateralgm.subframes.GmObjectFrame;
import org.lateralgm.subframes.IncludeFrame;
import org.lateralgm.subframes.PathFrame;
import org.lateralgm.subframes.RoomFrame;
import org.lateralgm.subframes.ScriptFrame;
import org.lateralgm.subframes.ShaderFrame;
import org.lateralgm.subframes.SoundFrame;
import org.lateralgm.subframes.SpriteFrame;
import org.lateralgm.subframes.TimelineFrame;
import org.lateralgm.ui.swing.propertylink.PropertyLinkFactory;
import org.lateralgm.util.WeakArrayList;

public abstract class ResourceFrame<R extends Resource<R, P>, P extends Enum<P>>
extends RevertableMDIFrame
implements ActionListener,
ExceptionListener {
    private static final long serialVersionUID = 1L;
    public final JButton save = new JButton();
    public R res;
    public R resOriginal;
    public final ResNode node;
    protected ResourceFrameListener frameListener;
    protected final PropertyLinkFactory<P> plf;
    private final List<WeakReference<PropertyLinkFactory<?>>> plfSecondaries = new WeakArrayList();
    public static Map<Class<?>, ResourceFrameFactory> factories = new HashMap();

    static {
        for (Class<? extends Resource<?, ?>> clazz : Resource.kinds) {
            factories.put(clazz, new DefaultResourceFrameFactory(clazz));
        }
    }

    public ResourceFrame(R res, ResNode node) {
        this(res, node, ((Resource)res).getName(), true);
    }

    public ResourceFrame(R res, ResNode node, String title, boolean functional) {
        this(res, node, title, functional, functional, functional, functional);
    }

    public ResourceFrame(R res, ResNode node, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.plf = new PropertyLinkFactory(((Resource)res).properties, this);
        this.res = res;
        this.node = node;
        this.resOriginal = ((Resource)res).clone();
        this.setFrameIcon(ResNode.ICON.get(res.getClass()));
        this.save.setToolTipText(Messages.getString("ResourceFrame.SAVE_TOOLTIP"));
        this.save.setIcon(LGM.getIconForKey("ResourceFrame.SAVE"));
        this.save.addActionListener(this);
    }

    @Override
    public String getConfirmationName() {
        return ((Resource)this.res).getName();
    }

    @Override
    public boolean resourceChanged() {
        this.commitChanges();
        if (this.frameListener != null && this.frameListener.resourceChanged()) {
            return true;
        }
        if (!this.areResourceFieldsEqual()) {
            return true;
        }
        return !((Resource)this.res).equals(this.resOriginal);
    }

    protected boolean areResourceFieldsEqual() {
        return true;
    }

    public void setFrameListener(ResourceFrameListener listener) {
        this.frameListener = listener;
    }

    @Override
    public void updateResource(boolean commit) {
        if (this.frameListener != null) {
            this.frameListener.updateResource(commit);
        }
        if (commit) {
            this.commitChanges();
        }
        this.resOriginal = ((Resource)this.res).clone();
    }

    @Override
    public void setResourceChanged() {
        if (this.frameListener != null) {
            this.frameListener.setResourceChanged();
        }
        LGM.setWindowModified(true);
    }

    @Override
    public void revertResource() {
        if (this.frameListener != null) {
            this.frameListener.revertResource();
        }
        ((Resource)this.resOriginal).updateReference();
    }

    public abstract void commitChanges();

    public void doDefaultSaveAction() {
        if (this.resourceChanged()) {
            this.setResourceChanged();
            this.updateResource(false);
        }
        this.close();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.save) {
            this.doDefaultSaveAction();
        }
    }

    @Override
    public void exceptionThrown(Exception e) {
        e.printStackTrace();
    }

    public void addSecondaryPropertyLinkFactory(PropertyLinkFactory<?> secondaryFactory) {
        this.plfSecondaries.add(new WeakReference(secondaryFactory));
    }

    @Override
    public void dispose() {
        if (this.frameListener != null) {
            this.frameListener.dispose();
        }
        super.dispose();
        if (this.node != null) {
            this.node.frame = null;
        }
        this.save.removeActionListener(this);
        this.removeAll();
        this.plf.removeAllLinks();
        for (WeakReference<PropertyLinkFactory<?>> wrs : this.plfSecondaries) {
            PropertyLinkFactory plfSecondary = (PropertyLinkFactory)wrs.get();
            if (plfSecondary == null) continue;
            plfSecondary.removeAllLinks();
        }
        this.plfSecondaries.clear();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.frameListener != null) {
            this.frameListener.setVisible(visible);
        }
        super.setVisible(visible);
    }

    private static class DefaultResourceFrameFactory
    implements ResourceFrameFactory {
        Class<?> kind;

        DefaultResourceFrameFactory(Class<?> kind) {
            this.kind = kind;
        }

        @Override
        public ResourceFrame<?, ?> makeFrame(Resource<?, ?> r, ResNode node) {
            if (this.kind == Sprite.class) {
                return new SpriteFrame((Sprite)r, node);
            }
            if (this.kind == Sound.class) {
                return new SoundFrame((Sound)r, node);
            }
            if (this.kind == Background.class) {
                return new BackgroundFrame((Background)r, node);
            }
            if (this.kind == Path.class) {
                return new PathFrame((Path)r, node);
            }
            if (this.kind == Script.class) {
                return new ScriptFrame((Script)r, node);
            }
            if (this.kind == Shader.class) {
                return new ShaderFrame((Shader)r, node);
            }
            if (this.kind == Font.class) {
                return new FontFrame((Font)r, node);
            }
            if (this.kind == Timeline.class) {
                return new TimelineFrame((Timeline)r, node);
            }
            if (this.kind == GmObject.class) {
                return new GmObjectFrame((GmObject)r, node);
            }
            if (this.kind == Room.class) {
                return new RoomFrame((Room)r, node);
            }
            if (this.kind == Include.class) {
                return new IncludeFrame((Include)r, node);
            }
            if (this.kind == Extension.class) {
                return new ExtensionFrame((Extension)r, node);
            }
            if (this.kind == Constants.class) {
                LGM.showConstantsFrame(LGM.currentFile.defaultConstants);
                return null;
            }
            if (this.kind == GameInformation.class) {
                return LGM.getGameInfo();
            }
            if (this.kind == GameSettings.class) {
                LGM.showGameSettings(LGM.getSelectedConfig());
                return null;
            }
            if (this.kind == ExtensionPackages.class) {
                return LGM.getExtensionPackages();
            }
            return null;
        }
    }

    public static interface ResourceFrameFactory {
        public ResourceFrame<?, ?> makeFrame(Resource<?, ?> var1, ResNode var2);
    }

    public static interface ResourceFrameListener {
        public void dispose();

        public void setVisible(boolean var1);

        public void updateResource(boolean var1);

        public void revertResource();

        public boolean resourceChanged();

        public void setResourceChanged();
    }
}

