/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.subframes;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.lateralgm.components.NumberField;
import org.lateralgm.components.ResourceMenu;
import org.lateralgm.components.impl.EditorScrollPane;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.visual.PathEditor;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Path;
import org.lateralgm.resources.Room;
import org.lateralgm.resources.sub.PathPoint;
import org.lateralgm.subframes.InstantiableResourceFrame;
import org.lateralgm.ui.swing.propertylink.PropertyLinkFactory;
import org.lateralgm.ui.swing.util.ArrayListModel;
import org.lateralgm.util.PropertyMap;

public class PathFrame
extends InstantiableResourceFrame<Path, Path.PPath> {
    private static final long serialVersionUID = 1L;
    private JList<PathPoint> list;
    private NumberField tx;
    private NumberField ty;
    private NumberField tsp;
    private NumberField tpr;
    private JButton add;
    private JButton insert;
    private JButton delete;
    private JCheckBox smooth;
    private JCheckBox closed;
    private final PathEditor pathEditor;
    private final PropertyLinkFactory<PathEditor.PPathEditor> peplf;
    private final PathEditorPropertyListener pepl = new PathEditorPropertyListener();
    private PropertyLinkFactory<PathPoint.PPathPoint> ppplf;

    public PathFrame(Path res, ResNode node) {
        super(res, node);
        this.pathEditor = new PathEditor(res);
        this.pathEditor.properties.updateSource.addListener(this.pepl);
        this.peplf = new PropertyLinkFactory<PathEditor.PPathEditor>(this.pathEditor.properties, this);
        this.addSecondaryPropertyLinkFactory(this.peplf);
        this.ppplf = new PropertyLinkFactory(null, null);
        this.addSecondaryPropertyLinkFactory(this.ppplf);
        GroupLayout layout = new GroupLayout(this.getContentPane()){

            @Override
            public void layoutContainer(Container parent) {
                Dimension m = PathFrame.this.getMinimumSize();
                Dimension s = PathFrame.this.getSize();
                Dimension r = new Dimension(Math.max(m.width, s.width), Math.max(m.height, s.height));
                if (!r.equals(s)) {
                    PathFrame.this.setSize(r);
                } else {
                    super.layoutContainer(parent);
                }
            }
        };
        this.setLayout(layout);
        JToolBar toolbar = this.makeToolBar();
        JPanel side = this.makeSide(res);
        JComponent preview = this.makePreview();
        GroupLayout.SequentialGroup orientationGroup = layout.createSequentialGroup();
        if (Prefs.rightOrientation) {
            orientationGroup.addComponent(preview, 240, 640, -1).addComponent(side, 200, -1, 200);
        } else {
            orientationGroup.addComponent(side, 200, -1, 200).addComponent(preview, 240, 640, -1);
        }
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(toolbar, -2, -2, Short.MAX_VALUE).addGroup(orientationGroup));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(toolbar, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(side).addComponent(preview, -1, 480, -1)));
        this.pack();
        this.list.setSelectedIndex(0);
    }

    private JToolBar makeToolBar() {
        JToolBar tool = new JToolBar();
        GroupLayout layout = new GroupLayout(tool);
        tool.setLayout(layout);
        tool.setFloatable(false);
        JLabel lsx = new JLabel(Messages.getString("PathFrame.SNAP_X"));
        NumberField sx = new NumberField(1, 999);
        this.plf.make(sx, Path.PPath.SNAP_X);
        JLabel lsy = new JLabel(Messages.getString("PathFrame.SNAP_Y"));
        NumberField sy = new NumberField(1, 999);
        this.plf.make(sy, Path.PPath.SNAP_Y);
        JToggleButton grid = new JToggleButton();
        grid.setToolTipText(Messages.getString("PathFrame.GRID"));
        grid.setActionCommand("PathFrame.GRID");
        grid.setIcon(LGM.getIconForKey("PathFrame.GRID"));
        this.peplf.make(grid, PathEditor.PPathEditor.SHOW_GRID);
        ResourceMenu room = new ResourceMenu(Room.class, Messages.getString("PathFrame.NO_ROOM"), 160);
        this.plf.make(room, Path.PPath.BACKGROUND_ROOM);
        JSeparator saveSep = new JSeparator(1);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.save).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(saveSep, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lsx).addComponent(sx, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lsy).addComponent(sy, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(grid).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(room, -1, -1, -2).addContainerGap());
        layout.setVerticalGroup(layout.createBaselineGroup(false, false).addComponent(this.save).addComponent(saveSep).addComponent(lsx).addComponent(sx).addComponent(lsy).addComponent(sy).addComponent(grid).addComponent(room));
        return tool;
    }

    private JPanel makeSide(Path res) {
        JPanel side1 = new JPanel(null);
        GroupLayout layout = new GroupLayout(side1);
        side1.setLayout(layout);
        JLabel lName = new JLabel(Messages.getString("PathFrame.NAME"));
        this.list = new JList<PathPoint>(new ArrayListModel<PathPoint>(res.points));
        this.list.setSelectionMode(0);
        this.peplf.make(this.list, PathEditor.PPathEditor.SELECTED_POINT);
        this.list.setFont(new Font("Monospaced", 0, 10));
        this.list.setVisibleRowCount(5);
        JScrollPane p = new JScrollPane(this.list);
        JLabel lx = new JLabel(Messages.getString("PathFrame.X"));
        this.tx = new NumberField(0);
        this.tx.setColumns(5);
        this.add = new JButton(Messages.getString("PathFrame.ADD"));
        this.add.addActionListener(this);
        JLabel ly = new JLabel(Messages.getString("PathFrame.Y"));
        this.ty = new NumberField(0);
        this.ty.setColumns(4);
        this.insert = new JButton(Messages.getString("PathFrame.INSERT"));
        this.insert.addActionListener(this);
        JLabel lsp = new JLabel(Messages.getString("PathFrame.SP"));
        this.tsp = new NumberField(0, 1000000, 100);
        this.tsp.setColumns(5);
        this.delete = new JButton(Messages.getString("PathFrame.DELETE"));
        this.delete.addActionListener(this);
        this.smooth = new JCheckBox(Messages.getString("PathFrame.SMOOTH"));
        this.plf.make(this.smooth, Path.PPath.SMOOTH);
        this.closed = new JCheckBox(Messages.getString("PathFrame.CLOSED"));
        this.plf.make(this.closed, Path.PPath.CLOSED);
        JLabel lpr = new JLabel(Messages.getString("PathFrame.PRECISION"));
        this.tpr = new NumberField(1, 8);
        this.plf.make(this.tpr, Path.PPath.PRECISION);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(lName).addComponent(this.name)).addGroup(layout.createSequentialGroup().addComponent(this.smooth).addComponent(this.closed)).addGroup(layout.createSequentialGroup().addComponent(lpr).addComponent(this.tpr)).addComponent(p).addGroup(layout.createSequentialGroup().addComponent(this.add, -1, -1, Integer.MAX_VALUE).addComponent(this.insert, -1, -1, Integer.MAX_VALUE)).addComponent(this.delete, -1, -1, Integer.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lx).addComponent(ly).addComponent(lsp)).addGroup(layout.createParallelGroup().addComponent(this.tx).addComponent(this.ty).addComponent(this.tsp))));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createBaselineGroup(true, false).addComponent(lName).addComponent(this.name)).addGroup(layout.createBaselineGroup(true, false).addComponent(this.smooth).addComponent(this.closed)).addGroup(layout.createBaselineGroup(true, false).addComponent(lpr).addComponent(this.tpr)).addComponent(p, -2, -1, -1).addGroup(layout.createBaselineGroup(true, false).addComponent(this.add).addComponent(this.insert)).addComponent(this.delete).addGroup(layout.createBaselineGroup(true, false).addComponent(lx).addComponent(this.tx)).addGroup(layout.createBaselineGroup(true, false).addComponent(ly).addComponent(this.ty)).addGroup(layout.createBaselineGroup(true, false).addComponent(lsp).addComponent(this.tsp)));
        return side1;
    }

    private JComponent makePreview() {
        return new EditorScrollPane(this.pathEditor);
    }

    @Override
    protected boolean areResourceFieldsEqual() {
        return ((Path)this.res).points.equals(((Path)this.resOriginal).points);
    }

    @Override
    public void commitChanges() {
        ((Path)this.res).setName(this.name.getText());
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension p = this.getContentPane().getSize();
        Dimension l = this.getContentPane().getMinimumSize();
        Dimension s = this.getSize();
        l.width += s.width - p.width;
        l.height += s.height - p.height;
        return l;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        Object s = e.getSource();
        if (s == this.add) {
            ((Path)this.res).points.add(new PathPoint((Integer)this.tx.getValue(), (Integer)this.ty.getValue(), (Integer)this.tsp.getValue()));
            this.list.setSelectedIndex(((Path)this.res).points.size() - 1);
        }
        if (s == this.insert) {
            i = this.list.getSelectedIndex();
            if (i == -1) {
                return;
            }
            ((Path)this.res).points.add(i, new PathPoint((Integer)this.tx.getValue(), (Integer)this.ty.getValue(), (Integer)this.tsp.getValue()));
            this.list.setSelectedIndex(i);
        }
        if (s == this.delete) {
            i = this.list.getSelectedIndex();
            PathPoint o = this.list.getSelectedValue();
            if (o == null) {
                return;
            }
            ((Path)this.res).points.remove(o);
            if (i >= ((Path)this.res).points.size()) {
                i = ((Path)this.res).points.size() - 1;
            }
            this.list.setSelectedIndex(i);
        }
        super.actionPerformed(e);
    }

    private class PathEditorPropertyListener
    extends PropertyMap.PropertyUpdateListener<PathEditor.PPathEditor> {
        private PathEditorPropertyListener() {
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<PathEditor.PPathEditor> e) {
            switch ((PathEditor.PPathEditor)((Object)e.key)) {
                case SELECTED_POINT: {
                    PathPoint pp = (PathPoint)e.map.get((PathEditor.PPathEditor)((Object)e.key));
                    PathFrame.this.ppplf.removeAllLinks();
                    if (pp == null) {
                        return;
                    }
                    PathFrame.this.ppplf.setMap(pp.properties);
                    PathFrame.this.ppplf.make(PathFrame.this.tx, PathPoint.PPathPoint.X);
                    PathFrame.this.ppplf.make(PathFrame.this.ty, PathPoint.PPathPoint.Y);
                    PathFrame.this.ppplf.make(PathFrame.this.tsp, PathPoint.PPathPoint.SPEED);
                    break;
                }
            }
        }
    }
}

